/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.core.refactoring.resource;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.ChangeDescriptor;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;
import org.eclipse.ltk.internal.core.refactoring.BasicElementLabels;
import org.eclipse.ltk.internal.core.refactoring.Messages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCoreMessages;
import org.eclipse.ltk.internal.core.refactoring.RefactoringCorePlugin;
import org.eclipse.ltk.internal.core.refactoring.resource.UndoDeleteResourceChange;
import org.eclipse.ltk.internal.core.refactoring.resource.undostates.ResourceUndoState;

public class DeleteResourceChange
extends ResourceChange {
    private IPath fResourcePath;
    private boolean fForceOutOfSync;
    private boolean fDeleteContent;
    private ChangeDescriptor fDescriptor;

    public DeleteResourceChange(IPath resourcePath, boolean forceOutOfSync) {
        this(resourcePath, forceOutOfSync, false);
    }

    public DeleteResourceChange(IPath resourcePath, boolean forceOutOfSync, boolean deleteContent) {
        this.fResourcePath = resourcePath;
        this.fForceOutOfSync = forceOutOfSync;
        this.fDeleteContent = deleteContent;
        this.setValidationMethod(4);
    }

    protected IResource getModifiedResource() {
        return this.getResource();
    }

    private IResource getResource() {
        return ResourcesPlugin.getWorkspace().getRoot().findMember(this.fResourcePath);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.DeleteResourceChange_name, BasicElementLabels.getPathLabel(this.fResourcePath.makeRelative(), false));
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        if (pm == null) {
            pm = new NullProgressMonitor();
        }
        pm.beginTask("", 10);
        pm.setTaskName(RefactoringCoreMessages.DeleteResourceChange_deleting);
        try {
            IResource resource = this.getResource();
            if (resource == null || !resource.exists()) {
                throw new CoreException((IStatus)new Status(4, RefactoringCorePlugin.getPluginId(), RefactoringCoreMessages.DeleteResourceChange_error_resource_not_exists));
            }
            if (resource.isAccessible()) {
                resource.accept(new IResourceVisitor(){

                    public boolean visit(IResource curr) throws CoreException {
                        try {
                            if (curr instanceof IFile) {
                                DeleteResourceChange.saveFileIfNeeded((IFile)curr, (IProgressMonitor)new NullProgressMonitor());
                            }
                        }
                        catch (CoreException coreException) {}
                        return true;
                    }
                }, 2, false);
            }
            ResourceUndoState desc = ResourceUndoState.fromResource(resource);
            if (resource instanceof IProject) {
                ((IProject)resource).delete(this.fDeleteContent, this.fForceOutOfSync, (IProgressMonitor)new SubProgressMonitor(pm, 10));
            } else {
                int updateFlags = this.fForceOutOfSync ? 3 : 2;
                resource.delete(updateFlags, (IProgressMonitor)new SubProgressMonitor(pm, 5));
                desc.recordStateFromHistory(resource, (IProgressMonitor)new SubProgressMonitor(pm, 5));
            }
            UndoDeleteResourceChange undoDeleteResourceChange = new UndoDeleteResourceChange(desc);
            return undoDeleteResourceChange;
        }
        finally {
            pm.done();
        }
    }

    private static void saveFileIfNeeded(IFile file, IProgressMonitor pm) throws CoreException {
        ITextFileBuffer buffer = FileBuffers.getTextFileBufferManager().getTextFileBuffer(file.getFullPath(), LocationKind.IFILE);
        if (buffer != null && buffer.isDirty() && buffer.isStateValidated() && buffer.isSynchronized()) {
            pm.beginTask("", 2);
            buffer.commit((IProgressMonitor)new SubProgressMonitor(pm, 1), false);
            file.refreshLocal(1, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            pm.done();
        } else {
            pm.beginTask("", 1);
            pm.worked(1);
            pm.done();
        }
    }

    public ChangeDescriptor getDescriptor() {
        return this.fDescriptor;
    }

    public void setDescriptor(ChangeDescriptor descriptor) {
        this.fDescriptor = descriptor;
    }
}

