/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.ui.internal.workbench.ContributionsAnalyzer;
import org.eclipse.e4.ui.model.application.MApplication;
import org.eclipse.e4.ui.model.application.ui.basic.MPart;
import org.eclipse.e4.ui.model.application.ui.menu.MMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuContribution;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuElement;
import org.eclipse.e4.ui.model.application.ui.menu.MPopupMenu;
import org.eclipse.e4.ui.model.application.ui.menu.MRenderedMenu;
import org.eclipse.e4.ui.model.application.ui.menu.impl.MenuFactoryImpl;
import org.eclipse.e4.ui.workbench.modeling.ExpressionContext;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuListener2;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.internal.ObjectActionContributorManager;
import org.eclipse.ui.internal.PluginActionContributionItem;
import org.eclipse.ui.internal.ViewerActionBuilder;
import org.eclipse.ui.internal.Workbench;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.menus.IMenuService;

public class PopupMenuExtender
implements IMenuListener2,
IRegistryChangeListener {
    private static final int STATIC_ACTION_READ = 1;
    private static final int INCLUDE_EDITOR_INPUT = 2;
    private final MenuManager menu;
    private SubMenuManager menuWrapper;
    private final ISelectionProvider selProvider;
    private final IWorkbenchPart part;
    private Map staticActionBuilders = null;
    private int bitSet = 0;
    private ArrayList actionContributionCache = new ArrayList();
    private ArrayList managerContributionCache = new ArrayList();
    private ArrayList<MRenderedMenu> renderedMenuCache = new ArrayList();
    private ArrayList<MRenderedMenu> lastRenderedMenuCache = new ArrayList();
    private boolean cleanupNeeded = false;
    private MPart modelPart;
    private MRenderedMenu menuModel;

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part) {
        this(id, menu, prov, part, true);
    }

    public PopupMenuExtender(String id, MenuManager menu, ISelectionProvider prov, IWorkbenchPart part, boolean includeEditorInput) {
        this.menu = menu;
        this.selProvider = prov;
        this.part = part;
        this.modelPart = (MPart)part.getSite().getService(MPart.class);
        if (includeEditorInput) {
            this.bitSet |= 2;
        }
        menu.addMenuListener((IMenuListener)this);
        if (!menu.getRemoveAllWhenShown()) {
            this.menuWrapper = new SubMenuManager((IMenuManager)menu);
            this.menuWrapper.setVisible(true);
        }
        this.createModelFor(id);
        this.readStaticActionsFor(id);
        Platform.getExtensionRegistry().addRegistryChangeListener((IRegistryChangeListener)this);
    }

    private void createModelFor(String id) {
        this.menuModel = null;
        for (MMenu item : this.modelPart.getMenus()) {
            if (!id.equals(item.getElementId()) || !(item instanceof MRenderedMenu) || !item.getTags().contains("popup")) continue;
            this.menuModel = (MRenderedMenu)item;
            break;
        }
        if (this.menuModel == null) {
            this.menuModel = MenuFactoryImpl.eINSTANCE.createRenderedMenu();
            this.menuModel.setElementId(id);
            this.menuModel.getTags().add("menuContribution:popup");
            this.modelPart.getMenus().add(this.menuModel);
            MPopupMenu popup = MenuFactoryImpl.eINSTANCE.createPopupMenu();
            popup.setElementId(id);
            popup.getTags().add("menuContribution:popup");
            this.menuModel.getChildren().add(popup);
        }
        this.menuModel.setContributionManager((Object)this.menu);
        this.registerE4Support();
    }

    private void registerE4Support() {
        if (this.menuModel.getWidget() == null && this.menu.getMenu() != null) {
            this.menuModel.setWidget((Object)this.menu.getMenu());
            this.menu.getMenu().setData("modelElement", (Object)this.menuModel);
            MPopupMenu popup = (MPopupMenu)this.menuModel.getChildren().get(0);
            IEclipseContext popupContext = this.modelPart.getContext().createChild("popup:" + popup.getElementId());
            popup.setContext(popupContext);
        }
    }

    public Set getMenuIds() {
        if (this.staticActionBuilders == null) {
            return Collections.EMPTY_SET;
        }
        return this.staticActionBuilders.keySet();
    }

    public final void addMenuId(String menuId) {
        String tag;
        List tags;
        this.bitSet &= 0xFFFFFFFE;
        if (this.menuModel != null && !(tags = ((MMenuElement)this.menuModel.getChildren().get(0)).getTags()).contains(tag = "popup:" + menuId)) {
            tags.add(tag);
        }
        this.readStaticActionsFor(menuId);
    }

    public final boolean matches(MenuManager menuManager, ISelectionProvider selectionProvider, IWorkbenchPart part) {
        return this.menu == menuManager && this.selProvider == selectionProvider && this.part == part;
    }

    private void addEditorActions(IMenuManager mgr) {
        ISelectionProvider activeEditor = new ISelectionProvider(){

            public void addSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public ISelection getSelection() {
                if (PopupMenuExtender.this.part instanceof IEditorPart) {
                    IEditorPart editorPart = (IEditorPart)PopupMenuExtender.this.part;
                    return new StructuredSelection(new Object[]{editorPart.getEditorInput()});
                }
                return new StructuredSelection(new Object[0]);
            }

            public void removeSelectionChangedListener(ISelectionChangedListener listener) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }

            public void setSelection(ISelection selection) {
                throw new UnsupportedOperationException("This ISelectionProvider is static, and cannot be modified.");
            }
        };
        if (ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, activeEditor)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private void addObjectActions(IMenuManager mgr) {
        if (this.selProvider != null && ObjectActionContributorManager.getManager().contributeObjectActions(this.part, mgr, this.selProvider)) {
            mgr.add((IContributionItem)new Separator());
        }
    }

    private final void clearStaticActions() {
        this.bitSet &= 0xFFFFFFFE;
        if (this.staticActionBuilders != null) {
            for (Object staticActionBuilder : this.staticActionBuilders.values()) {
                if (!(staticActionBuilder instanceof ViewerActionBuilder)) continue;
                ((ViewerActionBuilder)staticActionBuilder).dispose();
            }
        }
    }

    private void addStaticActions(IMenuManager mgr) {
        if (this.staticActionBuilders != null) {
            for (ViewerActionBuilder staticActionBuilder : this.staticActionBuilders.values()) {
                staticActionBuilder.contribute(mgr, null, true);
            }
        }
    }

    public void menuAboutToShow(IMenuManager mgr) {
        IWorkbench workbench;
        this.registerE4Support();
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            Workbench realWorkbench = (Workbench)workbench;
            this.runCleanUp(realWorkbench);
            StructuredSelection input = null;
            if ((this.bitSet & 2) != 0 && this.part instanceof IEditorPart) {
                IEditorPart editorPart = (IEditorPart)this.part;
                input = new StructuredSelection(new Object[]{editorPart.getEditorInput()});
            }
            ISelection s = this.selProvider == null ? null : this.selProvider.getSelection();
            realWorkbench.addShowingMenus(this.getMenuIds(), s, (ISelection)input);
        }
        this.readStaticActions();
        if (this.menuWrapper != null) {
            mgr = this.menuWrapper;
            this.menuWrapper.removeAll();
        }
        this.addMenuContributions(mgr);
        if ((this.bitSet & 2) != 0) {
            this.addEditorActions(mgr);
        }
        this.addObjectActions(mgr);
        this.addStaticActions(mgr);
        this.cleanUpContributionCache();
    }

    private void addMenuContributions(IMenuManager mgr) {
        MPopupMenu popup = (MPopupMenu)this.menuModel.getChildren().get(0);
        IEclipseContext popupContext = popup.getContext();
        IEclipseContext parentContext = popupContext.getParent();
        MApplication application = (MApplication)parentContext.get(MApplication.class);
        ArrayList toContribute = new ArrayList();
        ExpressionContext eContext = new ExpressionContext(popupContext);
        ContributionsAnalyzer.gatherMenuContributions((MMenu)popup, (List)application.getMenuContributions(), (String)popup.getElementId(), toContribute, (ExpressionContext)eContext, (boolean)true);
        for (String tag : popup.getTags()) {
            if (!tag.startsWith("popup:") || tag.length() <= 6) continue;
            ContributionsAnalyzer.gatherMenuContributions((MMenu)popup, (List)application.getMenuContributions(), (String)tag.substring(6), toContribute, (ExpressionContext)eContext, (boolean)false);
        }
        for (MMenuContribution contribution : toContribute) {
            String positionInParent = contribution.getPositionInParent();
            String id = null;
            String modifier = null;
            if (positionInParent != null && positionInParent.length() > 0) {
                String[] array = positionInParent.split("=");
                modifier = array[0];
                id = array[1];
            }
            if (id == null) continue;
            IContributionItem item = mgr.find(id);
            if (item == null) {
                if (!"additions".equals(id)) continue;
                mgr.add((IContributionItem)new GroupMarker("additions"));
            }
            for (MMenuElement element : contribution.getChildren()) {
                MMenu menu;
                if (!(element instanceof MMenu) || mgr.find((menu = (MMenu)element).getElementId()) != null) continue;
                MenuManager submenu = new MenuManager(menu.getLabel(), menu.getElementId());
                if (modifier.equals("before")) {
                    mgr.insertBefore(id, (IContributionItem)submenu);
                } else {
                    mgr.insertAfter(id, (IContributionItem)submenu);
                }
                MRenderedMenu renderedMenu = MenuFactoryImpl.eINSTANCE.createRenderedMenu();
                renderedMenu.setElementId(menu.getElementId());
                renderedMenu.getTags().add("menuContribution:popup");
                renderedMenu.setContributionManager((Object)submenu);
                popup.getChildren().add(renderedMenu);
                this.renderedMenuCache.add(renderedMenu);
            }
        }
    }

    public final void menuAboutToHide(IMenuManager mgr) {
        IWorkbench workbench;
        this.gatherContributions(mgr);
        if (!this.renderedMenuCache.isEmpty()) {
            this.lastRenderedMenuCache = this.renderedMenuCache;
            this.renderedMenuCache = new ArrayList();
        }
        this.cleanupNeeded = true;
        IWorkbenchPartSite site = this.part.getSite();
        if (site != null && (workbench = site.getWorkbenchWindow().getWorkbench()) instanceof Workbench) {
            workbench.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    Workbench realWorkbench = (Workbench)workbench;
                    PopupMenuExtender.this.runCleanUp(realWorkbench);
                }
            });
        }
    }

    private void runCleanUp(Workbench realWorkbench) {
        if (!this.cleanupNeeded) {
            return;
        }
        this.cleanupNeeded = false;
        realWorkbench.removeShowingMenus(this.getMenuIds(), null, null);
        this.cleanUpContributionCache();
    }

    private void gatherContributions(IMenuManager mgr) {
        IContributionItem[] items = mgr.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i] instanceof PluginActionContributionItem) {
                this.actionContributionCache.add(items[i]);
            } else if (items[i] instanceof IMenuManager) {
                if (items[i] instanceof ContributionManager) {
                    this.managerContributionCache.add(items[i]);
                }
                this.gatherContributions((IMenuManager)items[i]);
            }
            ++i;
        }
    }

    private void cleanUpContributionCache() {
        if (!this.actionContributionCache.isEmpty()) {
            PluginActionContributionItem[] items = this.actionContributionCache.toArray(new PluginActionContributionItem[this.actionContributionCache.size()]);
            this.actionContributionCache.clear();
            int i = 0;
            while (i < items.length) {
                items[i].dispose();
                ++i;
            }
        }
        for (MRenderedMenu rmenu : this.lastRenderedMenuCache) {
            MPopupMenu popup = (MPopupMenu)this.menuModel.getChildren().get(0);
            popup.getChildren().remove(rmenu);
        }
        this.lastRenderedMenuCache.clear();
        this.managerContributionCache.clear();
    }

    private final void readStaticActions() {
        if (this.staticActionBuilders != null) {
            for (String menuId : this.staticActionBuilders.keySet()) {
                this.readStaticActionsFor(menuId);
            }
        }
    }

    private void readStaticActionsFor(String menuId) {
        Object object;
        if ((this.bitSet & 1) != 0) {
            return;
        }
        this.bitSet |= 1;
        if (menuId == null || menuId.length() < 1) {
            return;
        }
        if (this.staticActionBuilders == null) {
            this.staticActionBuilders = new HashMap();
        }
        if (!((object = this.staticActionBuilders.get(menuId)) instanceof ViewerActionBuilder)) {
            object = new ViewerActionBuilder();
            this.staticActionBuilders.put(menuId, object);
        }
        ViewerActionBuilder staticActionBuilder = (ViewerActionBuilder)object;
        staticActionBuilder.readViewerContributions(menuId, this.selProvider, this.part);
    }

    public void dispose() {
        this.clearStaticActions();
        IMenuService menuService = (IMenuService)this.part.getSite().getService(IMenuService.class);
        if (menuService != null) {
            menuService.releaseContributions((ContributionManager)this.menu);
        }
        Platform.getExtensionRegistry().removeRegistryChangeListener((IRegistryChangeListener)this);
        this.menu.removeMenuListener((IMenuListener)this);
    }

    public void registryChanged(IRegistryChangeEvent event) {
        Display display = Display.getDefault();
        if (this.part != null) {
            display = this.part.getSite().getPage().getWorkbenchWindow().getWorkbench().getDisplay();
        }
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        int i = 0;
        while (i < deltas.length) {
            IExtensionDelta delta = deltas[i];
            IExtensionPoint extensionPoint = delta.getExtensionPoint();
            if (extensionPoint.getNamespace().equals(WorkbenchPlugin.PI_WORKBENCH) && extensionPoint.getSimpleIdentifier().equals("popupMenus")) {
                boolean clearPopups = false;
                IConfigurationElement[] elements = delta.getExtension().getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals("viewerContribution")) {
                        clearPopups = true;
                        break;
                    }
                    ++j;
                }
                if (clearPopups) {
                    display.syncExec(new Runnable(){

                        public void run() {
                            PopupMenuExtender.this.clearStaticActions();
                        }
                    });
                }
            }
            ++i;
        }
    }

    public MenuManager getManager() {
        return this.menu;
    }
}

