/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhKeyEvent_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.internal.photon.PtCallbackInfo_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.WidgetTable;

public class Spinner
extends Composite {
    public static final int LIMIT = Short.MAX_VALUE;

    public Spinner(Composite parent, int style) {
        super(parent, Spinner.checkStyle(style));
    }

    static int checkStyle(int style) {
        return style & 0xFFFFFCFF;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            Spinner.error(43);
        }
    }

    void createHandle(int index) {
        this.state |= 8;
        int parentHandle = this.parent.parentingHandle();
        boolean hasBorder = (this.style & 0x800) != 0;
        int textFlags = (this.style & 8) != 0 ? 0 : 2;
        boolean wrap = (this.style & 0x40) != 0;
        int[] nArray = new int[21];
        nArray[0] = 1008;
        nArray[2] = 0x3F00000;
        nArray[3] = 53003;
        nArray[4] = 1;
        nArray[6] = 53005;
        nArray[9] = 53006;
        nArray[10] = 100;
        nArray[12] = 4008;
        nArray[13] = textFlags;
        nArray[14] = 2;
        nArray[15] = 1006;
        nArray[16] = hasBorder ? 256 : 0;
        nArray[17] = 256;
        nArray[18] = 53001;
        nArray[19] = wrap ? 4 : 0;
        nArray[20] = 4;
        int[] args = nArray;
        this.handle = OS.PtCreateWidget(this.display.PtNumericInteger, parentHandle, args.length / 3, args);
        if (this.handle == 0) {
            Spinner.error(2);
        }
    }

    public void addModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Spinner.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(24, typedListener);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Spinner.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    void addVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Spinner.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(25, typedListener);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int[] nArray = new int[9];
        nArray[0] = 3010;
        nArray[3] = 53006;
        nArray[6] = 53002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int width = wHint;
        int height = hHint;
        if (wHint == -1 || hHint == -1) {
            int ptr = args[1];
            int length = OS.strlen(ptr);
            byte[] font = new byte[length + 1];
            OS.memmove(font, ptr, length);
            String string = String.valueOf(args[4]);
            PhRect_t rect = new PhRect_t();
            int size = string.length();
            char[] buffer = new char[size];
            string.getChars(0, size, buffer, 0);
            OS.PfExtentWideText(rect, null, font, buffer, size * 2);
            if (wHint == -1) {
                width = rect.lr_x - rect.ul_x + 1;
            }
            if (hHint == -1) {
                height = rect.lr_y - rect.ul_y + 1;
            }
        }
        Rectangle trim = this.computeTrim(0, 0, width, height);
        if (hHint == -1) {
            trim.height = Math.max(trim.height, args[7] * 2);
        }
        return new Point(trim.width, trim.height);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        int border = this.getBorderWidth();
        x -= border;
        y -= border;
        width += 2 * border;
        height += 2 * border;
        int[] nArray = new int[6];
        nArray[0] = 53017;
        nArray[3] = 53002;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        int textBorder = 2;
        width += args[1] + args[4] + 2 * textBorder;
        height += 2 * textBorder;
        int textHandle = OS.PtWidgetChildBack(this.handle);
        int[] nArray2 = new int[12];
        nArray2[0] = 2005;
        nArray2[3] = 3005;
        nArray2[6] = 3006;
        nArray2[9] = 3058;
        args = nArray2;
        OS.PtGetResources(textHandle, args.length / 3, args);
        return new Rectangle(x, y, width += args[1] + args[4] + args[7] + args[10], height);
    }

    public void copy() {
        this.checkWidget();
        int textHandle = OS.PtWidgetChildBack(this.handle);
        if (textHandle != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            int length = OS.PtTextGetSelection(textHandle, start, end);
            if (length <= 0) {
                return;
            }
            int[] nArray = new int[3];
            nArray[0] = 3011;
            int[] args = nArray;
            OS.PtGetResources(textHandle, args.length / 3, args);
            byte[] buffer = new byte[length + 1];
            OS.memmove(buffer, args[1] + start[0], length);
            int ig = OS.PhInputGroup(0);
            OS.PhClipboardCopyString((short)ig, buffer);
        }
    }

    public void cut() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        int textHandle = OS.PtWidgetChildBack(this.handle);
        if (textHandle != 0) {
            int[] start = new int[1];
            int[] end = new int[1];
            int length = OS.PtTextGetSelection(textHandle, start, end);
            if (length <= 0) {
                return;
            }
            int[] nArray = new int[3];
            nArray[0] = 3011;
            int[] args = nArray;
            OS.PtGetResources(textHandle, args.length / 3, args);
            byte[] buffer = new byte[length + 1];
            OS.memmove(buffer, args[1] + start[0], length);
            int ig = OS.PhInputGroup(0);
            OS.PhClipboardCopyString((short)ig, buffer);
            buffer = new byte[]{};
            OS.PtTextModifyText(textHandle, start[0], end[0], start[0], buffer, buffer.length);
        }
    }

    void deregister() {
        super.deregister();
        int textHandle = OS.PtWidgetChildBack(this.handle);
        WidgetTable.remove(textHandle);
    }

    int defaultBackground() {
        return this.display.TEXT_BACKGROUND;
    }

    int defaultForeground() {
        return this.display.TEXT_FOREGROUND;
    }

    public int getDigits() {
        this.checkWidget();
        return 0;
    }

    public int getIncrement() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 53003;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getMaximum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 53006;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getMinimum() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 53005;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public int getPageIncrement() {
        this.checkWidget();
        return 0;
    }

    public int getSelection() {
        this.checkWidget();
        int[] nArray = new int[3];
        nArray[0] = 53004;
        int[] args = nArray;
        OS.PtGetResources(this.handle, args.length / 3, args);
        return args[1];
    }

    public String getText() {
        this.checkWidget();
        return "";
    }

    public int getTextLimit() {
        this.checkWidget();
        return LIMIT;
    }

    boolean hasFocus() {
        return OS.PtIsFocused(this.handle) != 0;
    }

    void hookEvents() {
        super.hookEvents();
        int windowProc = this.display.windowProc;
        OS.PtAddCallback(this.handle, 53015, windowProc, 53015);
    }

    public void paste() {
        this.checkWidget();
        if ((this.style & 8) != 0) {
            return;
        }
        int textHandle = OS.PtWidgetChildBack(this.handle);
        if (textHandle != 0) {
            int ig = OS.PhInputGroup(0);
            int ptr = OS.PhClipboardPasteString((short)ig);
            if (ptr == 0) {
                return;
            }
            int length = OS.strlen(ptr);
            int[] start = new int[1];
            int[] end = new int[1];
            OS.PtTextGetSelection(textHandle, start, end);
            if (start[0] == -1) {
                int[] nArray = new int[3];
                nArray[0] = 4003;
                int[] args = nArray;
                OS.PtGetResources(textHandle, args.length / 3, args);
                start[0] = end[0] = args[1];
            }
            OS.PtTextModifyText(textHandle, start[0], end[0], end[0], ptr, length);
            OS.free(ptr);
        }
    }

    int Pt_CB_NUMERIC_CHANGED(int widget, int info) {
        if (info == 0) {
            return 2;
        }
        PtCallbackInfo_t cbinfo = new PtCallbackInfo_t();
        OS.memmove(cbinfo, info, 16);
        if (cbinfo.event == 0) {
            return 2;
        }
        switch (cbinfo.reason_subtype) {
            case 1: {
                this.sendEvent(24);
                break;
            }
            case 4: 
            case 8: {
                this.sendEvent(13);
            }
        }
        return 0;
    }

    void register() {
        super.register();
        int textHandle = OS.PtWidgetChildBack(this.handle);
        WidgetTable.put(textHandle, this);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Spinner.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(24, listener);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            Spinner.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    void removeVerifyListener(VerifyListener listener) {
        this.checkWidget();
        if (listener == null) {
            Spinner.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(25, listener);
    }

    public void setDigits(int value) {
        this.checkWidget();
    }

    public void setIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
        OS.PtSetResource(this.handle, 53003, value, 0);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        OS.PtSetResource(this.handle, 53006, value, 0);
    }

    public void setMinimum(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        OS.PtSetResource(this.handle, 53005, value, 0);
    }

    public void setPageIncrement(int value) {
        this.checkWidget();
        if (value < 1) {
            return;
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        OS.PtSetResource(this.handle, 53004, value, 0);
    }

    public void setTextLimit(int limit) {
        this.checkWidget();
        if (limit == 0) {
            Spinner.error(7);
        }
    }

    public void setValues(int selection, int minimum, int maximum, int digits, int increment, int pageIncrement) {
        this.checkWidget();
        if (minimum < 0) {
            return;
        }
        if (maximum <= minimum) {
            return;
        }
        if (digits < 0) {
            return;
        }
        if (increment < 1) {
            return;
        }
        if (pageIncrement < 1) {
            return;
        }
        selection = Math.min(Math.max(minimum, selection), maximum);
        int[] nArray = new int[12];
        nArray[0] = 53003;
        nArray[1] = increment;
        nArray[3] = 53005;
        nArray[4] = minimum;
        nArray[6] = 53006;
        nArray[7] = maximum;
        nArray[9] = 53004;
        nArray[10] = selection;
        int[] args = nArray;
        OS.PtSetResources(this.handle, args.length / 3, args);
    }

    boolean translateTraversal(int key_sym, PhKeyEvent_t phEvent) {
        boolean translated = super.translateTraversal(key_sym, phEvent);
        if (!translated && key_sym == 61453) {
            this.postEvent(14);
            return false;
        }
        return translated;
    }

    int widgetClass() {
        return OS.PtNumericInteger();
    }
}

