/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.photon.OS;
import org.eclipse.swt.internal.photon.PhCursorInfo_t;
import org.eclipse.swt.internal.photon.PhImage_t;
import org.eclipse.swt.internal.photon.PhRect_t;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.swt.widgets.WidgetTable;

public class Display
extends Device {
    int textHighlightThickness = 0;
    public boolean embedded;
    public int app_context;
    Event[] eventQueue;
    EventTable eventTable;
    EventTable filterTable;
    Callback windowCallback;
    Callback drawCallback;
    Callback workCallback;
    Callback inputCallback;
    Callback hotkeyCallback;
    int windowProc;
    int drawProc;
    int workProc;
    int inputProc;
    int hotkeyProc;
    int input;
    int pulse;
    boolean idle;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    int dragStartX;
    int dragStartY;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    int timerHandle;
    int lastKey;
    int lastAscii;
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    private static final int[][] KeyTable = new int[][]{{61673, 65536}, {61674, 65536}, {61665, 131072}, {61666, 131072}, {61667, 262144}, {61668, 262144}, {61522, 0x1000001}, {61524, 0x1000002}, {61521, 0x1000003}, {61523, 0x1000004}, {61525, 0x1000005}, {61526, 0x1000006}, {61520, 0x1000007}, {61527, 0x1000008}, {61539, 0x1000009}, {61448, 8}, {61453, 13}, {61695, 127}, {61467, 27}, {61450, 10}, {61449, 9}, {61577, 9}, {61630, 0x100000A}, {61631, 0x100000B}, {61632, 0x100000C}, {61633, 0x100000D}, {61634, 0x100000E}, {61635, 0x100000F}, {61636, 0x1000010}, {61637, 0x1000011}, {61638, 0x1000012}, {61639, 0x1000013}, {61640, 0x1000014}, {61641, 0x1000015}, {61642, 0x1000016}, {61643, 0x1000017}, {61644, 0x1000018}, {61610, 16777258}, {61611, 16777259}, {61581, 0x1000050}, {61613, 16777261}, {61614, 16777262}, {61615, 16777263}, {61616, 0x1000030}, {61617, 0x1000031}, {61618, 16777266}, {61619, 0x1000033}, {61620, 16777268}, {61621, 16777269}, {61622, 16777270}, {61623, 16777271}, {61624, 16777272}, {61625, 16777273}, {61629, 16777277}, {61669, 16777298}, {61567, 16777299}, {61460, 16777300}, {61459, 0x1000055}, {61547, 16777302}, {61537, 16777303}, {61546, 0x1000051}};
    static Display Default;
    static Display[] Displays;
    int ClassesPtr;
    int PtButton;
    int PtList;
    int PtLabel;
    int PtToggleButton;
    int PtComboBox;
    int PtText;
    int PtMultiText;
    int PtScrollbar;
    int PtContainer;
    int PtProgress;
    int PtPanelGroup;
    int PtSlider;
    int PtSeparator;
    int PtToolbar;
    int PtNumericInteger;
    int WIDGET_DARK_SHADOW;
    int WIDGET_NORMAL_SHADOW;
    int WIDGET_LIGHT_SHADOW;
    int WIDGET_HIGHLIGHT_SHADOW;
    int WIDGET_BACKGROUND;
    int WIDGET_FOREGROUND;
    int WIDGET_BORDER;
    int LIST_FOREGROUND;
    int LIST_BACKGROUND;
    int LIST_SELECTION;
    int LIST_SELECTION_TEXT;
    int INFO_FOREGROUND;
    int INFO_BACKGROUND;
    int TEXT_FOREGROUND;
    int TEXT_BACKGROUND;
    byte[] defaultFont;
    byte[] TEXT_FONT;
    byte[] LIST_FONT;
    byte[] TITLE_FONT;
    byte[] GAUGE_FONT;
    byte[] GROUP_FONT;
    Cursor[] cursors = new Cursor[22];
    int nullImage;
    int SCROLLBAR_WIDTH;
    int SCROLLBAR_HEIGHT;
    int SCROLLBAR_VERTICAL_BASIC_FLAGS;
    int SCROLLBAR_HORIZONTAL_BASIC_FLAGS;
    static final int GROW_SIZE = 1024;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_NAME;
    static int DrawBufferSize;
    Object data;
    String[] keys;
    Object[] values;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Displays = new Display[4];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.widgets.Display");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        PACKAGE_NAME = name.substring(0, index + 1);
        DrawBufferSize = 49152;
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(data);
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.PtBeep();
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[i].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    String convertToLf(String text) {
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int i = text.indexOf(10, 0);
        if (i == -1 || i == 0) {
            return text;
        }
        if (text.charAt(i - 1) != '\r') {
            return text;
        }
        i = 0;
        StringBuffer result = new StringBuffer();
        while (i < length) {
            int j = text.indexOf(13, i);
            if (j == -1) {
                j = length;
            }
            String s = text.substring(i, j);
            result.append(s);
            i = j + 2;
            result.append('\n');
        }
        return result.toString();
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, false);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        OS.PtInit(null);
        OS.PgSetDrawBufferSize(DrawBufferSize);
        this.app_context = OS.PtCreateAppContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    int drawProc(int handle, int damage) {
        if (this.thread != Thread.currentThread()) {
            return 0;
        }
        Widget widget = WidgetTable.get(handle);
        if (widget == null) {
            return 0;
        }
        return widget.drawProc(handle, damage);
    }

    void error(int code) {
        SWT.error(code);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                Display display = Displays[i];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return WidgetTable.get(handle);
    }

    public Widget findWidget(int handle, int id) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int id) {
        this.checkDevice();
        return null;
    }

    public Shell getActiveShell() {
        this.checkDevice();
        int handle = 0;
        while ((handle = OS.PtNextTopLevelWidget(handle)) != 0) {
            Widget widget;
            int state = OS.PtWindowGetState(handle);
            if (state == -1 || (state & 0x8000) == 0 || !((widget = WidgetTable.get(handle)) instanceof Shell)) continue;
            return (Shell)widget;
        }
        return null;
    }

    public Control getCursorControl() {
        this.checkDevice();
        int ig = OS.PhInputGroup(0);
        PhCursorInfo_t info = new PhCursorInfo_t();
        OS.PhQueryCursor((short)ig, info);
        PhRect_t rect = new PhRect_t();
        rect.ul_x = rect.lr_x = info.pos_x;
        rect.ul_y = rect.lr_y = info.pos_y;
        int handle = 0;
        while ((handle = OS.PtNextTopLevelWidget(handle)) != 0) {
            int child = handle;
            int parent = 0;
            short[] x = new short[1];
            short[] y = new short[1];
            do {
                OS.PtGetAbsPosition(child, x, y);
                rect.ul_x = rect.lr_x = (short)(info.pos_x - x[0]);
                rect.ul_y = rect.lr_y = (short)(info.pos_y - y[0]);
                child = OS.PtHit(child, 1, rect);
                if (child == 0) break;
                parent = child;
            } while (OS.PtWidgetIsClassMember(child, OS.PtContainer()) != 0 && child != 0);
            if (parent == 0) continue;
            do {
                Widget widget;
                if ((widget = WidgetTable.get(parent)) == null || !(widget instanceof Control)) continue;
                Control control = (Control)widget;
                if (control.getEnabled()) {
                    return control;
                }
                return control;
            } while ((parent = OS.PtWidgetParent(parent)) != 0);
        }
        return null;
    }

    public Point[] getCursorSizes() {
        this.checkDevice();
        return new Point[]{new Point(16, 16), new Point(32, 32)};
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int ig = OS.PhInputGroup(0);
        PhCursorInfo_t info = new PhCursorInfo_t();
        OS.PhQueryCursor((short)ig, info);
        return new Point(info.pos_x, info.pos_y);
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public static void setAppVersion(String version) {
        APP_VERSION = version;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 131072;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return 250;
    }

    public Control getFocusControl() {
        this.checkDevice();
        int handle = 0;
        while ((handle = OS.PtNextTopLevelWidget(handle)) != 0) {
            Widget widget;
            int state = OS.PtWindowGetState(handle);
            if (state == -1 || (state & 0x8000) == 0) continue;
            int focusHandle = OS.PtContainerFindFocus(handle);
            if (focusHandle != 0 && (widget = WidgetTable.get(focusHandle)) instanceof Control) {
                return (Control)widget;
            }
            return null;
        }
        return null;
    }

    int getLastEventTime() {
        return (int)System.currentTimeMillis();
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        this.checkDevice();
        return new Point[]{new Point(15, 15), new Point(43, 43)};
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        this.checkDevice();
        int cnt = OS.PhQueryRids(0, 0, 0, 4, 0, 0, null, null, 0);
        int[] rids = new int[cnt];
        cnt = OS.PhQueryRids(0, 0, 0, 4, 0, 0, null, rids, rids.length);
        PhRect_t rect = new PhRect_t();
        Monitor[] monitors = new Monitor[cnt];
        int i = 0;
        while (i < cnt) {
            Monitor monitor = new Monitor();
            monitor.handle = rids[i];
            OS.PhWindowQueryVisible(0, rids[i], OS.PhInputGroup(0), rect);
            monitor.x = rect.ul_x;
            monitor.y = rect.ul_y;
            monitor.width = rect.lr_x - rect.ul_x + 1;
            monitor.height = rect.lr_y - rect.ul_y + 1;
            OS.PhWindowQueryVisible(2, rids[i], OS.PhInputGroup(0), rect);
            monitor.clientX = rect.ul_x;
            monitor.clientY = rect.ul_y;
            monitor.clientWidth = rect.lr_x - rect.ul_x + 1;
            monitor.clientHeight = rect.lr_y - rect.ul_y + 1;
            monitors[i] = monitor;
            ++i;
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        this.checkDevice();
        Monitor[] monitors = this.getMonitors();
        if (monitors.length == 1) {
            return monitors[0];
        }
        int i = 0;
        while (i < monitors.length) {
            Monitor monitor = monitors[i];
            if (monitor.x == 0 && monitor.y == 0) {
                return monitor;
            }
            ++i;
        }
        return monitors[0];
    }

    public Shell[] getShells() {
        this.checkDevice();
        int count = 0;
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.display) {
                ++count;
            }
            ++i;
        }
        if (count == shells.length) {
            return shells;
        }
        int index = 0;
        Shell[] result = new Shell[count];
        int i2 = 0;
        while (i2 < shells.length) {
            Shell shell = shells[i2];
            if (!shell.isDisposed() && this == shell.display) {
                result[index++] = shell;
            }
            ++i2;
        }
        return result;
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        int color = 0;
        switch (id) {
            case 28: {
                color = this.INFO_FOREGROUND;
                break;
            }
            case 29: {
                color = this.INFO_BACKGROUND;
                break;
            }
            case 30: {
                color = 0xFFFFFF;
                break;
            }
            case 31: {
                color = 5407189;
                break;
            }
            case 32: {
                color = 7644159;
                break;
            }
            case 33: {
                color = 0;
                break;
            }
            case 34: {
                color = 11254739;
                break;
            }
            case 35: {
                color = 0xCDDDFF;
                break;
            }
            case 17: {
                color = this.WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                color = this.WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                color = this.WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                color = this.WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                color = this.WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                color = this.WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                color = this.WIDGET_BORDER;
                break;
            }
            case 24: {
                color = this.LIST_FOREGROUND;
                break;
            }
            case 25: {
                color = this.LIST_BACKGROUND;
                break;
            }
            case 26: {
                color = this.LIST_SELECTION;
                break;
            }
            case 27: {
                color = this.LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        return Color.photon_new(this, color);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Font getSystemFont() {
        this.checkDevice();
        byte[] font = this.defaultFont != null ? this.defaultFont : this.TEXT_FONT;
        return Font.photon_new(this, font);
    }

    public Image getSystemImage(int id) {
        this.checkDevice();
        return null;
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        return null;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    int hotkeyProc(int handle, int data, int info) {
        Widget widget = WidgetTable.get(handle);
        if (widget == null) {
            return 0;
        }
        return widget.hotkeyProc(handle, data, info);
    }

    protected void init() {
        super.init();
        this.initializeDisplay();
        this.initializeWidgetClasses();
        this.initializeWidgetColors();
        this.initializeWidgetFonts();
        this.initializeScrollbars();
        this.initializeImages();
    }

    void initializeDisplay() {
        this.windowCallback = new Callback(this, "windowProc", 3);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.drawCallback = new Callback(this, "drawProc", 2);
        this.drawProc = this.drawCallback.getAddress();
        if (this.drawProc == 0) {
            this.error(3);
        }
        this.workCallback = new Callback(this, "workProc", 1);
        this.workProc = this.workCallback.getAddress();
        if (this.workProc == 0) {
            this.error(3);
        }
        this.inputCallback = new Callback(this, "inputProc", 4);
        this.inputProc = this.inputCallback.getAddress();
        if (this.inputProc == 0) {
            this.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 3);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.hotkeyCallback = new Callback(this, "hotkeyProc", 3);
        this.hotkeyProc = this.hotkeyCallback.getAddress();
        if (this.hotkeyProc == 0) {
            this.error(3);
        }
        this.pulse = OS.PtAppCreatePulse(this.app_context, -1);
        this.input = OS.PtAppAddInput(this.app_context, this.pulse, this.inputProc, 0);
        int[] nArray = new int[9];
        nArray[0] = 15005;
        nArray[2] = -1;
        nArray[3] = 2002;
        nArray[4] = -1;
        nArray[6] = 15008;
        nArray[7] = 65536;
        nArray[8] = -1;
        int[] args = nArray;
        OS.PtSetParentWidget(0);
        this.timerHandle = OS.PtCreateWidget(OS.PtRegion(), 0, args.length / 3, args);
        if (this.timerHandle == 0) {
            this.error(2);
        }
        OS.PtRealizeWidget(this.timerHandle);
    }

    void initializeScrollbars() {
        OS.PtSetParentWidget(0);
        int shellHandle = OS.PtCreateWidget(OS.PtWindow(), 0, 0, null);
        int textHandle = OS.PtCreateWidget(OS.PtMultiText(), shellHandle, 0, null);
        int child = OS.PtWidgetChildFront(textHandle);
        while (child != 0) {
            if (OS.PtWidgetClass(child) == OS.PtScrollbar()) {
                int[] nArray = new int[12];
                nArray[0] = 21005;
                nArray[3] = 1023;
                nArray[6] = 1024;
                nArray[9] = 2015;
                int[] args = nArray;
                OS.PtGetResources(child, args.length / 3, args);
                switch (args[1]) {
                    case 1: {
                        this.SCROLLBAR_HEIGHT = args[7];
                        this.SCROLLBAR_HORIZONTAL_BASIC_FLAGS = args[10];
                        break;
                    }
                    case 0: {
                        this.SCROLLBAR_WIDTH = args[4];
                        this.SCROLLBAR_VERTICAL_BASIC_FLAGS = args[10];
                    }
                }
            }
            child = OS.PtWidgetBrotherBehind(child);
        }
        OS.PtDestroyWidget(shellHandle);
    }

    void initializeWidgetClasses() {
        int[] nArray = new int[3];
        nArray[0] = 1507348;
        nArray[1] = this.drawProc;
        int[] args = nArray;
        int[] nArray2 = new int[57];
        nArray2[0] = OS.PtCreateWidgetClass(OS.PtButton(), 0, args.length / 3, args);
        nArray2[3] = OS.PtCreateWidgetClass(OS.PtList(), 0, args.length / 3, args);
        nArray2[6] = OS.PtCreateWidgetClass(OS.PtLabel(), 0, args.length / 3, args);
        nArray2[9] = OS.PtCreateWidgetClass(OS.PtWindow(), 0, args.length / 3, args);
        nArray2[12] = OS.PtCreateWidgetClass(OS.PtToggleButton(), 0, args.length / 3, args);
        nArray2[15] = OS.PtCreateWidgetClass(OS.PtComboBox(), 0, args.length / 3, args);
        nArray2[18] = OS.PtCreateWidgetClass(OS.PtText(), 0, args.length / 3, args);
        nArray2[21] = OS.PtCreateWidgetClass(OS.PtMultiText(), 0, args.length / 3, args);
        nArray2[24] = OS.PtCreateWidgetClass(OS.PtScrollbar(), 0, args.length / 3, args);
        nArray2[27] = OS.PtCreateWidgetClass(OS.PtScrollContainer(), 0, args.length / 3, args);
        nArray2[30] = OS.PtCreateWidgetClass(OS.PtScrollArea(), 0, args.length / 3, args);
        nArray2[33] = OS.PtCreateWidgetClass(OS.PtContainer(), 0, args.length / 3, args);
        nArray2[36] = OS.PtCreateWidgetClass(OS.PtProgress(), 0, args.length / 3, args);
        nArray2[39] = OS.PtCreateWidgetClass(OS.PtPanelGroup(), 0, args.length / 3, args);
        nArray2[42] = OS.PtCreateWidgetClass(OS.PtPane(), 0, args.length / 3, args);
        nArray2[45] = OS.PtCreateWidgetClass(OS.PtSlider(), 0, args.length / 3, args);
        nArray2[48] = OS.PtCreateWidgetClass(OS.PtSeparator(), 0, args.length / 3, args);
        nArray2[51] = OS.PtCreateWidgetClass(OS.PtToolbar(), 0, args.length / 3, args);
        nArray2[54] = OS.PtCreateWidgetClass(OS.PtNumericInteger(), 0, args.length / 3, args);
        int[] buffer = nArray2;
        this.ClassesPtr = OS.malloc(buffer.length * 4);
        OS.memmove(this.ClassesPtr, buffer, buffer.length * 4);
        this.PtButton = this.ClassesPtr;
        this.PtList = this.ClassesPtr + 12;
        this.PtLabel = this.ClassesPtr + 24;
        this.PtToggleButton = this.ClassesPtr + 48;
        this.PtComboBox = this.ClassesPtr + 60;
        this.PtText = this.ClassesPtr + 72;
        this.PtMultiText = this.ClassesPtr + 84;
        this.PtScrollbar = this.ClassesPtr + 96;
        this.PtContainer = this.ClassesPtr + 132;
        this.PtProgress = this.ClassesPtr + 144;
        this.PtPanelGroup = this.ClassesPtr + 156;
        this.PtSlider = this.ClassesPtr + 180;
        this.PtSeparator = this.ClassesPtr + 192;
        this.PtToolbar = this.ClassesPtr + 204;
        this.PtNumericInteger = this.ClassesPtr + 216;
    }

    void initializeWidgetColors() {
        OS.PtSetParentWidget(0);
        int[] args = new int[]{18014, 1, -1};
        int shellHandle = OS.PtCreateWidget(OS.PtWindow(), 0, args.length / 3, args);
        int[] nArray = new int[6];
        nArray[0] = 2001;
        nArray[3] = 2002;
        args = nArray;
        OS.PtGetResources(shellHandle, args.length / 3, args);
        this.WIDGET_FOREGROUND = args[1];
        this.WIDGET_BACKGROUND = args[4];
        int listHandle = OS.PtCreateWidget(OS.PtList(), shellHandle, 0, null);
        int[] nArray2 = new int[12];
        nArray2[0] = 2001;
        nArray2[3] = 2002;
        nArray2[6] = 23012;
        nArray2[9] = 23013;
        args = nArray2;
        OS.PtGetResources(listHandle, args.length / 3, args);
        this.LIST_FOREGROUND = args[1];
        this.LIST_BACKGROUND = args[4];
        this.LIST_SELECTION = args[7];
        this.LIST_SELECTION_TEXT = args[10];
        int textHandle = OS.PtCreateWidget(OS.PtText(), shellHandle, 0, null);
        int[] nArray3 = new int[6];
        nArray3[0] = 2001;
        nArray3[3] = 2002;
        args = nArray3;
        OS.PtGetResources(textHandle, args.length / 3, args);
        this.TEXT_FOREGROUND = args[1];
        this.TEXT_BACKGROUND = args[4];
        int buttonHandle = OS.PtCreateWidget(OS.PtButton(), shellHandle, 0, null);
        OS.PtRealizeWidget(shellHandle);
        int[] nArray4 = new int[21];
        nArray4[0] = 2022;
        nArray4[3] = 2022;
        nArray4[6] = 2006;
        nArray4[9] = 2021;
        nArray4[12] = 2000;
        nArray4[15] = 3020;
        nArray4[18] = 3019;
        args = nArray4;
        OS.PtGetResources(buttonHandle, args.length / 3, args);
        this.WIDGET_BORDER = args[1];
        this.WIDGET_DARK_SHADOW = args[4];
        this.WIDGET_NORMAL_SHADOW = args[7];
        this.WIDGET_LIGHT_SHADOW = args[10];
        this.WIDGET_HIGHLIGHT_SHADOW = args[13];
        this.INFO_FOREGROUND = args[16];
        this.INFO_BACKGROUND = args[19];
        OS.PtDestroyWidget(shellHandle);
    }

    void initializeWidgetFonts() {
        String property = System.getProperty("swt.system.font");
        if (property != null) {
            this.defaultFont = Converter.wcsToMbcs(null, property, true);
            this.TITLE_FONT = this.defaultFont;
            this.GAUGE_FONT = this.defaultFont;
            this.LIST_FONT = this.GAUGE_FONT;
            this.TEXT_FONT = this.GAUGE_FONT;
            this.GROUP_FONT = Converter.wcsToMbcs(null, String.valueOf(property) + "b", true);
            return;
        }
        OS.PtSetParentWidget(0);
        int shellHandle = OS.PtCreateWidget(OS.PtWindow(), 0, 0, null);
        int[] nArray = new int[3];
        nArray[0] = 10008;
        int[] args = nArray;
        OS.PtGetResources(shellHandle, args.length / 3, args);
        int length = OS.strlen(args[1]);
        this.TITLE_FONT = new byte[length + 1];
        this.GROUP_FONT = this.TITLE_FONT;
        OS.memmove(this.TITLE_FONT, args[1], length);
        int listHandle = OS.PtCreateWidget(OS.PtList(), shellHandle, 0, null);
        int[] nArray2 = new int[3];
        nArray2[0] = 23003;
        args = nArray2;
        OS.PtGetResources(listHandle, args.length / 3, args);
        length = OS.strlen(args[1]);
        this.LIST_FONT = new byte[length + 1];
        OS.memmove(this.LIST_FONT, args[1], length);
        int textHandle = OS.PtCreateWidget(OS.PtText(), shellHandle, 0, null);
        int[] nArray3 = new int[3];
        nArray3[0] = 3010;
        args = nArray3;
        OS.PtGetResources(textHandle, args.length / 3, args);
        length = OS.strlen(args[1]);
        this.TEXT_FONT = new byte[length + 1];
        OS.memmove(this.TEXT_FONT, args[1], length);
        int scrollHandle = OS.PtCreateWidget(OS.PtScrollbar(), shellHandle, 0, null);
        int[] nArray4 = new int[3];
        nArray4[0] = 21001;
        args = nArray4;
        OS.PtGetResources(scrollHandle, args.length / 3, args);
        length = OS.strlen(args[1]);
        this.GAUGE_FONT = new byte[length + 1];
        OS.memmove(this.GAUGE_FONT, args[1], length);
        OS.PtDestroyWidget(shellHandle);
    }

    void initializeImages() {
        this.nullImage = OS.PhCreateImage(null, (short)1, (short)1, 33, 0, 0, 0);
        if (this.nullImage == 0) {
            SWT.error(2);
        }
    }

    int inputProc(int data, int rcvid, int message, int size) {
        if (this.embedded) {
            this.runDeferredEvents();
            if (this.runAsyncMessages(false)) {
                this.wakeThread();
            }
        }
        return 0;
    }

    public int internal_new_GC(GCData data) {
        int mask;
        int phGC;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((phGC = OS.PgCreateGC(0)) == 0) {
            SWT.error(2);
        }
        if ((data.style & (mask = 0x6000000)) == 0) {
            data.style |= 0x2000000;
        }
        data.device = this;
        data.rid = 1;
        return phGC;
    }

    public void internal_dispose_GC(int phGC, GCData data) {
        OS.PgDestroyGC(phGC);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_NAME);
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        short[] position_y;
        short[] position_x;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        if (from != null) {
            position_x = new short[1];
            position_y = new short[1];
            OS.PtGetAbsPosition(from.handle, position_x, position_y);
            point.x += position_x[0];
            point.y += position_y[0];
        }
        if (to != null) {
            position_x = new short[1];
            position_y = new short[1];
            OS.PtGetAbsPosition(to.handle, position_x, position_y);
            point.x -= position_x[0];
            point.y -= position_y[0];
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        short[] position_y;
        short[] position_x;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from == to) {
            return rect;
        }
        if (from != null) {
            position_x = new short[1];
            position_y = new short[1];
            OS.PtGetAbsPosition(from.handle, position_x, position_y);
            rect.x += position_x[0];
            rect.y += position_y[0];
        }
        if (to != null) {
            position_x = new short[1];
            position_y = new short[1];
            OS.PtGetAbsPosition(to.handle, position_x, position_y);
            rect.x -= position_x[0];
            rect.y -= position_y[0];
        }
        return rect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean post(Event event) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (event == null) {
                this.error(4);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return false;
        }
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
        if (this.embedded) {
            this.wakeThread();
        }
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        this.idle = false;
        OS.PtRelease();
        OS.PtHold();
        int id = OS.PtAppAddWorkProc(this.app_context, this.workProc, 0);
        OS.PtAppProcessEvent(this.app_context);
        OS.PtAppRemoveWorkProc(this.app_context, id);
        boolean result = true;
        if (this.idle) {
            result = this.runAsyncMessages(false);
        } else {
            this.runDeferredEvents();
        }
        OS.PtRelease();
        OS.PtHold();
        return this.isDisposed() || result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.display) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        OS.PtDestroyWidget(this.timerHandle);
        OS.free(this.ClassesPtr);
        OS.PtAppRemoveInput(this.app_context, this.input);
        OS.PtAppDeletePulse(this.app_context, this.pulse);
        if (this.timerIds != null) {
            int i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.PtDestroyWidget(this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.drawCallback.dispose();
        this.drawCallback = null;
        this.workCallback.dispose();
        this.workCallback = null;
        this.inputCallback.dispose();
        this.inputCallback = null;
        this.hotkeyCallback.dispose();
        this.hotkeyCallback = null;
        if (this.nullImage != 0) {
            PhImage_t phImage = new PhImage_t();
            OS.memmove(phImage, this.nullImage, 56);
            phImage.flags = (byte)31;
            OS.memmove(this.nullImage, phImage, 56);
            OS.PhReleaseImage(this.nullImage);
            OS.free(this.nullImage);
            this.nullImage = 0;
        }
        int i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        this.thread = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        boolean run = false;
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int i = 0;
                while (i < count) {
                    Widget widget = oldSkinWidgets[i];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFFFFDFFF;
                        oldSkinWidgets[i] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        OS.PhMoveCursorAbs(OS.PhInputGroup(0), x, y);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.runAsyncMessages(true);
            }
            return;
        }
    }

    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        OS.PtFlush();
        OS.PtHold();
        OS.PtAppProcessEvent(this.app_context);
        this.runDeferredEvents();
        OS.PtRelease();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    int textWidth(String string, byte[] font) {
        if (string.length() == 0) {
            return 0;
        }
        byte[] textBuffer = Converter.wcsToMbcs(null, string, false);
        PhRect_t rect = new PhRect_t();
        OS.PfExtentText(rect, null, font, textBuffer, textBuffer.length);
        if (rect.lr_x == rect.ul_x) {
            return 0;
        }
        return rect.lr_x - rect.ul_x + 1;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.PtDestroyWidget(this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        int[] nArray = new int[3];
        nArray[0] = 41000;
        nArray[1] = milliseconds;
        int[] args = nArray;
        int timerId = OS.PtCreateWidget(OS.PtTimer(), this.timerHandle, args.length / 3, args);
        if (timerId != 0) {
            OS.PtRealizeWidget(timerId);
            OS.PtAddCallback(timerId, 41002, this.timerProc, index);
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int handle, int index, int info) {
        if (this.timerList == null) {
            return 0;
        }
        if (index >= 0 && index < this.timerList.length) {
            int timerId = this.timerIds[index];
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                runnable.run();
            }
            OS.PtDestroyWidget(timerId);
        }
        return 0;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        Shell[] shells = WidgetTable.shells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed() && this == shell.display) {
                shell.update();
            }
            ++i;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        OS.PtAppPulseTrigger(this.app_context, this.pulse);
    }

    int windowProc(int handle, int data, int info) {
        Widget widget = WidgetTable.get(handle);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(handle, data, info);
    }

    int workProc(int data) {
        this.idle = true;
        return 0;
    }

    String wrapText(String text, byte[] font, int width) {
        text = this.convertToLf(text);
        int length = text.length();
        if (width <= 0 || length == 0 || length == 1) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int lineStart = 0;
        int lineEnd = 0;
        while (lineStart < length) {
            boolean noLf;
            lineEnd = text.indexOf(10, lineStart);
            boolean bl = noLf = lineEnd == -1;
            if (noLf) {
                lineEnd = length;
            }
            int nextStart = lineEnd + 1;
            while (lineEnd > lineStart + 1 && Compatibility.isWhitespace(text.charAt(lineEnd - 1))) {
                --lineEnd;
            }
            int wordStart = lineStart;
            int wordEnd = lineStart;
            int i = lineStart;
            while (i < lineEnd) {
                int lastStart = wordStart;
                int lastEnd = wordEnd;
                wordStart = i;
                while (i < lineEnd && !Compatibility.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                wordEnd = i - 1;
                String line = text.substring(lineStart, wordEnd + 1);
                int lineWidth = this.textWidth(line, font);
                while (i < lineEnd && Compatibility.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                if (lineWidth <= width) continue;
                if (lastStart == wordStart) {
                    while (wordStart < wordEnd) {
                        line = text.substring(lineStart, wordStart + 1);
                        lineWidth = this.textWidth(line, font);
                        if (lineWidth >= width) break;
                        ++wordStart;
                    }
                    if (wordStart == lastStart) {
                        ++wordStart;
                    }
                    lastEnd = wordStart - 1;
                }
                line = text.substring(lineStart, lastEnd + 1);
                result.append(line);
                result.append('\n');
                i = wordStart;
                lineStart = wordStart;
                wordEnd = wordStart;
            }
            if (lineStart < lineEnd) {
                result.append(text.substring(lineStart, lineEnd));
            }
            if (!noLf) {
                result.append('\n');
            }
            lineStart = nextStart;
        }
        return result.toString();
    }
}

