/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.DropTargetEffect;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class TreeDropTargetEffect
extends DropTargetEffect {
    static final int SCROLL_HYSTERESIS = 150;
    static final int EXPAND_HYSTERESIS = 1000;
    int currentEffect = 0;
    TreeItem currentItem;
    PaintListener paintListener;
    TreeItem dropSelection = null;
    TreeItem insertItem = null;
    boolean insertBefore = false;
    TreeItem scrollItem;
    long scrollBeginTime;
    TreeItem expandItem;
    long expandBeginTime;

    public TreeDropTargetEffect(Tree tree) {
        super(tree);
    }

    int checkEffect(int effect) {
        if ((effect & 1) != 0) {
            effect = effect & 0xFFFFFFFB & 0xFFFFFFFD;
        }
        if ((effect & 2) != 0) {
            effect &= 0xFFFFFFFB;
        }
        return effect;
    }

    public void dragEnter(DropTargetEvent event) {
        this.insertItem = null;
        this.currentItem = null;
        this.dropSelection = null;
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragLeave(DropTargetEvent event) {
        Tree tree = (Tree)this.control;
        if (this.insertItem != null) {
            tree.setInsertMark(null, false);
            this.insertItem = null;
        }
        if (this.currentItem != null) {
            this.setDropSelection(tree, null);
            this.currentItem = null;
        }
        this.expandBeginTime = 0L;
        this.expandItem = null;
        this.scrollBeginTime = 0L;
        this.scrollItem = null;
    }

    public void dragOver(DropTargetEvent event) {
        Tree tree = (Tree)this.control;
        int effect = this.checkEffect(event.feedback);
        TreeItem item = (TreeItem)this.getItem(tree, event.x, event.y);
        if ((effect & 0x10) == 0) {
            this.expandBeginTime = 0L;
            this.expandItem = null;
        } else if (item != null && item.equals(this.expandItem) && this.expandBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.expandBeginTime) {
                if (item.getItemCount() > 0 && !item.getExpanded()) {
                    Event e = new Event();
                    e.x = event.x;
                    e.y = event.y;
                    e.item = item;
                    e.time = (int)System.currentTimeMillis();
                    tree.notifyListeners(17, e);
                    if (item.isDisposed()) {
                        return;
                    }
                    item.setExpanded(true);
                }
                this.expandBeginTime = 0L;
                this.expandItem = null;
            }
        } else {
            this.expandBeginTime = System.currentTimeMillis() + 1000L;
            this.expandItem = item;
        }
        if ((effect & 8) == 0) {
            this.scrollBeginTime = 0L;
            this.scrollItem = null;
        } else if (item != null && item.equals(this.scrollItem) && this.scrollBeginTime != 0L) {
            if (System.currentTimeMillis() >= this.scrollBeginTime) {
                Rectangle area = tree.getClientArea();
                int headerHeight = tree.getHeaderHeight();
                int itemHeight = tree.getItemHeight();
                Point pt = new Point(event.x, event.y);
                pt = tree.getDisplay().map(null, (Control)tree, pt);
                TreeItem nextItem = null;
                if (pt.y < area.y + headerHeight + 2 * itemHeight) {
                    nextItem = this.previousItem(tree, item);
                }
                if (pt.y > area.y + area.height - 2 * itemHeight) {
                    nextItem = this.nextItem(tree, item);
                }
                if (nextItem != null) {
                    tree.showItem(nextItem);
                }
                this.scrollBeginTime = 0L;
                this.scrollItem = null;
            }
        } else {
            this.scrollBeginTime = System.currentTimeMillis() + 150L;
            this.scrollItem = item;
        }
        if ((effect & 1) != 0) {
            if (this.currentItem != item || (this.currentEffect & 1) == 0) {
                this.setDropSelection(tree, item);
                this.currentEffect = effect;
                this.currentItem = item;
            }
        } else {
            this.setDropSelection(tree, null);
        }
        if ((effect & 4) != 0 || (effect & 2) != 0) {
            if (this.currentItem != item || (effect & 4) != (this.currentEffect & 4) || (effect & 2) != (this.currentEffect & 2)) {
                this.setInsertMark(tree, item, (effect & 2) != 0);
                this.currentEffect = effect;
                this.currentItem = item;
            }
        } else {
            this.setInsertMark(tree, null, false);
        }
    }

    void setDropSelection(Tree tree, TreeItem item) {
        Rectangle bounds;
        if (item == this.dropSelection) {
            return;
        }
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds();
            tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        this.dropSelection = item;
        if (this.dropSelection != null && !this.dropSelection.isDisposed()) {
            bounds = this.dropSelection.getBounds();
            tree.redraw(bounds.x, bounds.y, bounds.width, bounds.height, true);
        }
        if (this.dropSelection == null) {
            if (this.paintListener != null) {
                tree.removePaintListener(this.paintListener);
                this.paintListener = null;
            }
        } else if (this.paintListener == null) {
            this.paintListener = new PaintListener(){

                public void paintControl(PaintEvent e) {
                    if (TreeDropTargetEffect.this.dropSelection == null || TreeDropTargetEffect.this.dropSelection.isDisposed()) {
                        return;
                    }
                    GC gc = e.gc;
                    boolean xor = gc.getXORMode();
                    gc.setXORMode(true);
                    Rectangle bounds = TreeDropTargetEffect.this.dropSelection.getBounds();
                    gc.fillRectangle(bounds.x, bounds.y, bounds.width, bounds.height);
                    gc.setXORMode(xor);
                }
            };
            tree.addPaintListener(this.paintListener);
        }
    }

    void setInsertMark(Tree tree, TreeItem item, boolean before) {
        if (item == this.insertItem && before == this.insertBefore) {
            return;
        }
        this.insertItem = item;
        this.insertBefore = before;
        tree.setInsertMark(item, before);
    }
}

