/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.carbon.AEDesc;
import org.eclipse.swt.internal.carbon.CFRange;
import org.eclipse.swt.internal.carbon.NavDialogCreationOptions;
import org.eclipse.swt.internal.carbon.NavReplyRecord;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class DirectoryDialog
extends Dialog {
    String message = "";
    String filterPath = "";

    public DirectoryDialog(Shell parent) {
        this(parent, 65536);
    }

    public DirectoryDialog(Shell parent, int style) {
        super(parent, DirectoryDialog.checkStyle(parent, style));
        this.checkSubclass();
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String getMessage() {
        return this.message;
    }

    public String open() {
        char[] buffer;
        String directoryPath = null;
        int titlePtr = 0;
        int messagePtr = 0;
        if (this.title != null) {
            buffer = new char[this.title.length()];
            this.title.getChars(0, buffer.length, buffer, 0);
            titlePtr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        }
        buffer = new char[this.message.length()];
        this.message.getChars(0, buffer.length, buffer, 0);
        messagePtr = OS.CFStringCreateWithCharacters(0, buffer, buffer.length);
        NavDialogCreationOptions options = new NavDialogCreationOptions();
        options.parentWindow = OS.GetControlOwner(this.parent.handle);
        options.windowTitle = options.clientName = titlePtr;
        options.optionFlags = 12544;
        options.message = messagePtr;
        options.location_h = (short)-1;
        options.location_v = (short)-1;
        int[] outDialog = new int[1];
        if (OS.NavCreateChooseFolderDialog(options, 0, 0, 0, outDialog) == 0) {
            if (this.filterPath != null && this.filterPath.length() > 0) {
                char[] chars = new char[this.filterPath.length()];
                this.filterPath.getChars(0, chars.length, chars, 0);
                int str = OS.CFStringCreateWithCharacters(0, chars, chars.length);
                if (str != 0) {
                    int url = OS.CFURLCreateWithFileSystemPath(0, str, 0, false);
                    if (url != 0) {
                        AEDesc params;
                        byte[] fsRef = new byte[80];
                        if (OS.CFURLGetFSRef(url, fsRef) && OS.AECreateDesc(1718841958, fsRef, fsRef.length, params = new AEDesc()) == 0) {
                            OS.NavCustomControl(outDialog[0], 8, params);
                            OS.AEDisposeDesc(params);
                        }
                        OS.CFRelease(url);
                    }
                    OS.CFRelease(str);
                }
            }
            Display display = this.parent != null ? this.parent.getDisplay() : Display.getCurrent();
            display.setModalDialog(this);
            OS.NavDialogRun(outDialog[0]);
            display.setModalDialog(null);
            if (OS.NavDialogGetUserAction(outDialog[0]) == 4) {
                NavReplyRecord record = new NavReplyRecord();
                OS.NavDialogGetReply(outDialog[0], record);
                AEDesc selection = new AEDesc();
                selection.descriptorType = record.selection_descriptorType;
                selection.dataHandle = record.selection_dataHandle;
                int[] count = new int[1];
                OS.AECountItems(selection, count);
                if (count[0] > 0) {
                    int[] actualSize;
                    int[] theAEKeyword = new int[1];
                    int[] typeCode = new int[1];
                    int maximumSize = 80;
                    int dataPtr = OS.NewPtr(maximumSize);
                    int status = OS.AEGetNthPtr(selection, 1, 1718841958, theAEKeyword, typeCode, dataPtr, maximumSize, actualSize = new int[1]);
                    if (status == 0 && typeCode[0] == 1718841958) {
                        byte[] fsRef = new byte[actualSize[0]];
                        OS.memmove(fsRef, dataPtr, actualSize[0]);
                        int dirUrl = OS.CFURLCreateFromFSRef(0, fsRef);
                        int dirString = OS.CFURLCopyFileSystemPath(dirUrl, 0);
                        OS.CFRelease(dirUrl);
                        int length = OS.CFStringGetLength(dirString);
                        buffer = new char[length];
                        CFRange range = new CFRange();
                        range.length = length;
                        OS.CFStringGetCharacters(dirString, range, buffer);
                        OS.CFRelease(dirString);
                        this.filterPath = directoryPath = new String(buffer);
                    }
                    OS.DisposePtr(dataPtr);
                }
            }
        }
        if (titlePtr != 0) {
            OS.CFRelease(titlePtr);
        }
        if (messagePtr != 0) {
            OS.CFRelease(messagePtr);
        }
        if (outDialog[0] != 0) {
            OS.NavDialogDispose(outDialog[0]);
        }
        return directoryPath;
    }

    public void setMessage(String string) {
        if (string == null) {
            this.error(4);
        }
        this.message = string;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

