/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.exports;

import java.net.URI;
import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.ProvisionException;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepository;
import org.eclipse.equinox.p2.repository.metadata.IMetadataRepositoryManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;

public class ExportTargetMetadata {
    IProvisioningAgent agent = null;
    public static ExportTargetMetadata instance = null;

    public ExportTargetMetadata(IProvisioningAgent agent) {
        this.agent = agent;
    }

    public synchronized void clearExporedRepository(URI destination) {
        this.agent = (IProvisioningAgent)PDECore.getDefault().acquireService(IProvisioningAgent.SERVICE_NAME);
        if (this.agent == null) {
            return;
        }
        if (((IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME)).contains(destination)) {
            ((IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME)).removeRepository(destination);
        }
    }

    public synchronized IStatus exportMetadata(IProfile profile, URI destination, String targetName) {
        block11: {
            if (this.agent == null) {
                return new Status(4, PDEPlugin.getPluginId(), "Failed to mirror the metadata.");
            }
            boolean removeRepoAfterLoad = false;
            try {
                IMetadataRepository repository = null;
                try {
                    removeRepoAfterLoad = !((IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME)).contains(destination);
                    repository = ((IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME)).loadRepository(destination, 1, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (ProvisionException provisionException) {}
                if (repository == null) {
                    repository = ((IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME)).createRepository(destination, targetName, "org.eclipse.equinox.p2.metadata.repository.simpleRepository", null);
                }
                if (repository != null) {
                    this.mirrorMetadata(profile, repository);
                    break block11;
                }
                Status status = new Status(4, PDEPlugin.getPluginId(), "Failed to mirror the metadata.");
                return status;
            }
            catch (ProvisionException e) {
                Status status = new Status(4, PDEPlugin.getPluginId(), "Failed to mirror the metadata.", (Throwable)e);
                return status;
            }
            finally {
                if (removeRepoAfterLoad) {
                    ((IMetadataRepositoryManager)this.agent.getService(IMetadataRepositoryManager.SERVICE_NAME)).removeRepository(destination);
                }
            }
        }
        return Status.OK_STATUS;
    }

    private void mirrorMetadata(IProfile profile, IMetadataRepository repository) {
        IQueryResult results = profile.query(QueryUtil.createIUAnyQuery(), (IProgressMonitor)new NullProgressMonitor());
        repository.addInstallableUnits((Collection)results.toUnmodifiableSet());
    }
}

