/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.examples.ui.midi.launcher;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.examples.ui.pda.DebugUIPlugin;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceListSelectionDialog;

public class MidiMainTab
extends AbstractLaunchConfigurationTab {
    private Text fFileText;
    private Button fFileButton;

    public void createControl(Composite parent) {
        Font font = parent.getFont();
        Composite comp = new Composite(parent, 0);
        this.setControl((Control)comp);
        GridLayout topLayout = new GridLayout();
        topLayout.verticalSpacing = 0;
        topLayout.numColumns = 3;
        comp.setLayout((Layout)topLayout);
        comp.setFont(font);
        this.createVerticalSpacer(comp, 3);
        Label programLabel = new Label(comp, 0);
        programLabel.setText("&Midi File:");
        GridData gd = new GridData(1);
        programLabel.setLayoutData((Object)gd);
        programLabel.setFont(font);
        this.fFileText = new Text(comp, 2052);
        gd = new GridData(768);
        this.fFileText.setLayoutData((Object)gd);
        this.fFileText.setFont(font);
        this.fFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MidiMainTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.fFileButton = this.createPushButton(comp, "&Browse...", null);
        this.fFileButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MidiMainTab.this.browseMidiFiles();
            }
        });
    }

    protected void browseMidiFiles() {
        ResourceListSelectionDialog dialog = new ResourceListSelectionDialog(this.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), 1);
        dialog.setTitle("MIDI File");
        dialog.setMessage("Select MIDI File");
        if (dialog.open() == 0) {
            Object[] files = dialog.getResult();
            IFile file = (IFile)files[0];
            this.fFileText.setText(file.getFullPath().toString());
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String file = null;
            file = configuration.getAttribute("midi.file", null);
            if (file != null) {
                this.fFileText.setText(file);
            }
        }
        catch (CoreException e) {
            this.setErrorMessage(e.getMessage());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        String file = this.fFileText.getText().trim();
        if (file.length() == 0) {
            file = null;
        }
        IResource[] resources = null;
        if (file != null) {
            Path path = new Path(file);
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path);
            if (res != null) {
                resources = new IResource[]{res};
            }
        }
        configuration.setAttribute("midi.file", file);
        configuration.setMappedResources(resources);
    }

    public String getName() {
        return "Main";
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String text = this.fFileText.getText();
        if (text.length() > 0) {
            Path path = new Path(text);
            if (ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)path) == null) {
                this.setErrorMessage("File does not exist");
                return false;
            }
        } else {
            this.setMessage("Select a MIDI file");
        }
        return true;
    }

    public Image getImage() {
        return DebugUIPlugin.getDefault().getImageRegistry().get("IMB_OBJ_MIDI");
    }
}

