/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.webapp.data;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.webapp.HelpWebappPlugin;
import org.eclipse.help.internal.webapp.data.RequestData;
import org.eclipse.help.internal.webapp.data.UrlUtil;
import org.eclipse.help.webapp.AbstractFrame;

public class FrameData
extends RequestData {
    private static final String FRAME_EXTENSION_POINT = "org.eclipse.help.webapp.frame";
    private List allFrames;

    public FrameData(ServletContext context, HttpServletRequest request, HttpServletResponse response) {
        super(context, request, response);
    }

    public AbstractFrame[] getFrames(int location) {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(FRAME_EXTENSION_POINT);
        if (this.allFrames == null) {
            this.allFrames = new ArrayList();
            int i = 0;
            while (i < elements.length) {
                Object obj = null;
                try {
                    obj = elements[i].createExecutableExtension("class");
                }
                catch (CoreException e) {
                    HelpWebappPlugin.logError("Create extension failed:[org.eclipse.help.webapp.frame].", e);
                }
                if (obj instanceof AbstractFrame) {
                    this.allFrames.add(obj);
                }
                ++i;
            }
            Collections.sort(this.allFrames);
        }
        ArrayList<AbstractFrame> frameList = new ArrayList<AbstractFrame>();
        Iterator iter = this.allFrames.iterator();
        while (iter.hasNext()) {
            AbstractFrame frame = (AbstractFrame)iter.next();
            if (!frame.isVisible() || frame.getLocation() != location) continue;
            frameList.add(frame);
        }
        AbstractFrame[] frames = frameList.toArray(new AbstractFrame[frameList.size()]);
        return frames;
    }

    public String getUrl(AbstractFrame frame) {
        return String.valueOf(this.request.getContextPath()) + frame.getURL();
    }

    public String getContentAreaFrameSizes() {
        String size = "24,*";
        AbstractFrame[] frames = this.getFrames(1);
        int f = 0;
        while (f < frames.length) {
            size = String.valueOf(size) + ',';
            size = String.valueOf(size) + frames[f].getSize();
            ++f;
        }
        return size;
    }

    public AbstractFrame getHelpToolbarFrame() {
        AbstractFrame[] frames = this.getFrames(2);
        if (frames.length > 0) {
            if (frames.length > 1) {
                HelpWebappPlugin.logWarning("Only one extra frame is supported to be added to Help Toolbar. The first reterived element will be used.");
            }
            return frames[0];
        }
        return null;
    }

    public String getHelpToolbarFrameSizes() {
        String size = "*";
        AbstractFrame frame = this.getHelpToolbarFrame();
        if (frame != null) {
            boolean isRTL = UrlUtil.isRTL(this.request, this.response);
            size = isRTL ? String.valueOf(frame.getSize()) + ", " + size : String.valueOf(size) + ", " + frame.getSize();
        }
        return size;
    }
}

