/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.shared.target;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.equinox.p2.engine.IProfile;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardNode;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardSelectionPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.IBundleContainer;
import org.eclipse.pde.internal.core.target.provisional.ITargetDefinition;
import org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.shared.target.AddFeatureContainersPage;
import org.eclipse.pde.internal.ui.shared.target.EditDirectoryContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditIUContainerPage;
import org.eclipse.pde.internal.ui.shared.target.EditProfileContainerPage;
import org.eclipse.pde.internal.ui.shared.target.Messages;
import org.eclipse.pde.internal.ui.shared.target.PreviewContainerPage;
import org.eclipse.pde.internal.ui.wizards.WizardElement;
import org.eclipse.pde.ui.IProvisionerWizard;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IPluginContribution;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.WorkbenchActivityHelper;

public class AddBundleContainerSelectionPage
extends WizardSelectionPage {
    private static final String PROVISIONER_POINT = "targetProvisioners";
    static final String SETTINGS_SECTION = "editBundleContainerWizard";
    private static ITargetPlatformService fTargetService;
    private Text fDescription;
    private ITargetDefinition fTarget;
    static /* synthetic */ Class class$0;

    protected AddBundleContainerSelectionPage(ITargetDefinition target) {
        super("SelectionPage");
        this.setTitle(Messages.AddBundleContainerSelectionPage_1);
        this.setMessage(Messages.AddBundleContainerSelectionPage_2);
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
        this.fTarget = target;
    }

    private static ITargetPlatformService getTargetPlatformService() throws CoreException {
        if (fTargetService == null) {
            PDECore pDECore = PDECore.getDefault();
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.pde.internal.core.target.provisional.ITargetPlatformService");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((fTargetService = (ITargetPlatformService)pDECore.acquireService(clazz.getName())) == null) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.pde.core", Messages.AddDirectoryContainerPage_9));
            }
        }
        return fTargetService;
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        SashForm sashForm = new SashForm(comp, 512);
        GridData gd = new GridData(1808);
        gd.widthHint = 300;
        sashForm.setLayoutData((Object)gd);
        TableViewer wizardSelectionViewer = new TableViewer((Composite)sashForm, 2048);
        wizardSelectionViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        wizardSelectionViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                if (element instanceof AbstractBundleContainerNode) {
                    return ((AbstractBundleContainerNode)element).getName();
                }
                return super.getText(element);
            }

            public Image getImage(Object element) {
                if (element instanceof AbstractBundleContainerNode) {
                    return ((AbstractBundleContainerNode)element).getImage();
                }
                return super.getImage(element);
            }
        });
        wizardSelectionViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    AddBundleContainerSelectionPage.this.setSelectedNode((IWizardNode)selection.getFirstElement());
                    AddBundleContainerSelectionPage.this.getContainer().showPage(AddBundleContainerSelectionPage.this.getNextPage());
                }
            }
        });
        wizardSelectionViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (!selection.isEmpty()) {
                    AddBundleContainerSelectionPage.this.fDescription.setText(((AbstractBundleContainerNode)selection.getFirstElement()).getDescription());
                    AddBundleContainerSelectionPage.this.setSelectedNode((AbstractBundleContainerNode)selection.getFirstElement());
                }
            }
        });
        wizardSelectionViewer.getTable().setLayoutData((Object)new GridData(1808));
        this.fDescription = SWTFactory.createText((Composite)sashForm, 2122, 1);
        sashForm.setWeights(new int[]{70, 30});
        this.initViewerContents(wizardSelectionViewer);
        this.setControl((Control)comp);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.pde.doc.user.add_location_wizard");
    }

    private void initViewerContents(TableViewer wizardSelectionViewer) {
        ArrayList choices = new ArrayList();
        choices.addAll(this.getStandardChoices());
        choices.addAll(this.getProvisionerExtensionChoices());
        wizardSelectionViewer.setInput((Object)choices.toArray(new IWizardNode[choices.size()]));
    }

    private List getStandardChoices() {
        ArrayList<AbstractBundleContainerNode> standardChoices = new ArrayList<AbstractBundleContainerNode>(4);
        standardChoices.add(new AbstractBundleContainerNode(Messages.AddBundleContainerSelectionPage_3, Messages.AddBundleContainerSelectionPage_4, PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER")){

            public IWizard createWizard() {
                Wizard wizard = new Wizard(this){
                    private EditDirectoryContainerPage fPage1;
                    final /* synthetic */ 4 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void addPages() {
                        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection("editBundleContainerWizard");
                        if (settings == null) {
                            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection("editBundleContainerWizard");
                        }
                        this.setDialogSettings(settings);
                        this.fPage1 = new EditDirectoryContainerPage();
                        this.addPage(this.fPage1);
                        this.addPage((IWizardPage)new PreviewContainerPage(AddBundleContainerSelectionPage.access$3(4.access$0(this.this$1)), this.fPage1));
                        this.setNeedsProgressMonitor(true);
                    }

                    public boolean performFinish() {
                        IBundleContainer container = this.fPage1.getBundleContainer();
                        if (container != null) {
                            this.fPage1.storeSettings();
                            IBundleContainer[] oldContainers = AddBundleContainerSelectionPage.access$3(4.access$0(this.this$1)).getBundleContainers();
                            if (oldContainers == null) {
                                AddBundleContainerSelectionPage.access$3(4.access$0(this.this$1)).setBundleContainers(new IBundleContainer[]{container});
                            } else {
                                IBundleContainer[] newContainers = new IBundleContainer[oldContainers.length + 1];
                                System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                newContainers[newContainers.length - 1] = container;
                                AddBundleContainerSelectionPage.access$3(4.access$0(this.this$1)).setBundleContainers(newContainers);
                            }
                        }
                        return true;
                    }
                };
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }

            static /* synthetic */ AddBundleContainerSelectionPage access$0(4 var0) {
                return var0.AddBundleContainerSelectionPage.this;
            }
        });
        standardChoices.add(new AbstractBundleContainerNode(Messages.AddBundleContainerSelectionPage_6, Messages.AddBundleContainerSelectionPage_7, PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PRODUCT_DEFINITION)){

            public IWizard createWizard() {
                Wizard wizard = new Wizard(this){
                    private EditProfileContainerPage fPage1;
                    final /* synthetic */ 6 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void addPages() {
                        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection("editBundleContainerWizard");
                        if (settings == null) {
                            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection("editBundleContainerWizard");
                        }
                        this.setDialogSettings(settings);
                        this.setDialogSettings(settings);
                        this.fPage1 = new EditProfileContainerPage();
                        this.addPage(this.fPage1);
                        this.addPage((IWizardPage)new PreviewContainerPage(AddBundleContainerSelectionPage.access$3(6.access$0(this.this$1)), this.fPage1));
                        this.setNeedsProgressMonitor(true);
                    }

                    public boolean performFinish() {
                        IBundleContainer container = this.fPage1.getBundleContainer();
                        if (container != null) {
                            this.fPage1.storeSettings();
                            IBundleContainer[] oldContainers = AddBundleContainerSelectionPage.access$3(6.access$0(this.this$1)).getBundleContainers();
                            if (oldContainers == null) {
                                AddBundleContainerSelectionPage.access$3(6.access$0(this.this$1)).setBundleContainers(new IBundleContainer[]{container});
                            } else {
                                IBundleContainer[] newContainers = new IBundleContainer[oldContainers.length + 1];
                                System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                newContainers[newContainers.length - 1] = container;
                                AddBundleContainerSelectionPage.access$3(6.access$0(this.this$1)).setBundleContainers(newContainers);
                            }
                        }
                        return true;
                    }
                };
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }

            static /* synthetic */ AddBundleContainerSelectionPage access$0(6 var0) {
                return var0.AddBundleContainerSelectionPage.this;
            }
        });
        standardChoices.add(new AbstractBundleContainerNode(Messages.AddBundleContainerSelectionPage_9, Messages.AddBundleContainerSelectionPage_10, PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_FEATURE_OBJ)){

            public IWizard createWizard() {
                Wizard wizard = new Wizard(this){
                    final /* synthetic */ 8 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void addPages() {
                        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection("editBundleContainerWizard");
                        if (settings == null) {
                            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection("editBundleContainerWizard");
                        }
                        this.setDialogSettings(settings);
                        this.addPage(new AddFeatureContainersPage());
                    }

                    public boolean performFinish() {
                        try {
                            IBundleContainer[] containers = ((AddFeatureContainersPage)this.getPages()[0]).getBundleContainers();
                            if (containers != null) {
                                ((AddFeatureContainersPage)this.getPages()[0]).storeSettings();
                                IBundleContainer[] oldContainers = AddBundleContainerSelectionPage.access$3(8.access$0(this.this$1)).getBundleContainers();
                                if (oldContainers == null) {
                                    AddBundleContainerSelectionPage.access$3(8.access$0(this.this$1)).setBundleContainers(containers);
                                } else {
                                    IBundleContainer[] newContainers = new IBundleContainer[oldContainers.length + containers.length];
                                    System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                    System.arraycopy(containers, 0, newContainers, oldContainers.length, containers.length);
                                    AddBundleContainerSelectionPage.access$3(8.access$0(this.this$1)).setBundleContainers(newContainers);
                                }
                            }
                            return true;
                        }
                        catch (CoreException e) {
                            8.access$0(this.this$1).setErrorMessage(e.getMessage());
                            return false;
                        }
                    }
                };
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }

            static /* synthetic */ AddBundleContainerSelectionPage access$0(8 var0) {
                return var0.AddBundleContainerSelectionPage.this;
            }
        });
        standardChoices.add(new AbstractBundleContainerNode(Messages.AddBundleContainerSelectionPage_8, Messages.AddBundleContainerSelectionPage_11, PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_REPOSITORY_OBJ)){

            public IWizard createWizard() {
                Wizard wizard = new Wizard(this){
                    final /* synthetic */ 10 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void addPages() {
                        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection("editBundleContainerWizard");
                        if (settings == null) {
                            settings = PDEPlugin.getDefault().getDialogSettings().addNewSection("editBundleContainerWizard");
                        }
                        this.setDialogSettings(settings);
                        IProfile profile = null;
                        try {
                            profile = ((TargetDefinition)AddBundleContainerSelectionPage.access$3(10.access$0(this.this$1))).getProfile();
                        }
                        catch (CoreException e) {
                            PDEPlugin.log(e);
                        }
                        this.addPage(new EditIUContainerPage(AddBundleContainerSelectionPage.access$3(10.access$0(this.this$1)), profile));
                    }

                    public boolean performFinish() {
                        IBundleContainer container = ((EditIUContainerPage)this.getPages()[0]).getBundleContainer();
                        if (container != null) {
                            ((EditIUContainerPage)this.getPages()[0]).storeSettings();
                            IBundleContainer[] oldContainers = AddBundleContainerSelectionPage.access$3(10.access$0(this.this$1)).getBundleContainers();
                            if (oldContainers == null) {
                                AddBundleContainerSelectionPage.access$3(10.access$0(this.this$1)).setBundleContainers(new IBundleContainer[]{container});
                            } else {
                                IBundleContainer[] newContainers = new IBundleContainer[oldContainers.length + 1];
                                System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                newContainers[newContainers.length - 1] = container;
                                AddBundleContainerSelectionPage.access$3(10.access$0(this.this$1)).setBundleContainers(newContainers);
                            }
                        }
                        return true;
                    }
                };
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }

            static /* synthetic */ AddBundleContainerSelectionPage access$0(10 var0) {
                return var0.AddBundleContainerSelectionPage.this;
            }
        });
        return standardChoices;
    }

    private List getProvisionerExtensionChoices() {
        ArrayList<AbstractBundleContainerNode> list = new ArrayList<AbstractBundleContainerNode>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(PDEPlugin.getPluginId(), PROVISIONER_POINT);
        if (point == null) {
            return list;
        }
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                WizardElement element = this.createWizardElement(elements[j]);
                if (element != null) {
                    final String pluginId = element.getPluginId();
                    final String contributionId = element.getID();
                    IPluginContribution pc = new IPluginContribution(){

                        public String getLocalId() {
                            return contributionId;
                        }

                        public String getPluginId() {
                            return pluginId;
                        }
                    };
                    if (!WorkbenchActivityHelper.filterItem((Object)pc)) {
                        list.add(this.createExtensionNode(element));
                    }
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    protected WizardElement createWizardElement(IConfigurationElement config) {
        String name = config.getAttribute("name");
        String id = config.getAttribute("id");
        if (name == null || id == null) {
            return null;
        }
        WizardElement element = new WizardElement(config);
        String imageName = config.getAttribute("icon");
        Image image = null;
        if (imageName != null) {
            String pluginID = config.getNamespaceIdentifier();
            image = PDEPlugin.getDefault().getLabelProvider().getImageFromPlugin(pluginID, imageName);
        }
        element.setImage(image);
        return element;
    }

    private AbstractBundleContainerNode createExtensionNode(final WizardElement element) {
        return new AbstractBundleContainerNode(element.getLabel(), element.getDescription(), element.getImage()){

            public IWizard createWizard() {
                Wizard wizard = new Wizard(this, element){
                    private IProvisionerWizard fWizard;
                    final /* synthetic */ 13 this$1;
                    private final /* synthetic */ WizardElement val$element;
                    {
                        this.this$1 = var1_1;
                        this.val$element = wizardElement;
                    }

                    public void addPages() {
                        try {
                            this.fWizard = (IProvisionerWizard)this.val$element.createExecutableExtension();
                        }
                        catch (CoreException e) {
                            PDEPlugin.log(e);
                            MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.Errors_CreationError, (String)Messages.Errors_CreationError_NoWizard);
                        }
                        this.fWizard.setContainer(this.getContainer());
                        this.fWizard.addPages();
                        IWizardPage[] pages = this.fWizard.getPages();
                        int i = 0;
                        while (i < pages.length) {
                            this.addPage(pages[i]);
                            ++i;
                        }
                    }

                    public boolean performFinish() {
                        if (this.fWizard != null) {
                            if (!this.fWizard.performFinish()) {
                                return false;
                            }
                            File[] dirs = this.fWizard.getLocations();
                            int i = 0;
                            while (i < dirs.length) {
                                if (dirs[i] == null || !dirs[i].isDirectory()) {
                                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AddBundleContainerSelectionPage_0, (String)Messages.AddBundleContainerSelectionPage_5, (IStatus)new Status(4, PDEPlugin.getPluginId(), Messages.AddDirectoryContainerPage_6));
                                    return false;
                                }
                                try {
                                    IBundleContainer container = AddBundleContainerSelectionPage.access$4().newDirectoryContainer(dirs[i].getPath());
                                    IBundleContainer[] oldContainers = AddBundleContainerSelectionPage.access$3(13.access$0(this.this$1)).getBundleContainers();
                                    if (oldContainers == null) {
                                        AddBundleContainerSelectionPage.access$3(13.access$0(this.this$1)).setBundleContainers(new IBundleContainer[]{container});
                                    } else {
                                        IBundleContainer[] newContainers = new IBundleContainer[oldContainers.length + 1];
                                        System.arraycopy(oldContainers, 0, newContainers, 0, oldContainers.length);
                                        newContainers[oldContainers.length] = container;
                                        AddBundleContainerSelectionPage.access$3(13.access$0(this.this$1)).setBundleContainers(newContainers);
                                    }
                                }
                                catch (CoreException ex) {
                                    ErrorDialog.openError((Shell)this.getShell(), (String)Messages.AddBundleContainerSelectionPage_0, (String)Messages.AddBundleContainerSelectionPage_5, (IStatus)ex.getStatus());
                                    return false;
                                }
                                ++i;
                            }
                        }
                        return true;
                    }
                };
                wizard.setContainer(AddBundleContainerSelectionPage.this.getContainer());
                wizard.setWindowTitle(Messages.AddBundleContainerSelectionPage_1);
                return wizard;
            }

            static /* synthetic */ AddBundleContainerSelectionPage access$0(13 var0) {
                return var0.AddBundleContainerSelectionPage.this;
            }
        };
    }

    static /* synthetic */ ITargetDefinition access$3(AddBundleContainerSelectionPage addBundleContainerSelectionPage) {
        return addBundleContainerSelectionPage.fTarget;
    }

    static /* synthetic */ ITargetPlatformService access$4() throws CoreException {
        return AddBundleContainerSelectionPage.getTargetPlatformService();
    }

    abstract class AbstractBundleContainerNode
    implements IWizardNode {
        private String fTypeName;
        private String fTypeDescription;
        private Image fTypeImage;
        private IWizard fWizard;

        public AbstractBundleContainerNode(String name, String description, Image image) {
            this.fTypeName = name;
            this.fTypeDescription = description;
            this.fTypeImage = image;
        }

        public abstract IWizard createWizard();

        public void dispose() {
            if (this.fWizard != null) {
                this.fWizard.dispose();
                this.fWizard = null;
            }
        }

        public Point getExtent() {
            return new Point(-1, -1);
        }

        public IWizard getWizard() {
            if (this.fWizard == null) {
                this.fWizard = this.createWizard();
            }
            return this.fWizard;
        }

        public boolean isContentCreated() {
            return this.fWizard != null;
        }

        public String getName() {
            return this.fTypeName;
        }

        public String getDescription() {
            return this.fTypeDescription;
        }

        public Image getImage() {
            return this.fTypeImage;
        }
    }
}

