/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.use;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.regex.PatternSyntaxException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.api.tools.ui.internal.ApiUIPlugin;
import org.eclipse.pde.api.tools.ui.internal.IApiToolsHelpContextIds;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.use.Messages;
import org.eclipse.pde.api.tools.ui.internal.use.PatternWizard;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;

public class ApiUsePatternTab
extends AbstractLaunchConfigurationTab {
    TreeSet patterns = new TreeSet(new Comparator(){

        public int compare(Object o1, Object o2) {
            return ((Pattern)o1).pattern.compareTo(((Pattern)o2).pattern);
        }
    });
    TableViewer viewer = null;
    Image image = null;
    Button addbutton = null;
    Button editbutton = null;
    Button removebutton = null;
    ColumnLayoutData[] columndata = new ColumnLayoutData[]{new ColumnWeightData(80), new ColumnWeightData(20)};
    String[] columnnames = new String[]{"Pattern", "Kind"};

    public void createControl(Composite parent) {
        Composite comp = SWTFactory.createComposite(parent, 2, 1, 1808);
        SWTFactory.createLabel(comp, Messages.ApiUsePatternTab_patterns, 2);
        Composite tcomp = SWTFactory.createComposite(comp, 1, 1, 1808, 0, 0);
        GridData gd = (GridData)tcomp.getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        Table table = new Table(tcomp, 68354);
        table.setHeaderVisible(true);
        TableLayout layout = new TableLayout();
        int i = 0;
        while (i < this.columndata.length) {
            layout.addColumnData(this.columndata[i]);
            ++i;
        }
        table.setLayout((Layout)layout);
        gd = new GridData(1808);
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 250;
        table.setLayoutData((Object)gd);
        this.viewer = new TableViewer(table);
        this.viewer.setColumnProperties(this.columnnames);
        this.viewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                return ((Pattern)element).kind;
            }
        });
        this.viewer.setLabelProvider((IBaseLabelProvider)new Labels());
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ApiUsePatternTab.this.updateButtons((IStructuredSelection)event.getSelection());
            }
        });
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ApiUsePatternTab.this.doEdit();
            }
        });
        TableColumn column = null;
        int i2 = 0;
        while (i2 < this.columnnames.length) {
            column = new TableColumn(table, 0);
            column.setResizable(false);
            column.setMoveable(false);
            column.setText(this.columnnames[i2]);
            ++i2;
        }
        this.viewer.setInput((Object)this.patterns);
        table.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0) {
                    ApiUsePatternTab.this.doRemove();
                }
            }
        });
        Composite bcomp = SWTFactory.createComposite(comp, 1, 1, 1040, 0, 0);
        this.addbutton = SWTFactory.createPushButton(bcomp, Messages.ApiUsePatternTab_add, null);
        this.addbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PatternWizard wizard = new PatternWizard(null, -1);
                WizardDialog dialog = new WizardDialog(ApiUsePatternTab.this.getShell(), (IWizard)wizard);
                if (dialog.open() == 0) {
                    ApiUsePatternTab.this.addPattern(wizard.getPattern(), wizard.getKind());
                    ApiUsePatternTab.this.viewer.refresh(true, true);
                    ApiUsePatternTab.this.updateLaunchConfigurationDialog();
                }
            }
        });
        this.editbutton = SWTFactory.createPushButton(bcomp, Messages.ApiUsePatternTab_edit, null);
        this.editbutton.setEnabled(false);
        this.editbutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiUsePatternTab.this.doEdit();
            }
        });
        this.removebutton = SWTFactory.createPushButton(bcomp, Messages.ApiUsePatternTab_remove, null);
        this.removebutton.setEnabled(false);
        this.removebutton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ApiUsePatternTab.this.doRemove();
            }
        });
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)comp, IApiToolsHelpContextIds.API_USE_PATTERN_TAB);
        this.setControl((Control)comp);
    }

    void doRemove() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            this.removePattern((Pattern)iter.next());
        }
        this.viewer.refresh();
        this.updateLaunchConfigurationDialog();
    }

    void doEdit() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        Pattern pattern = (Pattern)selection.getFirstElement();
        PatternWizard wizard = new PatternWizard(pattern.pattern, pattern.kind);
        WizardDialog dialog = new WizardDialog(this.getShell(), (IWizard)wizard);
        if (dialog.open() == 0) {
            pattern.pattern = wizard.getPattern();
            pattern.kind = wizard.getKind();
            this.viewer.refresh((Object)pattern, true, true);
            this.updateLaunchConfigurationDialog();
        }
    }

    void updateButtons(IStructuredSelection selection) {
        int size = selection.size();
        this.editbutton.setEnabled(size == 1);
        this.removebutton.setEnabled(size > 0);
    }

    public String getName() {
        return Messages.ApiUsePatternTab_patterns_title;
    }

    public Image getImage() {
        return ApiUIPlugin.getSharedImage("IMG_ELCL_TEXT_EDIT");
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            Iterator iter;
            this.patterns.clear();
            List pats = configuration.getAttribute("org.eclipse.pde.api.tools.ui.API_PATTERNS_LIST", null);
            if (pats != null) {
                iter = pats.iterator();
                while (iter.hasNext()) {
                    this.addPattern((String)iter.next(), 1);
                }
            }
            if ((pats = configuration.getAttribute("org.eclipse.pde.api.tools.ui.INTERNAL_PATTERNS_LIST", null)) != null) {
                iter = pats.iterator();
                while (iter.hasNext()) {
                    this.addPattern((String)iter.next(), 2);
                }
            }
            if ((pats = configuration.getAttribute("org.eclipse.pde.api.tools.ui.JAR_PATTERNS_LIST", null)) != null) {
                iter = pats.iterator();
                while (iter.hasNext()) {
                    this.addPattern((String)iter.next(), 3);
                }
            }
            if ((pats = configuration.getAttribute("org.eclipse.pde.api.tools.ui.REPORT_PATTERNS_LIST", null)) != null) {
                iter = pats.iterator();
                while (iter.hasNext()) {
                    this.addPattern((String)iter.next(), 4);
                }
            }
            if ((pats = configuration.getAttribute("org.eclipse.pde.api.tools.ui.TO_PATTERNS_LIST", null)) != null) {
                iter = pats.iterator();
                while (iter.hasNext()) {
                    this.addPattern((String)iter.next(), 5);
                }
            }
            this.viewer.refresh();
        }
        catch (CoreException ce) {
            ApiUIPlugin.log(ce);
        }
    }

    boolean addPattern(String pattern, int kind) {
        return this.patterns.add(new Pattern(pattern, kind));
    }

    boolean removePattern(Pattern pattern) {
        return this.patterns.remove(pattern);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        ArrayList<String> api = new ArrayList<String>();
        ArrayList<String> internal = new ArrayList<String>();
        ArrayList<String> jar = new ArrayList<String>();
        ArrayList<String> report = new ArrayList<String>();
        ArrayList<String> reportto = new ArrayList<String>();
        Pattern pattern = null;
        Iterator iter = this.patterns.iterator();
        while (iter.hasNext()) {
            pattern = (Pattern)iter.next();
            switch (pattern.kind) {
                case 1: {
                    api.add(pattern.pattern);
                    break;
                }
                case 2: {
                    internal.add(pattern.pattern);
                    break;
                }
                case 3: {
                    jar.add(pattern.pattern);
                    break;
                }
                case 4: {
                    report.add(pattern.pattern);
                    break;
                }
                case 5: {
                    reportto.add(pattern.pattern);
                }
            }
        }
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.API_PATTERNS_LIST", api.size() > 0 ? api : null);
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.INTERNAL_PATTERNS_LIST", internal.size() > 0 ? internal : null);
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.JAR_PATTERNS_LIST", jar.size() > 0 ? jar : null);
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.REPORT_PATTERNS_LIST", report.size() > 0 ? report : null);
        configuration.setAttribute("org.eclipse.pde.api.tools.ui.TO_PATTERNS_LIST", reportto.size() > 0 ? reportto : null);
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
    }

    class Labels
    extends LabelProvider
    implements ITableLabelProvider {
        Labels() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            Pattern pattern = (Pattern)element;
            switch (columnIndex) {
                case 0: {
                    return pattern.pattern;
                }
                case 1: {
                    switch (pattern.kind) {
                        case 1: {
                            return Messages.ApiUsePatternTab_API;
                        }
                        case 2: {
                            return Messages.ApiUsePatternTab_internal;
                        }
                        case 3: {
                            return Messages.ApiUsePatternTab_archive;
                        }
                        case 4: {
                            return Messages.ApiUsePatternTab_report;
                        }
                        case 5: {
                            return Messages.ApiUsePatternTab_report_to;
                        }
                    }
                }
            }
            return null;
        }
    }

    class Pattern {
        static final int API = 1;
        static final int INTERNAL = 2;
        static final int JAR = 3;
        static final int REPORT = 4;
        static final int REPORT_TO = 5;
        String pattern = null;
        int kind = -1;

        public Pattern(String pattern, int kind) {
            this.pattern = pattern;
            this.kind = kind;
        }

        public String toString() {
            return this.pattern;
        }
    }

    class RegexValidator
    implements IInputValidator {
        RegexValidator() {
        }

        public String isValid(String newText) {
            if ("".equals(newText)) {
                return Messages.ApiUsePatternTab_provide_regex;
            }
            try {
                java.util.regex.Pattern.compile(newText);
            }
            catch (PatternSyntaxException pse) {
                return pse.getDescription();
            }
            return null;
        }
    }
}

