/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import com.ibm.icu.text.Collator;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.SearchUtils;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEditorMessages;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PatternConstructor;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.search.core.text.TextSearchEngine;
import org.eclipse.search.core.text.TextSearchMatchAccess;
import org.eclipse.search.core.text.TextSearchRequestor;
import org.eclipse.search.core.text.TextSearchScope;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.TwoPaneElementSelector;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.ui.texteditor.ITextEditor;

public class PropertyKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private String fPropertiesKey;
    private Shell fShell;
    private IStorage fStorage;
    private ITextEditor fEditor;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public PropertyKeyHyperlink(IRegion region, String key, ITextEditor editor) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)key);
        Assert.isNotNull((Object)editor);
        this.fRegion = region;
        this.fPropertiesKey = key;
        this.fEditor = editor;
        IStorageEditorInput storageEditorInput = (IStorageEditorInput)this.fEditor.getEditorInput();
        this.fShell = this.fEditor.getEditorSite().getShell();
        try {
            this.fStorage = storageEditorInput.getStorage();
        }
        catch (CoreException coreException) {
            this.fStorage = null;
        }
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        if (!this.checkEnabled()) {
            return;
        }
        IResource resource = (IResource)this.fStorage;
        KeyReference[] references = null;
        if (resource != null) {
            references = this.search((IResource)resource.getProject(), this.fPropertiesKey);
        }
        if (references == null) {
            return;
        }
        if (references.length == 0) {
            String message = PropertiesFileEditorMessages.OpenAction_error_messageNoResult;
            this.showErrorInStatusLine(message);
            return;
        }
        this.open(references);
    }

    private boolean checkEnabled() {
        return this.fStorage instanceof IResource;
    }

    private void open(KeyReference[] keyReferences) {
        Assert.isLegal((keyReferences != null && keyReferences.length > 0 ? 1 : 0) != 0);
        if (keyReferences.length == 1) {
            this.open(keyReferences[0]);
        } else {
            this.open(this.select(keyReferences));
        }
    }

    private KeyReference select(final KeyReference[] keyReferences) {
        Object[] result;
        Arrays.sort(keyReferences);
        final int length = keyReferences.length;
        WorkbenchLabelProvider labelProvider = new WorkbenchLabelProvider(){

            public String decorateText(String input, Object element) {
                KeyReference keyRef = (KeyReference)element;
                IStorage storage = keyRef.storage;
                String name = storage.getName();
                if (name == null) {
                    return input;
                }
                int count = 0;
                int i = 0;
                while (i < length) {
                    if (keyReferences[i].storage.equals(storage)) {
                        ++count;
                    }
                    ++i;
                }
                if (count > 1) {
                    Object[] args = new Object[]{BasicElementLabels.getResourceName(name), new Integer(count)};
                    name = Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabelWithMatchCount, args);
                }
                return name;
            }
        };
        TwoPaneElementSelector dialog = new TwoPaneElementSelector(this.fShell, (ILabelProvider)labelProvider, (ILabelProvider)new WorkbenchLabelProvider());
        dialog.setLowerListLabel(PropertiesFileEditorMessages.OpenAction_SelectionDialog_details);
        dialog.setLowerListComparator(new Comparator(){

            public int compare(Object o1, Object o2) {
                return 0;
            }
        });
        dialog.setTitle(PropertiesFileEditorMessages.OpenAction_SelectionDialog_title);
        dialog.setMessage(PropertiesFileEditorMessages.OpenAction_SelectionDialog_message);
        dialog.setElements((Object[])keyReferences);
        if (dialog.open() == 0 && (result = dialog.getResult()) != null && result.length == 1) {
            return (KeyReference)result[0];
        }
        return null;
    }

    private void open(KeyReference keyReference) {
        if (keyReference == null) {
            return;
        }
        try {
            IEditorPart part = EditorUtility.openInEditor(keyReference.storage, true);
            if (part != null) {
                EditorUtility.revealInEditor(part, keyReference.offset, keyReference.length);
            }
        }
        catch (PartInitException x) {
            IWorkbenchAdapter wbAdapter;
            String message = null;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbAdapter = (IWorkbenchAdapter)keyReference.getAdapter(clazz)) != null) {
                message = Messages.format(PropertiesFileEditorMessages.OpenAction_error_messageArgs, new String[]{wbAdapter.getLabel((Object)keyReference), x.getLocalizedMessage()});
            }
            if (message == null) {
                message = Messages.format(PropertiesFileEditorMessages.OpenAction_error_message, x.getLocalizedMessage());
            }
            MessageDialog.openError((Shell)this.fShell, (String)PropertiesFileEditorMessages.OpenAction_error_messageProblems, (String)message);
        }
    }

    private String getErrorDialogTitle() {
        return PropertiesFileEditorMessages.OpenAction_error_title;
    }

    private void showError(CoreException e) {
        ExceptionHandler.handle(e, this.fShell, this.getErrorDialogTitle(), PropertiesFileEditorMessages.OpenAction_error_message);
    }

    private void showErrorInStatusLine(final String message) {
        IEditorStatusLine statusLine;
        this.fShell.getDisplay().beep();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.IEditorStatusLine");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((statusLine = (IEditorStatusLine)this.fEditor.getAdapter((Class)clazz)) != null) {
            this.fShell.getDisplay().asyncExec(new Runnable(){

                public void run() {
                    statusLine.setMessage(true, message, null);
                }
            });
        }
    }

    private boolean useDoubleQuotedKey() {
        if (this.fStorage == null) {
            return false;
        }
        String name = this.fStorage.getName();
        return name != null && !"about.properties".equals(name) && !"feature.properties".equals(name) && !"plugin.properties".equals(name);
    }

    private KeyReference[] search(final IResource scope, String key) {
        String searchString;
        if (key == null) {
            return new KeyReference[0];
        }
        final ArrayList result = new ArrayList(5);
        final boolean useDoubleQuotedKey = this.useDoubleQuotedKey();
        if (useDoubleQuotedKey) {
            StringBuffer buf = new StringBuffer("\"");
            buf.append(this.fPropertiesKey);
            buf.append('\"');
            searchString = buf.toString();
        } else {
            searchString = this.fPropertiesKey;
        }
        try {
            this.fEditor.getEditorSite().getWorkbenchWindow().getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    block11: {
                        if (monitor == null) {
                            monitor = new NullProgressMonitor();
                        }
                        monitor.beginTask("", 5);
                        try {
                            ResultCollector collector = new ResultCollector(result, useDoubleQuotedKey);
                            TextSearchEngine engine = TextSearchEngine.create();
                            Pattern searchPattern = PatternConstructor.createPattern(searchString, true, false);
                            engine.search(PropertyKeyHyperlink.createScope(scope), (TextSearchRequestor)collector, searchPattern, (IProgressMonitor)new SubProgressMonitor(monitor, 4));
                            if (result.size() == 0 && useDoubleQuotedKey) {
                                IJavaElement element = JavaCore.create((IResource)scope);
                                if (element == null) {
                                    return;
                                }
                                int includeMask = 11;
                                IJavaSearchScope javaSearchScope = SearchEngine.createJavaSearchScope((IJavaElement[])new IJavaElement[]{element}, (int)includeMask);
                                SearchPattern pattern = SearchPattern.createPattern((String)PropertyKeyHyperlink.this.fPropertiesKey, (int)4, (int)2, (int)10);
                                if (pattern == null) {
                                    return;
                                }
                                try {
                                    new SearchEngine().search(pattern, SearchUtils.getDefaultSearchParticipants(), javaSearchScope, new SearchRequestor(this, result){
                                        final /* synthetic */ 4 this$1;
                                        private final /* synthetic */ List val$result;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$result = list;
                                        }

                                        public void acceptSearchMatch(SearchMatch match) throws CoreException {
                                            this.val$result.add(new KeyReference((IStorage)match.getResource(), match.getOffset(), match.getLength()));
                                        }
                                    }, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                                    break block11;
                                }
                                catch (CoreException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                            monitor.worked(1);
                        }
                        finally {
                            monitor.done();
                        }
                    }
                }
            });
        }
        catch (InvocationTargetException ex) {
            String message = PropertiesFileEditorMessages.OpenAction_error_messageErrorSearchingKey;
            this.showError(new CoreException((IStatus)new Status(4, "org.eclipse.jdt.ui", 0, message, ex.getTargetException())));
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return result.toArray(new KeyReference[result.size()]);
    }

    private static TextSearchScope createScope(IResource scope) {
        ArrayList<String> fileNamePatternStrings = new ArrayList<String>();
        String[] javaExtensions = JavaCore.getJavaLikeExtensions();
        int i = 0;
        while (i < javaExtensions.length) {
            fileNamePatternStrings.add("*." + javaExtensions[i]);
            ++i;
        }
        fileNamePatternStrings.add("*.xml");
        fileNamePatternStrings.add("*.ini");
        String[] allPatternStrings = fileNamePatternStrings.toArray(new String[fileNamePatternStrings.size()]);
        Pattern fileNamePattern = PatternConstructor.createPattern(allPatternStrings, false, false);
        return TextSearchScope.newSearchScope((IResource[])new IResource[]{scope}, (Pattern)fileNamePattern, (boolean)false);
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return Messages.format(PropertiesFileEditorMessages.OpenAction_hyperlinkText, this.fPropertiesKey);
    }

    private static class KeyReference
    extends PlatformObject
    implements IWorkbenchAdapter,
    Comparable {
        private static final Collator fgCollator = Collator.getInstance();
        private IStorage storage;
        private int offset;
        private int length;

        private KeyReference(IStorage storage, int offset, int length) {
            Assert.isNotNull((Object)storage);
            this.storage = storage;
            this.offset = offset;
            this.length = length;
        }

        public Object getAdapter(Class adapter) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (adapter == clazz) {
                return this;
            }
            return super.getAdapter(adapter);
        }

        public Object[] getChildren(Object o) {
            return null;
        }

        public ImageDescriptor getImageDescriptor(Object object) {
            IWorkbenchAdapter wbAdapter;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((wbAdapter = (IWorkbenchAdapter)this.storage.getAdapter((Class)clazz)) != null) {
                return wbAdapter.getImageDescriptor((Object)this.storage);
            }
            return null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String getLabel(Object o) {
            ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
            try {
                manager.connect(this.storage.getFullPath(), LocationKind.NORMALIZE, null);
                try {
                    ITextFileBuffer buffer = manager.getTextFileBuffer(this.storage.getFullPath(), LocationKind.NORMALIZE);
                    IDocument document = buffer.getDocument();
                    if (document == null) return BasicElementLabels.getPathLabel(this.storage.getFullPath(), false);
                    int line = document.getLineOfOffset(this.offset) + 1;
                    Object[] args = new Object[]{new Integer(line), BasicElementLabels.getPathLabel(this.storage.getFullPath(), false)};
                    String string = Messages.format(PropertiesFileEditorMessages.OpenAction_SelectionDialog_elementLabel, args);
                    return string;
                }
                finally {
                    manager.disconnect(this.storage.getFullPath(), LocationKind.NORMALIZE, null);
                }
            }
            catch (CoreException e) {
                JavaPlugin.log(e.getStatus());
                return BasicElementLabels.getPathLabel(this.storage.getFullPath(), false);
            }
            catch (BadLocationException e) {
                JavaPlugin.log(e);
            }
            return BasicElementLabels.getPathLabel(this.storage.getFullPath(), false);
        }

        public Object getParent(Object o) {
            return null;
        }

        public int compareTo(Object o) {
            String otherPath;
            KeyReference otherRef = (KeyReference)o;
            String thisPath = this.storage.getFullPath().toString();
            int result = fgCollator.compare(thisPath, otherPath = otherRef.storage.getFullPath().toString());
            if (result != 0) {
                return result;
            }
            return this.offset - otherRef.offset;
        }
    }

    private static class ResultCollector
    extends TextSearchRequestor {
        private List fResult;
        private boolean fIsKeyDoubleQuoted;

        public ResultCollector(List result, boolean isKeyDoubleQuoted) {
            this.fResult = result;
            this.fIsKeyDoubleQuoted = isKeyDoubleQuoted;
        }

        public boolean acceptPatternMatch(TextSearchMatchAccess matchAccess) throws CoreException {
            int start = matchAccess.getMatchOffset();
            int length = matchAccess.getMatchLength();
            if (this.fIsKeyDoubleQuoted) {
                ++start;
                length -= 2;
            }
            this.fResult.add(new KeyReference((IStorage)matchAccess.getFile(), start, length));
            return true;
        }
    }
}

