/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQuery;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.resource.ResourceChange;

public class CopyResourceChange
extends ResourceChange {
    private final INewNameQuery fNewNameQuery;
    private final IResource fSource;
    private final IContainer fTarget;
    static /* synthetic */ Class class$0;

    public CopyResourceChange(IResource res, IContainer dest, INewNameQuery newNameQuery) {
        Assert.isTrue((res instanceof IFile || res instanceof IFolder ? 1 : 0) != 0);
        Assert.isTrue((dest instanceof IProject || dest instanceof IFolder ? 1 : 0) != 0);
        this.fNewNameQuery = newNameQuery;
        this.fSource = res;
        this.fTarget = dest;
        this.setValidationMethod(4);
    }

    public String getName() {
        return Messages.format(RefactoringCoreMessages.CopyResourceString_copy, new String[]{BasicElementLabels.getPathLabel(this.getResource().getFullPath(), false), BasicElementLabels.getResourceName((IResource)this.getDestination())});
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Change perform(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        try {
            pm.beginTask(this.getName(), 2);
            String newName = this.getNewResourceName();
            IResource resource = this.getResource();
            boolean performReorg = this.deleteIfAlreadyExists((IProgressMonitor)new SubProgressMonitor(pm, 1), newName);
            if (!performReorg) {
                return null;
            }
            this.getResource().copy(this.getDestinationPath(newName), this.getReorgFlags(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
            this.markAsExecuted(resource);
            return null;
        }
        finally {
            pm.done();
        }
    }

    private IPath getDestinationPath(String newName) {
        return this.getDestination().getFullPath().append(newName);
    }

    private boolean deleteIfAlreadyExists(IProgressMonitor pm, String newName) throws CoreException {
        pm.beginTask("", 1);
        IResource current = this.getDestination().findMember(newName);
        if (current == null) {
            return true;
        }
        if (!current.exists()) {
            return true;
        }
        IResource resource = this.getResource();
        Assert.isNotNull((Object)resource);
        if (ReorgUtils.areEqualInWorkspaceOrOnDisk(resource, current)) {
            return false;
        }
        if (current instanceof IFile) {
            ((IFile)current).delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else if (current instanceof IFolder) {
            ((IFolder)current).delete(false, true, (IProgressMonitor)new SubProgressMonitor(pm, 1));
        } else {
            Assert.isTrue((boolean)false);
        }
        return true;
    }

    private String getNewResourceName() throws OperationCanceledException {
        if (this.fNewNameQuery == null) {
            return this.getResource().getName();
        }
        String name = this.fNewNameQuery.getNewName();
        if (name == null) {
            return this.getResource().getName();
        }
        return name;
    }

    protected IResource getModifiedResource() {
        return this.getResource();
    }

    private IResource getResource() {
        return this.fSource;
    }

    private IContainer getDestination() {
        return this.fTarget;
    }

    private int getReorgFlags() {
        return 34;
    }

    private void markAsExecuted(IResource resource) {
        ReorgExecutionLog log;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((log = (ReorgExecutionLog)this.getAdapter(clazz)) != null) {
            log.markAsProcessed((Object)resource);
        }
    }
}

