/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.fr;

import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.fr.FrenchStemmer;

public final class FrenchStemFilter
extends TokenFilter {
    private Token token = null;
    private FrenchStemmer stemmer = new FrenchStemmer();
    private Set exclusions = null;

    public FrenchStemFilter(TokenStream in) {
        super(in);
    }

    public FrenchStemFilter(TokenStream in, Hashtable exclusiontable) {
        this(in);
        this.exclusions = new HashSet(exclusiontable.keySet());
    }

    public FrenchStemFilter(TokenStream in, Set exclusiontable) {
        this(in);
        this.exclusions = exclusiontable;
    }

    public final Token next() throws IOException {
        this.token = this.input.next();
        if (this.token == null) {
            return null;
        }
        if (this.exclusions != null && this.exclusions.contains(this.token.termText())) {
            return this.token;
        }
        String s = this.stemmer.stem(this.token.termText());
        if (!s.equals(this.token.termText())) {
            return new Token(s, this.token.startOffset(), this.token.endOffset(), this.token.type());
        }
        return this.token;
    }

    public void setStemmer(FrenchStemmer stemmer) {
        if (stemmer != null) {
            this.stemmer = stemmer;
        }
    }

    public void setExclusionTable(Hashtable exclusiontable) {
        this.exclusions = new HashSet(exclusiontable.keySet());
    }
}

