/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.commands.internal;

import java.util.Map;
import javax.inject.Inject;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.e4.core.commands.EHandlerService;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;

public class HandlerServiceImpl
implements EHandlerService {
    public static final String H_ID = "handler::";
    public static final String PARM_MAP = "parmMap::";
    static final String LOOKUP_HANDLER = "handler";
    private IEclipseContext context;

    public static Object lookUpHandler(IEclipseContext context, String commandId) {
        IEclipseContext current = context;
        IEclipseContext child = (IEclipseContext)current.getLocal("activeChildContext");
        while (child != null) {
            current = child;
            child = (IEclipseContext)current.getLocal("activeChildContext");
        }
        return current.get(H_ID + commandId);
    }

    public void activateHandler(String commandId, Object handler) {
        String handlerId = H_ID + commandId;
        this.context.set(handlerId, handler);
    }

    private void addParmsToContext(ParameterizedCommand command) {
        Map parms = command.getParameterMap();
        for (Map.Entry entry : parms.entrySet()) {
            this.context.set((String)entry.getKey(), entry.getValue());
        }
        this.context.set(PARM_MAP, (Object)parms);
    }

    private void removeParmsFromContext(ParameterizedCommand command) {
        if (this.context == null) {
            return;
        }
        Map parms = command.getParameterMap();
        for (Map.Entry entry : parms.entrySet()) {
            this.context.set((String)entry.getKey(), null);
        }
        this.context.set(PARM_MAP, null);
    }

    public boolean canExecute(ParameterizedCommand command) {
        String commandId = command.getId();
        Object handler = HandlerServiceImpl.lookUpHandler(this.context, commandId);
        if (handler == null) {
            return false;
        }
        try {
            this.addParmsToContext(command);
            Boolean result = (Boolean)ContextInjectionFactory.invoke((Object)handler, CanExecute.class, (IEclipseContext)this.context, (Object)Boolean.TRUE);
            boolean bl = result;
            return bl;
        }
        finally {
            this.removeParmsFromContext(command);
        }
    }

    public void deactivateHandler(String commandId, Object handler) {
        this.context.remove(H_ID + commandId);
    }

    public Object executeHandler(ParameterizedCommand command) {
        String commandId = command.getId();
        Object handler = HandlerServiceImpl.lookUpHandler(this.context, commandId);
        if (handler == null) {
            return null;
        }
        try {
            this.addParmsToContext(command);
            Object rc = ContextInjectionFactory.invoke((Object)handler, CanExecute.class, (IEclipseContext)this.context, (Object)Boolean.TRUE);
            if (Boolean.FALSE.equals(rc)) {
                return null;
            }
            Object object = ContextInjectionFactory.invoke((Object)handler, Execute.class, (IEclipseContext)this.context, null);
            return object;
        }
        finally {
            this.removeParmsFromContext(command);
        }
    }

    @Inject
    public void setContext(IEclipseContext c) {
        this.context = c;
    }

    public IEclipseContext getContext() {
        return this.context;
    }
}

