/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.buildpath;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathContainer;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.BasicElementLabels;
import org.eclipse.jdt.internal.junit.buildpath.BuildPathSupport;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.ExceptionHandler;
import org.eclipse.jdt.internal.junit.util.JUnitStatus;
import org.eclipse.jdt.internal.junit.util.JUnitStubUtility;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.junit.JUnitCore;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPage;
import org.eclipse.jdt.ui.wizards.IClasspathContainerPageExtension;
import org.eclipse.jdt.ui.wizards.NewElementWizardPage;
import org.eclipse.jface.layout.PixelConverter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class JUnitContainerWizardPage
extends NewElementWizardPage
implements IClasspathContainerPage,
IClasspathContainerPageExtension {
    private IJavaProject fProject;
    private IClasspathEntry fContainerEntryResult;
    private Combo fVersionCombo;
    private Label fResolvedPath;
    private Label fResolvedSourcePath;

    public JUnitContainerWizardPage() {
        super("JUnitContainerPage");
        this.setTitle(JUnitMessages.JUnitContainerWizardPage_wizard_title);
        this.setDescription(JUnitMessages.JUnitContainerWizardPage_wizard_description);
        this.setImageDescriptor(JavaPluginImages.DESC_WIZBAN_ADD_LIBRARY);
        this.fContainerEntryResult = JavaCore.newContainerEntry((IPath)JUnitCore.JUNIT3_CONTAINER_PATH);
    }

    public static IJavaProject getPlaceholderProject() {
        String name = "####internal";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project;
        while ((project = root.getProject(name)).exists()) {
            name = String.valueOf(name) + '1';
        }
        return JavaCore.create((IProject)project);
    }

    public boolean finish() {
        try {
            IJavaProject[] javaProjects = new IJavaProject[]{JUnitContainerWizardPage.getPlaceholderProject()};
            IClasspathContainer[] containers = new IClasspathContainer[1];
            JavaCore.setClasspathContainer((IPath)this.fContainerEntryResult.getPath(), (IJavaProject[])javaProjects, (IClasspathContainer[])containers, null);
        }
        catch (JavaModelException e) {
            ExceptionHandler.handle((CoreException)e, this.getShell(), JUnitMessages.JUnitContainerWizardPage_error_title, JUnitMessages.JUnitContainerWizardPage_error_problem_configuring_container);
            return false;
        }
        return true;
    }

    public IClasspathEntry getSelection() {
        return this.fContainerEntryResult;
    }

    public void setSelection(IClasspathEntry containerEntry) {
        this.fContainerEntryResult = containerEntry;
    }

    public void createControl(Composite parent) {
        PixelConverter converter = new PixelConverter((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setLayoutData((Object)new GridData(4, 2, false, false, 1, 1));
        label.setText(JUnitMessages.JUnitContainerWizardPage_combo_label);
        this.fVersionCombo = new Combo(composite, 8);
        this.fVersionCombo.setItems(new String[]{JUnitMessages.JUnitContainerWizardPage_option_junit3, JUnitMessages.JUnitContainerWizardPage_option_junit4});
        this.fVersionCombo.setFont(composite.getFont());
        GridData data = new GridData(1, 2, false, false, 1, 1);
        data.widthHint = converter.convertWidthInCharsToPixels(15);
        this.fVersionCombo.setLayoutData((Object)data);
        if (this.fContainerEntryResult != null && JUnitCore.JUNIT4_CONTAINER_PATH.equals((Object)this.fContainerEntryResult.getPath())) {
            this.fVersionCombo.select(1);
        } else {
            this.fVersionCombo.select(0);
        }
        this.fVersionCombo.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JUnitContainerWizardPage.this.doSelectionChanged();
            }
        });
        label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(JUnitMessages.JUnitContainerWizardPage_resolved_label);
        label.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.fResolvedPath = new Label(composite, 64);
        data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = converter.convertWidthInCharsToPixels(60);
        this.fResolvedPath.setFont(composite.getFont());
        this.fResolvedPath.setLayoutData((Object)data);
        label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(JUnitMessages.JUnitContainerWizardPage_source_location_label);
        label.setLayoutData((Object)new GridData(4, 1, false, false, 1, 1));
        this.fResolvedSourcePath = new Label(composite, 64);
        data = new GridData(4, 4, true, false, 1, 1);
        data.widthHint = converter.convertWidthInCharsToPixels(60);
        this.fResolvedSourcePath.setFont(composite.getFont());
        this.fResolvedSourcePath.setLayoutData((Object)data);
        this.doSelectionChanged();
        this.setControl((Control)composite);
    }

    protected void doSelectionChanged() {
        IClasspathEntry libEntry;
        IPath containerPath;
        JUnitStatus status = new JUnitStatus();
        if (this.fVersionCombo != null && this.fVersionCombo.getSelectionIndex() == 1) {
            containerPath = JUnitCore.JUNIT4_CONTAINER_PATH;
            libEntry = BuildPathSupport.getJUnit4LibraryEntry();
        } else {
            containerPath = JUnitCore.JUNIT3_CONTAINER_PATH;
            libEntry = BuildPathSupport.getJUnit3LibraryEntry();
        }
        if (libEntry == null) {
            status.setError(JUnitMessages.JUnitContainerWizardPage_error_version_not_available);
        } else if (JUnitCore.JUNIT4_CONTAINER_PATH.equals((Object)containerPath) && this.fProject != null && !JUnitStubUtility.is50OrHigher(this.fProject)) {
            status.setWarning(JUnitMessages.JUnitContainerWizardPage_warning_java5_required);
        }
        this.fContainerEntryResult = JavaCore.newContainerEntry((IPath)containerPath);
        if (this.fResolvedPath != null && !this.fResolvedPath.isDisposed()) {
            if (libEntry != null) {
                this.fResolvedPath.setText(this.getPathLabel(libEntry.getPath()));
            } else {
                this.fResolvedPath.setText(JUnitMessages.JUnitContainerWizardPage_lib_not_found);
            }
        }
        if (this.fResolvedSourcePath != null && !this.fResolvedSourcePath.isDisposed()) {
            if (libEntry != null && libEntry.getSourceAttachmentPath() != null) {
                this.fResolvedSourcePath.setText(this.getPathLabel(libEntry.getSourceAttachmentPath()));
            } else {
                this.fResolvedSourcePath.setText(JUnitMessages.JUnitContainerWizardPage_source_not_found);
            }
        }
        this.updateStatus(status);
    }

    private String getPathLabel(IPath path) {
        StringBuffer buf = new StringBuffer(BasicElementLabels.getResourceName((String)path.lastSegment()));
        buf.append(JavaElementLabels.CONCAT_STRING);
        buf.append(BasicElementLabels.getPathLabel((IPath)path.removeLastSegments(1), (boolean)true));
        return buf.toString();
    }

    public void initialize(IJavaProject project, IClasspathEntry[] currentEntries) {
        this.fProject = project;
    }
}

