/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.model.AbstractApiTypeRoot;
import org.eclipse.pde.api.tools.internal.model.ApiElement;
import org.eclipse.pde.api.tools.internal.model.TypeStructureBuilder;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.model.ApiTypeContainerVisitor;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiElement;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeContainer;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiTypeRoot;
import org.eclipse.pde.api.tools.internal.util.Util;

public class StubArchiveApiTypeContainer
extends ApiElement
implements IApiTypeContainer {
    String fLocation;
    private Map fPackages;
    private String[] fPackageNames;
    private ZipFile fZipFile = null;

    public StubArchiveApiTypeContainer(IApiElement parent, String path) {
        super(parent, 3, path);
        this.fLocation = path;
    }

    public void accept(ApiTypeContainerVisitor visitor) throws CoreException {
        if (visitor.visit(this)) {
            this.init();
            ArrayList packages = new ArrayList(this.fPackages.keySet());
            Collections.sort(packages);
            Iterator iterator = packages.iterator();
            while (iterator.hasNext()) {
                String pkg = (String)iterator.next();
                if (visitor.visitPackage(pkg)) {
                    ArrayList types = new ArrayList((Set)this.fPackages.get(pkg));
                    Iterator cfIterator = types.iterator();
                    ArrayList<ArchiveApiTypeRoot> classFiles = new ArrayList<ArchiveApiTypeRoot>(types.size());
                    while (cfIterator.hasNext()) {
                        String entryName = (String)cfIterator.next();
                        classFiles.add(new ArchiveApiTypeRoot(this, entryName));
                    }
                    Collections.sort(classFiles);
                    cfIterator = classFiles.iterator();
                    while (cfIterator.hasNext()) {
                        ArchiveApiTypeRoot classFile = (ArchiveApiTypeRoot)cfIterator.next();
                        visitor.visit(pkg, classFile);
                        visitor.end(pkg, classFile);
                    }
                }
                visitor.endVisitPackage(pkg);
            }
        }
        visitor.end(this);
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("Archive Class File Container: " + this.getName());
        return buff.toString();
    }

    public synchronized void close() throws CoreException {
        if (this.fZipFile != null) {
            try {
                this.fZipFile.close();
                this.fZipFile = null;
            }
            catch (IOException e) {
                this.abort("Failed to close class file archive", e);
            }
        }
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName) throws CoreException {
        String fileName;
        Set classFileNames;
        this.init();
        int index = qualifiedName.lastIndexOf(46);
        String packageName = "";
        if (index >= 0) {
            packageName = qualifiedName.substring(0, index);
        }
        if ((classFileNames = (Set)this.fPackages.get(packageName)) != null && classFileNames.contains(fileName = qualifiedName.replace('.', '/'))) {
            return new ArchiveApiTypeRoot(this, fileName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getPackageNames() throws CoreException {
        this.init();
        StubArchiveApiTypeContainer stubArchiveApiTypeContainer = this;
        synchronized (stubArchiveApiTypeContainer) {
            if (this.fPackageNames == null) {
                Set names = this.fPackages.keySet();
                Object[] result = new String[names.size()];
                names.toArray(result);
                Arrays.sort(result);
                this.fPackageNames = result;
            }
            return this.fPackageNames;
        }
    }

    private synchronized void init() throws CoreException {
        ZipFile zipFile = this.open();
        if (this.fPackages == null) {
            this.fPackages = new HashMap();
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                HashSet<String> fileNames;
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                String pkg = "";
                int index = name.lastIndexOf(47);
                if (index >= 0) {
                    pkg = name.substring(0, index).replace('/', '.');
                }
                if ((fileNames = (HashSet<String>)this.fPackages.get(pkg)) == null) {
                    fileNames = new HashSet<String>();
                    this.fPackages.put(pkg, fileNames);
                }
                fileNames.add(name);
            }
        }
    }

    synchronized ZipFile open() throws CoreException {
        if (this.fZipFile == null) {
            try {
                this.fZipFile = new ZipFile(this.fLocation);
            }
            catch (IOException e) {
                this.abort("Failed to open archive: " + this.fLocation, e);
            }
        }
        return this.fZipFile;
    }

    public boolean equals(Object obj) {
        if (obj instanceof StubArchiveApiTypeContainer) {
            return this.fLocation.equals(((StubArchiveApiTypeContainer)obj).fLocation);
        }
        return false;
    }

    public int hashCode() {
        return this.fLocation.hashCode();
    }

    public IApiTypeRoot findTypeRoot(String qualifiedName, String id) throws CoreException {
        return this.findTypeRoot(qualifiedName);
    }

    public int getContainerType() {
        return 1;
    }

    static class ArchiveApiTypeRoot
    extends AbstractApiTypeRoot
    implements Comparable {
        private String fTypeName;

        public IApiType getStructure() throws CoreException {
            return TypeStructureBuilder.buildStubTypeStructure(this.getContents(), this.getApiComponent(), this);
        }

        public ArchiveApiTypeRoot(StubArchiveApiTypeContainer container, String entryName) {
            super(container, entryName);
        }

        public String getTypeName() {
            if (this.fTypeName == null) {
                this.fTypeName = this.getName().replace('/', '.').substring(0, this.getName().length() - ".class".length());
            }
            return this.fTypeName;
        }

        public int compareTo(Object o) {
            return this.getTypeName().compareTo(((ArchiveApiTypeRoot)o).getTypeName());
        }

        public boolean equals(Object obj) {
            if (obj instanceof ArchiveApiTypeRoot) {
                ArchiveApiTypeRoot classFile = (ArchiveApiTypeRoot)obj;
                return this.getName().equals(classFile.getName());
            }
            return false;
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public byte[] getContents() throws CoreException {
            StubArchiveApiTypeContainer archive = (StubArchiveApiTypeContainer)this.getParent();
            ZipFile zipFile = archive.open();
            ZipEntry entry = zipFile.getEntry(this.getName());
            InputStream stream = null;
            if (entry != null) {
                try {
                    stream = zipFile.getInputStream(entry);
                }
                catch (IOException e) {
                    this.abort("Failed to open class file: " + this.getTypeName() + " in archive: " + archive.fLocation, e);
                    return null;
                }
                try {
                    byte[] byArray = Util.getInputStreamAsByteArray(stream, -1);
                    return byArray;
                }
                catch (IOException ioe) {
                    this.abort("Unable to read class file: " + this.getTypeName(), ioe);
                    return null;
                }
                finally {
                    try {
                        stream.close();
                    }
                    catch (IOException e) {
                        ApiPlugin.log(e);
                    }
                }
            }
            this.abort("Class file not found: " + this.getTypeName() + " in archive: " + archive.fLocation, null);
            return null;
        }
    }
}

