/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.callhierarchy;

import java.util.Iterator;
import org.eclipse.jdt.internal.corext.callhierarchy.CallLocation;
import org.eclipse.jdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.jdt.internal.ui.callhierarchy.CopyCallHierarchyAction;
import org.eclipse.jdt.internal.ui.callhierarchy.LocationViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;

class LocationCopyAction
extends Action {
    private final Clipboard fClipboard;
    private final IViewSite fViewSite;
    private final LocationViewer fLocationViewer;

    LocationCopyAction(IViewSite viewSite, Clipboard clipboard, LocationViewer locationViewer) {
        this.fClipboard = clipboard;
        this.fViewSite = viewSite;
        this.fLocationViewer = locationViewer;
        this.setText(CallHierarchyMessages.LocationCopyAction_copy);
        this.setActionDefinitionId("org.eclipse.ui.edit.copy");
        this.setEnabled(!this.fLocationViewer.getSelection().isEmpty());
        locationViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LocationCopyAction.this.setEnabled(!event.getSelection().isEmpty());
            }
        });
    }

    public void run() {
        block4: {
            IStructuredSelection selection = (IStructuredSelection)this.fLocationViewer.getSelection();
            StringBuffer buf = new StringBuffer();
            Iterator iterator = selection.iterator();
            while (iterator.hasNext()) {
                CallLocation location = (CallLocation)iterator.next();
                buf.append(location.getLineNumber()).append('\t').append(location.getCallText());
                buf.append('\n');
            }
            TextTransfer plainTextTransfer = TextTransfer.getInstance();
            try {
                this.fClipboard.setContents((Object[])new String[]{CopyCallHierarchyAction.convertLineTerminators(buf.toString())}, new Transfer[]{plainTextTransfer});
            }
            catch (SWTError e) {
                if (e.code != 2002) {
                    throw e;
                }
                if (!MessageDialog.openQuestion((Shell)this.fViewSite.getShell(), (String)CallHierarchyMessages.CopyCallHierarchyAction_problem, (String)CallHierarchyMessages.CopyCallHierarchyAction_clipboard_busy)) break block4;
                this.run();
            }
        }
    }
}

