/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.carbon;

import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.carbon.HICommand;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.WorkbenchWindow;

public class CarbonUIEnhancer
implements IStartup {
    private static final int kHICommandPreferences = 1886545254;
    private static final int kHICommandAbout = 1633841013;
    private static final int kHICommandServices = 1936028278;
    private static final int kHICommandHide = 1751737445;
    private static final int kHICommandQuit = 1903520116;
    private static final String RESOURCE_BUNDLE;
    private String fAboutActionName;
    private String fQuitActionName;
    private String fHideActionName;
    private int applicationMenuHandle;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.carbon.CarbonUIEnhancer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        RESOURCE_BUNDLE = String.valueOf(clazz.getPackage().getName()) + ".Messages";
    }

    public CarbonUIEnhancer() {
        String format;
        IProduct product = Platform.getProduct();
        String productName = null;
        if (product != null) {
            productName = product.getName();
        }
        ResourceBundle resourceBundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        try {
            if (productName != null && (format = resourceBundle.getString("AboutAction.format")) != null) {
                this.fAboutActionName = MessageFormat.format(format, productName);
            }
            if (this.fAboutActionName == null) {
                this.fAboutActionName = resourceBundle.getString("AboutAction.name");
            }
        }
        catch (MissingResourceException missingResourceException) {}
        if (this.fAboutActionName == null) {
            this.fAboutActionName = "About";
        }
        if (productName != null) {
            try {
                format = resourceBundle.getString("HideAction.format");
                if (format != null) {
                    this.fHideActionName = MessageFormat.format(format, productName);
                }
            }
            catch (MissingResourceException missingResourceException) {}
            try {
                format = resourceBundle.getString("QuitAction.format");
                if (format != null) {
                    this.fQuitActionName = MessageFormat.format(format, productName);
                }
            }
            catch (MissingResourceException missingResourceException) {}
        }
    }

    public void earlyStartup() {
        final Display display = Display.getDefault();
        display.syncExec(new Runnable(){

            public void run() {
                CarbonUIEnhancer.this.hookApplicationMenu(display);
                CarbonUIEnhancer.this.hookToolbarButtonCallback();
                CarbonUIEnhancer.this.hookWorkbenchListener();
                IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
                int i = 0;
                while (i < windows.length) {
                    CarbonUIEnhancer.this.modifyWindowShell(windows[i]);
                    ++i;
                }
            }
        });
    }

    protected void hookWorkbenchListener() {
        PlatformUI.getWorkbench().addWindowListener(new IWindowListener(){

            public void windowActivated(IWorkbenchWindow window) {
            }

            public void windowDeactivated(IWorkbenchWindow window) {
            }

            public void windowClosed(IWorkbenchWindow window) {
            }

            public void windowOpened(IWorkbenchWindow window) {
                CarbonUIEnhancer.this.modifyWindowShell(window);
            }
        });
    }

    protected void modifyWindowShell(IWorkbenchWindow window) {
        boolean coolBarInitiallyVsible = ((WorkbenchWindow)window).getCoolBarVisible();
        boolean perspectiveBarInitiallyVsible = ((WorkbenchWindow)window).getPerspectiveBarVisible();
        if (coolBarInitiallyVsible || perspectiveBarInitiallyVsible) {
            Shell shell = window.getShell();
            int windowHandle = OS.GetControlOwner((int)shell.handle);
            OS.ChangeWindowAttributes((int)windowHandle, (int)64, (int)0);
        }
    }

    protected void hookToolbarButtonCallback() {
        Target target = new Target();
        Callback commandCallback = new Callback((Object)target, "toolbarProc", 3);
        int commandProc = commandCallback.getAddress();
        if (commandProc == 0) {
            commandCallback.dispose();
            return;
        }
        int[] mask = new int[]{2003398244, 150};
        OS.InstallEventHandler((int)OS.GetApplicationEventTarget(), (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)0, null);
    }

    private void hookApplicationMenu(Display display) {
        Target target = new Target();
        final Callback commandCallback = new Callback((Object)target, "commandProc", 3);
        int commandProc = commandCallback.getAddress();
        if (commandProc == 0) {
            commandCallback.dispose();
            return;
        }
        int[] mask = new int[]{1668113523, 1};
        OS.InstallEventHandler((int)OS.GetApplicationEventTarget(), (int)commandProc, (int)(mask.length / 2), (int[])mask, (int)0, null);
        int[] outMenu = new int[1];
        short[] outIndex = new short[1];
        if (OS.GetIndMenuItemWithCommandID((int)0, (int)1886545254, (int)1, (int[])outMenu, (short[])outIndex) == 0 && outMenu[0] != 0) {
            this.applicationMenuHandle = outMenu[0];
            int l = this.fAboutActionName.length();
            char[] buffer = new char[l];
            this.fAboutActionName.getChars(0, l, buffer, 0);
            int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.InsertMenuItemTextWithCFString((int)this.applicationMenuHandle, (int)str, (short)0, (int)0, (int)1633841013);
            OS.CFRelease((int)str);
            if (this.fHideActionName != null) {
                this.renameApplicationMenuItem(1751737445, this.fHideActionName);
            }
            if (this.fQuitActionName != null) {
                this.renameApplicationMenuItem(1903520116, this.fQuitActionName);
            }
            OS.InsertMenuItemTextWithCFString((int)this.applicationMenuHandle, (int)0, (short)1, (int)64, (int)0);
            OS.EnableMenuCommand((int)this.applicationMenuHandle, (int)1886545254);
            OS.DisableMenuCommand((int)this.applicationMenuHandle, (int)1936028278);
        }
        display.disposeExec(new Runnable(){

            public void run() {
                commandCallback.dispose();
            }
        });
    }

    private void renameApplicationMenuItem(int itemConstant, String replacementName) {
        int[] itemMenu = new int[1];
        short[] itemIndex = new short[1];
        if (OS.GetIndMenuItemWithCommandID((int)0, (int)itemConstant, (int)1, (int[])itemMenu, (short[])itemIndex) == 0 && itemMenu[0] != 0) {
            int l = replacementName.length();
            char[] buffer = new char[l];
            replacementName.getChars(0, l, buffer, 0);
            int str = OS.CFStringCreateWithCharacters((int)0, (char[])buffer, (int)l);
            OS.SetMenuItemTextWithCFString((int)itemMenu[0], (short)itemIndex[0], (int)str);
            OS.CFRelease((int)str);
        }
    }

    private int runAction(String actionId) {
        IMenuManager manager;
        IAction action;
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        if (window != null && (action = this.findAction(actionId, manager = ((WorkbenchWindow)window).getActionBars().getMenuManager())) != null && action.isEnabled()) {
            try {
                OS.DisableMenuCommand((int)this.applicationMenuHandle, (int)1886545254);
                OS.DisableMenuCommand((int)this.applicationMenuHandle, (int)1633841013);
                action.run();
            }
            finally {
                OS.EnableMenuCommand((int)this.applicationMenuHandle, (int)1886545254);
                OS.EnableMenuCommand((int)this.applicationMenuHandle, (int)1633841013);
            }
            return 0;
        }
        return -9874;
    }

    private int runCommand(String commandId) {
        IHandlerService commandService;
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return -9874;
        }
        IWorkbenchWindow activeWorkbenchWindow = workbench.getActiveWorkbenchWindow();
        if (activeWorkbenchWindow == null) {
            return -9874;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.handlers.IHandlerService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((commandService = (IHandlerService)activeWorkbenchWindow.getService((Class)clazz)) != null) {
            try {
                commandService.executeCommand(commandId, null);
                return 0;
            }
            catch (ExecutionException executionException) {
            }
            catch (NotDefinedException notDefinedException) {
            }
            catch (NotEnabledException notEnabledException) {
            }
            catch (NotHandledException notHandledException) {}
        }
        return -9874;
    }

    private IAction findAction(String actionId, IMenuManager manager) {
        IContributionItem[] items = manager.getItems();
        int i = 0;
        while (i < items.length) {
            IAction found;
            IContributionItem item = items[i];
            if (item instanceof ActionContributionItem) {
                ActionContributionItem aci = (ActionContributionItem)item;
                String id = aci.getId();
                if (id != null && id.equals(actionId)) {
                    return aci.getAction();
                }
            } else if (item instanceof IMenuManager && (found = this.findAction(actionId, (IMenuManager)item)) != null) {
                return found;
            }
            ++i;
        }
        return null;
    }

    class Target {
        Target() {
        }

        public int toolbarProc(int nextHandler, int theEvent, int userData) {
            int eventKind = OS.GetEventKind((int)theEvent);
            if (eventKind != 150) {
                return -9874;
            }
            int[] theWindow = new int[1];
            OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)2003398244, null, (int)4, null, (int[])theWindow);
            int[] theRoot = new int[1];
            OS.GetRootControl((int)theWindow[0], (int[])theRoot);
            Widget widget = Display.getCurrent().findWidget(theRoot[0]);
            if (!(widget instanceof Shell)) {
                return -9874;
            }
            Shell shell = (Shell)widget;
            IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
            int i = 0;
            while (i < windows.length) {
                if (windows[i].getShell() == shell) {
                    return CarbonUIEnhancer.this.runCommand("org.eclipse.ui.ToggleCoolbarAction");
                }
                ++i;
            }
            return -9874;
        }

        public int commandProc(int nextHandler, int theEvent, int userData) {
            if (OS.GetEventKind((int)theEvent) == 1) {
                HICommand command = new HICommand();
                OS.GetEventParameter((int)theEvent, (int)0x2D2D2D2D, (int)1751346532, null, (int)14, null, (HICommand)command);
                switch (command.commandID) {
                    case 1886545254: {
                        return CarbonUIEnhancer.this.runAction("preferences");
                    }
                    case 1633841013: {
                        return CarbonUIEnhancer.this.runAction("about");
                    }
                }
            }
            return -9874;
        }
    }
}

