/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import org.eclipse.ant.internal.ui.AntUIPlugin;
import org.eclipse.ant.internal.ui.AntUtil;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.ant.internal.ui.launchConfigurations.AntTargetsTab;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.variables.IStringVariableManager;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.launchConfigurations.ExternalToolsMainTab;
import org.eclipse.ui.externaltools.internal.ui.FileSelectionDialog;

public class AntMainTab
extends ExternalToolsMainTab {
    private String fCurrentLocation = null;
    private Button fSetInputHandlerButton;
    private IFile fNewFile;

    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            this.fCurrentLocation = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
        }
        catch (CoreException coreException) {}
        this.updateCheckButtons(configuration);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        try {
            String newLocation = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
            if (newLocation != null) {
                if (!newLocation.equals(this.fCurrentLocation)) {
                    this.updateTargetsTab();
                    this.fCurrentLocation = newLocation;
                    this.updateProjectName(configuration);
                }
            } else if (this.fCurrentLocation != null) {
                this.updateTargetsTab();
                this.fCurrentLocation = newLocation;
                this.updateProjectName(configuration);
            }
        }
        catch (CoreException coreException) {}
        this.setMappedResources(configuration);
        this.setAttribute("org.eclipse.ant.uiSET_INPUTHANDLER", configuration, this.fSetInputHandlerButton.getSelection(), true);
    }

    private void setMappedResources(ILaunchConfigurationWorkingCopy configuration) {
        try {
            if (!"org.eclipse.ant.AntBuilderLaunchConfigurationType".equals(configuration.getType().getIdentifier())) {
                IFile file = this.getIFile(configuration);
                configuration.setMappedResources(new IResource[]{file});
            }
        }
        catch (CoreException coreException) {}
    }

    private void updateProjectName(ILaunchConfigurationWorkingCopy configuration) {
        IFile file = this.getIFile(configuration);
        String projectName = "";
        if (file != null) {
            projectName = file.getProject().getName();
        }
        configuration.setAttribute(IJavaLaunchConfigurationConstants.ATTR_PROJECT_NAME, projectName);
    }

    private IFile getIFile(ILaunchConfigurationWorkingCopy configuration) {
        IFile file = null;
        if (this.fNewFile != null) {
            file = this.fNewFile;
            this.fNewFile = null;
        } else {
            IStringVariableManager manager = VariablesPlugin.getDefault().getStringVariableManager();
            try {
                String expandedLocation;
                String location = configuration.getAttribute("org.eclipse.ui.externaltools.ATTR_LOCATION", null);
                if (location != null && (expandedLocation = manager.performStringSubstitution(location)) != null) {
                    file = AntUtil.getFileForLocation(expandedLocation, null);
                }
            }
            catch (CoreException coreException) {}
        }
        return file;
    }

    public void createControl(Composite parent) {
        Composite mainComposite = new Composite(parent, 0);
        this.setControl((Control)mainComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)mainComposite, "org.eclipse.ant.ui.ant_main_tab_context");
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData gridData = new GridData(768);
        mainComposite.setLayout((Layout)layout);
        mainComposite.setLayoutData((Object)gridData);
        mainComposite.setFont(parent.getFont());
        this.createLocationComponent(mainComposite);
        this.createWorkDirectoryComponent(mainComposite);
        this.createArgumentComponent(mainComposite);
        this.createVerticalSpacer(mainComposite, 2);
        this.createSetInputHandlerComponent(mainComposite);
        Dialog.applyDialogFont((Control)parent);
    }

    private void createSetInputHandlerComponent(Composite parent) {
        this.fSetInputHandlerButton = this.createCheckButton(parent, AntLaunchConfigurationMessages.AntMainTab_0);
        GridData data = new GridData(256);
        data.horizontalSpan = 2;
        this.fSetInputHandlerButton.setLayoutData((Object)data);
        this.fSetInputHandlerButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AntMainTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    private void updateCheckButtons(ILaunchConfiguration configuration) {
        boolean setInputHandler = true;
        try {
            setInputHandler = configuration.getAttribute("org.eclipse.ant.uiSET_INPUTHANDLER", true);
        }
        catch (CoreException ce) {
            AntUIPlugin.log(AntLaunchConfigurationMessages.AntMainTab_1, ce);
        }
        this.fSetInputHandlerButton.setSelection(setInputHandler);
    }

    protected void handleWorkspaceLocationButtonSelected() {
        FileSelectionDialog dialog = new FileSelectionDialog(this.getShell(), (IAdaptable)ResourcesPlugin.getWorkspace().getRoot(), AntLaunchConfigurationMessages.AntMainTab__Select_a_build_file__1);
        dialog.open();
        IStructuredSelection result = dialog.getResult();
        if (result == null) {
            return;
        }
        Object file = result.getFirstElement();
        if (file instanceof IFile) {
            this.fNewFile = (IFile)file;
            this.locationField.setText(VariablesPlugin.getDefault().getStringVariableManager().generateVariableExpression("workspace_loc", this.fNewFile.getFullPath().toString()));
        }
    }

    protected String getWorkingDirectoryLabel() {
        return AntLaunchConfigurationMessages.AntMainTab_3;
    }

    private void updateTargetsTab() {
        ILaunchConfigurationTab[] tabs = this.getLaunchConfigurationDialog().getTabs();
        int i = 0;
        while (i < tabs.length) {
            ILaunchConfigurationTab tab = tabs[i];
            if (tab instanceof AntTargetsTab) {
                ((AntTargetsTab)tab).setDirty(true);
                break;
            }
            ++i;
        }
    }

    protected String getLocationLabel() {
        return AntLaunchConfigurationMessages.AntMainTab_6;
    }
}

