/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.core.internal.contexts;

import java.lang.reflect.Type;
import javax.inject.Named;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.IInjector;
import org.eclipse.e4.core.di.suppliers.IObjectDescriptor;
import org.eclipse.e4.core.di.suppliers.IRequestor;
import org.eclipse.e4.core.di.suppliers.PrimaryObjectSupplier;
import org.eclipse.e4.core.internal.contexts.IContextRecorder;
import org.eclipse.e4.core.internal.contexts.RunAndTrackExt;

public class ContextObjectSupplier
extends PrimaryObjectSupplier {
    protected static final String ECLIPSE_CONTEXT_NAME = IEclipseContext.class.getName();
    private final IEclipseContext context;

    public ContextObjectSupplier(IEclipseContext context, IInjector injector) {
        this.context = context;
    }

    public IEclipseContext getContext() {
        return this.context;
    }

    public void get(IObjectDescriptor[] descriptors, Object[] actualArgs, IRequestor requestor, boolean track, boolean group) {
        String[] keys = new String[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            keys[i] = actualArgs[i] == IInjector.NOT_A_VALUE ? this.getKey(descriptors[i]) : null;
            ++i;
        }
        if (requestor != null && track) {
            ContextInjectionListener trackable = new ContextInjectionListener(this.context, actualArgs, keys, requestor, group);
            this.context.runAndTrack(trackable);
        } else {
            i = 0;
            while (i < descriptors.length) {
                if (keys[i] != null) {
                    if (ECLIPSE_CONTEXT_NAME.equals(keys[i])) {
                        actualArgs[i] = this.context;
                    } else if (this.context.containsKey(keys[i])) {
                        actualArgs[i] = this.context.get(keys[i]);
                    }
                }
                ++i;
            }
        }
    }

    private String getKey(IObjectDescriptor descriptor) {
        if (descriptor.hasQualifier(Named.class)) {
            Named namedAnnotation = (Named)descriptor.getQualifier(Named.class);
            return namedAnnotation.value();
        }
        Type elementType = descriptor.getDesiredType();
        if (elementType instanceof Class) {
            return ((Class)elementType).getName();
        }
        return null;
    }

    public static ContextObjectSupplier getObjectSupplier(IEclipseContext context, IInjector injector) {
        if (context == null) {
            return null;
        }
        ContextObjectSupplier supplier = context.getLocal(ContextObjectSupplier.class);
        if (supplier != null) {
            return supplier;
        }
        ContextObjectSupplier objectSupplier = new ContextObjectSupplier(context, injector);
        context.set(ContextObjectSupplier.class, objectSupplier);
        return objectSupplier;
    }

    public static class ContextInjectionListener
    extends RunAndTrackExt {
        private final Object[] result;
        private final String[] keys;
        private final IRequestor requestor;
        private final IEclipseContext context;

        public ContextInjectionListener(IEclipseContext context, Object[] result, String[] keys, IRequestor requestor, boolean group) {
            super(group);
            this.result = result;
            this.keys = keys;
            this.requestor = requestor;
            this.context = context;
        }

        public boolean update(IEclipseContext eventsContext, int eventType, Object[] extraArguments, IContextRecorder recorder) {
            if (eventType == 0) {
                int i = 0;
                while (i < this.keys.length) {
                    if (this.keys[i] != null) {
                        if (ECLIPSE_CONTEXT_NAME.equals(this.keys[i])) {
                            this.result[i] = this.context;
                            this.context.getParent();
                        } else if (this.context.containsKey(this.keys[i])) {
                            this.result[i] = this.context.get(this.keys[i]);
                        }
                    }
                    ++i;
                }
                return true;
            }
            if (eventType == 3) {
                if (eventsContext == this.context) {
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    this.requestor.disposed((PrimaryObjectSupplier)originatingSupplier);
                    return false;
                }
            } else if (eventType == 4) {
                if (eventsContext == this.context) {
                    ContextObjectSupplier originatingSupplier = eventsContext.getLocal(ContextObjectSupplier.class);
                    return this.requestor.uninject(extraArguments[0], (PrimaryObjectSupplier)originatingSupplier);
                }
            } else {
                if (!this.requestor.isValid()) {
                    return false;
                }
                this.requestor.resolveArguments();
                if (recorder != null) {
                    recorder.stopAccessRecording();
                }
                try {
                    this.requestor.execute();
                }
                finally {
                    if (recorder != null) {
                        recorder.startAccessRecording();
                    }
                }
            }
            return true;
        }

        public boolean changed(IEclipseContext eventsContext) {
            return true;
        }

        public int hashCode() {
            int hashRresult = 1;
            hashRresult = 31 * hashRresult + (this.context == null ? 0 : this.context.hashCode());
            hashRresult = 31 * hashRresult + (this.requestor == null ? 0 : this.requestor.hashCode());
            return hashRresult;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ContextInjectionListener other = (ContextInjectionListener)obj;
            if (this.context == null ? other.context != null : !this.context.equals(other.context)) {
                return false;
            }
            return !(this.requestor == null ? other.requestor != null : !this.requestor.equals(other.requestor));
        }
    }
}

