/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.quickaccess;

import javax.annotation.PostConstruct;
import org.eclipse.e4.ui.model.application.ui.basic.MWindow;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.internal.quickaccess.ActionProvider;
import org.eclipse.ui.internal.quickaccess.CommandProvider;
import org.eclipse.ui.internal.quickaccess.EditorProvider;
import org.eclipse.ui.internal.quickaccess.PerspectiveProvider;
import org.eclipse.ui.internal.quickaccess.PreferenceProvider;
import org.eclipse.ui.internal.quickaccess.PropertiesProvider;
import org.eclipse.ui.internal.quickaccess.QuickAccessContents;
import org.eclipse.ui.internal.quickaccess.QuickAccessElement;
import org.eclipse.ui.internal.quickaccess.QuickAccessMessages;
import org.eclipse.ui.internal.quickaccess.QuickAccessProvider;
import org.eclipse.ui.internal.quickaccess.ViewProvider;
import org.eclipse.ui.internal.quickaccess.WizardProvider;

public class SearchField {
    Shell shell;
    private QuickAccessContents quickAccessContents;
    private MWindow window;

    @PostConstruct
    void createWidget(Composite parent, MWindow window) {
        this.window = window;
        final Composite comp = new Composite(parent, 0);
        comp.setLayout((Layout)new GridLayout());
        final Text text = new Text(comp, 640);
        GridDataFactory.fillDefaults().hint(130, -1).applyTo((Control)text);
        text.setMessage(QuickAccessMessages.QuickAccess_EnterSearch);
        final CommandProvider commandProvider = new CommandProvider();
        QuickAccessProvider[] providers = new QuickAccessProvider[]{new EditorProvider(), new ViewProvider(), new PerspectiveProvider(), commandProvider, new ActionProvider(), new WizardProvider(), new PreferenceProvider(), new PropertiesProvider()};
        this.quickAccessContents = new QuickAccessContents(providers){

            void updateFeedback(boolean filterTextEmpty, boolean showAllMatches) {
            }

            void doClose() {
            }

            QuickAccessElement getPerfectMatch(String filter) {
                return null;
            }

            void handleElementSelected(String string, Object selectedElement) {
                if (selectedElement instanceof QuickAccessElement) {
                    QuickAccessElement element = (QuickAccessElement)selectedElement;
                    text.setText("");
                    element.execute();
                }
            }
        };
        this.quickAccessContents.hookFilterText(text);
        this.shell = new Shell(parent.getShell(), 16400);
        this.shell.setBackground(this.shell.getDisplay().getSystemColor(1));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                text.setText("");
                e.doit = false;
            }
        });
        GridLayoutFactory.fillDefaults().applyTo((Composite)this.shell);
        final Table table = this.quickAccessContents.createTable((Composite)this.shell, Window.getDefaultOrientation());
        text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchField.this.checkFocusLost(table, text);
            }

            public void focusGained(FocusEvent e) {
                IHandlerService hs = (IHandlerService)SearchField.this.window.getContext().get(IHandlerService.class);
                if (commandProvider.getContextSnapshot() == null) {
                    commandProvider.setSnapshot(hs.createContextSnapshot(true));
                }
            }
        });
        this.shell.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                SearchField.this.checkFocusLost(table, text);
            }

            public void focusGained(FocusEvent e) {
            }
        });
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean nowVisible;
                boolean wasVisible = SearchField.this.shell.getVisible();
                boolean bl = nowVisible = text.getText().length() > 0;
                if (!wasVisible && nowVisible) {
                    Rectangle tempBounds = comp.getBounds();
                    Rectangle compBounds = e.display.map((Control)comp, null, tempBounds);
                    Rectangle monitorBounds = comp.getMonitor().getBounds();
                    int width = Math.max(350, compBounds.width);
                    int height = 250;
                    if (compBounds.x + width > monitorBounds.width) {
                        compBounds.x = monitorBounds.width - width;
                    }
                    if (compBounds.y + height > monitorBounds.height) {
                        compBounds.y = compBounds.y - tempBounds.height - height;
                    }
                    SearchField.this.shell.setBounds(compBounds.x, compBounds.y + compBounds.height, width, height);
                    SearchField.this.shell.layout();
                }
                SearchField.this.shell.setVisible(nowVisible);
            }
        });
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.keyCode == 27) {
                    text.setText("");
                }
            }
        });
    }

    protected void checkFocusLost(final Table table, final Text text) {
        table.getDisplay().asyncExec(new Runnable(){

            public void run() {
                if (!(table.isDisposed() || text.isDisposed() || table.isFocusControl() || text.isFocusControl())) {
                    text.setText("");
                    SearchField.this.quickAccessContents.resetProviders();
                }
            }
        });
    }
}

