/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.importing;

import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.importing.IBundleImporter;
import org.eclipse.pde.internal.core.importing.provisional.BundleImportDescription;
import org.eclipse.pde.internal.core.importing.provisional.IBundleImporterDelegate;

public class BundleImporterExtension
implements IBundleImporter {
    private IBundleImporterDelegate delegate;
    private IConfigurationElement element;

    public BundleImporterExtension(IConfigurationElement element) {
        this.element = element;
    }

    public BundleImportDescription[] validateImport(Map[] manifests) {
        try {
            return this.getDelegate().validateImport(manifests);
        }
        catch (CoreException e) {
            PDECore.log(e);
            return null;
        }
    }

    private synchronized IBundleImporterDelegate getDelegate() throws CoreException {
        if (this.delegate == null) {
            this.delegate = (IBundleImporterDelegate)this.element.createExecutableExtension("class");
        }
        return this.delegate;
    }

    public IProject[] performImport(BundleImportDescription[] descriptions, IProgressMonitor monitor) throws CoreException {
        return this.getDelegate().performImport(descriptions, monitor);
    }

    public String getId() {
        return this.element.getAttribute("id");
    }

    public String getDescription() {
        return this.element.getAttribute("description");
    }

    public String getName() {
        return this.element.getAttribute("name");
    }
}

