/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.synchronize;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.team.core.synchronize.ISyncInfoSetChangeListener;
import org.eclipse.team.core.synchronize.ISyncInfoTreeChangeEvent;
import org.eclipse.team.core.synchronize.SyncInfo;
import org.eclipse.team.core.synchronize.SyncInfoSet;
import org.eclipse.team.internal.ui.synchronize.AbstractSynchronizeModelProvider;
import org.eclipse.team.internal.ui.synchronize.SyncInfoModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizeModelElement;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;

public abstract class SynchronizeModelProvider
extends AbstractSynchronizeModelProvider
implements ISyncInfoSetChangeListener {
    protected final Map resourceMap = Collections.synchronizedMap(new HashMap());
    protected static final boolean DEBUG = false;

    public SynchronizeModelProvider(ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(configuration, set);
    }

    public SynchronizeModelProvider(AbstractSynchronizeModelProvider parentProvider, ISynchronizeModelElement modelRoot, ISynchronizePageConfiguration configuration, SyncInfoSet set) {
        super(parentProvider, modelRoot, configuration, set);
        this.associateRoot(modelRoot);
    }

    private void associateRoot(ISynchronizeModelElement modelRoot) {
        this.resourceMap.put(ResourcesPlugin.getWorkspace().getRoot(), modelRoot);
    }

    public void dispose() {
        this.resourceMap.clear();
        super.dispose();
    }

    public abstract ViewerSorter getViewerSorter();

    protected ISynchronizeModelElement getModelObject(IResource resource) {
        return (ISynchronizeModelElement)this.resourceMap.get(resource);
    }

    protected ISynchronizeModelElement[] getModelObjects(IResource resource) {
        ISynchronizeModelElement element = this.getModelObject(resource);
        if (element == null) {
            return new ISynchronizeModelElement[0];
        }
        return new ISynchronizeModelElement[]{element};
    }

    protected void associateDiffNode(ISynchronizeModelElement node) {
        IResource resource = node.getResource();
        if (resource != null) {
            this.resourceMap.put(resource, node);
        }
    }

    protected void unassociateDiffNode(IResource resource) {
        this.resourceMap.remove(resource);
    }

    protected void removeFromViewer(IResource resource) {
        ISynchronizeModelElement element = this.getModelObject(resource);
        if (element != null) {
            this.removeFromViewer(new ISynchronizeModelElement[]{element});
        }
    }

    protected void removeFromViewer(IResource[] resources) {
        ArrayList<ISynchronizeModelElement> elements = new ArrayList<ISynchronizeModelElement>();
        int i = 0;
        while (i < resources.length) {
            IResource resource = resources[i];
            ISynchronizeModelElement element = this.getModelObject(resource);
            if (element != null) {
                elements.add(element);
            }
            ++i;
        }
        if (!elements.isEmpty()) {
            this.removeFromViewer(elements.toArray(new ISynchronizeModelElement[elements.size()]));
        }
    }

    protected void recursiveClearModelObjects(ISynchronizeModelElement node) {
        super.recursiveClearModelObjects(node);
        if (node == this.getModelRoot()) {
            this.resourceMap.clear();
            this.associateRoot(this.getModelRoot());
        } else {
            IResource resource = node.getResource();
            if (resource != null) {
                this.unassociateDiffNode(resource);
            }
        }
    }

    protected void addToViewer(ISynchronizeModelElement node) {
        this.associateDiffNode(node);
        super.addToViewer(node);
    }

    protected boolean hasViewerState() {
        return !this.resourceMap.isEmpty();
    }

    public ISynchronizeModelElement[] getClosestExistingParents(IResource resource) {
        ISynchronizeModelElement element = this.getModelObject(resource);
        if (element == null) {
            while ((element = this.getModelObject(resource = resource.getParent())) == null && resource != null) {
            }
        }
        if (element == null) {
            return new ISynchronizeModelElement[0];
        }
        return new ISynchronizeModelElement[]{element};
    }

    protected final void handleChanges(ISyncInfoTreeChangeEvent event, IProgressMonitor monitor) {
        super.handleChanges(event, monitor);
    }

    protected void handleResourceChanges(ISyncInfoTreeChangeEvent event) {
        SyncInfo[] infos = event.getChangedResources();
        int i = 0;
        while (i < infos.length) {
            SyncInfo info = infos[i];
            IResource local = info.getLocal();
            ISynchronizeModelElement diffNode = this.getModelObject(local);
            if (diffNode != null) {
                this.handleChange(diffNode, info);
            }
            ++i;
        }
    }

    protected void handleChange(ISynchronizeModelElement diffNode, SyncInfo info) {
        IResource local = info.getLocal();
        if (diffNode instanceof SyncInfoModelElement) {
            ((SyncInfoModelElement)diffNode).update(info);
            this.propogateConflictState(diffNode, false);
            this.queueForLabelUpdate(diffNode);
        } else {
            this.removeFromViewer(local);
            this.addResource(info);
            ISynchronizeModelElement node = this.getModelObject(info.getLocal());
            this.buildModelObjects(node);
        }
    }

    protected void addResources(SyncInfo[] added) {
        int i = 0;
        while (i < added.length) {
            SyncInfo info = added[i];
            this.addResource(info);
            ++i;
        }
    }

    protected abstract void addResource(SyncInfo var1);

    protected abstract ISynchronizeModelElement createModelObject(ISynchronizeModelElement var1, SyncInfo var2);
}

