/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.motif.OS;
import org.eclipse.swt.internal.motif.XColor;
import org.eclipse.swt.internal.motif.XConfigureEvent;
import org.eclipse.swt.internal.motif.XExposeEvent;
import org.eclipse.swt.internal.motif.XIconSize;
import org.eclipse.swt.internal.motif.XKeyEvent;
import org.eclipse.swt.internal.motif.XModifierKeymap;
import org.eclipse.swt.internal.motif.XineramaScreenInfo;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.EventTable;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Synchronizer;
import org.eclipse.swt.widgets.TaskBar;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.Widget;

public class Display
extends Device {
    public int xEvent;
    int lastSerial;
    Callback windowCallback;
    int windowProc;
    int shellHandle;
    static String APP_NAME = "SWT";
    static String APP_VERSION = "";
    static final String SHELL_HANDLE_KEY = "org.eclipse.swt.internal.motif.shellHandle";
    byte[] displayName;
    byte[] appName;
    byte[] appClass;
    Event[] eventQueue;
    XKeyEvent keyEvent = new XKeyEvent();
    EventTable eventTable;
    EventTable filterTable;
    int freeSlot = 0;
    int[] indexTable;
    int[] userData;
    Shell[] shellTable;
    Widget[] widgetTable;
    static final int GROW_SIZE = 1024;
    int focusEvent;
    boolean postFocusOut;
    Combo focusedCombo;
    Font defaultFont;
    Font listFont;
    Font textFont;
    Font buttonFont;
    Font labelFont;
    int buttonBackground;
    int buttonForeground;
    int buttonShadowThickness;
    int compositeBackground;
    int compositeForeground;
    int compositeTopShadow;
    int compositeBottomShadow;
    int compositeBorder;
    int listBackground;
    int listForeground;
    int listSelect;
    int textBackground;
    int textForeground;
    int labelBackground;
    int labelForeground;
    int scrolledInsetX;
    int scrolledInsetY;
    int scrolledMarginX;
    int scrolledMarginY;
    int defaultBackground;
    int defaultForeground;
    int textHighlightThickness;
    int blinkRate;
    XColor COLOR_WIDGET_DARK_SHADOW;
    XColor COLOR_WIDGET_NORMAL_SHADOW;
    XColor COLOR_WIDGET_LIGHT_SHADOW;
    XColor COLOR_WIDGET_HIGHLIGHT_SHADOW;
    XColor COLOR_WIDGET_FOREGROUND;
    XColor COLOR_WIDGET_BACKGROUND;
    XColor COLOR_WIDGET_BORDER;
    XColor COLOR_LIST_FOREGROUND;
    XColor COLOR_LIST_BACKGROUND;
    XColor COLOR_LIST_SELECTION;
    XColor COLOR_LIST_SELECTION_TEXT;
    Color COLOR_INFO_BACKGROUND;
    Menu[] popups;
    int errorPixmap;
    int infoPixmap;
    int questionPixmap;
    int warningPixmap;
    int workingPixmap;
    int errorMask;
    int infoMask;
    int questionMask;
    int warningMask;
    int workingMask;
    Cursor[] cursors = new Cursor[22];
    int leftBorderWidth = 2;
    int rightBorderWidth = 2;
    int topBorderHeight = 2;
    int bottomBorderHeight = 2;
    int leftResizeWidth = 3;
    int rightResizeWidth = 3;
    int topResizeHeight = 3;
    int bottomResizeHeight = 3;
    int leftTitleBorderWidth = 3;
    int rightTitleBorderWidth = 2;
    int topTitleBorderHeight = 26;
    int bottomTitleBorderHeight = 2;
    int leftTitleResizeWidth = 3;
    int rightTitleResizeWidth = 3;
    int topTitleResizeHeight = 26;
    int bottomTitleResizeHeight = 3;
    int leftTitleWidth = 0;
    int rightTitleWidth = 0;
    int topTitleHeight = 23;
    int bottomTitleHeight = 0;
    boolean ignoreTrim;
    Synchronizer synchronizer = new Synchronizer(this);
    Thread thread;
    Runnable[] disposeList;
    Composite[] layoutDeferred;
    int layoutDeferredCount;
    Tray tray;
    int[] timerIds;
    Runnable[] timerList;
    Callback timerCallback;
    int timerProc;
    Callback windowTimerCallback;
    int windowTimerProc;
    int resizeLocationX;
    int resizeLocationY;
    int resizeBoundsX;
    int resizeBoundsY;
    int resizeBoundsWidth;
    int resizeBoundsHeight;
    int resizeMode;
    static int[][] KeyTable = new int[][]{{65513, 65536}, {65514, 65536}, {65511, 65536}, {65512, 65536}, {65505, 131072}, {65506, 131072}, {65507, 262144}, {65508, 262144}, {65362, 0x1000001}, {65431, 0x1000001}, {65364, 0x1000002}, {65433, 0x1000002}, {65361, 0x1000003}, {65430, 0x1000003}, {65363, 0x1000004}, {65432, 0x1000004}, {65365, 0x1000005}, {65434, 0x1000005}, {65366, 0x1000006}, {65435, 0x1000006}, {65360, 0x1000007}, {65429, 0x1000007}, {65367, 0x1000008}, {65436, 0x1000008}, {65379, 0x1000009}, {65438, 0x1000009}, {65288, 8}, {65293, 13}, {65535, 127}, {65439, 127}, {65307, 27}, {65290, 10}, {65289, 9}, {65056, 9}, {65470, 0x100000A}, {65471, 0x100000B}, {65472, 0x100000C}, {65473, 0x100000D}, {65474, 0x100000E}, {65475, 0x100000F}, {65476, 0x1000010}, {65477, 0x1000011}, {65478, 0x1000012}, {65479, 0x1000013}, {65480, 0x1000014}, {65481, 0x1000015}, {65482, 0x1000016}, {65483, 0x1000017}, {65484, 0x1000018}, {65485, 0x1000019}, {65486, 0x100001A}, {65487, 0x100001B}, {65488, 0x100001C}, {65489, 0x100001D}, {65450, 16777258}, {65451, 16777259}, {65421, 0x1000050}, {65453, 16777261}, {65454, 16777262}, {65455, 16777263}, {65456, 0x1000030}, {65457, 0x1000031}, {65458, 16777266}, {65459, 0x1000033}, {65460, 16777268}, {65461, 16777269}, {65462, 16777270}, {65463, 16777271}, {65464, 16777272}, {65465, 16777273}, {65469, 16777277}, {65509, 16777298}, {65407, 16777299}, {65300, 16777300}, {65299, 0x1000055}, {65387, 16777302}, {65377, 16777303}, {65386, 0x1000051}};
    static String numLock;
    static Display Default;
    static Display[] Displays;
    int lastTime;
    int lastButton;
    int clickCount = 1;
    Caret currentCaret;
    Callback caretCallback;
    int caretID;
    int caretProc;
    static boolean DisplayDisposed;
    Widget[] skinList = new Widget[1024];
    int skinCount;
    static final String PACKAGE_PREFIX = "org.eclipse.swt.widgets.";
    Callback mouseHoverCallback;
    int mouseHoverID;
    int mouseHoverProc;
    int mouseHoverHandle;
    int toolTipHandle;
    int dragTranslations;
    int arrowTranslations;
    int tabTranslations;
    Callback checkExposeCallback;
    int checkExposeProc;
    int exposeCount;
    int lastExpose;
    XExposeEvent xExposeEvent = new XExposeEvent();
    Callback checkResizeCallback;
    int checkResizeProc;
    int resizeWidth;
    int resizeHeight;
    int resizeCount;
    int resizeWindow;
    XConfigureEvent xConfigureEvent = new XConfigureEvent();
    Callback focusCallback;
    int focusProc;
    Callback wakeCallback;
    int wakeProc;
    int read_fd;
    int write_fd;
    int inputID;
    byte[] wake_buffer = new byte[1];
    int[] timeout = new int[2];
    byte[] fd_set;
    Object data;
    String[] keys;
    Object[] values;
    static /* synthetic */ Class class$0;

    static {
        Displays = new Display[4];
        DeviceFinder = new Runnable(){

            public void run() {
                Display device = Display.getCurrent();
                if (device == null) {
                    device = Display.getDefault();
                }
                Display.setDevice(device);
            }
        };
    }

    static void setDevice(Device device) {
        CurrentDevice = device;
    }

    public Display() {
        this(null);
    }

    public Display(DeviceData data) {
        super(Display.checkNull(data));
    }

    static DeviceData checkNull(DeviceData data) {
        if (data == null) {
            data = new DeviceData();
        }
        if (data.application_name == null) {
            data.application_name = APP_NAME;
        }
        if (data.application_class == null) {
            data.application_class = APP_NAME;
        }
        return data;
    }

    protected void checkDevice() {
        if (this.thread == null) {
            this.error(24);
        }
        if (this.thread != Thread.currentThread()) {
            this.error(22);
        }
        if (this.isDisposed()) {
            this.error(45);
        }
    }

    void addMouseHoverTimeOut(int handle) {
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        this.mouseHoverID = OS.XtAppAddTimeOut(xtContext, 400, this.mouseHoverProc, handle);
        this.mouseHoverHandle = handle;
    }

    void addWidget(int handle, Widget widget) {
        if (handle == 0) {
            return;
        }
        if (OS.XtIsSubclass(handle, OS.shellWidgetClass())) {
            int i = 0;
            while (i < this.shellTable.length) {
                if (this.shellTable[i] == null) {
                    this.shellTable[i] = (Shell)widget;
                    return;
                }
                ++i;
            }
            Shell[] newShells = new Shell[this.shellTable.length + 128];
            System.arraycopy(this.shellTable, 0, newShells, 0, this.shellTable.length);
            newShells[this.shellTable.length] = (Shell)widget;
            this.shellTable = newShells;
            return;
        }
        if (this.freeSlot == -1) {
            this.freeSlot = this.indexTable.length;
            int length = this.freeSlot + 1024;
            int[] newIndexTable = new int[length];
            Widget[] newWidgetTable = new Widget[length];
            System.arraycopy(this.indexTable, 0, newIndexTable, 0, this.freeSlot);
            System.arraycopy(this.widgetTable, 0, newWidgetTable, 0, this.freeSlot);
            int i = this.freeSlot;
            while (i < length - 1) {
                newIndexTable[i] = i + 1;
                ++i;
            }
            newIndexTable[length - 1] = -1;
            this.indexTable = newIndexTable;
            this.widgetTable = newWidgetTable;
        }
        this.userData[1] = this.freeSlot + 1;
        OS.XtSetValues(handle, this.userData, this.userData.length / 2);
        int oldSlot = this.freeSlot;
        this.freeSlot = this.indexTable[oldSlot];
        this.indexTable[oldSlot] = -2;
        this.widgetTable[oldSlot] = widget;
    }

    public void addFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            this.filterTable = new EventTable();
        }
        this.filterTable.hook(eventType, listener);
    }

    void addLayoutDeferred(Composite comp) {
        if (this.layoutDeferred == null) {
            this.layoutDeferred = new Composite[64];
        }
        if (this.layoutDeferredCount == this.layoutDeferred.length) {
            Composite[] temp = new Composite[this.layoutDeferred.length + 64];
            System.arraycopy(this.layoutDeferred, 0, temp, 0, this.layoutDeferred.length);
            this.layoutDeferred = temp;
        }
        this.layoutDeferred[this.layoutDeferredCount++] = comp;
    }

    public void addListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            this.eventTable = new EventTable();
        }
        this.eventTable.hook(eventType, listener);
    }

    void addPopup(Menu menu) {
        if (this.popups == null) {
            this.popups = new Menu[4];
        }
        int length = this.popups.length;
        int i = 0;
        while (i < length) {
            if (this.popups[i] == menu) {
                return;
            }
            ++i;
        }
        int index = 0;
        while (index < length) {
            if (this.popups[index] == null) break;
            ++index;
        }
        if (index == length) {
            Menu[] newPopups = new Menu[length + 4];
            System.arraycopy(this.popups, 0, newPopups, 0, length);
            this.popups = newPopups;
        }
        this.popups[index] = menu;
    }

    void addSkinnableWidget(Widget widget) {
        if (this.skinCount >= this.skinList.length) {
            Widget[] newSkinWidgets = new Widget[this.skinList.length + 1024];
            System.arraycopy(this.skinList, 0, newSkinWidgets, 0, this.skinList.length);
            this.skinList = newSkinWidgets;
        }
        this.skinList[this.skinCount++] = widget;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void asyncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            this.synchronizer.asyncExec(runnable);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public void beep() {
        this.checkDevice();
        OS.XBell(this.xDisplay, 100);
        OS.XFlush(this.xDisplay);
    }

    int caretProc(int clientData, int id) {
        this.caretID = 0;
        if (this.currentCaret == null) {
            return 0;
        }
        if (this.currentCaret.blinkCaret()) {
            int blinkRate = this.currentCaret.blinkRate;
            if (blinkRate == 0) {
                return 0;
            }
            int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.caretID = OS.XtAppAddTimeOut(xtContext, blinkRate, this.caretProc, 0);
        } else {
            this.currentCaret = null;
        }
        return 0;
    }

    int checkExposeProc(int display, int event, int window) {
        OS.memmove(this.xExposeEvent, event, 40);
        if (this.xExposeEvent.window != window) {
            return 0;
        }
        switch (this.xExposeEvent.type) {
            case 12: 
            case 13: {
                ++this.exposeCount;
                this.lastExpose = event;
                this.xExposeEvent.count = 1;
                OS.memmove(event, this.xExposeEvent, 40);
            }
        }
        return 0;
    }

    int checkResizeProc(int display, int event, int arg) {
        OS.memmove(this.xConfigureEvent, event, 52);
        if (this.xConfigureEvent.window != this.resizeWindow) {
            return 0;
        }
        switch (this.xConfigureEvent.type) {
            case 22: {
                int width = this.xConfigureEvent.width;
                int height = this.xConfigureEvent.height;
                if (width == this.resizeWidth && height == this.resizeHeight) break;
                ++this.resizeCount;
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void checkDisplay(Thread thread, boolean multiple) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] != null) {
                    if (!multiple) {
                        SWT.error(20, null, " [multiple displays]");
                    }
                    if (Display.Displays[i].thread == thread) {
                        SWT.error(22);
                    }
                }
                ++i;
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    protected void checkSubclass() {
        if (!Display.isValidClass(this.getClass())) {
            this.error(43);
        }
    }

    public void close() {
        this.checkDevice();
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit) {
            this.dispose();
        }
    }

    String convertToLf(String text) {
        char Cr = '\r';
        char Lf = '\n';
        int length = text.length();
        if (length == 0) {
            return text;
        }
        int i = text.indexOf(Lf, 0);
        if (i == -1 || i == 0) {
            return text;
        }
        if (text.charAt(i - 1) != Cr) {
            return text;
        }
        i = 0;
        StringBuffer result = new StringBuffer();
        while (i < length) {
            int j = text.indexOf(Cr, i);
            if (j == -1) {
                j = length;
            }
            String s = text.substring(i, j);
            result.append(s);
            i = j + 2;
            result.append(Lf);
        }
        return result.toString();
    }

    protected void create(DeviceData data) {
        this.checkSubclass();
        this.thread = Thread.currentThread();
        Display.checkDisplay(this.thread, true);
        this.createDisplay(data);
        Display.register(this);
        if (Default == null) {
            Default = this;
        }
    }

    void createDisplay(DeviceData data) {
        this.xEvent = OS.XtMalloc(96);
        int dpy = 0;
        if (Default == null) {
            int xtContext = OS.__XtDefaultAppContext();
            int[] dpy_return = new int[1];
            int[] num_dpy_return = new int[1];
            OS.XtGetDisplays(xtContext, dpy_return, num_dpy_return);
            if (num_dpy_return[0] > 0) {
                OS.memmove(dpy_return, dpy_return[0], 4);
                dpy = dpy_return[0];
            }
        }
        if (dpy != 0) {
            this.xDisplay = dpy;
        } else {
            int[] argc = new int[1];
            int xtContext = OS.XtCreateApplicationContext();
            OS.XtSetLanguageProc(xtContext, 0, 0);
            int ptr1 = 0;
            int ptr2 = 0;
            if (OS.IsLinux && OS.IsDBLocale) {
                String resource = "*fontList: -*-*-medium-r-*-*-*-120-*-*-*-*-*-*:";
                byte[] buffer = Converter.wcsToMbcs(null, resource, true);
                ptr1 = OS.XtMalloc(buffer.length);
                if (ptr1 != 0) {
                    OS.memmove(ptr1, buffer, buffer.length);
                }
                int[] nArray = new int[2];
                nArray[0] = ptr1;
                int[] spec = nArray;
                ptr2 = OS.XtMalloc(spec.length * 4);
                if (ptr2 != 0) {
                    OS.memmove(ptr2, spec, spec.length * 4);
                }
                OS.XtAppSetFallbackResources(xtContext, ptr2);
            }
            String display_name = null;
            String application_name = APP_NAME;
            String application_class = APP_NAME;
            if (data != null) {
                if (data.display_name != null) {
                    display_name = data.display_name;
                }
                if (data.application_name != null) {
                    application_name = data.application_name;
                }
                if (data.application_class != null) {
                    application_class = data.application_class;
                }
            }
            if (display_name != null) {
                this.displayName = Converter.wcsToMbcs(null, display_name, true);
            }
            if (application_name != null) {
                this.appName = Converter.wcsToMbcs(null, application_name, true);
            }
            if (application_class != null) {
                this.appClass = Converter.wcsToMbcs(null, application_class, true);
            }
            this.xDisplay = OS.XtOpenDisplay(xtContext, this.displayName, this.appName, this.appClass, 0, 0, argc, 0);
            DisplayDisposed = false;
            if (ptr2 != 0) {
                OS.XtAppSetFallbackResources(xtContext, 0);
                OS.XtFree(ptr2);
            }
            if (ptr1 != 0) {
                OS.XtFree(ptr1);
            }
        }
    }

    int createMask(int pixmap) {
        if (pixmap == 0) {
            return 0;
        }
        int[] unused = new int[1];
        int[] width = new int[1];
        int[] height = new int[1];
        OS.XGetGeometry(this.xDisplay, pixmap, unused, unused, unused, width, height, unused, unused);
        int mask = OS.XCreatePixmap(this.xDisplay, pixmap, width[0], height[0], 1);
        int gc = OS.XCreateGC(this.xDisplay, mask, 0, null);
        if (OS.IsSunOS) {
            OS.XSetBackground(this.xDisplay, gc, 0);
            OS.XSetForeground(this.xDisplay, gc, 1);
        }
        OS.XCopyPlane(this.xDisplay, pixmap, mask, gc, 0, 0, width[0], height[0], 0, 0, 1);
        OS.XFreeGC(this.xDisplay, gc);
        return mask;
    }

    int createPixmap(String name) {
        int screen = OS.XDefaultScreenOfDisplay(this.xDisplay);
        int fgPixel = OS.XBlackPixel(this.xDisplay, OS.XDefaultScreen(this.xDisplay));
        int bgPixel = OS.XWhitePixel(this.xDisplay, OS.XDefaultScreen(this.xDisplay));
        byte[] buffer = Converter.wcsToMbcs(null, name, true);
        int pixmap = OS.XmGetPixmap(screen, buffer, fgPixel, bgPixel);
        if (pixmap == 2 && (pixmap = OS.XmGetPixmap(screen, buffer = Converter.wcsToMbcs(null, "default_" + name, true), fgPixel, bgPixel)) == 2) {
            if (OS.IsSunOS) {
                buffer = Converter.wcsToMbcs(null, "/usr/dt/share/include/bitmaps/" + name, true);
                pixmap = OS.XmGetPixmap(screen, buffer, fgPixel, bgPixel);
                if (pixmap == 2) {
                    pixmap = 0;
                }
            } else {
                pixmap = 0;
            }
        }
        return pixmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void deregister(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (display == Displays[i]) {
                    Display.Displays[i] = null;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void destroy() {
        if (this == Default) {
            Default = null;
        }
        Display.deregister(this);
        this.destroyDisplay();
    }

    void destroyDisplay() {
        if (!OS.IsSunOS) {
            OS.XtDestroyWidget(OS.XmGetXmDisplay(this.xDisplay));
        }
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        OS.XtDestroyApplicationContext(xtContext);
        DisplayDisposed = true;
    }

    public void disposeExec(Runnable runnable) {
        this.checkDevice();
        if (this.disposeList == null) {
            this.disposeList = new Runnable[4];
        }
        int i = 0;
        while (i < this.disposeList.length) {
            if (this.disposeList[i] == null) {
                this.disposeList[i] = runnable;
                return;
            }
            ++i;
        }
        Runnable[] newDisposeList = new Runnable[this.disposeList.length + 4];
        System.arraycopy(this.disposeList, 0, newDisposeList, 0, this.disposeList.length);
        newDisposeList[this.disposeList.length] = runnable;
        this.disposeList = newDisposeList;
    }

    void error(int code) {
        SWT.error(code);
    }

    boolean filterEvent(Event event) {
        if (this.filterTable != null) {
            this.filterTable.sendEvent(event);
        }
        return false;
    }

    boolean filters(int eventType) {
        if (this.filterTable == null) {
            return false;
        }
        return this.filterTable.hooks(eventType);
    }

    boolean filterEvent(int event) {
        char[] result;
        OS.memmove(this.keyEvent, event, 60);
        if (this.keyEvent.type != 2) {
            return false;
        }
        if (this.keyEvent.keycode == 0) {
            return false;
        }
        int xWindow = this.keyEvent.window;
        if (xWindow == 0) {
            return false;
        }
        int handle = OS.XtWindowToWidget(this.xDisplay, xWindow);
        if (handle == 0) {
            return false;
        }
        if ((handle = OS.XmGetFocusWidget(handle)) == 0) {
            return false;
        }
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return false;
        }
        char key = '\u0000';
        byte[] buffer = new byte[5];
        int[] keysym = new int[1];
        int oldState = this.keyEvent.state;
        this.keyEvent.state = 0;
        int length = OS.XLookupString(this.keyEvent, buffer, buffer.length, keysym, null);
        this.keyEvent.state = oldState;
        this.fixKey(keysym, buffer, 0);
        if (length != 0 && (result = Converter.mbcsToWcs(null, buffer)).length != 0) {
            key = result[0];
        }
        keysym[0] = keysym[0] & 0xFFFF;
        if ((keysym[0] == 65293 || keysym[0] == 65421) && this.keyEvent.serial != this.lastSerial) {
            if (OS.XFilterEvent(event, OS.XtWindow(handle))) {
                return true;
            }
            this.lastSerial = this.keyEvent.serial;
        }
        if (OS.IsSunOS) {
            switch (keysym[0]) {
                case 65505: 
                case 65506: 
                case 65507: 
                case 65508: 
                case 65511: 
                case 65512: 
                case 65513: 
                case 65514: {
                    break;
                }
                default: {
                    if (!widget.translateAccelerator(key, keysym[0], this.keyEvent, true)) break;
                    return true;
                }
            }
        }
        if (key != '\u0000' && widget.translateMnemonic(key, keysym[0], this.keyEvent)) {
            return true;
        }
        switch (keysym[0]) {
            case 65289: 
            case 65293: 
            case 65307: 
            case 65361: 
            case 65362: 
            case 65363: 
            case 65364: 
            case 65365: 
            case 65366: 
            case 65421: {
                if (!OS.IsSunOS && widget.translateAccelerator(key, keysym[0], this.keyEvent, true)) {
                    return true;
                }
                if (!widget.translateTraversal(keysym[0], this.keyEvent)) break;
                return true;
            }
        }
        return false;
    }

    public Widget findWidget(int handle) {
        this.checkDevice();
        return this.getWidget(handle);
    }

    public Widget findWidget(int handle, int id) {
        this.checkDevice();
        return null;
    }

    public Widget findWidget(Widget widget, int id) {
        this.checkDevice();
        return null;
    }

    boolean fixKey(int[] keysym, byte[] buffer, int state) {
        if (OS.IsSunOS && keysym[0] != 0) {
            switch (keysym[0]) {
                case 268828432: {
                    keysym[0] = 65480;
                    buffer[0] = 0;
                    break;
                }
                case 268828433: {
                    keysym[0] = 65481;
                    buffer[0] = 0;
                    break;
                }
                case 65490: {
                    keysym[0] = 65299;
                    break;
                }
                case 65491: {
                    keysym[0] = 65377;
                    break;
                }
                case 65492: {
                    keysym[0] = 65300;
                    break;
                }
                case 65493: {
                    keysym[0] = 65453;
                    break;
                }
                case 65494: {
                    keysym[0] = 65455;
                    break;
                }
                case 65495: {
                    keysym[0] = 65450;
                    break;
                }
                case 65496: {
                    keysym[0] = 65429;
                    break;
                }
                case 65498: {
                    keysym[0] = 65434;
                    break;
                }
                case 65502: {
                    keysym[0] = 65436;
                    break;
                }
                case 65504: {
                    keysym[0] = 65435;
                }
            }
            keysym[0] = keysym[0] & 0xFFFF;
        }
        if (OS.IsHPUX && keysym[0] != 0) {
            switch (keysym[0]) {
                case 65425: {
                    keysym[0] = 65478;
                    break;
                }
                case 65426: {
                    keysym[0] = 65479;
                    break;
                }
                case 65427: {
                    keysym[0] = 65480;
                    break;
                }
                case 65428: {
                    keysym[0] = 65481;
                    break;
                }
                case 268500852: {
                    keysym[0] = 65056;
                }
            }
        }
        switch (keysym[0]) {
            case 65439: {
                buffer[0] = 127;
                break;
            }
            case 65056: {
                buffer[0] = 9;
                break;
            }
            case 32: {
                buffer[0] = 32;
            }
        }
        boolean isNull = false;
        int key = keysym[0];
        if ((state & 4) != 0) {
            if (key >= 0 && key <= 127) {
                if (97 <= key && key <= 122) {
                    key -= 32;
                }
                if (64 > key || key > 95) {
                    buffer[0] = (byte)key;
                }
                isNull = key == 64 && buffer[0] == 0;
            } else {
                switch (keysym[0]) {
                    case 65456: {
                        buffer[0] = 48;
                        break;
                    }
                    case 65457: {
                        buffer[0] = 49;
                        break;
                    }
                    case 65458: {
                        buffer[0] = 50;
                        break;
                    }
                    case 65459: {
                        buffer[0] = 51;
                        break;
                    }
                    case 65460: {
                        buffer[0] = 52;
                        break;
                    }
                    case 65461: {
                        buffer[0] = 53;
                        break;
                    }
                    case 65462: {
                        buffer[0] = 54;
                        break;
                    }
                    case 65463: {
                        buffer[0] = 55;
                        break;
                    }
                    case 65464: {
                        buffer[0] = 56;
                        break;
                    }
                    case 65465: {
                        buffer[0] = 57;
                    }
                }
            }
        }
        return isNull;
    }

    int focusProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        Widget widget = this.getWidget(client_data);
        if (widget == null) {
            return 0;
        }
        return widget.focusProc(w, client_data, call_data, continue_to_dispatch);
    }

    public Shell getActiveShell() {
        this.checkDevice();
        int[] buffer1 = new int[1];
        int[] buffer2 = new int[1];
        OS.XGetInputFocus(this.xDisplay, buffer1, buffer2);
        int xWindow = buffer1[0];
        if (xWindow == 0) {
            return null;
        }
        int handle = OS.XtWindowToWidget(this.xDisplay, xWindow);
        if (handle == 0) {
            return null;
        }
        do {
            if (!OS.XtIsSubclass(handle, OS.shellWidgetClass())) continue;
            Widget widget = this.getWidget(handle);
            if (widget instanceof Shell) {
                return (Shell)widget;
            }
            return null;
        } while ((handle = OS.XtParent(handle)) != 0);
        return null;
    }

    public static Display getCurrent() {
        return Display.findDisplay(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display findDisplay(Thread thread) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                Display display = Displays[i];
                if (display != null && display.thread == thread) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return display;
                }
                ++i;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return null;
        }
    }

    int getCaretBlinkTime() {
        return this.blinkRate;
    }

    public Control getCursorControl() {
        int xWindow;
        this.checkDevice();
        int[] unused = new int[1];
        int[] buffer = new int[1];
        int xParent = OS.XDefaultRootWindow(this.xDisplay);
        do {
            if (OS.XQueryPointer(this.xDisplay, xParent, unused, buffer, unused, unused, unused, unused, unused) == 0) {
                return null;
            }
            xWindow = buffer[0];
            if (xWindow == 0) continue;
            xParent = xWindow;
        } while (xWindow != 0);
        int handle = OS.XtWindowToWidget(this.xDisplay, xParent);
        if (handle == 0) {
            return null;
        }
        do {
            Control control;
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control) || !(control = (Control)widget).isEnabled()) continue;
            return control;
        } while ((handle = OS.XtParent(handle)) != 0);
        return null;
    }

    public Point getCursorLocation() {
        this.checkDevice();
        int window = OS.XDefaultRootWindow(this.xDisplay);
        int[] rootX = new int[1];
        int[] rootY = new int[1];
        int[] unused = new int[1];
        OS.XQueryPointer(this.xDisplay, window, unused, unused, rootX, rootY, unused, unused, unused);
        return new Point(rootX[0], rootY[0]);
    }

    public Point[] getCursorSizes() {
        Point[] pointArray;
        this.checkDevice();
        int xDrawable = OS.XDefaultRootWindow(this.xDisplay);
        int[] width_return = new int[1];
        int[] height_return = new int[1];
        OS.XQueryBestCursor(this.xDisplay, xDrawable, 16, 16, width_return, height_return);
        Point pt = new Point(width_return[0], height_return[0]);
        OS.XQueryBestCursor(this.xDisplay, xDrawable, 32, 32, width_return, height_return);
        if (pt.x == width_return[0] && pt.y == height_return[0]) {
            Point[] pointArray2 = new Point[1];
            pointArray = pointArray2;
            pointArray2[0] = pt;
        } else {
            Point[] pointArray3 = new Point[2];
            pointArray3[0] = pt;
            pointArray = pointArray3;
            pointArray3[1] = new Point(width_return[0], height_return[0]);
        }
        return pointArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Display getDefault() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (Default == null) {
                Default = new Display();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return Default;
        }
    }

    public Object getData(String key) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (key.equals(SHELL_HANDLE_KEY)) {
            return new Integer(this.shellHandle);
        }
        if (this.keys == null) {
            return null;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                return this.values[i];
            }
            ++i;
        }
        return null;
    }

    public Object getData() {
        this.checkDevice();
        return this.data;
    }

    public int getDismissalAlignment() {
        this.checkDevice();
        return 16384;
    }

    public int getDoubleClickTime() {
        this.checkDevice();
        return OS.XtGetMultiClickTime(this.xDisplay);
    }

    public Control getFocusControl() {
        this.checkDevice();
        int[] buffer1 = new int[1];
        int[] buffer2 = new int[1];
        OS.XGetInputFocus(this.xDisplay, buffer1, buffer2);
        int xWindow = buffer1[0];
        if (xWindow == 0) {
            return null;
        }
        int handle = OS.XtWindowToWidget(this.xDisplay, xWindow);
        if (handle == 0) {
            return null;
        }
        if ((handle = OS.XmGetFocusWidget(handle)) == 0) {
            return null;
        }
        do {
            Widget widget;
            if ((widget = this.getWidget(handle)) == null || !(widget instanceof Control)) continue;
            Control control = (Control)widget;
            return control.isEnabled() ? control : null;
        } while ((handle = OS.XtParent(handle)) != 0);
        return null;
    }

    public boolean getHighContrast() {
        this.checkDevice();
        return false;
    }

    public int getIconDepth() {
        return this.getDepth();
    }

    public Point[] getIconSizes() {
        Point max;
        Point min;
        this.checkDevice();
        int w = OS.XDefaultRootWindow(this.xDisplay);
        int[] size_list_return = new int[1];
        int[] count_return = new int[1];
        int status = OS.XGetIconSizes(this.xDisplay, w, size_list_return, count_return);
        if (status != 0 && count_return[0] > 0) {
            XIconSize iconSize = new XIconSize();
            OS.memmove(iconSize, size_list_return[0], 24);
            min = new Point(iconSize.min_width, iconSize.min_height);
            max = new Point(iconSize.max_width, iconSize.max_height);
            OS.XFree(size_list_return[0]);
        } else {
            min = new Point(16, 16);
            max = new Point(32, 32);
        }
        return new Point[]{min, max};
    }

    int getLastEventTime() {
        return OS.XtLastTimestampProcessed(this.xDisplay);
    }

    int getMessageCount() {
        return this.synchronizer.getMessageCount();
    }

    public Monitor[] getMonitors() {
        boolean result;
        this.checkDevice();
        Monitor[] monitors = null;
        if (OS.IsLinux && (result = OS.XineramaIsActive(this.xDisplay))) {
            int[] number = new int[1];
            int ptr = OS.XineramaQueryScreens(this.xDisplay, number);
            int monitorCount = number[0];
            if (ptr != 0 && monitorCount > 0) {
                monitors = new Monitor[monitorCount];
                XineramaScreenInfo info = new XineramaScreenInfo();
                int address = ptr;
                int i = 0;
                while (i < monitorCount) {
                    Monitor monitor = new Monitor();
                    OS.memmove(info, address, 12);
                    address += 12;
                    monitor.handle = info.screen_number;
                    monitor.x = info.x_org;
                    monitor.y = info.y_org;
                    monitor.width = info.width;
                    monitor.height = info.height;
                    monitor.clientX = monitor.x;
                    monitor.clientY = monitor.y;
                    monitor.clientWidth = monitor.width;
                    monitor.clientHeight = monitor.height;
                    monitors[i] = monitor;
                    ++i;
                }
            }
            if (ptr != 0) {
                OS.XFree(ptr);
            }
        }
        if (monitors == null) {
            Monitor monitor = new Monitor();
            Rectangle bounds = this.getBounds();
            monitor.x = bounds.x;
            monitor.y = bounds.y;
            monitor.width = bounds.width;
            monitor.height = bounds.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
            monitors = new Monitor[]{monitor};
        }
        return monitors;
    }

    public Monitor getPrimaryMonitor() {
        boolean result;
        this.checkDevice();
        Monitor monitor = null;
        if (OS.IsLinux && (result = OS.XineramaIsActive(this.xDisplay))) {
            int[] number = new int[1];
            int ptr = OS.XineramaQueryScreens(this.xDisplay, number);
            int monitorCount = number[0];
            if (ptr != 0 && monitorCount >= 1) {
                monitor = new Monitor();
                XineramaScreenInfo info = new XineramaScreenInfo();
                OS.memmove(info, ptr, 12);
                monitor.handle = info.screen_number;
                monitor.x = info.x_org;
                monitor.y = info.y_org;
                monitor.width = info.width;
                monitor.height = info.height;
                monitor.clientX = monitor.x;
                monitor.clientY = monitor.y;
                monitor.clientWidth = monitor.width;
                monitor.clientHeight = monitor.height;
            }
            if (ptr != 0) {
                OS.XFree(ptr);
            }
        }
        if (monitor == null) {
            monitor = new Monitor();
            Rectangle bounds = this.getBounds();
            monitor.x = bounds.x;
            monitor.y = bounds.y;
            monitor.width = bounds.width;
            monitor.height = bounds.height;
            monitor.clientX = monitor.x;
            monitor.clientY = monitor.y;
            monitor.clientWidth = monitor.width;
            monitor.clientHeight = monitor.height;
        }
        return monitor;
    }

    public Shell[] getShells() {
        this.checkDevice();
        int length = 0;
        int i = 0;
        while (i < this.shellTable.length) {
            if (this.shellTable[i] != null) {
                ++length;
            }
            ++i;
        }
        int index = 0;
        Shell[] result = new Shell[length];
        int i2 = 0;
        while (i2 < this.shellTable.length) {
            Shell widget = this.shellTable[i2];
            if (widget != null) {
                result[index++] = widget;
            }
            ++i2;
        }
        return result;
    }

    public Synchronizer getSynchronizer() {
        this.checkDevice();
        return this.synchronizer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getSyncThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.synchronizer.syncThread;
        }
    }

    public Color getSystemColor(int id) {
        this.checkDevice();
        XColor xColor = null;
        switch (id) {
            case 28: {
                return super.getSystemColor(2);
            }
            case 29: {
                return this.COLOR_INFO_BACKGROUND;
            }
            case 30: {
                return super.getSystemColor(1);
            }
            case 31: {
                return super.getSystemColor(10);
            }
            case 32: {
                return super.getSystemColor(9);
            }
            case 33: {
                return super.getSystemColor(2);
            }
            case 34: {
                return super.getSystemColor(16);
            }
            case 35: {
                return super.getSystemColor(15);
            }
            case 17: {
                xColor = this.COLOR_WIDGET_DARK_SHADOW;
                break;
            }
            case 18: {
                xColor = this.COLOR_WIDGET_NORMAL_SHADOW;
                break;
            }
            case 19: {
                xColor = this.COLOR_WIDGET_LIGHT_SHADOW;
                break;
            }
            case 20: {
                xColor = this.COLOR_WIDGET_HIGHLIGHT_SHADOW;
                break;
            }
            case 22: {
                xColor = this.COLOR_WIDGET_BACKGROUND;
                break;
            }
            case 21: {
                xColor = this.COLOR_WIDGET_FOREGROUND;
                break;
            }
            case 23: {
                xColor = this.COLOR_WIDGET_BORDER;
                break;
            }
            case 24: {
                xColor = this.COLOR_LIST_FOREGROUND;
                break;
            }
            case 25: {
                xColor = this.COLOR_LIST_BACKGROUND;
                break;
            }
            case 26: {
                xColor = this.COLOR_LIST_SELECTION;
                break;
            }
            case 27: {
                xColor = this.COLOR_LIST_SELECTION_TEXT;
                break;
            }
            default: {
                return super.getSystemColor(id);
            }
        }
        if (xColor == null) {
            return super.getSystemColor(2);
        }
        return Color.motif_new(this, xColor);
    }

    public Cursor getSystemCursor(int id) {
        this.checkDevice();
        if (id < 0 || id >= this.cursors.length) {
            return null;
        }
        if (this.cursors[id] == null) {
            this.cursors[id] = new Cursor(this, id);
        }
        return this.cursors[id];
    }

    public Font getSystemFont() {
        this.checkDevice();
        return this.defaultFont;
    }

    public Image getSystemImage(int style) {
        this.checkDevice();
        int imagePixmap = 0;
        int maskPixmap = 0;
        switch (style) {
            case 1: {
                if (this.errorPixmap == 0) {
                    this.errorPixmap = this.createPixmap("xm_error");
                    this.errorMask = this.createMask(this.errorPixmap);
                }
                imagePixmap = this.errorPixmap;
                maskPixmap = this.errorMask;
                break;
            }
            case 2: {
                if (this.infoPixmap == 0) {
                    this.infoPixmap = this.createPixmap("xm_information");
                    this.infoMask = this.createMask(this.infoPixmap);
                }
                imagePixmap = this.infoPixmap;
                maskPixmap = this.infoMask;
                break;
            }
            case 4: {
                if (this.questionPixmap == 0) {
                    this.questionPixmap = this.createPixmap("xm_question");
                    this.questionMask = this.createMask(this.questionPixmap);
                }
                imagePixmap = this.questionPixmap;
                maskPixmap = this.questionMask;
                break;
            }
            case 8: {
                if (this.warningPixmap == 0) {
                    this.warningPixmap = this.createPixmap("xm_warning");
                    this.warningMask = this.createMask(this.warningPixmap);
                }
                imagePixmap = this.warningPixmap;
                maskPixmap = this.warningMask;
                break;
            }
            case 16: {
                if (this.workingPixmap == 0) {
                    this.workingPixmap = this.createPixmap("xm_working");
                    this.workingMask = this.createMask(this.workingPixmap);
                }
                imagePixmap = this.workingPixmap;
                maskPixmap = this.workingMask;
            }
        }
        if (imagePixmap == 0) {
            return null;
        }
        return Image.motif_new(this, 1, imagePixmap, maskPixmap);
    }

    public TaskBar getSystemTaskBar() {
        this.checkDevice();
        return null;
    }

    public Tray getSystemTray() {
        this.checkDevice();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Thread getThread() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.thread;
        }
    }

    Widget getWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        if (OS.XtIsSubclass(handle, OS.shellWidgetClass())) {
            int i = 0;
            while (i < this.shellTable.length) {
                Shell shell = this.shellTable[i];
                if (shell != null && ((Widget)shell).topHandle() == handle) {
                    return shell;
                }
                ++i;
            }
            return null;
        }
        this.userData[1] = 0;
        OS.XtGetValues(handle, this.userData, this.userData.length / 2);
        if (this.userData[1] == 0) {
            return null;
        }
        int index = this.userData[1] - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            return this.widgetTable[index];
        }
        return null;
    }

    void hideToolTip() {
        if (this.toolTipHandle != 0) {
            int shellHandle = OS.XtParent(this.toolTipHandle);
            OS.XtDestroyWidget(shellHandle);
        }
        this.toolTipHandle = 0;
    }

    protected void init() {
        super.init();
        this.initializeDisplay();
        this.initializeButton();
        this.initializeComposite();
        this.initializeDialog();
        this.initializeLabel();
        this.initializeList();
        this.initializeScrollBar();
        this.initializeText();
        this.initializeSystemColors();
        this.initializeDefaults();
        this.initializeTranslations();
        this.initializeWidgetTable();
        this.initializeNumLock();
        this.initializePixmaps();
    }

    void initializeButton() {
        int widgetClass = OS.topLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        byte[] buffer = Converter.wcsToMbcs(null, "string", true);
        int widgetHandle = OS.XmCreatePushButton(shellHandle, buffer, null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] nArray = new int[8];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNshadowThickness;
        nArray[6] = OS.XmNfontList;
        int[] argList = nArray;
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.buttonForeground = argList[1];
        this.buttonBackground = argList[3];
        this.buttonShadowThickness = argList[5];
        this.buttonFont = Font.motif_new(this, OS.XmFontListCopy(argList[7]));
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeComposite() {
        int widgetClass = OS.topLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int scrolledHandle = OS.XmCreateMainWindow(shellHandle, null, null, 0);
        int[] argList1 = new int[]{OS.XmNorientation, 2};
        int hScrollHandle = OS.XmCreateScrollBar(scrolledHandle, null, argList1, argList1.length / 2);
        OS.XtManageChild(hScrollHandle);
        int[] argList2 = new int[]{OS.XmNorientation, 1};
        int vScrollHandle = OS.XmCreateScrollBar(scrolledHandle, null, argList2, argList2.length / 2);
        OS.XtManageChild(vScrollHandle);
        OS.XtManageChild(scrolledHandle);
        int[] argList5 = new int[]{OS.XmNmarginWidth, 3, OS.XmNmarginHeight, 3};
        int formHandle = OS.XmCreateForm(scrolledHandle, null, argList5, argList5.length / 2);
        OS.XtManageChild(formHandle);
        int[] nArray = new int[14];
        nArray[0] = OS.XmNmarginWidth;
        nArray[2] = OS.XmNmarginHeight;
        nArray[4] = OS.XmNresizePolicy;
        nArray[6] = OS.XmNtopAttachment;
        nArray[7] = 1;
        nArray[8] = OS.XmNbottomAttachment;
        nArray[9] = 1;
        nArray[10] = OS.XmNleftAttachment;
        nArray[11] = 1;
        nArray[12] = OS.XmNrightAttachment;
        nArray[13] = 1;
        int[] argList6 = nArray;
        int widgetHandle = OS.XmCreateDrawingArea(formHandle, null, argList6, argList6.length / 2);
        OS.XtManageChild(widgetHandle);
        OS.XmMainWindowSetAreas(scrolledHandle, 0, 0, hScrollHandle, vScrollHandle, formHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        int screen = OS.XDefaultScreen(this.xDisplay);
        OS.XtResizeWidget(shellHandle, OS.XDisplayWidth(this.xDisplay, screen), OS.XDisplayHeight(this.xDisplay, screen), 0);
        OS.XtRealizeWidget(shellHandle);
        int[] nArray2 = new int[4];
        nArray2[0] = OS.XmNwidth;
        nArray2[2] = OS.XmNheight;
        int[] argList3 = nArray2;
        OS.XtGetValues(scrolledHandle, argList3, argList3.length / 2);
        int[] nArray3 = new int[8];
        nArray3[0] = OS.XmNx;
        nArray3[2] = OS.XmNy;
        nArray3[4] = OS.XmNwidth;
        nArray3[6] = OS.XmNheight;
        int[] argList8 = nArray3;
        OS.XtGetValues(formHandle, argList8, argList8.length / 2);
        int[] nArray4 = new int[18];
        nArray4[0] = OS.XmNx;
        nArray4[2] = OS.XmNy;
        nArray4[4] = OS.XmNwidth;
        nArray4[6] = OS.XmNheight;
        nArray4[8] = OS.XmNforeground;
        nArray4[10] = OS.XmNbackground;
        nArray4[12] = OS.XmNtopShadowColor;
        nArray4[14] = OS.XmNbottomShadowColor;
        nArray4[16] = OS.XmNborderColor;
        int[] argList4 = nArray4;
        OS.XtGetValues(widgetHandle, argList4, argList4.length / 2);
        this.scrolledInsetX = argList4[1] + argList8[1];
        this.scrolledInsetY = argList4[3] + argList8[3];
        this.scrolledMarginX = argList3[1] - argList8[1] - argList4[1] - argList4[5];
        this.scrolledMarginY = argList3[3] - argList8[3] - argList4[3] - argList4[7];
        this.compositeForeground = argList4[9];
        this.compositeBackground = argList4[11];
        this.compositeTopShadow = argList4[13];
        this.compositeBottomShadow = argList4[15];
        this.compositeBorder = argList4[17];
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeDefaults() {
        this.defaultFont = this.labelFont;
        this.defaultForeground = this.compositeForeground;
        this.defaultBackground = this.compositeBackground;
    }

    void initializeDialog() {
    }

    void initializeDisplay() {
        int[] filedes;
        this.focusCallback = new Callback(this, "focusProc", 4);
        this.focusProc = this.focusCallback.getAddress();
        if (this.focusProc == 0) {
            this.error(3);
        }
        this.windowCallback = new Callback(this, "windowProc", 4);
        this.windowProc = this.windowCallback.getAddress();
        if (this.windowProc == 0) {
            this.error(3);
        }
        this.windowTimerCallback = new Callback(this, "windowTimerProc", 2);
        this.windowTimerProc = this.windowTimerCallback.getAddress();
        if (this.windowTimerProc == 0) {
            this.error(3);
        }
        this.timerCallback = new Callback(this, "timerProc", 2);
        this.timerProc = this.timerCallback.getAddress();
        if (this.timerProc == 0) {
            this.error(3);
        }
        this.caretCallback = new Callback(this, "caretProc", 2);
        this.caretProc = this.caretCallback.getAddress();
        if (this.caretProc == 0) {
            this.error(3);
        }
        this.mouseHoverCallback = new Callback(this, "mouseHoverProc", 2);
        this.mouseHoverProc = this.mouseHoverCallback.getAddress();
        if (this.mouseHoverProc == 0) {
            this.error(3);
        }
        this.checkExposeCallback = new Callback(this, "checkExposeProc", 3);
        this.checkExposeProc = this.checkExposeCallback.getAddress();
        if (this.checkExposeProc == 0) {
            this.error(3);
        }
        this.checkResizeCallback = new Callback(this, "checkResizeProc", 3);
        this.checkResizeProc = this.checkResizeCallback.getAddress();
        if (this.checkResizeProc == 0) {
            this.error(3);
        }
        this.wakeCallback = new Callback(this, "wakeProc", 3);
        this.wakeProc = this.wakeCallback.getAddress();
        if (this.wakeProc == 0) {
            this.error(3);
        }
        if (OS.pipe(filedes = new int[2]) != 0) {
            this.error(2);
        }
        this.read_fd = filedes[0];
        this.write_fd = filedes[1];
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        this.inputID = OS.XtAppAddInput(xtContext, this.read_fd, 1, this.wakeProc, 0);
        this.fd_set = new byte[OS.fd_set_sizeof()];
        int xmDisplay = OS.XmGetXmDisplay(this.xDisplay);
        int[] args = new int[]{OS.XmNenableThinThickness, 1, OS.XmNdragInitiatorProtocolStyle, 5, OS.XmNdragReceiverProtocolStyle, 5};
        OS.XtSetValues(xmDisplay, args, args.length / 2);
        int xScreen = OS.XDefaultScreen(this.xDisplay);
        int widgetClass = OS.topLevelShellWidgetClass();
        this.shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        OS.XtSetMappedWhenManaged(this.shellHandle, false);
        OS.XtResizeWidget(this.shellHandle, OS.XDisplayWidth(this.xDisplay, xScreen), OS.XDisplayHeight(this.xDisplay, xScreen), 0);
        OS.XtRealizeWidget(this.shellHandle);
    }

    void initializeLabel() {
        int widgetClass = OS.topLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        byte[] buffer = Converter.wcsToMbcs(null, "string", true);
        int widgetHandle = OS.XmCreateLabel(shellHandle, buffer, null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] nArray = new int[6];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNfontList;
        int[] argList2 = nArray;
        OS.XtGetValues(widgetHandle, argList2, argList2.length / 2);
        this.labelForeground = argList2[1];
        this.labelBackground = argList2[3];
        this.labelFont = Font.motif_new(this, OS.XmFontListCopy(argList2[5]));
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeList() {
        int widgetClass = OS.topLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int widgetHandle = OS.XmCreateScrolledList(shellHandle, new byte[1], null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] nArray = new int[10];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNfontList;
        nArray[6] = OS.XmNselectColor;
        nArray[8] = OS.XmNhighlightColor;
        int[] argList = nArray;
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.listForeground = argList[1];
        this.listBackground = argList[3];
        this.listFont = Font.motif_new(this, OS.XmFontListCopy(argList[5]));
        byte selectColor = (byte)argList[7];
        switch (selectColor) {
            case -2: 
            case -1: {
                this.listSelect = this.listForeground;
                break;
            }
            case -3: {
                this.listSelect = argList[9];
                break;
            }
            default: {
                this.listSelect = argList[7];
            }
        }
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeNumLock() {
        int numLockCode = OS.XKeysymToKeycode(this.xDisplay, 65407);
        int keymapHandle = OS.XGetModifierMapping(this.xDisplay);
        XModifierKeymap keymap = new XModifierKeymap();
        OS.memmove(keymap, keymapHandle, 8);
        int i = 0;
        while (i < 8 * keymap.max_keypermod) {
            byte[] keymapCode = new byte[1];
            OS.memmove(keymapCode, keymap.modifiermap + i, 1);
            if (keymapCode[0] == numLockCode) {
                int modIndex = i / keymap.max_keypermod;
                switch (modIndex) {
                    case 3: {
                        numLock = "Mod1";
                        break;
                    }
                    case 4: {
                        numLock = "Mod2";
                        break;
                    }
                    case 5: {
                        numLock = "Mod3";
                        break;
                    }
                    case 6: {
                        numLock = "Mod4";
                        break;
                    }
                    case 7: {
                        numLock = "Mod5";
                        break;
                    }
                    default: {
                        numLock = "Mod2";
                        break;
                    }
                }
                break;
            }
            ++i;
        }
        OS.XFreeModifiermap(keymapHandle);
    }

    void initializePixmaps() {
        int dialog = OS.XmCreateErrorDialog(this.shellHandle, null, null, 0);
        OS.XtDestroyWidget(dialog);
    }

    void initializeScrollBar() {
    }

    void initializeSystemColors() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNcolormap;
        int[] argList = nArray;
        OS.XtGetValues(this.shellHandle, argList, argList.length / 2);
        int colormap = argList[1];
        this.COLOR_WIDGET_DARK_SHADOW = new XColor();
        this.COLOR_WIDGET_DARK_SHADOW.pixel = this.compositeBottomShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_DARK_SHADOW);
        this.COLOR_WIDGET_NORMAL_SHADOW = new XColor();
        this.COLOR_WIDGET_NORMAL_SHADOW.pixel = this.compositeBottomShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_NORMAL_SHADOW);
        this.COLOR_WIDGET_LIGHT_SHADOW = new XColor();
        this.COLOR_WIDGET_LIGHT_SHADOW.pixel = this.compositeTopShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_LIGHT_SHADOW);
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = new XColor();
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW.pixel = this.compositeTopShadow;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_HIGHLIGHT_SHADOW);
        this.COLOR_WIDGET_FOREGROUND = new XColor();
        this.COLOR_WIDGET_FOREGROUND.pixel = this.textForeground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_FOREGROUND);
        this.COLOR_WIDGET_BACKGROUND = new XColor();
        this.COLOR_WIDGET_BACKGROUND.pixel = this.compositeBackground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_BACKGROUND);
        this.COLOR_WIDGET_BORDER = new XColor();
        this.COLOR_WIDGET_BORDER.pixel = this.compositeBorder;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_WIDGET_BORDER);
        this.COLOR_LIST_FOREGROUND = new XColor();
        this.COLOR_LIST_FOREGROUND.pixel = this.listForeground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_FOREGROUND);
        this.COLOR_LIST_BACKGROUND = new XColor();
        this.COLOR_LIST_BACKGROUND.pixel = this.listBackground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_BACKGROUND);
        this.COLOR_LIST_SELECTION = new XColor();
        this.COLOR_LIST_SELECTION.pixel = this.listSelect;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_SELECTION);
        this.COLOR_LIST_SELECTION_TEXT = new XColor();
        this.COLOR_LIST_SELECTION_TEXT.pixel = this.listBackground;
        OS.XQueryColor(this.xDisplay, colormap, this.COLOR_LIST_SELECTION_TEXT);
        this.COLOR_INFO_BACKGROUND = new Color(this, 255, 255, 225);
    }

    void initializeText() {
        int widgetClass = OS.topLevelShellWidgetClass();
        int shellHandle = OS.XtAppCreateShell(this.appName, this.appClass, widgetClass, this.xDisplay, null, 0);
        int widgetHandle = OS.XmCreateScrolledText(shellHandle, new byte[1], null, 0);
        OS.XtManageChild(widgetHandle);
        OS.XtSetMappedWhenManaged(shellHandle, false);
        OS.XtRealizeWidget(shellHandle);
        int[] nArray = new int[10];
        nArray[0] = OS.XmNforeground;
        nArray[2] = OS.XmNbackground;
        nArray[4] = OS.XmNfontList;
        nArray[6] = OS.XmNhighlightThickness;
        nArray[8] = OS.XmNblinkRate;
        int[] argList = nArray;
        OS.XtGetValues(widgetHandle, argList, argList.length / 2);
        this.textForeground = argList[1];
        this.textBackground = argList[3];
        this.textHighlightThickness = argList[7];
        this.blinkRate = argList[9];
        this.textFont = Font.motif_new(this, OS.XmFontListCopy(argList[5]));
        OS.XtDestroyWidget(shellHandle);
    }

    void initializeTranslations() {
        byte[] buffer1 = Converter.wcsToMbcs(null, "<Key>osfUp:\n<Key>osfDown:\n<Key>osfLeft:\n<Key>osfRight:\u0000");
        this.arrowTranslations = OS.XtParseTranslationTable(buffer1);
        byte[] buffer2 = Converter.wcsToMbcs(null, "~Meta ~Alt <Key>Tab:\nShift ~Meta ~Alt <Key>Tab:\u0000");
        this.tabTranslations = OS.XtParseTranslationTable(buffer2);
        byte[] buffer3 = Converter.wcsToMbcs(null, "<Btn2Down>:\u0000");
        this.dragTranslations = OS.XtParseTranslationTable(buffer3);
    }

    void initializeWidgetTable() {
        int[] nArray = new int[2];
        nArray[0] = OS.XmNuserData;
        this.userData = nArray;
        this.indexTable = new int[1024];
        this.shellTable = new Shell[128];
        this.widgetTable = new Widget[1024];
        int i = 0;
        while (i < 1023) {
            this.indexTable[i] = i + 1;
            ++i;
        }
        this.indexTable[1023] = -1;
    }

    public int internal_new_GC(GCData data) {
        int xDrawable;
        int xGC;
        if (this.isDisposed()) {
            SWT.error(45);
        }
        if ((xGC = OS.XCreateGC(this.xDisplay, xDrawable = OS.XDefaultRootWindow(this.xDisplay), 0, null)) == 0) {
            SWT.error(2);
        }
        OS.XSetSubwindowMode(this.xDisplay, xGC, 1);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.display = this.xDisplay;
            data.drawable = xDrawable;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.defaultFont;
            data.colormap = OS.XDefaultColormap(this.xDisplay, OS.XDefaultScreen(this.xDisplay));
        }
        return xGC;
    }

    public void internal_dispose_GC(int gc, GCData data) {
        OS.XFreeGC(this.xDisplay, gc);
    }

    boolean isValidThread() {
        return this.thread == Thread.currentThread();
    }

    static boolean isValidClass(Class clazz) {
        String name = clazz.getName();
        int index = name.lastIndexOf(46);
        return name.substring(0, index + 1).equals(PACKAGE_PREFIX);
    }

    public Point map(Control from, Control to, Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        return this.map(from, to, point.x, point.y);
    }

    public Point map(Control from, Control to, int x, int y) {
        short[] root_y;
        short[] root_x;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Point point = new Point(x, y);
        if (from == to) {
            return point;
        }
        if (from != null) {
            root_x = new short[1];
            root_y = new short[1];
            OS.XtTranslateCoords(from.handle, (short)x, (short)y, root_x, root_y);
            point.x = root_x[0];
            point.y = root_y[0];
        }
        if (to != null) {
            root_x = new short[1];
            root_y = new short[1];
            OS.XtTranslateCoords(to.handle, (short)0, (short)0, root_x, root_y);
            point.x -= root_x[0];
            point.y -= root_y[0];
        }
        return point;
    }

    public Rectangle map(Control from, Control to, Rectangle rectangle) {
        this.checkDevice();
        if (rectangle == null) {
            this.error(4);
        }
        return this.map(from, to, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public Rectangle map(Control from, Control to, int x, int y, int width, int height) {
        short[] root_y;
        short[] root_x;
        this.checkDevice();
        if (from != null && from.isDisposed()) {
            this.error(5);
        }
        if (to != null && to.isDisposed()) {
            this.error(5);
        }
        Rectangle rect = new Rectangle(x, y, width, height);
        if (from == to) {
            return rect;
        }
        if (from != null) {
            root_x = new short[1];
            root_y = new short[1];
            OS.XtTranslateCoords(from.handle, (short)x, (short)y, root_x, root_y);
            rect.x = root_x[0];
            rect.y = root_y[0];
        }
        if (to != null) {
            root_x = new short[1];
            root_y = new short[1];
            OS.XtTranslateCoords(to.handle, (short)0, (short)0, root_x, root_y);
            rect.x -= root_x[0];
            rect.y -= root_y[0];
        }
        return rect;
    }

    int mouseHoverProc(int handle, int id) {
        this.mouseHoverHandle = 0;
        this.mouseHoverID = 0;
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.hoverProc(id);
    }

    /*
     * Exception decompiling
     */
    public boolean post(Event event) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 0[TRYBLOCK]], but top level block is 11[CASE]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    void postEvent(Event event) {
        if (this.eventQueue == null) {
            this.eventQueue = new Event[4];
        }
        int index = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            if (this.eventQueue[index] == null) break;
            ++index;
        }
        if (index == length) {
            Event[] newQueue = new Event[length + 4];
            System.arraycopy(this.eventQueue, 0, newQueue, 0, length);
            this.eventQueue = newQueue;
        }
        this.eventQueue[index] = event;
    }

    public boolean readAndDispatch() {
        this.checkDevice();
        this.runSkin();
        this.runDeferredLayouts();
        boolean events = this.runPopups();
        int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        int status = OS.XtAppPending(xtContext);
        if (status != 0) {
            events |= true;
            if ((status & 2) != 0) {
                OS.XtAppProcessEvent(xtContext, 2);
                status = OS.XtAppPending(xtContext);
            }
            if ((status & 4) != 0) {
                OS.XtAppProcessEvent(xtContext, 4);
                status = OS.XtAppPending(xtContext);
            }
            if ((status & 1) != 0) {
                OS.XtAppNextEvent(xtContext, this.xEvent);
                if (!this.filterEvent(this.xEvent)) {
                    OS.XtDispatchEvent(this.xEvent);
                }
            }
        }
        if (events) {
            this.runDeferredEvents();
            return true;
        }
        return this.isDisposed() || this.runAsyncMessages(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void register(Display display) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            int i = 0;
            while (i < Displays.length) {
                if (Displays[i] == null) {
                    Display.Displays[i] = display;
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return;
                }
                ++i;
            }
            Display[] newDisplays = new Display[Displays.length + 4];
            System.arraycopy(Displays, 0, newDisplays, 0, Displays.length);
            newDisplays[Display.Displays.length] = display;
            Displays = newDisplays;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    protected void release() {
        this.sendEvent(12, new Event());
        Shell[] shells = this.getShells();
        int i = 0;
        while (i < shells.length) {
            Shell shell = shells[i];
            if (!shell.isDisposed()) {
                shell.dispose();
            }
            ++i;
        }
        if (this.tray != null) {
            this.tray.dispose();
        }
        this.tray = null;
        while (this.readAndDispatch()) {
        }
        if (this.disposeList != null) {
            i = 0;
            while (i < this.disposeList.length) {
                if (this.disposeList[i] != null) {
                    this.disposeList[i].run();
                }
                ++i;
            }
        }
        this.disposeList = null;
        this.synchronizer.releaseSynchronizer();
        this.synchronizer = null;
        this.releaseDisplay();
        super.release();
    }

    void releaseDisplay() {
        int screen = OS.XDefaultScreenOfDisplay(this.xDisplay);
        if (this.errorPixmap != 0) {
            OS.XmDestroyPixmap(screen, this.errorPixmap);
            OS.XFreePixmap(this.xDisplay, this.errorMask);
        }
        if (this.infoPixmap != 0) {
            OS.XmDestroyPixmap(screen, this.infoPixmap);
            OS.XFreePixmap(this.xDisplay, this.infoMask);
        }
        if (this.questionPixmap != 0) {
            OS.XmDestroyPixmap(screen, this.questionPixmap);
            OS.XFreePixmap(this.xDisplay, this.questionMask);
        }
        if (this.warningPixmap != 0) {
            OS.XmDestroyPixmap(screen, this.warningPixmap);
            OS.XFreePixmap(this.xDisplay, this.warningMask);
        }
        if (this.workingPixmap != 0) {
            OS.XmDestroyPixmap(screen, this.workingPixmap);
            OS.XFreePixmap(this.xDisplay, this.workingMask);
        }
        this.workingPixmap = 0;
        this.warningPixmap = 0;
        this.questionPixmap = 0;
        this.infoPixmap = 0;
        this.errorPixmap = 0;
        this.workingMask = 0;
        this.warningMask = 0;
        this.questionMask = 0;
        this.infoMask = 0;
        this.errorMask = 0;
        int i = 0;
        while (i < this.cursors.length) {
            if (this.cursors[i] != null) {
                this.cursors[i].dispose();
            }
            ++i;
        }
        this.cursors = null;
        if (this.shellHandle != 0) {
            if (!OS.IsSunOS) {
                OS.XtDestroyWidget(this.shellHandle);
            }
            this.shellHandle = 0;
        }
        if (this.caretID != 0) {
            OS.XtRemoveTimeOut(this.caretID);
        }
        this.caretProc = 0;
        this.caretID = 0;
        this.caretCallback.dispose();
        this.caretCallback = null;
        if (this.timerIds != null) {
            i = 0;
            while (i < this.timerIds.length) {
                if (this.timerIds[i] != 0) {
                    OS.XtRemoveTimeOut(this.timerIds[i]);
                }
                ++i;
            }
        }
        this.timerIds = null;
        this.timerList = null;
        this.timerProc = 0;
        this.timerCallback.dispose();
        this.timerCallback = null;
        this.windowTimerProc = 0;
        this.windowTimerCallback.dispose();
        this.windowTimerCallback = null;
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        this.toolTipHandle = 0;
        this.mouseHoverHandle = 0;
        this.mouseHoverProc = 0;
        this.mouseHoverID = 0;
        this.mouseHoverCallback.dispose();
        this.mouseHoverCallback = null;
        this.windowCallback.dispose();
        this.windowCallback = null;
        this.checkExposeCallback.dispose();
        this.checkExposeCallback = null;
        this.checkExposeProc = 0;
        this.checkResizeCallback.dispose();
        this.checkResizeCallback = null;
        this.checkResizeProc = 0;
        if (this.inputID != 0) {
            OS.XtRemoveInput(this.inputID);
        }
        this.wakeCallback.dispose();
        this.wakeCallback = null;
        this.wakeProc = 0;
        OS.close(this.read_fd);
        OS.close(this.write_fd);
        this.focusCallback.dispose();
        this.focusCallback = null;
        this.focusProc = 0;
        if (this.buttonFont != null) {
            OS.XmFontListFree(this.buttonFont.handle);
            this.buttonFont.handle = 0;
        }
        if (this.labelFont != null) {
            OS.XmFontListFree(this.labelFont.handle);
            this.labelFont.handle = 0;
        }
        if (this.textFont != null) {
            OS.XmFontListFree(this.textFont.handle);
            this.textFont.handle = 0;
        }
        if (this.listFont != null) {
            OS.XmFontListFree(this.listFont.handle);
            this.listFont.handle = 0;
        }
        this.buttonFont = null;
        this.labelFont = null;
        this.textFont = null;
        this.listFont = null;
        this.defaultFont = null;
        if (this.xEvent != 0) {
            OS.XtFree(this.xEvent);
        }
        this.xEvent = 0;
        this.thread = null;
        this.buttonForeground = 0;
        this.buttonBackground = 0;
        this.defaultForeground = 0;
        this.defaultBackground = 0;
        this.COLOR_LIST_SELECTION_TEXT = null;
        this.COLOR_LIST_SELECTION = null;
        this.COLOR_LIST_BACKGROUND = null;
        this.COLOR_LIST_FOREGROUND = null;
        this.COLOR_WIDGET_BORDER = null;
        this.COLOR_WIDGET_BACKGROUND = null;
        this.COLOR_WIDGET_FOREGROUND = null;
        this.COLOR_WIDGET_HIGHLIGHT_SHADOW = null;
        this.COLOR_WIDGET_LIGHT_SHADOW = null;
        this.COLOR_WIDGET_NORMAL_SHADOW = null;
        this.COLOR_WIDGET_DARK_SHADOW = null;
        this.COLOR_INFO_BACKGROUND = null;
        this.popups = null;
        this.focusedCombo = null;
        this.fd_set = null;
        this.wake_buffer = null;
        this.appClass = null;
        this.appName = null;
        this.displayName = null;
        this.keyEvent = null;
        this.filterTable = null;
        this.eventTable = null;
        this.timeout = null;
        this.userData = null;
        this.indexTable = null;
        this.shellTable = null;
        this.widgetTable = null;
        this.xExposeEvent = null;
        this.xConfigureEvent = null;
        this.data = null;
        this.keys = null;
        this.values = null;
    }

    void releaseToolTipHandle(int handle) {
        int shellHandle;
        int shellParent;
        if (this.mouseHoverHandle == handle) {
            this.removeMouseHoverTimeOut();
        }
        if (this.toolTipHandle != 0 && handle == (shellParent = OS.XtParent(shellHandle = OS.XtParent(this.toolTipHandle)))) {
            this.toolTipHandle = 0;
        }
    }

    void removeMouseHoverTimeOut() {
        if (this.mouseHoverID != 0) {
            OS.XtRemoveTimeOut(this.mouseHoverID);
        }
        this.mouseHoverHandle = 0;
        this.mouseHoverID = 0;
    }

    Widget removeWidget(int handle) {
        if (handle == 0) {
            return null;
        }
        if (OS.XtIsSubclass(handle, OS.shellWidgetClass())) {
            int i = 0;
            while (i < this.shellTable.length) {
                Shell shell = this.shellTable[i];
                if (shell != null && ((Widget)shell).topHandle() == handle) {
                    this.shellTable[i] = null;
                    return shell;
                }
                ++i;
            }
            return null;
        }
        this.userData[1] = 0;
        Widget widget = null;
        OS.XtGetValues(handle, this.userData, this.userData.length / 2);
        int index = this.userData[1] - 1;
        if (index >= 0 && index < this.widgetTable.length) {
            widget = this.widgetTable[index];
            this.widgetTable[index] = null;
            this.indexTable[index] = this.freeSlot;
            this.freeSlot = index;
            this.userData[1] = 0;
            OS.XtSetValues(handle, this.userData, this.userData.length / 2);
        }
        return widget;
    }

    void removePopup(Menu menu) {
        if (this.popups == null) {
            return;
        }
        int i = 0;
        while (i < this.popups.length) {
            if (this.popups[i] == menu) {
                this.popups[i] = null;
                return;
            }
            ++i;
        }
    }

    public void removeFilter(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.filterTable == null) {
            return;
        }
        this.filterTable.unhook(eventType, listener);
        if (this.filterTable.size() == 0) {
            this.filterTable = null;
        }
    }

    public void removeListener(int eventType, Listener listener) {
        this.checkDevice();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(eventType, listener);
    }

    boolean runAsyncMessages(boolean all) {
        return this.synchronizer.runAsyncMessages(all);
    }

    boolean runDeferredEvents() {
        boolean run = false;
        while (this.eventQueue != null) {
            Widget item;
            Event event = this.eventQueue[0];
            if (event == null) break;
            int length = this.eventQueue.length;
            System.arraycopy(this.eventQueue, 1, this.eventQueue, 0, --length);
            this.eventQueue[length] = null;
            Widget widget = event.widget;
            if (widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed()) continue;
            run = true;
            widget.sendEvent(event);
        }
        this.eventQueue = null;
        return run;
    }

    boolean runFocusOutEvents() {
        if (this.eventQueue == null) {
            return false;
        }
        Event[] focusQueue = null;
        int index = 0;
        int count = 0;
        int length = this.eventQueue.length;
        while (index < length) {
            Event event = this.eventQueue[index];
            if (event != null && event.type == 16) {
                if (focusQueue == null) {
                    focusQueue = new Event[length];
                }
                focusQueue[count++] = event;
                System.arraycopy(this.eventQueue, index + 1, this.eventQueue, index, --length - index);
                this.eventQueue[length] = null;
                continue;
            }
            ++index;
        }
        if (focusQueue == null) {
            return false;
        }
        int i = 0;
        while (i < count) {
            Widget item;
            Event event = focusQueue[i];
            Widget widget = event.widget;
            if (!(widget == null || widget.isDisposed() || (item = event.item) != null && item.isDisposed())) {
                widget.sendEvent(event);
            }
            ++i;
        }
        return true;
    }

    boolean runDeferredLayouts() {
        if (this.layoutDeferredCount != 0) {
            Composite[] temp = this.layoutDeferred;
            int count = this.layoutDeferredCount;
            this.layoutDeferred = null;
            this.layoutDeferredCount = 0;
            int i = 0;
            while (i < count) {
                Composite comp = temp[i];
                if (!comp.isDisposed()) {
                    comp.setLayoutDeferred(false);
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    boolean runPopups() {
        if (this.popups == null) {
            return false;
        }
        boolean result = false;
        while (this.popups != null) {
            Menu menu = this.popups[0];
            if (menu == null) break;
            int length = this.popups.length;
            System.arraycopy(this.popups, 1, this.popups, 0, --length);
            this.popups[length] = null;
            this.runDeferredEvents();
            if (!menu.isDisposed()) {
                menu._setVisible(true);
            }
            result = true;
        }
        this.popups = null;
        return result;
    }

    boolean runSkin() {
        if (this.skinCount > 0) {
            Widget[] oldSkinWidgets = this.skinList;
            int count = this.skinCount;
            this.skinList = new Widget[1024];
            this.skinCount = 0;
            if (this.eventTable != null && this.eventTable.hooks(45)) {
                int i = 0;
                while (i < count) {
                    Widget widget = oldSkinWidgets[i];
                    if (widget != null && !widget.isDisposed()) {
                        widget.state &= 0xFFFF7FFF;
                        oldSkinWidgets[i] = null;
                        Event event = new Event();
                        event.widget = widget;
                        this.sendEvent(45, event);
                    }
                    ++i;
                }
            }
            return true;
        }
        return false;
    }

    void sendEvent(int eventType, Event event) {
        if (this.eventTable == null && this.filterTable == null) {
            return;
        }
        if (event == null) {
            event = new Event();
        }
        event.display = this;
        event.type = eventType;
        if (event.time == 0) {
            event.time = this.getLastEventTime();
        }
        if (!this.filterEvent(event) && this.eventTable != null) {
            this.eventTable.sendEvent(event);
        }
    }

    void sendFocusEvent(Control control, int type) {
        if (type == 15) {
            this.focusEvent = 15;
            control.sendEvent(15);
            this.focusEvent = 0;
        } else if (this.postFocusOut) {
            control.postEvent(16);
        } else {
            this.focusEvent = 16;
            control.sendEvent(16);
            this.focusEvent = 0;
        }
    }

    public void setCursorLocation(int x, int y) {
        this.checkDevice();
        int xWindow = OS.XDefaultRootWindow(this.xDisplay);
        OS.XWarpPointer(this.xDisplay, 0, xWindow, 0, 0, 0, 0, x, y);
    }

    public void setCursorLocation(Point point) {
        this.checkDevice();
        if (point == null) {
            this.error(4);
        }
        this.setCursorLocation(point.x, point.y);
    }

    public static String getAppName() {
        return APP_NAME;
    }

    public static String getAppVersion() {
        return APP_VERSION;
    }

    public static void setAppName(String name) {
        APP_NAME = name;
    }

    public static void setAppVersion(String version) {
        APP_VERSION = version;
    }

    void setCurrentCaret(Caret caret) {
        if (this.caretID != 0) {
            OS.XtRemoveTimeOut(this.caretID);
        }
        this.caretID = 0;
        this.currentCaret = caret;
        if (this.currentCaret != null) {
            int blinkRate = this.currentCaret.blinkRate;
            int xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
            this.caretID = OS.XtAppAddTimeOut(xtContext, blinkRate, this.caretProc, 0);
        }
    }

    public void setData(String key, Object value) {
        this.checkDevice();
        if (key == null) {
            this.error(4);
        }
        if (value == null) {
            if (this.keys == null) {
                return;
            }
            int index = 0;
            while (index < this.keys.length && !this.keys[index].equals(key)) {
                ++index;
            }
            if (index == this.keys.length) {
                return;
            }
            if (this.keys.length == 1) {
                this.keys = null;
                this.values = null;
            } else {
                String[] newKeys = new String[this.keys.length - 1];
                Object[] newValues = new Object[this.values.length - 1];
                System.arraycopy(this.keys, 0, newKeys, 0, index);
                System.arraycopy(this.keys, index + 1, newKeys, index, newKeys.length - index);
                System.arraycopy(this.values, 0, newValues, 0, index);
                System.arraycopy(this.values, index + 1, newValues, index, newValues.length - index);
                this.keys = newKeys;
                this.values = newValues;
            }
            return;
        }
        if (this.keys == null) {
            this.keys = new String[]{key};
            this.values = new Object[]{value};
            return;
        }
        int i = 0;
        while (i < this.keys.length) {
            if (this.keys[i].equals(key)) {
                this.values[i] = value;
                return;
            }
            ++i;
        }
        String[] newKeys = new String[this.keys.length + 1];
        Object[] newValues = new Object[this.values.length + 1];
        System.arraycopy(this.keys, 0, newKeys, 0, this.keys.length);
        System.arraycopy(this.values, 0, newValues, 0, this.values.length);
        newKeys[this.keys.length] = key;
        newValues[this.values.length] = value;
        this.keys = newKeys;
        this.values = newValues;
    }

    public void setData(Object data) {
        this.checkDevice();
        this.data = data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSynchronizer(Synchronizer synchronizer) {
        this.checkDevice();
        if (synchronizer == null) {
            this.error(4);
        }
        if (synchronizer == this.synchronizer) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            Synchronizer oldSynchronizer = this.synchronizer;
            this.synchronizer = synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            if (oldSynchronizer != null) {
                oldSynchronizer.runAsyncMessages(true);
            }
            return;
        }
    }

    void setToolTipText(int handle, String toolTipText) {
        if (this.toolTipHandle == 0) {
            return;
        }
        int shellHandle = OS.XtParent(this.toolTipHandle);
        int shellParent = OS.XtParent(shellHandle);
        if (handle != shellParent) {
            return;
        }
        this.showToolTip(handle, toolTipText);
    }

    void showToolTip(int handle, String toolTipText) {
        int shellHandle = 0;
        if (toolTipText == null) {
            toolTipText = "";
        }
        char[] text = new char[toolTipText.length()];
        toolTipText.getChars(0, text.length, text, 0);
        Widget.fixMnemonic(text);
        byte[] buffer = Converter.wcsToMbcs(null, text, true);
        if (this.toolTipHandle != 0) {
            shellHandle = OS.XtParent(this.toolTipHandle);
            int shellParent = OS.XtParent(shellHandle);
            if (handle != shellParent) {
                return;
            }
            int xmString = OS.XmStringGenerate(buffer, null, 0, null);
            int[] argList = new int[]{OS.XmNlabelString, xmString};
            OS.XtSetValues(this.toolTipHandle, argList, argList.length / 2);
            if (xmString != 0) {
                OS.XmStringFree(xmString);
            }
        } else {
            int widgetClass = OS.overrideShellWidgetClass();
            int[] nArray = new int[6];
            nArray[0] = OS.XmNmwmDecorations;
            nArray[2] = OS.XmNborderWidth;
            nArray[3] = 1;
            nArray[4] = OS.XmNallowShellResize;
            nArray[5] = 1;
            int[] argList1 = nArray;
            shellHandle = OS.XtCreatePopupShell(null, widgetClass, handle, argList1, argList1.length / 2);
            Color infoForeground = this.getSystemColor(28);
            Color infoBackground = this.getSystemColor(29);
            int foregroundPixel = infoForeground.handle.pixel;
            int backgroundPixel = infoBackground.handle.pixel;
            int[] nArray2 = new int[6];
            nArray2[0] = OS.XmNforeground;
            nArray2[1] = foregroundPixel;
            nArray2[2] = OS.XmNbackground;
            nArray2[3] = backgroundPixel;
            nArray2[4] = OS.XmNalignment;
            int[] argList2 = nArray2;
            this.toolTipHandle = OS.XmCreateLabel(shellHandle, buffer, argList2, argList2.length / 2);
            OS.XtManageChild(this.toolTipHandle);
        }
        if (toolTipText == null || toolTipText.length() == 0) {
            OS.XtPopdown(shellHandle);
        } else {
            int xWindow = OS.XDefaultRootWindow(this.xDisplay);
            int[] rootX = new int[1];
            int[] rootY = new int[1];
            int[] unused = new int[1];
            int[] mask = new int[1];
            OS.XQueryPointer(this.xDisplay, xWindow, unused, unused, rootX, rootY, unused, unused, mask);
            int x = rootX[0] + 16;
            int y = rootY[0] + 16;
            int screen = OS.XDefaultScreen(this.xDisplay);
            int width = OS.XDisplayWidth(this.xDisplay, screen);
            int height = OS.XDisplayHeight(this.xDisplay, screen);
            int[] nArray = new int[4];
            nArray[0] = OS.XmNwidth;
            nArray[2] = OS.XmNheight;
            int[] argList4 = nArray;
            OS.XtGetValues(this.toolTipHandle, argList4, argList4.length / 2);
            x = Math.max(0, Math.min(x, width - argList4[1]));
            y = Math.max(0, Math.min(y, height - argList4[3]));
            OS.XtMoveWidget(shellHandle, x, y);
            int flags = 1792;
            if ((mask[0] & flags) == 0) {
                OS.XtPopup(shellHandle, 0);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean sleep() {
        this.checkDevice();
        if (this.getMessageCount() != 0) {
            return true;
        }
        workProc = true;
        display_fd = OS.ConnectionNumber(this.xDisplay);
        xtContext = OS.XtDisplayToApplicationContext(this.xDisplay);
        max_fd = display_fd > this.read_fd ? display_fd : this.read_fd;
        do {
            OS.FD_ZERO(this.fd_set);
            OS.FD_SET(display_fd, this.fd_set);
            OS.FD_SET(this.read_fd, this.fd_set);
            this.timeout[0] = 0;
            this.timeout[1] = 50000;
            lock = OS.lock;
            count = lock.lock();
            i = 0;
            while (i < count) {
                lock.unlock();
                ++i;
            }
            try {
                result = OS.select(max_fd + 1, this.fd_set, null, null, this.timeout);
            }
            finally {
                i = 0;
                ** while (i < count)
            }
lbl-1000:
            // 1 sources

            {
                lock.lock();
                ++i;
                continue;
            }
lbl31:
            // 1 sources

            lock.unlock();
            status = OS.XtAppPending(xtContext);
            if (!workProc || status != 0) continue;
            workProc = false;
            OS.XtAppAddTimeOut(xtContext, 1, 0, 0);
            OS.XtAppProcessEvent(xtContext, 2);
        } while (result == 0 && this.getMessageCount() == 0 && status == 0);
        return OS.FD_ISSET(display_fd, this.fd_set);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void syncExec(Runnable runnable) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            Synchronizer synchronizer = this.synchronizer;
            // ** MonitorExit[var3_2] (shouldn't be in output)
            synchronizer.syncExec(runnable);
            return;
        }
    }

    int textWidth(String string, Font font) {
        if (string.length() == 0) {
            return 0;
        }
        int fontList = font.handle;
        String codePage = font.codePage;
        byte[] textBuffer = Converter.wcsToMbcs(codePage, string, true);
        int xmString = OS.XmStringGenerate(textBuffer, null, 0, null);
        int width = OS.XmStringWidth(fontList, xmString);
        OS.XmStringFree(xmString);
        return width;
    }

    public void timerExec(int milliseconds, Runnable runnable) {
        int xtContext;
        int timerId;
        this.checkDevice();
        if (runnable == null) {
            this.error(4);
        }
        if (this.timerList == null) {
            this.timerList = new Runnable[4];
        }
        if (this.timerIds == null) {
            this.timerIds = new int[4];
        }
        int index = 0;
        while (index < this.timerList.length) {
            if (this.timerList[index] == runnable) break;
            ++index;
        }
        if (index != this.timerList.length) {
            OS.XtRemoveTimeOut(this.timerIds[index]);
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (milliseconds < 0) {
                return;
            }
        } else {
            if (milliseconds < 0) {
                return;
            }
            index = 0;
            while (index < this.timerList.length) {
                if (this.timerList[index] == null) break;
                ++index;
            }
            if (index == this.timerList.length) {
                Runnable[] newTimerList = new Runnable[this.timerList.length + 4];
                System.arraycopy(this.timerList, 0, newTimerList, 0, this.timerList.length);
                this.timerList = newTimerList;
                int[] newTimerIds = new int[this.timerIds.length + 4];
                System.arraycopy(this.timerIds, 0, newTimerIds, 0, this.timerIds.length);
                this.timerIds = newTimerIds;
            }
        }
        if ((timerId = OS.XtAppAddTimeOut(xtContext = OS.XtDisplayToApplicationContext(this.xDisplay), milliseconds, this.timerProc, index)) != 0) {
            this.timerIds[index] = timerId;
            this.timerList[index] = runnable;
        }
    }

    int timerProc(int index, int id) {
        if (this.timerList == null) {
            return 0;
        }
        if (index >= 0 && index < this.timerList.length) {
            Runnable runnable = this.timerList[index];
            this.timerList[index] = null;
            this.timerIds[index] = 0;
            if (runnable != null) {
                runnable.run();
            }
        }
        return 0;
    }

    static int translateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][0] == key) {
                return KeyTable[i][1];
            }
            ++i;
        }
        return 0;
    }

    static int untranslateKey(int key) {
        int i = 0;
        while (i < KeyTable.length) {
            if (KeyTable[i][1] == key) {
                return KeyTable[i][0];
            }
            ++i;
        }
        return 0;
    }

    public void update() {
        this.checkDevice();
        int event = OS.XtMalloc(96);
        int mask = 1998848;
        OS.XSync(this.xDisplay, false);
        OS.XSync(this.xDisplay, false);
        while (OS.XCheckMaskEvent(this.xDisplay, mask, event)) {
            OS.XtDispatchEvent(event);
        }
        OS.XtFree(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wake() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.graphics.Device");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (this.isDisposed()) {
                this.error(45);
            }
            if (this.thread == Thread.currentThread()) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
            this.wakeThread();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    void wakeThread() {
        while (OS.write(this.write_fd, this.wake_buffer, 1) != 1) {
        }
    }

    int wakeProc(int closure, int source, int id) {
        while (OS.read(this.read_fd, this.wake_buffer, 1) != 1) {
        }
        return 0;
    }

    static int wcsToMbcs(char ch) {
        return Display.wcsToMbcs(ch, null);
    }

    static int wcsToMbcs(char ch, String codePage) {
        int key = ch & 0xFFFF;
        if (key <= 127) {
            return ch;
        }
        byte[] buffer = Converter.wcsToMbcs(codePage, new char[]{ch}, false);
        if (buffer.length == 1) {
            return (char)buffer[0];
        }
        if (buffer.length == 2) {
            return (char)((buffer[0] & 0xFF) << 8 | buffer[1] & 0xFF);
        }
        return 0;
    }

    int windowTimerProc(int handle, int id) {
        Widget widget = this.getWidget(handle);
        if (widget == null) {
            return 0;
        }
        return widget.timerProc(id);
    }

    int windowProc(int w, int client_data, int call_data, int continue_to_dispatch) {
        Widget widget = this.getWidget(w);
        if (widget == null) {
            return 0;
        }
        return widget.windowProc(w, client_data, call_data, continue_to_dispatch);
    }

    String wrapText(String text, Font font, int width) {
        String Lf = "\n";
        text = this.convertToLf(text);
        int length = text.length();
        if (width <= 0 || length == 0 || length == 1) {
            return text;
        }
        StringBuffer result = new StringBuffer();
        int lineStart = 0;
        int lineEnd = 0;
        while (lineStart < length) {
            boolean noLf;
            lineEnd = text.indexOf(Lf, lineStart);
            boolean bl = noLf = lineEnd == -1;
            if (noLf) {
                lineEnd = length;
            }
            int nextStart = lineEnd + Lf.length();
            while (lineEnd > lineStart + 1 && Compatibility.isWhitespace(text.charAt(lineEnd - 1))) {
                --lineEnd;
            }
            int wordStart = lineStart;
            int wordEnd = lineStart;
            int i = lineStart;
            while (i < lineEnd) {
                int lastStart = wordStart;
                int lastEnd = wordEnd;
                wordStart = i;
                while (i < lineEnd && !Compatibility.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                wordEnd = i - 1;
                String line = text.substring(lineStart, wordEnd + 1);
                int lineWidth = this.textWidth(line, font);
                while (i < lineEnd && Compatibility.isWhitespace(text.charAt(i))) {
                    ++i;
                }
                if (lineWidth <= width) continue;
                if (lastStart == wordStart) {
                    while (wordStart < wordEnd) {
                        line = text.substring(lineStart, wordStart + 1);
                        lineWidth = this.textWidth(line, font);
                        if (lineWidth >= width) break;
                        ++wordStart;
                    }
                    if (wordStart == lastStart) {
                        ++wordStart;
                    }
                    lastEnd = wordStart - 1;
                }
                line = text.substring(lineStart, lastEnd + 1);
                result.append(line);
                result.append(Lf);
                i = wordStart;
                lineStart = wordStart;
                wordEnd = wordStart;
            }
            if (lineStart < lineEnd) {
                result.append(text.substring(lineStart, lineEnd));
            }
            if (!noLf) {
                result.append(Lf);
            }
            lineStart = nextStart;
        }
        return result.toString();
    }
}

