/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.sql;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;

public class SQLExecutor
extends AbstractScriptExecutor {
    private static final String SQL_MODULE_NAME_CANNOT_BE_NULL = "SQL module name cannot be null.";
    private static final Logger logger = Logger.getLogger(SQLExecutor.class);
    private IRepository repository;
    private String[] rootPaths;
    private Map<String, Object> defaultVariables;

    public SQLExecutor(IRepository repository, String ... rootPaths) {
        this.repository = repository;
        this.rootPaths = rootPaths;
        this.defaultVariables = new HashMap<String, Object>();
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        String result = null;
        try {
            logger.debug("entering: executeServiceModule()");
            logger.debug("module=" + module);
            if (module == null) {
                throw new IOException(SQL_MODULE_NAME_CANNOT_BE_NULL);
            }
            String sqlSource = new String(this.retrieveModule(this.repository, module, "", this.rootPaths).getContent());
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(request);
            Connection connection = null;
            try {
                connection = dataSource.getConnection();
                PreparedStatement pstmt = connection.prepareStatement(sqlSource);
                ResultSet rs = pstmt.executeQuery();
                ResultSetMetaData rsmd = rs.getMetaData();
                int columnCnt = rsmd.getColumnCount();
                ArrayList<String> columnNames = new ArrayList<String>();
                int i = 1;
                while (i <= columnCnt) {
                    columnNames.add(rsmd.getColumnName(i).toUpperCase());
                    ++i;
                }
                JsonArray array = new JsonArray();
                while (rs.next()) {
                    JsonObject obj = new JsonObject();
                    int i2 = 1;
                    while (i2 <= columnCnt) {
                        String key = (String)columnNames.get(i2 - 1);
                        String value = rs.getString(i2);
                        obj.add(key, (JsonElement)new JsonPrimitive(value != null ? value : ""));
                        ++i2;
                    }
                    array.add((JsonElement)obj);
                }
                result = new Gson().toJson((JsonElement)array);
                rs.close();
                pstmt.close();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new IOException(e);
        }
        return result;
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
        this.defaultVariables.put(name, value);
    }

    protected String getModuleType(String path) {
        return "ScriptingServices";
    }
}

