/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.property.tester;

import java.io.IOException;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.jgit.utils.GitProjectProperties;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public class GitProjectPropertyTest
extends PropertyTester {
    private static final Logger logger = Logger.getLogger(GitProjectProperties.class);

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        boolean result = false;
        boolean inverseForm = false;
        if (expectedValue instanceof Boolean) {
            boolean bl = inverseForm = (Boolean)expectedValue == false;
        }
        if (receiver instanceof IProject) {
            IProject project = (IProject)receiver;
            IRepository repository = RepositoryFacade.getInstance().getRepository();
            String user = CommonIDEParameters.getUserName();
            String projectName = project.getName();
            String gitFilePath = String.format("/db/dirigible/users/%s/git/%s/git.property", user, projectName);
            try {
                result = repository.hasResource(gitFilePath);
            }
            catch (IOException e) {
                result = false;
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        if (inverseForm) {
            result = !result;
        }
        return result;
    }
}

