/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.scheduler;

import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.job.JobsSynchronizer;
import org.eclipse.dirigible.runtime.messaging.MessagingSynchronizer;
import org.eclipse.dirigible.runtime.repository.RepositoryHistoryCleanupTask;
import org.eclipse.dirigible.runtime.search.RebuildSearchIndexTask;
import org.eclipse.dirigible.runtime.search.UpdateSearchIndexTask;
import org.eclipse.dirigible.runtime.security.SecuritySynchronizer;
import org.eclipse.dirigible.runtime.task.IRunnableTask;
import org.eclipse.dirigible.runtime.task.TaskManagerLong;
import org.eclipse.dirigible.runtime.task.TaskManagerMedium;
import org.eclipse.dirigible.runtime.task.TaskManagerShort;

public class SchedulerServlet
extends HttpServlet {
    private static final long serialVersionUID = -3775928162856885854L;
    private static final Logger logger = Logger.getLogger(SchedulerServlet.class);
    private static ScheduledExecutorService securitySynchronizerScheduler;
    private static ScheduledExecutorService jobsSynchronizerScheduler;
    private static ScheduledExecutorService messagingSynchronizerScheduler;
    private static ScheduledExecutorService taskManagerShortScheduler;
    private static ScheduledExecutorService taskManagerMediumScheduler;
    private static ScheduledExecutorService taskManagerLongScheduler;
    private static final Object LOCK;
    private static volatile boolean started;

    static {
        LOCK = new Object();
        started = false;
    }

    public void init() throws ServletException {
        super.init();
        this.startSchedulers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startSchedulers() {
        if (!started) {
            Object object = LOCK;
            synchronized (object) {
                if (!started) {
                    logger.debug("entering: " + ((Object)((Object)this)).getClass().getCanonicalName() + " -> " + "contextInitialized");
                    securitySynchronizerScheduler = Executors.newSingleThreadScheduledExecutor();
                    securitySynchronizerScheduler.scheduleAtFixedRate((Runnable)new SecuritySynchronizer(), 1L, 1L, TimeUnit.MINUTES);
                    jobsSynchronizerScheduler = Executors.newSingleThreadScheduledExecutor();
                    jobsSynchronizerScheduler.scheduleAtFixedRate((Runnable)new JobsSynchronizer(), 1L, 1L, TimeUnit.MINUTES);
                    messagingSynchronizerScheduler = Executors.newSingleThreadScheduledExecutor();
                    messagingSynchronizerScheduler.scheduleAtFixedRate((Runnable)new MessagingSynchronizer(), 1L, 1L, TimeUnit.MINUTES);
                    taskManagerShortScheduler = Executors.newSingleThreadScheduledExecutor();
                    taskManagerShortScheduler.scheduleAtFixedRate((Runnable)TaskManagerShort.getInstance(), 10L, 10L, TimeUnit.SECONDS);
                    taskManagerMediumScheduler = Executors.newSingleThreadScheduledExecutor();
                    taskManagerMediumScheduler.scheduleAtFixedRate((Runnable)TaskManagerMedium.getInstance(), 1L, 1L, TimeUnit.MINUTES);
                    taskManagerLongScheduler = Executors.newSingleThreadScheduledExecutor();
                    taskManagerLongScheduler.scheduleAtFixedRate((Runnable)TaskManagerLong.getInstance(), 1L, 1L, TimeUnit.HOURS);
                    this.registerRunnableTasks();
                    started = true;
                    logger.debug("exiting: " + ((Object)((Object)this)).getClass().getCanonicalName() + " -> " + "contextInitialized");
                }
            }
        }
    }

    public void destroy() {
        this.stopSchedulers();
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopSchedulers() {
        if (started) {
            Object object = LOCK;
            synchronized (object) {
                if (started) {
                    logger.debug("entering: " + ((Object)((Object)this)).getClass().getCanonicalName() + " -> " + "contextDestroyed");
                    securitySynchronizerScheduler.shutdownNow();
                    jobsSynchronizerScheduler.shutdownNow();
                    messagingSynchronizerScheduler.shutdownNow();
                    taskManagerShortScheduler.shutdownNow();
                    taskManagerMediumScheduler.shutdownNow();
                    taskManagerLongScheduler.shutdownNow();
                    started = false;
                    logger.debug("exiting: " + ((Object)((Object)this)).getClass().getCanonicalName() + " -> " + "contextDestroyed");
                }
            }
        }
    }

    private void registerRunnableTasks() {
        logger.debug("entering: " + ((Object)((Object)this)).getClass().getCanonicalName() + " -> " + "registerRunnableTasks");
        UpdateSearchIndexTask updateSearchIndexTask = new UpdateSearchIndexTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)updateSearchIndexTask);
        RepositoryHistoryCleanupTask historyCleanupTask = new RepositoryHistoryCleanupTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)historyCleanupTask);
        RebuildSearchIndexTask rebuildSearchIndexTask = new RebuildSearchIndexTask();
        TaskManagerLong.getInstance().registerRunnableTask((IRunnableTask)rebuildSearchIndexTask);
        logger.debug("exiting: " + ((Object)((Object)this)).getClass().getCanonicalName() + " -> " + "registerRunnableTasks");
    }

    public ScheduledExecutorService getSecuritySynchronizerScheduler() {
        return securitySynchronizerScheduler;
    }

    public ScheduledExecutorService getJobsSynchronizerScheduler() {
        return jobsSynchronizerScheduler;
    }

    public ScheduledExecutorService getMessagingSynchronizerScheduler() {
        return messagingSynchronizerScheduler;
    }

    public ScheduledExecutorService getTaskManagerShortScheduler() {
        return taskManagerShortScheduler;
    }

    public ScheduledExecutorService getTaskManagerMediumScheduler() {
        return taskManagerMediumScheduler;
    }

    public ScheduledExecutorService getTaskManagerLongScheduler() {
        return taskManagerLongScheduler;
    }
}

