/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.JavaScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptEngineExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptEngineProvider;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptExecutor;

class JavaScriptExecutorFactoryNonOSGi {
    private static final Logger logger = Logger.getLogger(JavaScriptExecutorFactoryNonOSGi.class);
    private static Map<String, IJavaScriptEngineProvider> javaScriptEngineProviders = Collections.synchronizedMap(new HashMap());
    private static boolean registered = false;
    static String rhinoJavaScriptEngineProvider = "org.eclipse.dirigible.runtime.js.rhino.RhinoJavaScriptEngineProvider";
    static String nashornJavaScriptEngineProvider = "org.eclipse.dirigible.runtime.js.nashorn.NashornJavaScriptEngineProvider";

    static {
        IJavaScriptEngineProvider rhino = JavaScriptExecutorFactoryNonOSGi.createJavaScriptEngineProvider(rhinoJavaScriptEngineProvider);
        javaScriptEngineProviders.put(rhino.getType(), rhino);
        IJavaScriptEngineProvider nashorn = JavaScriptExecutorFactoryNonOSGi.createJavaScriptEngineProvider(nashornJavaScriptEngineProvider);
        javaScriptEngineProviders.put(nashorn.getType(), nashorn);
    }

    JavaScriptExecutorFactoryNonOSGi() {
    }

    public static IJavaScriptEngineExecutor createExecutor(String type, JavaScriptExecutor javaScriptExecutor) throws IOException {
        IJavaScriptEngineProvider javascriptEngineProvider = javaScriptEngineProviders.get(type);
        IJavaScriptEngineExecutor javacriptExecutor = javascriptEngineProvider.create((IJavaScriptExecutor)javaScriptExecutor);
        return javacriptExecutor;
    }

    private static IJavaScriptEngineProvider createJavaScriptEngineProvider(String clazz) {
        try {
            return (IJavaScriptEngineProvider)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

