/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.dirigible.repository.api.IMasterRepository;
import org.eclipse.dirigible.repository.api.IMasterRepositoryProvider;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IRepositoryProvider;
import org.eclipse.dirigible.repository.api.RepositoryCreationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RepositoryFactoryNonOSGi {
    private static final Logger logger = LoggerFactory.getLogger((String)RepositoryFactoryNonOSGi.class.getCanonicalName());
    static IRepositoryProvider localRepositoryProvider;
    static IMasterRepositoryProvider masterRepositoryProvider;
    static List<IRepositoryProvider> repositoryProviders;
    static List<IMasterRepositoryProvider> masterRepositoryProviders;
    static String localRepositoryProviderClass;
    static String dbRepositoryProviderClass;
    static String dbMasterRepositoryProviderClass;
    static String filesystemMasterRepositoryProviderClass;
    static String gitMasterRepositoryProviderClass;
    static String zipMasterRepositoryProviderClass;
    static String jarMasterRepositoryProviderClass;

    static {
        repositoryProviders = new ArrayList<IRepositoryProvider>();
        masterRepositoryProviders = new ArrayList<IMasterRepositoryProvider>();
        localRepositoryProviderClass = "org.eclipse.dirigible.repository.local.LocalRepositoryProvider";
        dbRepositoryProviderClass = "org.eclipse.dirigible.repository.db.DBRepositoryProvider";
        dbMasterRepositoryProviderClass = "org.eclipse.dirigible.repository.db.DBMasterRepositoryProvider";
        filesystemMasterRepositoryProviderClass = "org.eclipse.dirigible.repository.local.FileSystemMasterRepositoryProvider";
        gitMasterRepositoryProviderClass = "org.eclipse.dirigible.repository.git.GitMasterRepositoryProvider";
        zipMasterRepositoryProviderClass = "org.eclipse.dirigible.repository.local.ZipMasterRepositoryProvider";
        jarMasterRepositoryProviderClass = "org.eclipse.dirigible.repository.local.JarMasterRepositoryProvider";
        repositoryProviders.add(RepositoryFactoryNonOSGi.createRepositoryProvider(localRepositoryProviderClass));
        repositoryProviders.add(RepositoryFactoryNonOSGi.createRepositoryProvider(dbRepositoryProviderClass));
        masterRepositoryProviders.add(RepositoryFactoryNonOSGi.createMasterRepositoryProvider(dbMasterRepositoryProviderClass));
        masterRepositoryProviders.add(RepositoryFactoryNonOSGi.createMasterRepositoryProvider(filesystemMasterRepositoryProviderClass));
        masterRepositoryProviders.add(RepositoryFactoryNonOSGi.createMasterRepositoryProvider(gitMasterRepositoryProviderClass));
        masterRepositoryProviders.add(RepositoryFactoryNonOSGi.createMasterRepositoryProvider(zipMasterRepositoryProviderClass));
        masterRepositoryProviders.add(RepositoryFactoryNonOSGi.createMasterRepositoryProvider(jarMasterRepositoryProviderClass));
    }

    RepositoryFactoryNonOSGi() {
    }

    public static IRepository createRepository(Map<String, Object> parameters) throws RepositoryCreationException {
        String defaultRepositoryProvider = System.getProperty("repositoryProvider");
        if (defaultRepositoryProvider == null) {
            defaultRepositoryProvider = "local";
        }
        for (IRepositoryProvider repositoryProvider : repositoryProviders) {
            if (!repositoryProvider.getType().equals(defaultRepositoryProvider)) continue;
            logger.info(String.format("Repository Provider used is: %s", repositoryProvider.getType()));
            localRepositoryProvider = repositoryProvider;
        }
        IRepository repository = localRepositoryProvider.createRepository(parameters);
        return repository;
    }

    public static IMasterRepository createMasterRepository(Map<String, Object> parameters) throws RepositoryCreationException {
        String defaultMasterRepositoryProvider = System.getProperty("repositoryProviderMaster");
        for (IMasterRepositoryProvider repositoryProvider : masterRepositoryProviders) {
            if (!repositoryProvider.getType().equals(defaultMasterRepositoryProvider)) continue;
            logger.info(String.format("Master Repository Provider used is: %s", new Object[0]), (Object)repositoryProvider.getType());
            masterRepositoryProvider = repositoryProvider;
        }
        if (masterRepositoryProvider == null) {
            if (masterRepositoryProviders.size() == 0) {
                logger.info("Master Repository Provider has NOT been registered");
            }
            return null;
        }
        IMasterRepository masterRepository = masterRepositoryProvider.createRepository(parameters);
        return masterRepository;
    }

    private static IRepositoryProvider createRepositoryProvider(String clazz) {
        try {
            return (IRepositoryProvider)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static IMasterRepositoryProvider createMasterRepositoryProvider(String clazz) {
        try {
            return (IMasterRepositoryProvider)Class.forName(clazz).newInstance();
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            e.printStackTrace();
            return null;
        }
    }
}

