/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public class TemplateTypesEnumerator {
    private static final Logger logger = Logger.getLogger(TemplateTypesEnumerator.class);

    public static TemplateType[] prepareTemplateTypes(String templatesPath, String category) throws IOException {
        return TemplateTypesEnumerator.prepareTemplateTypes(templatesPath, category, null);
    }

    public static TemplateType[] prepareTemplateTypes(String templatesPath, String category, HttpServletRequest request) throws IOException {
        ArrayList<TemplateType> templateTypesList = new ArrayList<TemplateType>();
        IRepository repository = RepositoryFacade.getInstance().getRepository(request);
        ICollection templatesRoot = repository.getCollection(templatesPath);
        if (!templatesRoot.exists()) {
            return new TemplateType[0];
        }
        for (ICollection templateCollection : templatesRoot.getCollections()) {
            try {
                String type = templateCollection.getName();
                TemplateType templateType = TemplateType.createTemplateType(category, templateCollection.getPath(), type, repository);
                templateTypesList.add(templateType);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return templateTypesList.toArray(new TemplateType[0]);
    }
}

