/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.services.stream;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Properties;
import org.apache.derby.iapi.services.i18n.MessageService;
import org.apache.derby.iapi.services.io.FileUtil;
import org.apache.derby.iapi.services.monitor.ModuleControl;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.services.stream.HeaderPrintWriter;
import org.apache.derby.iapi.services.stream.InfoStreams;
import org.apache.derby.iapi.services.stream.PrintWriterGetHeader;
import org.apache.derby.impl.services.stream.BasicGetLogHeader;
import org.apache.derby.impl.services.stream.BasicHeaderPrintWriter;

public final class SingleStream
implements InfoStreams,
ModuleControl,
PrivilegedAction<HeaderPrintWriter> {
    private HeaderPrintWriter theStream;
    private String PBfileName;
    private PrintWriterGetHeader PBheader;

    @Override
    public void boot(boolean bl, Properties properties) {
        this.theStream = this.makeStream();
    }

    @Override
    public void stop() {
        ((BasicHeaderPrintWriter)this.theStream).complete();
    }

    @Override
    public HeaderPrintWriter stream() {
        return this.theStream;
    }

    private HeaderPrintWriter makeStream() {
        PrintWriterGetHeader printWriterGetHeader = this.makeHeader();
        HeaderPrintWriter headerPrintWriter = this.makeHPW(printWriterGetHeader);
        if (headerPrintWriter == null) {
            headerPrintWriter = this.createDefaultStream(printWriterGetHeader);
        }
        return headerPrintWriter;
    }

    private PrintWriterGetHeader makeHeader() {
        return new BasicGetLogHeader(true, true, null);
    }

    private HeaderPrintWriter makeHPW(PrintWriterGetHeader printWriterGetHeader) {
        String string = PropertyUtil.getSystemProperty("derby.stream.error.style");
        if (string != null) {
            return this.makeStyleHPW(string, printWriterGetHeader);
        }
        string = PropertyUtil.getSystemProperty("derby.stream.error.file");
        if (string != null) {
            return this.makeFileHPW(string, printWriterGetHeader);
        }
        string = PropertyUtil.getSystemProperty("derby.stream.error.method");
        if (string != null) {
            return this.makeMethodHPW(string, printWriterGetHeader, false);
        }
        string = PropertyUtil.getSystemProperty("derby.stream.error.field");
        if (string != null) {
            return this.makeFieldHPW(string, printWriterGetHeader);
        }
        return null;
    }

    private HeaderPrintWriter PBmakeFileHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        Object object;
        boolean bl = PropertyUtil.getSystemBoolean("derby.infolog.append");
        File file = new File(string);
        if (!file.isAbsolute() && (object = Monitor.getMonitor().getEnvironment()) instanceof File) {
            file = new File((File)object, string);
        }
        try {
            object = file.exists() && bl ? new FileOutputStream(file.getPath(), true) : new FileOutputStream(file);
            FileUtil.limitAccessToOwner(file);
        }
        catch (IOException iOException) {
            return this.useDefaultStream(printWriterGetHeader, iOException);
        }
        catch (SecurityException securityException) {
            return this.useDefaultStream(printWriterGetHeader, securityException);
        }
        return new BasicHeaderPrintWriter(new BufferedOutputStream((OutputStream)object), printWriterGetHeader, true, file.getPath());
    }

    private HeaderPrintWriter makeMethodHPW(String string, PrintWriterGetHeader printWriterGetHeader, boolean bl) {
        Throwable throwable;
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        try {
            Class<?> clazz = Class.forName(string2);
            try {
                Method method = clazz.getMethod(string3, new Class[0]);
                if (!Modifier.isStatic(method.getModifiers())) {
                    HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
                    headerPrintWriter.printlnWithHeader(method.toString() + " is not static");
                    return headerPrintWriter;
                }
                try {
                    return this.makeValueHPW(method, method.invoke((Object)null, new Object[0]), printWriterGetHeader, string, bl);
                }
                catch (IllegalAccessException illegalAccessException) {
                    throwable = illegalAccessException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throwable = illegalArgumentException;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = invocationTargetException.getTargetException();
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throwable = noSuchMethodException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throwable = classNotFoundException;
        }
        catch (SecurityException securityException) {
            throwable = securityException;
        }
        return this.useDefaultStream(printWriterGetHeader, throwable);
    }

    private HeaderPrintWriter makeStyleHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        HeaderPrintWriter headerPrintWriter = null;
        if ("rollingFile".equals(string)) {
            String string2 = "org.apache.derby.impl.services.stream.RollingFileStreamProvider.getOutputStream";
            headerPrintWriter = this.makeMethodHPW(string2, printWriterGetHeader, true);
        } else {
            try {
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("unknown derby.stream.error.style: " + string);
                throw illegalArgumentException;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                headerPrintWriter = this.useDefaultStream(printWriterGetHeader, illegalArgumentException);
            }
            catch (Exception exception) {
                headerPrintWriter = this.useDefaultStream(printWriterGetHeader, exception);
            }
        }
        return headerPrintWriter;
    }

    private HeaderPrintWriter makeFieldHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        Exception exception;
        int n = string.lastIndexOf(46);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1, string.length());
        try {
            Class<?> clazz = Class.forName(string2);
            try {
                Field field = clazz.getField(string3);
                if (!Modifier.isStatic(field.getModifiers())) {
                    HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
                    headerPrintWriter.printlnWithHeader(field.toString() + " is not static");
                    return headerPrintWriter;
                }
                try {
                    return this.makeValueHPW(field, field.get(null), printWriterGetHeader, string, false);
                }
                catch (IllegalAccessException illegalAccessException) {
                    exception = illegalAccessException;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    exception = illegalArgumentException;
                }
            }
            catch (NoSuchFieldException noSuchFieldException) {
                exception = noSuchFieldException;
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            exception = classNotFoundException;
        }
        catch (SecurityException securityException) {
            exception = securityException;
        }
        return this.useDefaultStream(printWriterGetHeader, exception);
    }

    private HeaderPrintWriter makeValueHPW(Member member, Object object, PrintWriterGetHeader printWriterGetHeader, String string, boolean bl) {
        if (object instanceof OutputStream) {
            return new BasicHeaderPrintWriter((OutputStream)object, printWriterGetHeader, bl, string);
        }
        if (object instanceof Writer) {
            return new BasicHeaderPrintWriter((Writer)object, printWriterGetHeader, bl, string);
        }
        HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
        if (object == null) {
            headerPrintWriter.printlnWithHeader(member.toString() + "=null");
        } else {
            headerPrintWriter.printlnWithHeader(member.toString() + " instanceof " + object.getClass().getName());
        }
        return headerPrintWriter;
    }

    private HeaderPrintWriter createDefaultStream(PrintWriterGetHeader printWriterGetHeader) {
        return this.makeFileHPW("derby.log", printWriterGetHeader);
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader printWriterGetHeader) {
        return new BasicHeaderPrintWriter(System.err, printWriterGetHeader, false, "System.err");
    }

    private HeaderPrintWriter useDefaultStream(PrintWriterGetHeader printWriterGetHeader, Throwable throwable) {
        HeaderPrintWriter headerPrintWriter = this.useDefaultStream(printWriterGetHeader);
        while (throwable != null) {
            Throwable throwable2 = throwable.getCause();
            String string = MessageService.getTextMessage("N001", new Object[0]);
            headerPrintWriter.printlnWithHeader(throwable.toString() + (throwable2 != null ? " " + string : ""));
            throwable = throwable2;
        }
        return headerPrintWriter;
    }

    private HeaderPrintWriter makeFileHPW(String string, PrintWriterGetHeader printWriterGetHeader) {
        this.PBfileName = string;
        this.PBheader = printWriterGetHeader;
        return AccessController.doPrivileged(this);
    }

    @Override
    public final HeaderPrintWriter run() {
        return this.PBmakeFileHPW(this.PBfileName, this.PBheader);
    }
}

