/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js.nashorn;

import java.io.IOException;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jdk.nashorn.api.scripting.NashornScriptEngine;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.nashorn.NashornRepositoryModuleSourceProvider;
import org.eclipse.dirigible.runtime.scripting.IBaseScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptEngineExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptExecutor;

public class NashornJavaScriptEngineExecutor
implements IJavaScriptEngineExecutor {
    private static final Logger logger = Logger.getLogger(NashornJavaScriptEngineExecutor.class);
    private IJavaScriptExecutor javaScriptExecutor;

    public NashornJavaScriptEngineExecutor(IJavaScriptExecutor javaScriptExecutor) {
        this.javaScriptExecutor = javaScriptExecutor;
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        Object result;
        block6: {
            logger.debug("entering: executeServiceModule()");
            logger.debug("module=" + module);
            if (module == null) {
                throw new IOException("JavaScript module name cannot be null");
            }
            result = null;
            ScriptEngineManager engineManager = new ScriptEngineManager();
            NashornScriptEngine engine = (NashornScriptEngine)engineManager.getEngineByName("nashorn");
            try {
                NashornRepositoryModuleSourceProvider sourceProvider = this.createRepositoryModuleSourceProvider();
                Bindings bindings = engine.getBindings(100);
                bindings.put("SourceProvider", (Object)sourceProvider);
                bindings.put("engine", (Object)"nashorn");
                this.javaScriptExecutor.registerDefaultVariables(request, response, input, executionContext, this.javaScriptExecutor.getRepository(), (Object)bindings);
                this.javaScriptExecutor.beforeExecution(request, response, module, (Object)bindings);
                String code = sourceProvider.loadSource(module);
                try {
                    engine.eval("var Require = (function(modulePath) {\tvar _loadedModules = {}; var _require = function(path) { var moduleInfo, buffered, head = '(function(exports,module,require){ ', code = '', tail = '})', line = null; moduleInfo = _loadedModules[path]; if (moduleInfo) {   return moduleInfo; } code = SourceProvider.loadSource(path); moduleInfo = {   loaded : false,   id : path,   exports : {},   require : _requireClosure() }; code = head + code + tail; _loadedModules[path] = moduleInfo; var compiledWrapper = null; try {   compiledWrapper = eval(code); } catch (e) {   throw new Error('Error evaluating module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } var parameters = [ moduleInfo.exports, /* exports */   moduleInfo, /* module */   moduleInfo.require /* require */ ]; try {   compiledWrapper.apply(moduleInfo.exports, /* this */   parameters); } catch (e) {   throw new Error('Error executing module ' + path + ' line #' + e.lineNumber + ' : ' + e.message, path, e.lineNumber); } moduleInfo.loaded = true; return moduleInfo;};var _requireClosure = function() {  return function(path) {  var module = _require(path);  return module.exports; };};return _requireClosure();});var require = Require();");
                    engine.eval("load(\"nashorn:mozilla_compat.js\");");
                    result = engine.eval(code);
                }
                catch (ScriptException e) {
                    if (e.getMessage() != null && e.getMessage().contains("\"exports\" is not defined")) {
                        result = "Requested endpoint is not a service, but rather a library.";
                        logger.error(e.getMessage());
                        break block6;
                    }
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
        logger.debug("exiting: executeServiceModule()");
        return result;
    }

    private NashornRepositoryModuleSourceProvider createRepositoryModuleSourceProvider() {
        NashornRepositoryModuleSourceProvider repositoryModuleSourceProvider = null;
        repositoryModuleSourceProvider = new NashornRepositoryModuleSourceProvider((IBaseScriptExecutor)this.javaScriptExecutor, this.javaScriptExecutor.getRepository(), this.javaScriptExecutor.getRootPaths());
        return repositoryModuleSourceProvider;
    }
}

