/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.cmis;

import java.io.IOException;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.runtime.cmis.CmisSession;
import org.eclipse.dirigible.runtime.cmis.ObjectType;

public class CmisObject {
    private CmisSession session;
    private IEntity internalEntity;
    private boolean typeCollection = false;

    public CmisObject(CmisSession session, String path) throws IOException {
        this.session = session;
        path = this.sanitize(path);
        IRepository repository = (IRepository)session.getCmisRepository().getInternalObject();
        if (repository.hasCollection(path)) {
            this.internalEntity = repository.getCollection(path);
            this.typeCollection = true;
        } else if (repository.hasResource(path)) {
            this.internalEntity = repository.getResource(path);
            this.typeCollection = false;
        }
    }

    protected String sanitize(String path) {
        return path.replace("\\", "");
    }

    public IEntity getInternalEntity() {
        return this.internalEntity;
    }

    public String getId() {
        return this.getInternalEntity().getPath();
    }

    public String getName() {
        if ("".equals(this.getInternalEntity().getName())) {
            return "root";
        }
        return this.getInternalEntity().getName();
    }

    public ObjectType getType() {
        return this.isCollection() ? ObjectType.FOLDER : ObjectType.DOCUMENT;
    }

    protected boolean isCollection() {
        return this.typeCollection;
    }

    public void delete() throws IOException {
        this.getInternalEntity().delete();
    }

    public void delete(boolean allVersions) throws IOException {
        this.delete();
    }

    public void rename(String newName) throws IOException {
        this.getInternalEntity().renameTo(newName);
    }
}

