/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.util.ArrayList;
import org.eclipse.dirigible.ide.db.viewer.views.IDbConnectionFactory;
import org.eclipse.dirigible.ide.db.viewer.views.TreeObject;

public class TreeParent
extends TreeObject {
    private ArrayList<TreeObject> children;
    private IDbConnectionFactory connectionFactory;

    public TreeParent(String name, IDbConnectionFactory connectionFactory) {
        super(name);
        this.connectionFactory = connectionFactory;
        this.children = new ArrayList();
    }

    public void addChild(TreeObject child) {
        this.children.add(child);
        child.setParent(this);
    }

    public void removeChild(TreeObject child) {
        this.children.remove(child);
        child.setParent(null);
    }

    public TreeObject[] getChildren() {
        return this.children.toArray(new TreeObject[this.children.size()]);
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public IDbConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    @Override
    public int hashCode() {
        int toCode = super.hashCode();
        if (this.children != null && this.children.size() > 0) {
            for (TreeObject to : this.children) {
                toCode += to != null ? to.hashCode() : 0;
            }
        }
        return toCode;
    }

    @Override
    public boolean equals(Object arg0) {
        if (!TreeParent.class.isInstance(arg0)) {
            return false;
        }
        TreeParent tp = (TreeParent)arg0;
        if (super.equals(arg0)) {
            boolean compareChildren = this.compareChildren(tp.getChildren(), this.getChildren());
            return compareChildren;
        }
        return false;
    }

    private boolean compareChildren(TreeObject[] childrenHome, TreeObject[] childrenAway) {
        if (childrenAway != null && childrenHome != null) {
            if (childrenAway.length == childrenHome.length) {
                boolean f = false;
                TreeObject[] treeObjectArray = childrenAway;
                int n = childrenAway.length;
                int n2 = 0;
                while (n2 < n) {
                    TreeObject treeObjectA = treeObjectArray[n2];
                    f = false;
                    TreeObject[] treeObjectArray2 = childrenHome;
                    int n3 = childrenHome.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        TreeObject treeObjectH = treeObjectArray2[n4];
                        if (TreeParent.class.isInstance(treeObjectH) && TreeParent.class.isInstance(treeObjectA)) {
                            f = treeObjectA.getName().equals(treeObjectH.getName());
                        } else {
                            boolean bl = f = treeObjectH != null && treeObjectH.equals(treeObjectA);
                        }
                        if (f) break;
                        ++n4;
                    }
                    if (!f) {
                        return false;
                    }
                    ++n2;
                }
                return true;
            }
        } else {
            return childrenHome == childrenAway;
        }
        return false;
    }
}

