/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.api;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IRepositoryProvider;
import org.eclipse.dirigible.repository.api.RepositoryActivator;
import org.eclipse.dirigible.repository.api.RepositoryCreationException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class RepositoryFactory {
    static IRepositoryProvider repositoryProvider;

    static {
        RepositoryFactory.registerServices();
    }

    private static void registerServices() {
        try {
            BundleContext context = RepositoryActivator.getContext();
            Collection serviceReferences = context.getServiceReferences(IRepositoryProvider.class, null);
            Iterator iterator = serviceReferences.iterator();
            if (iterator.hasNext()) {
                ServiceReference serviceReference = (ServiceReference)iterator.next();
                repositoryProvider = (IRepositoryProvider)context.getService(serviceReference);
            }
        }
        catch (InvalidSyntaxException e) {
            e.printStackTrace();
        }
    }

    public static IRepository createRepository(Map<String, Object> parameters) throws RepositoryCreationException {
        if (repositoryProvider == null) {
            RepositoryFactory.registerServices();
            if (repositoryProvider == null) {
                throw new RepositoryCreationException("Repository provider has NOT been registered");
            }
        }
        return repositoryProvider.createRepository(parameters);
    }
}

