/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.StringTokenizer;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.ext.db.dialect.DerbyDBSpecifier;
import org.eclipse.dirigible.repository.ext.db.dialect.HANADBSpecifier;
import org.eclipse.dirigible.repository.ext.db.dialect.IDialectSpecifier;
import org.eclipse.dirigible.repository.ext.db.dialect.PostgreSQLDBSpecifier;
import org.eclipse.dirigible.repository.ext.db.dialect.SAPDBSpecifier;
import org.eclipse.dirigible.repository.ext.db.dialect.SybaseDBSpecifier;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBUtils {
    private static final String PRODUCT_DERBY = "Apache Derby";
    private static final String PRODUCT_SYBASE = "Adaptive Server Enterprise";
    private static final String PRODUCT_SAP_DB = "SAP DB";
    private static final String PRODUCT_HDB = "HDB";
    private static final String PRODUCT_POSTGRESQL = "PostgreSQL";
    public static final String SCRIPT_DELIMITER = ";";
    private static Logger logger = Logger.getLogger((String)DBUtils.class.getCanonicalName());
    private DataSource dataSource;

    public DBUtils(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    /*
     * Loose catch block
     */
    public String readScript(Connection conn, String path, Class<?> clazz) throws IOException {
        String sql;
        block25: {
            logger.debug("entering readScript");
            sql = null;
            InputStream in = clazz.getResourceAsStream(path);
            if (in == null) {
                throw new IOException("SQL script does not exist: " + path);
            }
            BufferedInputStream bufferedInput = null;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PrintWriter writer = new PrintWriter(baos);
            byte[] buffer = new byte[1024];
            try {
                bufferedInput = new BufferedInputStream(in);
                int bytesRead = 0;
                while ((bytesRead = bufferedInput.read(buffer)) != -1) {
                    String chunk = new String(buffer, 0, bytesRead, Charset.defaultCharset());
                    writer.write(chunk);
                }
                writer.flush();
                sql = new String(baos.toByteArray(), Charset.defaultCharset());
                String productName = conn.getMetaData().getDatabaseProductName();
                IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier(productName);
                sql = dialectSpecifier.specify(sql);
            }
            catch (FileNotFoundException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                try {
                    if (bufferedInput != null) {
                        bufferedInput.close();
                    }
                    break block25;
                }
                catch (IOException ex2) {
                    logger.error(ex2.getMessage(), (Throwable)ex2);
                }
                break block25;
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                break block25;
            }
            catch (SQLException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    if (bufferedInput != null) {
                        bufferedInput.close();
                    }
                    break block25;
                }
                catch (IOException ex3) {
                    logger.error(ex3.getMessage(), (Throwable)ex3);
                }
                break block25;
            }
            {
                finally {
                    try {
                        if (bufferedInput != null) {
                            bufferedInput.close();
                        }
                    }
                    catch (IOException ex) {
                        logger.error(ex.getMessage(), (Throwable)ex);
                    }
                }
            }
            try {
                if (bufferedInput != null) {
                    bufferedInput.close();
                }
            }
            catch (IOException ex) {
                logger.error(ex.getMessage(), (Throwable)ex);
            }
        }
        logger.debug("exiting readScript");
        return sql;
    }

    public boolean executeUpdate(Connection connection, String script) {
        logger.debug("entering executeUpdate");
        boolean status = false;
        StringTokenizer tokenizer = new StringTokenizer(script, SCRIPT_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            block15: {
                String line = tokenizer.nextToken();
                if ("".equals(line.trim())) continue;
                PreparedStatement preparedStatement = null;
                try {
                    try {
                        preparedStatement = connection.prepareStatement(line);
                        preparedStatement.execute();
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.error(line);
                        if (preparedStatement != null) {
                            try {
                                preparedStatement.close();
                            }
                            catch (SQLException e2) {
                                logger.error(e2.getMessage(), (Throwable)e2);
                            }
                        }
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    throw throwable;
                }
                if (preparedStatement != null) {
                    try {
                        preparedStatement.close();
                    }
                    catch (SQLException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            status = true;
        }
        logger.debug("exiting executeUpdate");
        return status;
    }

    public PreparedStatement getPreparedStatement(Connection connection, String sql) throws SQLException {
        logger.debug("entering getPreparedStatement");
        PreparedStatement preparedStatement = connection.prepareStatement(sql);
        logger.debug("exiting getPreparedStatement");
        return preparedStatement;
    }

    public Connection getConnection() throws SQLException {
        logger.debug("entering getConnection");
        Connection connection = this.dataSource.getConnection();
        logger.debug("exiting getConnection");
        return connection;
    }

    public void closeConnection(Connection connection) {
        logger.debug("entering closeConnection");
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.debug("exiting closeConnection");
    }

    public void closeStatement(Statement statement) {
        logger.debug("entering closeStatement");
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
        logger.debug("exiting closeStatement");
    }

    public static IDialectSpecifier getDialectSpecifier(String productName) {
        if (productName != null) {
            if (PRODUCT_HDB.equals(productName)) {
                return new HANADBSpecifier();
            }
            if (PRODUCT_SAP_DB.equals(productName)) {
                return new SAPDBSpecifier();
            }
            if (PRODUCT_SYBASE.equals(productName)) {
                return new SybaseDBSpecifier();
            }
            if (PRODUCT_DERBY.equals(productName)) {
                return new DerbyDBSpecifier();
            }
            if (PRODUCT_POSTGRESQL.equals(productName)) {
                return new PostgreSQLDBSpecifier();
            }
        }
        return new HANADBSpecifier();
    }

    public String specifyDataType(Connection connection, String commonType) throws SQLException {
        String productName = connection.getMetaData().getDatabaseProductName();
        IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier(productName);
        return dialectSpecifier.getSpecificType(commonType);
    }

    public static byte[] dbToData(ResultSet resultSet) throws SQLException {
        String data = resultSet.getString("DOC_CONTENT");
        return data.getBytes(Charset.defaultCharset());
    }

    public static byte[] dbToDataBinary(Connection connection, ResultSet resultSet, String columnName) throws SQLException, IOException {
        String productName = connection.getMetaData().getDatabaseProductName();
        IDialectSpecifier dialectSpecifier = DBUtils.getDialectSpecifier(productName);
        InputStream is = dialectSpecifier.getBinaryStream(resultSet, columnName);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)is, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        return bytes;
    }
}

