/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.datasource;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.derby.jdbc.EmbeddedDataSource;
import org.eclipse.dirigible.ide.common.CommonParameters;
import org.eclipse.dirigible.ide.datasource.Messages;
import org.eclipse.dirigible.repository.ext.db.WrappedDataSource;
import org.eclipse.dirigible.repository.logging.Logger;

public class DataSourceFacade {
    private static final String EMPTY = "";
    private static final String EMBEDDED_DATA_SOURCE_IS_USED = Messages.DataSourceFacade_EMBEDDED_DATA_SOURCE_IS_USED;
    private static final String LOCAL_DB_ACTION = "create";
    private static final String LOCAL_DB_NAME = "derby";
    private static final String DATASOURCE_DEFAULT = "DEFAULT_DATASOURCE";
    public static final Logger logger = Logger.getLogger((String)DataSourceFacade.class.getCanonicalName());
    private static DataSource localDataSource;
    private static DataSourceFacade instance;
    private WrappedDataSource dataSource;

    public static DataSourceFacade getInstance() {
        if (instance == null) {
            instance = new DataSourceFacade();
        }
        return instance;
    }

    public DataSource getDataSource() {
        if (this.dataSource == null) {
            this.dataSource = this.getFromSession();
            if (this.dataSource == null) {
                this.dataSource = this.createLocal();
            }
            this.populateMetaData((DataSource)this.dataSource);
        }
        return this.dataSource;
    }

    private WrappedDataSource getFromSession() {
        DataSource dataSource = null;
        dataSource = (DataSource)CommonParameters.getObject((String)DATASOURCE_DEFAULT);
        if (dataSource != null) {
            WrappedDataSource wrappedDataSource = new WrappedDataSource(dataSource);
            return wrappedDataSource;
        }
        return null;
    }

    private WrappedDataSource createLocal() {
        localDataSource = (DataSource)System.getProperties().get(LOCAL_DB_NAME);
        if (localDataSource == null) {
            localDataSource = new EmbeddedDataSource();
            ((EmbeddedDataSource)localDataSource).setDatabaseName(LOCAL_DB_NAME);
            ((EmbeddedDataSource)localDataSource).setCreateDatabase(LOCAL_DB_ACTION);
            System.getProperties().put(LOCAL_DB_NAME, localDataSource);
        }
        logger.warn(EMBEDDED_DATA_SOURCE_IS_USED);
        WrappedDataSource wrappedDataSource = new WrappedDataSource(localDataSource);
        return wrappedDataSource;
    }

    private void populateMetaData(DataSource dataSource) {
        Connection connection = null;
        try {
            try {
                connection = dataSource.getConnection();
                DatabaseMetaData metaData = connection.getMetaData();
                CommonParameters.set((String)"DATABASE_PRODUCT_NAME", (String)metaData.getDatabaseProductName());
                CommonParameters.set((String)"DATABASE_PRODUCT_VERSION", (String)metaData.getDatabaseProductVersion());
                CommonParameters.set((String)"DATABASE_MINOR_VERSION", (String)String.valueOf(metaData.getDatabaseMinorVersion()));
                CommonParameters.set((String)"DATABASE_MAJOR_VERSION", (String)String.valueOf(metaData.getDatabaseMajorVersion()));
                CommonParameters.set((String)"DATABASE_DRIVER_NAME", (String)metaData.getDriverName());
                CommonParameters.set((String)"DATABASE_DRIVER_MINOR_VERSION", (String)String.valueOf(metaData.getDriverMinorVersion()));
                CommonParameters.set((String)"DATABASE_DRIVER_MAJOR_VERSION", (String)String.valueOf(metaData.getDriverMajorVersion()));
                CommonParameters.set((String)"DATABASE_CONNECTION_CLASS_NAME", (String)connection.getClass().getCanonicalName());
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }
}

