/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.impl;

import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.resources.FileInfoMatcherDescription;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceFilterDescription;
import org.eclipse.core.resources.IResourceProxyVisitor;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.workspace.impl.File;
import org.eclipse.dirigible.ide.workspace.impl.Folder;
import org.eclipse.dirigible.ide.workspace.impl.Messages;
import org.eclipse.dirigible.ide.workspace.impl.Resource;
import org.eclipse.dirigible.ide.workspace.impl.Workspace;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;

public class Container
extends Resource
implements IContainer {
    private static final String COULD_NOT_GET_MEMBERS = Messages.Container_COULD_NOT_GET_MEMBERS;
    private static final String THE_FOLDER_PATH_MUST_HAVE_AT_LEAST_TWO_SEGMENTS = Messages.Container_THE_FOLDER_PATH_MUST_HAVE_AT_LEAST_TWO_SEGMENTS;
    private static final String THE_FILE_PATH_MUST_HAVE_AT_LEAST_TWO_SEGMENTS = Messages.Container_THE_FILE_PATH_MUST_HAVE_AT_LEAST_TWO_SEGMENTS;
    private String defaultCharset = "UTF-8";
    private static final Logger logger = Logger.getLogger(Container.class);

    public Container(IPath path, Workspace workspace) {
        super(path, workspace);
    }

    @Override
    public IEntity getEntity() {
        IRepository repository = this.getRepository();
        IWorkspaceRoot root = this.workspace.getRoot();
        IPath fullPath = root.getLocation().append(this.path);
        return repository.getCollection(fullPath.toString());
    }

    public IResourceFilterDescription createFilter(int type, FileInfoMatcherDescription matcherDescription, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public boolean exists(IPath childPath) {
        IPath location = this.getLocation().append(childPath);
        return this.workspace.hasResource(location);
    }

    public IFile[] findDeletedMembersWithHistory(int depth, IProgressMonitor monitor) throws CoreException {
        return new IFile[0];
    }

    public IResource findMember(String name) {
        return this.findMember(name, false);
    }

    public IResource findMember(IPath path) {
        return this.findMember(path, false);
    }

    public IResource findMember(String name, boolean phantom) {
        IPath resourcePath = this.getLocation().append(name);
        IResource resource = this.workspace.newResource(resourcePath);
        if (resource == null || !resource.exists()) {
            return null;
        }
        return resource;
    }

    public IResource findMember(IPath path, boolean phantom) {
        IPath resourcePath = this.getLocation().append(path);
        IResource resource = this.workspace.newResource(resourcePath);
        if (resource == null || !resource.exists()) {
            return null;
        }
        return resource;
    }

    public String getDefaultCharset() throws CoreException {
        return this.getDefaultCharset(true);
    }

    public String getDefaultCharset(boolean checkImplicit) throws CoreException {
        return this.defaultCharset;
    }

    public IFile getFile(IPath path) {
        IPath resourcePath = this.path.append(path);
        if (resourcePath.segmentCount() < 2) {
            throw new IllegalArgumentException(String.format(THE_FILE_PATH_MUST_HAVE_AT_LEAST_TWO_SEGMENTS, resourcePath.toString()));
        }
        return new File(resourcePath, this.workspace);
    }

    public IResourceFilterDescription[] getFilters() throws CoreException {
        return new IResourceFilterDescription[0];
    }

    public IFolder getFolder(IPath path) {
        IPath resourcePath = this.path.append(path);
        if (resourcePath.segmentCount() < 2) {
            throw new IllegalArgumentException(String.format(THE_FOLDER_PATH_MUST_HAVE_AT_LEAST_TWO_SEGMENTS, resourcePath.toString()));
        }
        return new Folder(resourcePath, this.workspace);
    }

    public IResource[] members() throws CoreException {
        return this.members(false);
    }

    public IResource[] members(boolean phantom) throws CoreException {
        return this.members(phantom ? 1 : 0);
    }

    public IResource[] members(int memberFlags) throws CoreException {
        ICollection collection = (ICollection)this.getEntity();
        ArrayList childNames = new ArrayList();
        try {
            childNames.addAll(collection.getCollectionsNames());
            childNames.addAll(collection.getResourcesNames());
        }
        catch (IOException ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new CoreException(Container.createErrorStatus(String.valueOf(COULD_NOT_GET_MEMBERS) + ex.getMessage()));
        }
        ArrayList<IResource> result = new ArrayList<IResource>();
        for (String childName : childNames) {
            result.add(this.workspace.newResource(this.getLocation().append(childName)));
        }
        return result.toArray(new IResource[0]);
    }

    public void removeFilter(IResourceFilterDescription arg0, int arg1, IProgressMonitor arg2) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void setDefaultCharset(String charset) throws CoreException {
        this.setDefaultCharset(charset, null);
    }

    public void setDefaultCharset(String charset, IProgressMonitor monitor) throws CoreException {
        this.defaultCharset = charset;
    }

    public IPathVariableManager getPathVariableManager() {
        return null;
    }

    public void accept(IResourceProxyVisitor visitor, int depth, int memberFlags) throws CoreException {
    }
}

