/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui.specification.ext;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.diffmerge.api.IMatchPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableDiffPolicy;
import org.eclipse.emf.diffmerge.impl.policies.ConfigurableMatchPolicy;
import org.eclipse.emf.diffmerge.ui.Messages;
import org.eclipse.emf.diffmerge.ui.specification.ext.ConfigurableComparisonMethod;
import org.eclipse.emf.diffmerge.ui.util.UIUtil;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class ConfigureComparisonDialog
extends MessageDialog {
    protected final ComparisonMethodConfigurationData _data;

    public ConfigureComparisonDialog(Shell shell_p, ComparisonMethodConfigurationData data_p) {
        super(shell_p, Messages.ConfigureComparisonDialog_Title, null, Messages.ConfigureComparisonDialog_Label, 0, new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        this._data = data_p;
    }

    protected void createAbsoluteMatchingArea(Composite parent_p) {
        Collection<ConfigurableMatchPolicy.MatchCriterionKind> applicableCiteria = this._data.getApplicableCriteria();
        if (applicableCiteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID) || applicableCiteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID)) {
            Group group = new Group(parent_p, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(Messages.ConfigureComparisonDialog_AbsoluteCriteria);
            group.setToolTipText(Messages.ConfigureComparisonDialog_AbsoluteCriteriaTooltip);
            this.createMatchingCriterionArea((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.EXTRINSIC_ID, Messages.ConfigureComparisonDialog_EIDCriterion, Messages.ConfigureComparisonDialog_EIDCriterionTooltip);
            this.createMatchingCriterionArea((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.INTRINSIC_ID, Messages.ConfigureComparisonDialog_IIDCriterion, Messages.ConfigureComparisonDialog_IIDCriterionTooltip);
        }
    }

    protected Control createCustomArea(Composite parent_p) {
        Composite result = new Composite(parent_p, 0);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        result.setLayout((Layout)new GridLayout(1, false));
        this.createMatchingArea(result);
        this.createDifferencingArea(result);
        this.createMergingArea(result);
        return result;
    }

    protected void createDifferencingArea(Composite parent_p) {
        Group group = new Group(parent_p, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.ConfigureComparisonDialog_Differencing);
        this.createIgnoreOrdersArea((Composite)group);
    }

    protected void createIgnoreOrdersArea(Composite parent_p) {
        Button checkBox = new Button(parent_p, 32);
        checkBox.setLayoutData((Object)new GridData(4, 128, true, false));
        checkBox.setText(Messages.ConfigureComparisonDialog_IgnoreOrders);
        checkBox.setSelection(this._data.isIgnoreOrders());
        checkBox.setToolTipText(Messages.ConfigureComparisonDialog_IgnoreOrdersTooltip);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ConfigureComparisonDialog.this._data.setIgnoreOrders(!ConfigureComparisonDialog.this._data.isIgnoreOrders());
            }
        });
    }

    protected void createKeepMatchIDsArea(Composite parent_p) {
        Button checkBox = new Button(parent_p, 32);
        checkBox.setLayoutData((Object)new GridData(4, 128, true, false));
        checkBox.setText(Messages.ConfigureComparisonDialog_KeepMatchData);
        checkBox.setSelection(this._data.isKeepMatchIDs());
        checkBox.setToolTipText(Messages.ConfigureComparisonDialog_KeepMatchDataTooltip);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ConfigureComparisonDialog.this._data.setKeepMatchIDs(!ConfigureComparisonDialog.this._data.isKeepMatchIDs());
            }
        });
    }

    protected Control createLabelWithNote(Composite parent_p, String text_p) {
        Composite composite = new Composite(parent_p, 0);
        composite.setLayoutData((Object)new GridData(16384, 128, false, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.createNoteLabel(composite);
        Label label = new Label(composite, 0);
        label.setText(text_p);
        return composite;
    }

    protected void createMatchingArea(Composite parent_p) {
        Group group = new Group(parent_p, 0);
        group.setLayoutData((Object)new GridData(4, 4, true, true));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setText(Messages.ConfigureComparisonDialog_Matching);
        this.createAbsoluteMatchingArea((Composite)group);
        this.createRelativeMatchingArea((Composite)group);
        if (this._data.getApplicableCriteria().size() > 1) {
            this.createLabelWithNote((Composite)group, Messages.ConfigureComparisonDialog_MatchingTooltip);
        }
        this.createKeepMatchIDsArea((Composite)group);
    }

    protected void createMatchingCriterionArea(Composite parent_p, final ConfigurableMatchPolicy.MatchCriterionKind criterion_p, String label_p, String tooltip_p) {
        if (!this._data.getApplicableCriteria().contains(criterion_p)) {
            return;
        }
        Button checkBox = new Button(parent_p, 32);
        checkBox.setLayoutData((Object)new GridData(4, 128, true, false));
        checkBox.setText(label_p);
        checkBox.setSelection(this._data.useMatchCriterion(criterion_p));
        checkBox.setToolTipText(tooltip_p);
        checkBox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e_p) {
                ConfigureComparisonDialog.this._data.invertMatchCriterionUse(criterion_p);
            }
        });
    }

    protected void createMergingArea(Composite parent_p) {
    }

    protected Label createNoteLabel(Composite parent_p) {
        Label result = new Label(parent_p, 0);
        result.setText(Messages.ConfigureComparisonDialog_Note);
        result.setFont(UIUtil.getBold(result.getFont()));
        return result;
    }

    protected void createRelativeMatchingArea(Composite parent_p) {
        Collection<ConfigurableMatchPolicy.MatchCriterionKind> applicableCiteria = this._data.getApplicableCriteria();
        if (applicableCiteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.NAME) || applicableCiteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.STRUCTURE) || applicableCiteria.contains(ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS)) {
            Group group = new Group(parent_p, 0);
            group.setLayoutData((Object)new GridData(4, 4, true, true));
            group.setLayout((Layout)new GridLayout(1, false));
            group.setText(Messages.ConfigureComparisonDialog_RelativeCriteria);
            group.setToolTipText(Messages.ConfigureComparisonDialog_RelativeCriteriaTooltip);
            this.createMatchingCriterionArea((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.NAME, Messages.ConfigureComparisonDialog_NameCriterion, Messages.ConfigureComparisonDialog_NameCriterionTooltip);
            this.createMatchingCriterionArea((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.STRUCTURE, Messages.ConfigureComparisonDialog_StructureCriterion, Messages.ConfigureComparisonDialog_StructureCriterionTooltip);
            this.createMatchingCriterionArea((Composite)group, ConfigurableMatchPolicy.MatchCriterionKind.SEMANTICS, Messages.ConfigureComparisonDialog_SemanticCriteria, Messages.ConfigureComparisonDialog_SemanticCriteriaTooltip);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ComparisonMethodConfigurationData {
        private boolean _keepMatchIDs;
        private final Set<ConfigurableMatchPolicy.MatchCriterionKind> _applicableCriteria;
        private final Set<ConfigurableMatchPolicy.MatchCriterionKind> _selectedCriteria;
        private boolean _ignoreOrders;

        public ComparisonMethodConfigurationData(ConfigurableComparisonMethod comparisonMethod_p) {
            IMatchPolicy matchPolicy = comparisonMethod_p.getMatchPolicy();
            if (matchPolicy instanceof ConfigurableMatchPolicy) {
                this._keepMatchIDs = matchPolicy.keepMatchIDs();
                this._applicableCriteria = Collections.unmodifiableSet(new HashSet(((ConfigurableMatchPolicy)matchPolicy).getApplicableCriteria()));
                this._selectedCriteria = new HashSet<ConfigurableMatchPolicy.MatchCriterionKind>();
                for (ConfigurableMatchPolicy.MatchCriterionKind criterion : this._applicableCriteria) {
                    if (!((ConfigurableMatchPolicy)matchPolicy).useMatchCriterion(criterion)) continue;
                    this._selectedCriteria.add(criterion);
                }
            } else {
                this._keepMatchIDs = false;
                this._applicableCriteria = Collections.emptySet();
                this._selectedCriteria = this._applicableCriteria;
            }
            ConfigurableDiffPolicy diffPolicy = (ConfigurableDiffPolicy)comparisonMethod_p.getDiffPolicy();
            this._ignoreOrders = diffPolicy.isIgnoreOrders();
        }

        public Collection<ConfigurableMatchPolicy.MatchCriterionKind> getApplicableCriteria() {
            return this._applicableCriteria;
        }

        public void invertMatchCriterionUse(ConfigurableMatchPolicy.MatchCriterionKind criterion_p) {
            if (this._selectedCriteria.contains(criterion_p)) {
                this._selectedCriteria.remove(criterion_p);
            } else {
                this._selectedCriteria.add(criterion_p);
            }
        }

        public boolean isIgnoreOrders() {
            return this._ignoreOrders;
        }

        public boolean isKeepMatchIDs() {
            return this._keepMatchIDs;
        }

        public void setIgnoreOrders(boolean ignore_p) {
            this._ignoreOrders = ignore_p;
        }

        public void setKeepMatchIDs(boolean keep_p) {
            this._keepMatchIDs = keep_p;
        }

        public void setUseMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind criterion_p, boolean use_p) {
            if (use_p) {
                this._selectedCriteria.add(criterion_p);
            } else {
                this._selectedCriteria.remove(criterion_p);
            }
        }

        public boolean useMatchCriterion(ConfigurableMatchPolicy.MatchCriterionKind criterion_p) {
            return this._selectedCriteria.contains(criterion_p);
        }
    }
}

