/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.ui.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPatternRepository;
import org.eclipse.emf.diffmerge.patterns.core.gen.corepatterns.PatternRepository;
import org.eclipse.emf.diffmerge.patterns.repositories.catalogs.operations.OpenCatalogOperation;
import org.eclipse.emf.diffmerge.patterns.ui.actions.AbstractContextualAction;
import org.eclipse.emf.diffmerge.patterns.ui.util.UIUtil;
import org.eclipse.emf.diffmerge.patterns.ui.wizards.PatternWizardDialog;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenCatalogAction
extends AbstractContextualAction<IFile> {
    public OpenCatalogAction() {
        super(IFile.class);
    }

    @Override
    protected void coreRun(List<Object> selection_p) {
        if (!selection_p.isEmpty()) {
            Object context = selection_p.get(0);
            EditingDomain domain = null;
            if (context instanceof IFile) {
                domain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain((IFile)context);
            } else if (context instanceof EObject) {
                domain = CorePatternsPlugin.getDefault().getModelEnvironment().getEditingDomain((EObject)context);
            }
            if (domain instanceof TransactionalEditingDomain) {
                PatternRepository repository;
                ArrayList<PatternRepository> repositories = new ArrayList<PatternRepository>();
                for (Object current : selection_p) {
                    OpenCatalogOperation operation = new OpenCatalogOperation(current, (TransactionalEditingDomain)domain);
                    Collection result = (Collection)this.executeOperation(operation);
                    if (result != null && !result.isEmpty()) {
                        repositories.add((PatternRepository)result.iterator().next());
                    }
                    if (operation.getErrors().isEmpty()) continue;
                    UIUtil.informRepositoryOpeningError(this.getShell(), operation.getErrors());
                    return;
                }
                PatternRepository patternRepository = repository = repositories.isEmpty() ? null : (PatternRepository)repositories.iterator().next();
                if (repository != null) {
                    PatternWizardDialog dialog = new PatternWizardDialog(this.getShell(), this._dialogAndWizardFactory.instantiatePatternBrowsingWizard(domain.getResourceSet(), (IPatternRepository)repository), true, null);
                    dialog.open();
                }
            }
        }
    }

    @Override
    protected boolean mustBeEnabled() {
        return true;
    }
}

