/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.util.structures;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.diffmerge.util.structures.AbstractBinaryRelation;
import org.eclipse.emf.diffmerge.util.structures.FArrayList;
import org.eclipse.emf.diffmerge.util.structures.FHashMap;
import org.eclipse.emf.diffmerge.util.structures.FHashSet;
import org.eclipse.emf.diffmerge.util.structures.IEqualityTester;
import org.eclipse.emf.diffmerge.util.structures.IRangedBinaryRelation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashBinaryRelation<T, U>
extends AbstractBinaryRelation<T, U>
implements IRangedBinaryRelation.Editable<T, U> {
    protected final FHashMap<T, List<U>> _contents = new FHashMap(this.getEqualityTester());

    public HashBinaryRelation(IEqualityTester tester_p) {
        super(tester_p);
    }

    public HashBinaryRelation() {
        this(null);
    }

    @Override
    public boolean add(T source_p, U target_p) {
        assert (source_p != null && target_p != null);
        boolean result = false;
        Object values = (List)this._contents.get(source_p);
        if (values == null) {
            values = new FArrayList(this.getEqualityTester());
            this._contents.put(source_p, values);
        }
        if (!values.contains(target_p)) {
            result = values.add(target_p);
        }
        return result;
    }

    @Override
    public void clear() {
        this._contents.clear();
    }

    @Override
    public List<U> get(T element_p) {
        assert (element_p != null);
        List values = (List)this._contents.get(element_p);
        List result = values == null ? Collections.emptyList() : Collections.unmodifiableList(values);
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this._contents.isEmpty();
    }

    @Override
    public boolean remove(T source_p, U target_p) {
        assert (source_p != null && target_p != null);
        boolean result = false;
        List values = (List)this._contents.get(source_p);
        if (values != null) {
            result = values.remove(target_p);
            if (values.isEmpty()) {
                this._contents.removeKey(source_p);
            }
        }
        return result;
    }

    @Override
    public Collection<T> getSources() {
        return Collections.unmodifiableSet(this._contents.keySet());
    }

    @Override
    public Collection<U> getTargets() {
        FHashSet result = new FHashSet(this.getEqualityTester());
        for (List valueList : this._contents.values()) {
            result.addAll(valueList);
        }
        return Collections.unmodifiableSet(result);
    }

    @Override
    public boolean removeSource(T source_p) {
        assert (source_p != null);
        List values = (List)this._contents.removeKey(source_p);
        boolean result = values != null;
        return result;
    }

    @Override
    public boolean removeTarget(U target_p) {
        boolean result = false;
        FArrayList<T> sources = new FArrayList<T>(this.getSources(), this.getEqualityTester());
        Iterator iterator = sources.iterator();
        while (iterator.hasNext()) {
            Object source = iterator.next();
            boolean bl = result = result || this.remove(source, target_p);
        }
        return result;
    }
}

