/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.diffmerge.ui.actions.ComparisonSetup;
import org.eclipse.emf.diffmerge.ui.actions.EMFDiffMergeEditorInput;
import org.eclipse.emf.diffmerge.ui.specification.IComparisonSpecificationFactory;
import org.eclipse.emf.diffmerge.ui.specification.IOverridableFactory;
import org.eclipse.emf.diffmerge.ui.specification.IScopeSpecification;
import org.eclipse.emf.diffmerge.ui.specification.IScopeSpecificationFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComparisonContextManager {
    private static final String MODEL_COMPARISON_CONTEXT_EXTENSION_POINT = "org.eclipse.emf.diffmerge.ui.modelComparisonContext";
    private static final String EXTENSION_POINT_PROPERTY_CONFIGURATION = "specificationFactory";
    private static final String EXTENSION_POINT_PROPERTY_SCOPE = "scopeFactory";
    private Map<Class<?>, IComparisonSpecificationFactory> _comparisonFactories = null;
    private Map<Class<?>, IScopeSpecificationFactory> _scopeFactories = null;

    public EMFDiffMergeEditorInput createDefaultEditorInput(Object entrypoint1_p, Object entrypoint2_p, Object entrypoint3_p) {
        EMFDiffMergeEditorInput result = null;
        ComparisonSetup selection = this.createComparisonSetup(entrypoint1_p, entrypoint2_p, entrypoint3_p);
        if (selection != null && selection.getComparisonSpecification() != null) {
            result = new EMFDiffMergeEditorInput(selection.getComparisonSpecification());
        }
        return result;
    }

    public ComparisonSetup createComparisonSetup(Object entrypoint1_p, Object entrypoint2_p, Object entrypoint3_p) {
        IScopeSpecification scopeSpec3;
        IScopeSpecification scopeSpec2;
        IScopeSpecification scopeSpec1;
        List<IComparisonSpecificationFactory> cFactories;
        List factories3;
        ComparisonSetup result = null;
        List<IScopeSpecificationFactory> factories1 = this.getApplicableScopeFactories(entrypoint1_p);
        List<IScopeSpecificationFactory> factories2 = this.getApplicableScopeFactories(entrypoint2_p);
        List<Object> list = factories3 = entrypoint3_p == null ? Collections.emptyList() : this.getApplicableScopeFactories(entrypoint3_p);
        if (!(factories1.isEmpty() || factories2.isEmpty() || (cFactories = this.getApplicableComparisonFactories(scopeSpec1 = factories1.get(0).createScopeSpecification(entrypoint1_p, null, true), scopeSpec2 = factories2.get(0).createScopeSpecification(entrypoint2_p, null, true), scopeSpec3 = factories3.isEmpty() ? null : ((IScopeSpecificationFactory)factories3.get(0)).createScopeSpecification(entrypoint3_p, null, true))).isEmpty())) {
            result = new ComparisonSetup(scopeSpec1, scopeSpec2, scopeSpec3, cFactories);
        }
        return result;
    }

    private void discoverRegisteredComparisonContexts() {
        IConfigurationElement[] config;
        this._comparisonFactories = new HashMap();
        this._scopeFactories = new HashMap();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] iConfigurationElementArray = config = registry.getConfigurationElementsFor(MODEL_COMPARISON_CONTEXT_EXTENSION_POINT);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            Object o2;
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                o2 = e.createExecutableExtension(EXTENSION_POINT_PROPERTY_CONFIGURATION);
                if (o2 instanceof IComparisonSpecificationFactory) {
                    this._comparisonFactories.put(o2.getClass(), (IComparisonSpecificationFactory)o2);
                }
            }
            catch (CoreException o2) {
                // empty catch block
            }
            try {
                o2 = e.createExecutableExtension(EXTENSION_POINT_PROPERTY_SCOPE);
                if (o2 instanceof IScopeSpecificationFactory) {
                    this._scopeFactories.put(o2.getClass(), (IScopeSpecificationFactory)o2);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++n2;
        }
    }

    public List<IComparisonSpecificationFactory> getApplicableComparisonFactories(IScopeSpecification leftScopeSpec_p, IScopeSpecification rightScopeSpec_p, IScopeSpecification ancestorScopeSpec_p) {
        ArrayList<IComparisonSpecificationFactory> result = new ArrayList();
        for (IComparisonSpecificationFactory factory : this.getRegisteredComparisonFactories()) {
            if (!factory.isApplicableTo(leftScopeSpec_p, rightScopeSpec_p, ancestorScopeSpec_p)) continue;
            result.add(factory);
        }
        result = this.reduceByOverride(result, this._comparisonFactories);
        return result;
    }

    public List<IScopeSpecificationFactory> getApplicableScopeFactories(Object entrypoint_p) {
        List<Object> result = new ArrayList();
        for (IScopeSpecificationFactory factory : this.getRegisteredScopeFactories()) {
            if (!factory.isApplicableTo(entrypoint_p)) continue;
            result.add(factory);
        }
        result = this.reduceByOverride(result, this._scopeFactories);
        return Collections.unmodifiableList(result);
    }

    protected final Collection<IComparisonSpecificationFactory> getRegisteredComparisonFactories() {
        if (this._comparisonFactories == null) {
            this.discoverRegisteredComparisonContexts();
        }
        return this._comparisonFactories.values();
    }

    protected final Collection<IScopeSpecificationFactory> getRegisteredScopeFactories() {
        if (this._scopeFactories == null) {
            this.discoverRegisteredComparisonContexts();
        }
        return this._scopeFactories.values();
    }

    public boolean isValidEntrypoint(Object entrypoint_p) {
        for (IScopeSpecificationFactory factory : this.getRegisteredScopeFactories()) {
            if (!factory.isApplicableTo(entrypoint_p)) continue;
            return true;
        }
        return false;
    }

    protected <T extends IOverridableFactory> List<T> reduceByOverride(List<T> factories_p, Map<Class<?>, T> configurationFactories_p) {
        ArrayList<T> result = new ArrayList<T>(factories_p);
        for (IOverridableFactory factory : factories_p) {
            for (Class<?> factoryClass : factory.getOverridenClasses()) {
                result.remove(configurationFactories_p.get(factoryClass));
            }
        }
        return Collections.unmodifiableList(result);
    }
}

