/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.EMFDiffMergePlugin;
import org.eclipse.emf.diffmerge.Messages;
import org.eclipse.emf.diffmerge.api.scopes.IPersistentModelScope;
import org.eclipse.emf.diffmerge.impl.scopes.AbstractEditableModelScope;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;

public class SubtreeModelScope
extends AbstractEditableModelScope
implements IPersistentModelScope.Editable {
    private final EObject _root;

    public SubtreeModelScope(EObject root_p) {
        this._root = root_p;
    }

    public boolean add(EObject element_p) {
        if (element_p != this.getRoot() && this.getHoldingResource() != null) {
            this.getHoldingResource().getContents().add((Object)element_p);
        }
        return false;
    }

    @Override
    public EObject getContainer(EObject element_p) {
        return this.getRoot() == element_p ? null : super.getContainer(element_p);
    }

    @Override
    public EReference getContainment(EObject element_p) {
        return this.getRoot() == element_p ? null : super.getContainment(element_p);
    }

    @Override
    public List<EObject> getContents() {
        return this.getRawRoots();
    }

    protected Object getDefaultOriginator() {
        return this._root;
    }

    @Override
    public Resource getHoldingResource() {
        return this.getRoot().eResource();
    }

    public List<EObject> getRawRoots() {
        return Collections.singletonList(this.getRoot());
    }

    public EObject getRoot() {
        return this._root;
    }

    public boolean isLoaded() {
        return !this._root.eIsProxy();
    }

    public IStatus load() {
        return this.isLoaded() ? Status.OK_STATUS : EMFDiffMergePlugin.getDefault().createErrorStatus(Messages.SubtreeModelScope_NotLoaded);
    }

    @Override
    public boolean remove(EObject element_p) {
        boolean result = false;
        if (element_p != this.getRoot()) {
            result = super.remove(element_p);
        }
        return result;
    }

    public IStatus save() {
        IStatus result;
        Resource resource = this.getHoldingResource();
        if (resource != null) {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("SAVE_ONLY_IF_CHANGED", "MEMORY_BUFFER");
            try {
                resource.save(options);
                result = Status.OK_STATUS;
            }
            catch (IOException e) {
                result = EMFDiffMergePlugin.getDefault().createErrorStatus(e);
            }
        } else {
            result = EMFDiffMergePlugin.getDefault().createErrorStatus(Messages.FragmentedModelScope_ResourceNotDefined);
        }
        return result;
    }

    @Override
    public void setStream(InputStream stream_p) {
    }

    @Override
    public List<Resource> unload() {
        return Collections.emptyList();
    }
}

