/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.ecore.resource.impl;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.CommonUtil;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BinaryResourceImpl
extends ResourceImpl {
    public static final String OPTION_VERSION = "VERSION";
    public static final String OPTION_STYLE_BINARY_FLOATING_POINT = "BINARY_FLOATING_POINT ";
    public static final String OPTION_STYLE_BINARY_DATE = "BINARY_DATE";
    public static final String OPTION_STYLE_PROXY_ATTRIBUTES = "PROXY_ATTRIBUTES";
    public static final String OPTION_STYLE_BINARY_ENUMERATOR = "BINARY_ENUMERATOR";
    public static final String OPTION_STYLE_DATA_CONVERTER = "DATA_CONVERTER";
    public static final String OPTION_EAGER_PROXY_RESOLUTION = "EAGER_PROXY_RESOLUTION";
    public static final String OPTION_BUFFER_CAPACITY = "BUFFER_CAPACITY";
    public static final int DEFAULT_BUFFER_CAPACITY = 1024;
    public static final String OPTION_INTERNAL_BUFFER_CAPACITY = "INTERNAL_BUFFER_CAPACITY";

    public static int getBufferCapacity(Map<?, ?> options) {
        Integer capacity;
        if (options != null && (capacity = (Integer)options.get(OPTION_BUFFER_CAPACITY)) != null) {
            return capacity;
        }
        return 1024;
    }

    public static int getInternalBufferCapacity(Map<?, ?> options) {
        Integer capacity;
        if (options != null && (capacity = (Integer)options.get(OPTION_INTERNAL_BUFFER_CAPACITY)) != null) {
            return capacity;
        }
        return 0;
    }

    public BinaryResourceImpl() {
    }

    public BinaryResourceImpl(URI uri) {
        super(uri);
    }

    @Override
    protected void doSave(OutputStream outputStream, Map<?, ?> options) throws IOException {
        if (outputStream instanceof URIConverter.Saveable) {
            ((URIConverter.Saveable)((Object)outputStream)).saveResource(this);
        } else {
            boolean buffer;
            boolean bl = buffer = !(outputStream instanceof BufferedOutputStream);
            if (buffer) {
                int bufferCapacity = BinaryResourceImpl.getBufferCapacity(options);
                if (bufferCapacity > 0) {
                    outputStream = new BufferedOutputStream(outputStream, bufferCapacity);
                } else {
                    buffer = false;
                }
            }
            try {
                EObjectOutputStream eObjectOutputStream = this.createEObjectOutputStream(outputStream, options);
                eObjectOutputStream.saveResource(this);
                eObjectOutputStream.flush();
            }
            finally {
                if (buffer) {
                    outputStream.flush();
                }
            }
        }
    }

    protected EObjectOutputStream createEObjectOutputStream(OutputStream outputStream, Map<?, ?> options) throws IOException {
        return new EObjectOutputStream(outputStream, options);
    }

    @Override
    protected void doLoad(InputStream inputStream, Map<?, ?> options) throws IOException {
        if (inputStream instanceof URIConverter.Loadable) {
            ((URIConverter.Loadable)((Object)inputStream)).loadResource(this);
        } else {
            int bufferCapacity;
            if (!(inputStream instanceof BufferedInputStream) && (bufferCapacity = BinaryResourceImpl.getBufferCapacity(options)) > 0) {
                inputStream = new BufferedInputStream(inputStream, bufferCapacity);
            }
            EObjectInputStream eObjectInputStream = this.createEObjectInputStream(inputStream, options);
            eObjectInputStream.loadResource(this);
            eObjectInputStream.flush();
        }
    }

    protected EObjectInputStream createEObjectInputStream(InputStream inputStream, Map<?, ?> options) throws IOException {
        return new EObjectInputStream(inputStream, options);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class BinaryIO {
        public static final int STYLE_BINARY_FLOATING_POINT = 1;
        public static final int STYLE_BINARY_DATE = 2;
        public static final int STYLE_PROXY_ATTRIBUTES = 4;
        public static final int STYLE_BINARY_ENUMERATOR = 8;
        public static final int STYLE_DATA_CONVERTER = 16;
        protected Version version;
        protected int style;
        protected Resource resource;
        protected URI baseURI;
        protected Map<?, ?> options;
        protected char[] characters;
        protected InternalEObject[][] internalEObjectDataArrayBuffer = new InternalEObject[50][];
        protected int internalEObjectDataArrayBufferCount = -1;
        Map<EDataType, DataConverter<?>> dataConverterMap = new HashMap();
        protected FeatureMap.Entry.Internal[][] featureMapEntryDataArrayBuffer = new FeatureMap.Entry.Internal[50][];
        protected int featureMapEntryDataArrayBufferCount = -1;
        static final int MAX_DELIMITER = 192;
        static final String[] DELIMITERS = new String[192];
        static final List<String> INTRINSIC_STRINGS = new ArrayList<String>();
        static final Map<String, Integer> INTRINSIC_STRING_TO_ID_MAP = new HashMap<String, Integer>();

        static {
            INTRINSIC_STRING_TO_ID_MAP.put("", 0);
            INTRINSIC_STRINGS.add("");
            char c = '\u0000';
            while (c < '\u00c0') {
                if (Character.isDigit(c)) {
                    String string = CommonUtil.javaIntern(Character.toString(c));
                    INTRINSIC_STRING_TO_ID_MAP.put(string, INTRINSIC_STRINGS.size());
                    INTRINSIC_STRINGS.add(string);
                } else if (!Character.isLetter(c)) {
                    String delimiter;
                    BinaryIO.DELIMITERS[c] = delimiter = CommonUtil.javaIntern(Character.toString(c));
                    INTRINSIC_STRING_TO_ID_MAP.put(delimiter, INTRINSIC_STRINGS.size());
                    INTRINSIC_STRINGS.add(delimiter);
                }
                c = (char)(c + '\u0001');
            }
        }

        protected static int getStyle(Map<?, ?> options) {
            int result = 1;
            if (options != null) {
                if (Boolean.FALSE.equals(options.get(BinaryResourceImpl.OPTION_STYLE_BINARY_FLOATING_POINT))) {
                    result &= 0xFFFFFFFE;
                }
                if (Boolean.TRUE.equals(options.get(BinaryResourceImpl.OPTION_STYLE_BINARY_DATE))) {
                    result |= 2;
                }
                if (Boolean.TRUE.equals(options.get(BinaryResourceImpl.OPTION_STYLE_PROXY_ATTRIBUTES))) {
                    result |= 4;
                }
                if (Boolean.TRUE.equals(options.get(BinaryResourceImpl.OPTION_STYLE_BINARY_ENUMERATOR))) {
                    result |= 8;
                }
                if (Boolean.TRUE.equals(options.get(BinaryResourceImpl.OPTION_STYLE_DATA_CONVERTER))) {
                    result |= 0x10;
                }
            }
            return result;
        }

        protected URI resolve(URI uri) {
            return this.baseURI != null && uri.isRelative() && uri.hasRelativePath() ? uri.resolve(this.baseURI) : uri;
        }

        protected URI deresolve(URI uri) {
            URI deresolvedURI;
            if (this.baseURI != null && !uri.isRelative() && (deresolvedURI = uri.deresolve(this.baseURI, true, true, false)).hasRelativePath() && (!uri.isPlatform() || uri.segment(0).equals(this.baseURI.segment(0)))) {
                uri = deresolvedURI;
            }
            return uri;
        }

        protected InternalEObject[] allocateInternalEObjectArray(int length) {
            if (this.internalEObjectDataArrayBufferCount == -1) {
                return new InternalEObject[length];
            }
            InternalEObject[] buffer = this.internalEObjectDataArrayBuffer[this.internalEObjectDataArrayBufferCount];
            this.internalEObjectDataArrayBuffer[this.internalEObjectDataArrayBufferCount--] = null;
            return buffer.length >= length ? buffer : new InternalEObject[length];
        }

        protected void recycle(InternalEObject[] values) {
            if (++this.internalEObjectDataArrayBufferCount >= this.internalEObjectDataArrayBuffer.length) {
                InternalEObject[][] newInternalEObjectDataArrayBuffer = new InternalEObject[this.internalEObjectDataArrayBufferCount * 2][];
                System.arraycopy(this.internalEObjectDataArrayBuffer, 0, newInternalEObjectDataArrayBuffer, 0, this.internalEObjectDataArrayBufferCount);
                this.internalEObjectDataArrayBuffer = newInternalEObjectDataArrayBuffer;
            }
            this.internalEObjectDataArrayBuffer[this.internalEObjectDataArrayBufferCount] = values;
        }

        protected FeatureMap.Entry.Internal[] allocateFeatureMapEntryArray(int length) {
            if (this.featureMapEntryDataArrayBufferCount == -1) {
                return new FeatureMap.Entry.Internal[length];
            }
            FeatureMap.Entry.Internal[] buffer = this.featureMapEntryDataArrayBuffer[this.featureMapEntryDataArrayBufferCount];
            this.featureMapEntryDataArrayBuffer[this.featureMapEntryDataArrayBufferCount--] = null;
            return buffer.length >= length ? buffer : new FeatureMap.Entry.Internal[length];
        }

        protected void recycle(FeatureMap.Entry.Internal[] values) {
            if (++this.featureMapEntryDataArrayBufferCount >= this.featureMapEntryDataArrayBuffer.length) {
                FeatureMap.Entry.Internal[][] newFeatureMapEntryDataArrayBuffer = new FeatureMap.Entry.Internal[this.featureMapEntryDataArrayBufferCount * 2][];
                System.arraycopy(this.featureMapEntryDataArrayBuffer, 0, newFeatureMapEntryDataArrayBuffer, 0, this.featureMapEntryDataArrayBufferCount);
                this.featureMapEntryDataArrayBuffer = newFeatureMapEntryDataArrayBuffer;
            }
            this.featureMapEntryDataArrayBuffer[this.featureMapEntryDataArrayBufferCount] = values;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        protected static enum FeatureKind {
            EOBJECT_CONTAINER,
            EOBJECT_CONTAINER_PROXY_RESOLVING,
            EOBJECT,
            EOBJECT_PROXY_RESOLVING,
            EOBJECT_LIST,
            EOBJECT_LIST_PROXY_RESOLVING,
            EOBJECT_CONTAINMENT,
            EOBJECT_CONTAINMENT_PROXY_RESOLVING,
            EOBJECT_CONTAINMENT_LIST,
            EOBJECT_CONTAINMENT_LIST_PROXY_RESOLVING,
            BOOLEAN,
            BYTE,
            CHAR,
            DOUBLE,
            FLOAT,
            INT,
            LONG,
            SHORT,
            STRING,
            DATE,
            ENUMERATOR,
            DATA,
            DATA_LIST,
            FEATURE_MAP;


            public static FeatureKind get(EStructuralFeature eStructuralFeature) {
                if (eStructuralFeature instanceof EReference) {
                    EReference eReference = (EReference)eStructuralFeature;
                    if (eReference.isContainment()) {
                        if (eReference.isResolveProxies()) {
                            if (eReference.isMany()) {
                                return EOBJECT_CONTAINMENT_LIST_PROXY_RESOLVING;
                            }
                            return EOBJECT_CONTAINMENT_PROXY_RESOLVING;
                        }
                        if (eReference.isMany()) {
                            return EOBJECT_CONTAINMENT_LIST;
                        }
                        return EOBJECT_CONTAINMENT;
                    }
                    if (eReference.isContainer()) {
                        if (eReference.isResolveProxies()) {
                            return EOBJECT_CONTAINER_PROXY_RESOLVING;
                        }
                        return EOBJECT_CONTAINER;
                    }
                    if (eReference.isResolveProxies()) {
                        if (eReference.isMany()) {
                            return EOBJECT_LIST_PROXY_RESOLVING;
                        }
                        return EOBJECT_PROXY_RESOLVING;
                    }
                    if (eReference.isMany()) {
                        return EOBJECT_LIST;
                    }
                    return EOBJECT;
                }
                EAttribute eAttribute = (EAttribute)eStructuralFeature;
                EDataType eDataType = eAttribute.getEAttributeType();
                String instanceClassName = eDataType.getInstanceClassName();
                if (instanceClassName == "org.eclipse.emf.ecore.util.FeatureMap$Entry") {
                    return FEATURE_MAP;
                }
                if (eAttribute.isMany()) {
                    return DATA_LIST;
                }
                if (instanceClassName == "java.lang.String") {
                    return STRING;
                }
                if (instanceClassName == "boolean") {
                    return BOOLEAN;
                }
                if (instanceClassName == "byte") {
                    return BYTE;
                }
                if (instanceClassName == "char") {
                    return CHAR;
                }
                if (instanceClassName == "double") {
                    return DOUBLE;
                }
                if (instanceClassName == "float") {
                    return FLOAT;
                }
                if (instanceClassName == "int") {
                    return INT;
                }
                if (instanceClassName == "long") {
                    return LONG;
                }
                if (instanceClassName == "short") {
                    return SHORT;
                }
                if (instanceClassName == "java.util.Date") {
                    return DATE;
                }
                if (eDataType instanceof EEnum) {
                    return ENUMERATOR;
                }
                return DATA;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Version {
            VERSION_1_0,
            VERSION_1_1;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class DataConverter<T> {
        static final DataConverter<Object> NULL = new DataConverter<Object>(){

            @Override
            public Object read(EObjectInputStream eObjectInputStream) throws IOException {
                throw new UnsupportedOperationException();
            }

            @Override
            protected void doWrite(EObjectOutputStream eObjectOutputStream, Object value) throws IOException {
                throw new UnsupportedOperationException();
            }
        };

        public boolean isTabulated() {
            return true;
        }

        public abstract T read(EObjectInputStream var1) throws IOException;

        public void write(EObjectOutputStream eObjectOutputStream, Object value) throws IOException {
            this.doWrite(eObjectOutputStream, value);
        }

        protected abstract void doWrite(EObjectOutputStream var1, T var2) throws IOException;

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static interface Factory {
            public DataConverter<?> create(EDataType var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EObjectInputStream
    extends BinaryIO {
        private boolean isMarkSupported;
        private byte[] bytes;
        private int index;
        private int count;
        protected ResourceSet resourceSet;
        protected InputStream inputStream;
        private EPackageDataList internalEPackageDataList;
        protected List<EPackageData> ePackageDataList;
        private InternalEObjectList internalInternalEObjectList;
        protected List<InternalEObject> eObjectList;
        private URIList internalURIList;
        protected List<URI> uriList;
        protected BasicEList<InternalEObject> internalEObjectList;
        protected BasicEList<Object> dataValueList;
        private final StringList segmentedStringsList;
        private final StringList segmentsList;
        private char[] builder;
        protected boolean isEagerProxyResolution;
        protected int[][] intDataArrayBuffer;
        protected int intDataArrayBufferCount;

        public EObjectInputStream(InputStream inputStream, Map<?, ?> options) throws IOException {
            this.ePackageDataList = this.internalEPackageDataList = new EPackageDataList();
            this.eObjectList = this.internalInternalEObjectList = new InternalEObjectList();
            this.uriList = this.internalURIList = new URIList();
            this.internalEObjectList = new BasicEList();
            this.dataValueList = new BasicEList();
            this.intDataArrayBuffer = new int[50][];
            this.intDataArrayBufferCount = -1;
            this.inputStream = inputStream;
            this.options = options;
            int bufferCapacity = BinaryResourceImpl.getInternalBufferCapacity(options);
            if (bufferCapacity > 1) {
                this.bytes = new byte[bufferCapacity];
            }
            this.isMarkSupported = inputStream.markSupported();
            if (options != null) {
                this.isEagerProxyResolution = Boolean.TRUE.equals(options.get(BinaryResourceImpl.OPTION_EAGER_PROXY_RESOLUTION));
            }
            this.readSignature();
            this.readVersion();
            if (this.version.ordinal() > 0) {
                this.readStyle();
                if ((this.style & 0x10) != 0) {
                    this.segmentedStringsList = new StringList();
                    this.segmentsList = new StringList();
                    this.segmentsList.addAllUnique(INTRINSIC_STRINGS);
                    this.builder = new char[200];
                } else {
                    this.segmentedStringsList = null;
                    this.segmentsList = null;
                }
            } else {
                this.style = 1;
                this.segmentedStringsList = null;
                this.segmentsList = null;
            }
        }

        protected void readSignature() throws IOException {
            if (this.readByte() != -119 || this.readByte() != 101 || this.readByte() != 109 || this.readByte() != 102 || this.readByte() != 10 || this.readByte() != 13 || this.readByte() != 26 || this.readByte() != 10) {
                throw new IOException("Invalid signature for a binary EMF serialization");
            }
        }

        protected void readVersion() throws IOException {
            this.version = BinaryIO.Version.values()[this.readByte()];
        }

        protected void readStyle() throws IOException {
            this.style = this.readInt();
        }

        protected int[] allocateIntArray(int length) {
            if (this.intDataArrayBufferCount == -1) {
                return new int[length];
            }
            int[] buffer = this.intDataArrayBuffer[this.intDataArrayBufferCount];
            this.intDataArrayBuffer[this.intDataArrayBufferCount--] = null;
            return buffer.length >= length ? buffer : new int[length];
        }

        protected void recycle(int[] values) {
            if (++this.intDataArrayBufferCount >= this.intDataArrayBuffer.length) {
                int[][] newIntDataArrayBuffer = new int[this.intDataArrayBufferCount * 2][];
                System.arraycopy(this.intDataArrayBuffer, 0, newIntDataArrayBuffer, 0, this.intDataArrayBufferCount);
                this.intDataArrayBuffer = newIntDataArrayBuffer;
            }
            this.intDataArrayBuffer[this.intDataArrayBufferCount] = values;
        }

        protected EPackageData readEPackage() throws IOException {
            int id = this.readCompressedInt();
            if (this.internalEPackageDataList.size() <= id) {
                EPackageData ePackageData = new EPackageData();
                String nsURI = this.readSegmentedString();
                URI uri = this.readURI();
                if (this.resourceSet != null) {
                    ePackageData.ePackage = this.resourceSet.getPackageRegistry().getEPackage(nsURI);
                    if (ePackageData.ePackage == null) {
                        ePackageData.ePackage = (EPackage)this.resourceSet.getEObject(uri, true);
                    }
                } else {
                    ePackageData.ePackage = EPackage.Registry.INSTANCE.getEPackage(nsURI);
                }
                ePackageData.eClassData = new EClassData[ePackageData.ePackage.getEClassifiers().size()];
                this.internalEPackageDataList.add(ePackageData);
                return ePackageData;
            }
            return this.internalEPackageDataList.ePackageData[id];
        }

        protected EClassData readEClass() throws IOException {
            int classID;
            int packageID;
            if (this.index + 2 < this.count && (packageID = this.bytes[this.index]) <= 63 && packageID >= 0 && --packageID < this.internalEPackageDataList.size() && (classID = this.bytes[this.index + 1]) <= 63 && classID >= 0) {
                EClassData eClassData;
                this.index += 2;
                EPackageData ePackageData = this.internalEPackageDataList.ePackageData[packageID];
                return (eClassData = ePackageData.eClassData[--classID]) == null ? this.initEClassData(ePackageData, classID) : eClassData;
            }
            EPackageData ePackageData = this.readEPackage();
            int id = this.readCompressedInt();
            EClassData eClassData = ePackageData.eClassData[id];
            return eClassData == null ? this.initEClassData(ePackageData, id) : eClassData;
        }

        private EClassData initEClassData(EPackageData ePackageData, int id) throws IOException {
            EClassData eClassData = ePackageData.eClassData[id] = new EClassData();
            String name = this.readString();
            eClassData.eClass = (EClass)ePackageData.ePackage.getEClassifier(name);
            eClassData.eFactory = ePackageData.ePackage.getEFactoryInstance();
            eClassData.eStructuralFeatureData = new EStructuralFeatureData[eClassData.eClass.getFeatureCount()];
            return eClassData;
        }

        protected EStructuralFeatureData readEStructuralFeature() throws IOException {
            EClassData eClassData = this.readEClass();
            int featureID = this.readCompressedInt();
            return this.getEStructuralFeatureData(eClassData, featureID);
        }

        protected EStructuralFeatureData getEStructuralFeatureData(EClassData eClassData, int featureID) throws IOException {
            EStructuralFeatureData eStructuralFeatureData = eClassData.eStructuralFeatureData[featureID];
            if (eStructuralFeatureData == null) {
                eStructuralFeatureData = eClassData.eStructuralFeatureData[featureID] = new EStructuralFeatureData();
                String name = this.readString();
                eStructuralFeatureData.eStructuralFeature = eClassData.eClass.getEStructuralFeature(name);
                if (eStructuralFeatureData.eStructuralFeature == null) {
                    throw new IOException("Invalid Structural Feature '" + name + "' for EClass " + eClassData.eClass.getName());
                }
                eStructuralFeatureData.featureID = eClassData.eClass.getFeatureID(eStructuralFeatureData.eStructuralFeature);
                eStructuralFeatureData.kind = BinaryIO.FeatureKind.get(eStructuralFeatureData.eStructuralFeature);
                if (eStructuralFeatureData.eStructuralFeature instanceof EAttribute) {
                    EAttribute eAttribute = (EAttribute)eStructuralFeatureData.eStructuralFeature;
                    eStructuralFeatureData.eDataType = eAttribute.getEAttributeType();
                    eStructuralFeatureData.eFactory = eStructuralFeatureData.eDataType.getEPackage().getEFactoryInstance();
                    if (this.segmentedStringsList != null && this.readBoolean()) {
                        DataConverter<Object> dataConverter = (DataConverter<Object>)this.dataConverterMap.get(eStructuralFeatureData.eDataType);
                        if (dataConverter == null) {
                            DataConverter<Object> tabulatedDataConverter;
                            final DataConverter<Object> rawDataConverter = ((DataConverter.Factory)((Object)eStructuralFeatureData.eFactory)).create(eStructuralFeatureData.eDataType);
                            dataConverter = rawDataConverter.isTabulated() ? (tabulatedDataConverter = new DataConverter<Object>(){
                                final DataValueList objects = new DataValueList();

                                @Override
                                public Object read(EObjectInputStream eObjectInputStream) throws IOException {
                                    int id = eObjectInputStream.readCompressedInt();
                                    if (id == -1) {
                                        return null;
                                    }
                                    if (this.objects.size() <= id) {
                                        Object value = rawDataConverter.read(eObjectInputStream);
                                        this.objects.add(value);
                                        return value;
                                    }
                                    return this.objects.values[id];
                                }

                                @Override
                                protected void doWrite(EObjectOutputStream eObjectOutputStream, Object value) throws IOException {
                                    throw new UnsupportedOperationException();
                                }
                            }) : rawDataConverter;
                            this.dataConverterMap.put(eStructuralFeatureData.eDataType, dataConverter);
                        }
                        eStructuralFeatureData.dataConverter = dataConverter;
                    }
                }
            }
            return eStructuralFeatureData;
        }

        public void loadResource(Resource resource) throws IOException {
            this.resource = resource;
            this.resourceSet = resource.getResourceSet();
            URI uri = resource.getURI();
            if (uri != null && uri.isHierarchical() && !uri.isRelative()) {
                this.baseURI = uri;
            }
            int size = this.readCompressedInt();
            Object[] values = this.allocateInternalEObjectArray(size);
            int i = 0;
            while (i < size) {
                values[i] = this.loadEObject();
                ++i;
            }
            this.internalEObjectList.setData(size, values);
            InternalEList internalEObjects = (InternalEList)resource.getContents();
            internalEObjects.addAllUnique(this.internalEObjectList);
            this.recycle((InternalEObject[])values);
        }

        public void loadEObjects(InternalEList<InternalEObject> internalEObjects) throws IOException {
            int size = this.readCompressedInt();
            Object[] values = this.allocateInternalEObjectArray(size);
            int i = 0;
            while (i < size) {
                values[i] = this.loadEObject();
                ++i;
            }
            int existingSize = internalEObjects.size();
            if (existingSize == 0) {
                this.internalEObjectList.setData(size, values);
                internalEObjects.addAllUnique(0, this.internalEObjectList);
            } else {
                InternalEObject[] existingValues = this.allocateInternalEObjectArray(existingSize);
                internalEObjects.basicToArray(existingValues);
                int[] indices = this.allocateIntArray(existingSize);
                int duplicateCount = 0;
                int i2 = 0;
                while (i2 < size) {
                    block10: {
                        Object internalEObject = values[i2];
                        int j = 0;
                        int count = duplicateCount;
                        while (j < existingSize) {
                            InternalEObject existingInternalEObject = existingValues[j];
                            if (existingInternalEObject == internalEObject) {
                                if (duplicateCount != count) {
                                    internalEObjects.move(duplicateCount, count);
                                }
                                indices[duplicateCount] = i2;
                                ++duplicateCount;
                                existingValues[j] = null;
                                break block10;
                            }
                            if (existingInternalEObject != null) {
                                ++count;
                            }
                            ++j;
                        }
                        values[i2 - duplicateCount] = internalEObject;
                    }
                    ++i2;
                }
                this.internalEObjectList.setData(size -= existingSize, values);
                internalEObjects.addAllUnique(0, this.internalEObjectList);
                i2 = 0;
                while (i2 < existingSize) {
                    int newPosition = indices[i2];
                    int oldPosition = size + i2;
                    if (newPosition != oldPosition) {
                        internalEObjects.move(newPosition, oldPosition);
                    }
                    ++i2;
                }
                this.recycle(existingValues);
                this.recycle(indices);
            }
            this.recycle((InternalEObject[])values);
        }

        public void loadFeatureMap(FeatureMap.Internal featureMap) throws IOException {
            int size = this.readCompressedInt();
            Object[] values = this.allocateFeatureMapEntryArray(size);
            int i = 0;
            while (i < size) {
                values[i] = this.loadFeatureMapEntry();
                ++i;
            }
            int existingSize = featureMap.size();
            if (existingSize == 0) {
                featureMap.addAllUnique((FeatureMap.Entry.Internal[])values, 0, size);
            } else {
                FeatureMap.Entry.Internal[] existingValues = this.allocateFeatureMapEntryArray(existingSize);
                featureMap.basicToArray(existingValues);
                int[] indices = this.allocateIntArray(existingSize);
                int duplicateCount = 0;
                int i2 = 0;
                while (i2 < size) {
                    block10: {
                        FeatureMap.Entry.Internal entry = values[i2];
                        int j = 0;
                        int count = 0;
                        while (j < existingSize) {
                            FeatureMap.Entry.Internal existingEntry = existingValues[j];
                            if (entry.equals(existingEntry)) {
                                if (duplicateCount != count) {
                                    featureMap.move(duplicateCount, count);
                                }
                                indices[duplicateCount] = i2;
                                ++count;
                                ++duplicateCount;
                                existingValues[j] = null;
                                break block10;
                            }
                            if (existingEntry != null) {
                                ++count;
                            }
                            ++j;
                        }
                        values[i2 - duplicateCount] = entry;
                    }
                    ++i2;
                }
                this.internalEObjectList.setData(size -= existingSize, values);
                featureMap.addAllUnique(0, (FeatureMap.Entry.Internal[])values, 0, size);
                i2 = 0;
                while (i2 < existingSize) {
                    int newPosition = indices[i2];
                    int oldPosition = size + i2;
                    if (newPosition != oldPosition) {
                        featureMap.move(newPosition, oldPosition);
                    }
                    ++i2;
                }
                this.recycle(existingValues);
                this.recycle(indices);
            }
            this.recycle((FeatureMap.Entry.Internal[])values);
        }

        public FeatureMap.Entry.Internal loadFeatureMapEntry() throws IOException {
            Object value;
            EStructuralFeatureData eStructuralFeatureData = this.readEStructuralFeature();
            switch (eStructuralFeatureData.kind) {
                case EOBJECT_CONTAINER: 
                case EOBJECT_CONTAINER_PROXY_RESOLVING: 
                case EOBJECT: 
                case EOBJECT_PROXY_RESOLVING: 
                case EOBJECT_LIST: 
                case EOBJECT_LIST_PROXY_RESOLVING: 
                case EOBJECT_CONTAINMENT: 
                case EOBJECT_CONTAINMENT_PROXY_RESOLVING: 
                case EOBJECT_CONTAINMENT_LIST: 
                case EOBJECT_CONTAINMENT_LIST_PROXY_RESOLVING: {
                    value = this.loadEObject();
                    break;
                }
                case STRING: {
                    value = this.readSegmentedString();
                    break;
                }
                case DATE: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        value = eStructuralFeatureData.dataConverter.read(this);
                        break;
                    }
                    if ((this.style & 2) != 0) {
                        value = this.readDate();
                        break;
                    }
                    value = eStructuralFeatureData.eFactory.createFromString(eStructuralFeatureData.eDataType, this.readSegmentedString());
                    break;
                }
                case ENUMERATOR: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        value = eStructuralFeatureData.dataConverter.read(this);
                        break;
                    }
                    if ((this.style & 8) != 0) {
                        value = ((EEnum)eStructuralFeatureData.eDataType).getEEnumLiteral(this.readInt()).getInstance();
                        break;
                    }
                    value = eStructuralFeatureData.eFactory.createFromString(eStructuralFeatureData.eDataType, this.readString());
                    break;
                }
                case DATA: 
                case DATA_LIST: {
                    value = eStructuralFeatureData.dataConverter != null ? eStructuralFeatureData.dataConverter.read(this) : eStructuralFeatureData.eFactory.createFromString(eStructuralFeatureData.eDataType, this.readSegmentedString());
                    break;
                }
                case BOOLEAN: {
                    value = this.readBoolean();
                    break;
                }
                case BYTE: {
                    value = this.readByte();
                    break;
                }
                case CHAR: {
                    value = Character.valueOf(this.readChar());
                    break;
                }
                case DOUBLE: {
                    value = this.readDouble();
                    break;
                }
                case FLOAT: {
                    value = Float.valueOf(this.readFloat());
                    break;
                }
                case INT: {
                    value = this.readInt();
                    break;
                }
                case LONG: {
                    value = this.readLong();
                    break;
                }
                case SHORT: {
                    value = this.readShort();
                    break;
                }
                default: {
                    throw new IOException("Unhandled case " + (Object)((Object)eStructuralFeatureData.kind));
                }
            }
            return FeatureMapUtil.createRawEntry(eStructuralFeatureData.eStructuralFeature, value);
        }

        public InternalEObject loadEObject() throws IOException {
            int id = this.readCompressedInt();
            if (id == -1) {
                return null;
            }
            if (this.internalInternalEObjectList.size() <= id) {
                InternalEObject internalEObject;
                EClassData eClassData = this.readEClass();
                InternalEObject result = internalEObject = (InternalEObject)eClassData.eFactory.create(eClassData.eClass);
                int featureID = this.readCompressedInt() - 1;
                if (featureID == -2) {
                    internalEObject.eSetProxyURI(this.readURI());
                    if (this.isEagerProxyResolution) {
                        result = (InternalEObject)EcoreUtil.resolve((EObject)internalEObject, this.resource);
                        this.internalInternalEObjectList.add(result);
                        if ((this.style & 4) == 0) {
                            return result;
                        }
                    } else {
                        this.internalInternalEObjectList.add(internalEObject);
                        if ((this.style & 4) == 0) {
                            return internalEObject;
                        }
                    }
                    featureID = this.readCompressedInt() - 1;
                } else {
                    this.internalInternalEObjectList.add(internalEObject);
                }
                while (featureID != -1) {
                    EStructuralFeatureData eStructuralFeatureData = this.getEStructuralFeatureData(eClassData, featureID);
                    this.loadFeatureValue(internalEObject, eStructuralFeatureData);
                    featureID = this.readCompressedInt() - 1;
                }
                return result;
            }
            return this.internalInternalEObjectList.eObjects[id];
        }

        protected void loadFeatureValue(InternalEObject internalEObject, EStructuralFeatureData eStructuralFeatureData) throws IOException {
            switch (eStructuralFeatureData.kind) {
                case EOBJECT_CONTAINER: 
                case EOBJECT_CONTAINER_PROXY_RESOLVING: 
                case EOBJECT: 
                case EOBJECT_PROXY_RESOLVING: 
                case EOBJECT_CONTAINMENT: 
                case EOBJECT_CONTAINMENT_PROXY_RESOLVING: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.loadEObject());
                    break;
                }
                case EOBJECT_LIST: 
                case EOBJECT_LIST_PROXY_RESOLVING: 
                case EOBJECT_CONTAINMENT_LIST: 
                case EOBJECT_CONTAINMENT_LIST_PROXY_RESOLVING: {
                    InternalEList internalEList = (InternalEList)internalEObject.eGet(eStructuralFeatureData.featureID, false, true);
                    this.loadEObjects(internalEList);
                    break;
                }
                case STRING: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readSegmentedString());
                    break;
                }
                case FEATURE_MAP: {
                    FeatureMap.Internal featureMap = (FeatureMap.Internal)internalEObject.eGet(eStructuralFeatureData.featureID, false, true);
                    this.loadFeatureMap(featureMap);
                    break;
                }
                case DATE: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        internalEObject.eSet(eStructuralFeatureData.featureID, eStructuralFeatureData.dataConverter.read(this));
                        break;
                    }
                    if ((this.style & 2) != 0) {
                        internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readDate());
                        break;
                    }
                    internalEObject.eSet(eStructuralFeatureData.featureID, eStructuralFeatureData.eFactory.createFromString(eStructuralFeatureData.eDataType, this.readSegmentedString()));
                    break;
                }
                case ENUMERATOR: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        internalEObject.eSet(eStructuralFeatureData.featureID, eStructuralFeatureData.dataConverter.read(this));
                        break;
                    }
                    if ((this.style & 8) != 0) {
                        internalEObject.eSet(eStructuralFeatureData.featureID, (Object)((EEnum)eStructuralFeatureData.eDataType).getEEnumLiteral(this.readInt()).getInstance());
                        break;
                    }
                    internalEObject.eSet(eStructuralFeatureData.featureID, eStructuralFeatureData.eFactory.createFromString(eStructuralFeatureData.eDataType, this.readString()));
                    break;
                }
                case DATA: {
                    Object value = eStructuralFeatureData.dataConverter != null ? eStructuralFeatureData.dataConverter.read(this) : eStructuralFeatureData.eFactory.createFromString(eStructuralFeatureData.eDataType, this.readSegmentedString());
                    internalEObject.eSet(eStructuralFeatureData.featureID, value);
                    break;
                }
                case DATA_LIST: {
                    int i;
                    int size = this.readCompressedInt();
                    this.dataValueList.grow(size);
                    Object[] dataValues = this.dataValueList.data();
                    if (eStructuralFeatureData.dataConverter != null) {
                        i = 0;
                        while (i < size) {
                            dataValues[i] = eStructuralFeatureData.dataConverter.read(this);
                            ++i;
                        }
                    } else {
                        i = 0;
                        while (i < size) {
                            String literal = this.readSegmentedString();
                            dataValues[i] = eStructuralFeatureData.eFactory.createFromString(eStructuralFeatureData.eDataType, literal);
                            ++i;
                        }
                    }
                    this.dataValueList.setData(size, dataValues);
                    InternalEList values = (InternalEList)internalEObject.eGet(eStructuralFeatureData.featureID, false, true);
                    values.addAllUnique(this.dataValueList);
                    break;
                }
                case BOOLEAN: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readBoolean());
                    break;
                }
                case BYTE: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readByte());
                    break;
                }
                case CHAR: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)Character.valueOf(this.readChar()));
                    break;
                }
                case DOUBLE: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readDouble());
                    break;
                }
                case FLOAT: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)Float.valueOf(this.readFloat()));
                    break;
                }
                case INT: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readInt());
                    break;
                }
                case LONG: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readLong());
                    break;
                }
                case SHORT: {
                    internalEObject.eSet(eStructuralFeatureData.featureID, (Object)this.readShort());
                    break;
                }
                default: {
                    throw new IOException("Unhandled case " + (Object)((Object)eStructuralFeatureData.kind));
                }
            }
        }

        public byte readByte() throws IOException {
            return this.index < this.count ? this.bytes[this.index++] : this.fill();
        }

        private byte fill() throws IOException {
            if (this.bytes == null) {
                int result = this.inputStream.read();
                if (result == -1) {
                    throw new IOException("Unexpected end of stream");
                }
                return (byte)result;
            }
            if (this.isMarkSupported) {
                this.inputStream.mark(this.bytes.length);
            }
            this.count = this.inputStream.read(this.bytes, 0, this.bytes.length);
            if (this.count == -1) {
                throw new IOException("Unexpected end of stream");
            }
            this.index = 1;
            return this.bytes[0];
        }

        public void flush() throws IOException {
            if (this.bytes != null && this.index < this.count) {
                if (this.isMarkSupported) {
                    this.inputStream.reset();
                    this.inputStream.read(this.bytes, 0, this.index);
                } else {
                    throw new IOException("Unable to place " + this.index + "unconsumed bytes back into the input stream; specify an OPTION_BUFFER_CAPACITY to support this");
                }
            }
        }

        public boolean readBoolean() throws IOException {
            return this.readByte() != 0;
        }

        public char readChar() throws IOException {
            return (char)(this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF);
        }

        public short readShort() throws IOException {
            return (short)(this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF);
        }

        public int readInt() throws IOException {
            return this.readByte() << 24 | this.readByte() << 16 & 0xFF0000 | this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF;
        }

        public long readLong() throws IOException {
            return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
        }

        public float readFloat() throws IOException {
            if ((this.style & 1) != 0) {
                return Float.intBitsToFloat(this.readInt());
            }
            return Float.parseFloat(this.readString());
        }

        public double readDouble() throws IOException {
            if ((this.style & 1) != 0) {
                return Double.longBitsToDouble(this.readLong());
            }
            return Double.parseDouble(this.readString());
        }

        public int readCompressedInt() throws IOException {
            if (this.index + 4 < this.count) {
                byte initialByte = this.bytes[this.index++];
                int code = initialByte >> 6 & 3;
                switch (code) {
                    case 0: {
                        return initialByte - 1;
                    }
                    case 1: {
                        return (initialByte << 8 & 0x3F00 | this.bytes[this.index++] & 0xFF) - 1;
                    }
                    case 2: {
                        return (initialByte << 16 & 0x3F0000 | this.bytes[this.index++] << 8 & 0xFF00 | this.bytes[this.index++] & 0xFF) - 1;
                    }
                }
                return (initialByte << 24 & 0x3F000000 | this.bytes[this.index++] << 16 & 0xFF0000 | this.bytes[this.index++] << 8 & 0xFF00 | this.bytes[this.index++] & 0xFF) - 1;
            }
            byte initialByte = this.readByte();
            int code = initialByte >> 6 & 3;
            switch (code) {
                case 0: {
                    return initialByte - 1;
                }
                case 1: {
                    return (initialByte << 8 & 0x3F00 | this.readByte() & 0xFF) - 1;
                }
                case 2: {
                    return (initialByte << 16 & 0x3F0000 | this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF) - 1;
                }
            }
            return (initialByte << 24 & 0x3F000000 | this.readByte() << 16 & 0xFF0000 | this.readByte() << 8 & 0xFF00 | this.readByte() & 0xFF) - 1;
        }

        public String readSegmentedString() throws IOException {
            if (this.segmentedStringsList == null) {
                return this.basicReadString();
            }
            int id = this.readCompressedInt();
            if (id == -1) {
                return null;
            }
            if (this.segmentedStringsList.size() <= id) {
                String value;
                int segmentCount = this.readCompressedInt();
                if (segmentCount == 0) {
                    value = this.readString();
                } else {
                    int length = 0;
                    int i = 0;
                    while (i < segmentCount) {
                        String segment = this.readString();
                        int segmentLength = segment.length();
                        int newLength = length + segmentLength;
                        if (this.builder.length < newLength) {
                            char[] newBuilder = new char[Math.max(2 * this.builder.length, newLength)];
                            System.arraycopy(this.builder, 0, newBuilder, 0, this.builder.length);
                            this.builder = newBuilder;
                        }
                        if (segmentLength == 1) {
                            this.builder[length] = segment.charAt(0);
                        } else {
                            segment.getChars(0, segmentLength, this.builder, length);
                        }
                        length = newLength;
                        ++i;
                    }
                    value = new String(this.builder, 0, length);
                }
                this.segmentedStringsList.add(value);
                return value;
            }
            return this.segmentedStringsList.strings[id];
        }

        public String readString() throws IOException {
            if (this.segmentsList != null) {
                int id = this.readCompressedInt();
                if (id == -1) {
                    return null;
                }
                if (this.segmentsList.size() <= id) {
                    String value = this.basicReadString();
                    this.segmentsList.add(value);
                    return value;
                }
                return this.segmentsList.strings[id];
            }
            return this.basicReadString();
        }

        private String basicReadString() throws IOException {
            int length = this.readCompressedInt();
            if (length == -1) {
                return null;
            }
            if (this.characters == null || this.characters.length < length) {
                this.characters = new char[length];
            }
            int i = 0;
            while (i < length) {
                byte value = this.readByte();
                if (value == 0) {
                    do {
                        this.characters[i] = this.readChar();
                    } while (++i < length);
                    break;
                }
                this.characters[i] = (char)(value & 0xFF);
                ++i;
            }
            return new String(this.characters, 0, length);
        }

        public Date readDate() throws IOException {
            long time = this.readLong();
            return new Date(time);
        }

        public URI readURI() throws IOException {
            URI uri;
            int id = this.readCompressedInt();
            if (id == -1) {
                return null;
            }
            if (this.internalURIList.size() <= id) {
                String value = this.readSegmentedString();
                uri = this.resolve(URI.createURI(value));
                this.internalURIList.add(uri);
            } else {
                uri = this.internalURIList.uris[id];
            }
            String fragment = this.readSegmentedString();
            if (fragment != null) {
                uri = uri.appendFragment(fragment);
            }
            return uri;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class DataValueList
        extends BasicEList<Object> {
            private static final long serialVersionUID = 1L;
            public Object[] values;

            public DataValueList() {
                super(1000);
            }

            @Override
            protected Object[] newData(int capacity) {
                this.values = new Object[capacity];
                return this.values;
            }

            @Override
            public final boolean add(Object object) {
                if (this.size == this.data.length) {
                    this.grow(this.size + 1);
                }
                this.data[this.size++] = object;
                return true;
            }
        }

        protected static class EClassData {
            public EClass eClass;
            public EFactory eFactory;
            public EStructuralFeatureData[] eStructuralFeatureData;

            protected EClassData() {
            }
        }

        protected static class EPackageData {
            public EPackage ePackage;
            public EClassData[] eClassData;

            protected EPackageData() {
            }

            public final int allocateEClassID() {
                int i = 0;
                int length = this.eClassData.length;
                while (i < length) {
                    EClassData eClassData = this.eClassData[i];
                    if (eClassData == null) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class EPackageDataList
        extends BasicEList<EPackageData> {
            private static final long serialVersionUID = 1L;
            public EPackageData[] ePackageData;

            public EPackageDataList() {
                super(20);
            }

            @Override
            protected Object[] newData(int capacity) {
                this.ePackageData = new EPackageData[capacity];
                return this.ePackageData;
            }

            @Override
            public final boolean add(EPackageData object) {
                if (this.size == this.data.length) {
                    this.grow(this.size + 1);
                }
                this.ePackageData[this.size++] = object;
                return true;
            }
        }

        protected static class EStructuralFeatureData {
            public int featureID;
            public EStructuralFeature eStructuralFeature;
            public BinaryIO.FeatureKind kind;
            public EFactory eFactory;
            public EDataType eDataType;
            public DataConverter<?> dataConverter;

            protected EStructuralFeatureData() {
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class InternalEObjectList
        extends BasicEList<InternalEObject> {
            private static final long serialVersionUID = 1L;
            public InternalEObject[] eObjects;

            public InternalEObjectList() {
                super(1000);
            }

            @Override
            protected Object[] newData(int capacity) {
                this.eObjects = new InternalEObject[capacity];
                return this.eObjects;
            }

            @Override
            public final boolean add(InternalEObject object) {
                if (this.size == this.eObjects.length) {
                    this.grow(this.size + 1);
                }
                this.eObjects[this.size++] = object;
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class StringList
        extends BasicEList<String> {
            private static final long serialVersionUID = 1L;
            public String[] strings;

            public StringList() {
                super(1000);
            }

            @Override
            protected Object[] newData(int capacity) {
                this.strings = new String[capacity];
                return this.strings;
            }

            @Override
            public final boolean add(String object) {
                if (this.size == this.strings.length) {
                    this.grow(this.size + 1);
                }
                this.strings[this.size++] = object;
                return true;
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class URIList
        extends BasicEList<URI> {
            private static final long serialVersionUID = 1L;
            public URI[] uris;

            public URIList() {
                super(1000);
            }

            @Override
            protected Object[] newData(int capacity) {
                this.uris = new URI[capacity];
                return this.uris;
            }

            @Override
            public final boolean add(URI object) {
                if (this.size == this.uris.length) {
                    this.grow(this.size + 1);
                }
                this.uris[this.size++] = object;
                return true;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EObjectOutputStream
    extends BinaryIO {
        private byte[] bytes;
        private int index;
        protected OutputStream outputStream;
        protected Map<EPackage, EPackageData> ePackageDataMap = new HashMap<EPackage, EPackageData>();
        protected Map<EClass, EClassData> eClassDataMap = new HashMap<EClass, EClassData>();
        protected Map<EObject, Integer> eObjectIDMap = new HashMap<EObject, Integer>();
        protected Map<URI, Integer> uriToIDMap = new HashMap<URI, Integer>();
        private Map<String, Integer> segmentedStringToIDMap;
        private Map<String, Integer> segmentToIDMap;
        private String[] segments;

        public EObjectOutputStream(OutputStream outputStream, Map<?, ?> options) throws IOException {
            this(outputStream, options, options != null && options.containsKey(BinaryResourceImpl.OPTION_VERSION) ? (BinaryIO.Version)((Object)options.get(BinaryResourceImpl.OPTION_VERSION)) : BinaryIO.Version.VERSION_1_0);
        }

        public EObjectOutputStream(OutputStream outputStream, Map<?, ?> options, BinaryIO.Version version) throws IOException {
            this(outputStream, options, version, version.ordinal() > 0 ? EObjectOutputStream.getStyle(options) : 1);
        }

        public EObjectOutputStream(OutputStream outputStream, Map<?, ?> options, BinaryIO.Version version, int style) throws IOException {
            this.outputStream = outputStream;
            this.options = options;
            this.version = version;
            this.style = style;
            int bufferCapacity = BinaryResourceImpl.getInternalBufferCapacity(options);
            if (bufferCapacity > 1) {
                this.bytes = new byte[bufferCapacity];
            }
            this.writeSignature();
            this.writeVersion();
            if (version.ordinal() > 0) {
                this.writeStyle();
            }
            if ((style & 0x10) != 0) {
                this.segmentedStringToIDMap = new HashMap<String, Integer>();
                this.segmentToIDMap = new HashMap<String, Integer>(INTRINSIC_STRING_TO_ID_MAP);
            }
        }

        protected void writeSignature() throws IOException {
            this.writeByte(137);
            this.writeByte(101);
            this.writeByte(109);
            this.writeByte(102);
            this.writeByte(10);
            this.writeByte(13);
            this.writeByte(26);
            this.writeByte(10);
        }

        protected void writeVersion() throws IOException {
            this.writeByte(this.version.ordinal());
        }

        protected void writeStyle() throws IOException {
            this.writeInt(this.style);
        }

        protected EPackageData writeEPackage(EPackage ePackage) throws IOException {
            EPackageData ePackageData = this.ePackageDataMap.get(ePackage);
            if (ePackageData == null) {
                int id;
                ePackageData = new EPackageData();
                ePackageData.id = id = this.ePackageDataMap.size();
                ePackageData.eClassData = new EClassData[ePackage.getEClassifiers().size()];
                this.writeCompressedInt(id);
                this.writeSegmentedString(ePackage.getNsURI());
                this.writeURI(EcoreUtil.getURI(ePackage));
                this.ePackageDataMap.put(ePackage, ePackageData);
            } else {
                this.writeCompressedInt(ePackageData.id);
            }
            return ePackageData;
        }

        protected EClassData writeEClass(EClass eClass) throws IOException {
            EClassData eClassData = this.eClassDataMap.get(eClass);
            if (eClassData == null) {
                eClassData = new EClassData();
                EPackageData ePackageData = this.writeEPackage(eClass.getEPackage());
                eClassData.ePackageID = ePackageData.id;
                eClassData.id = ePackageData.allocateEClassID();
                this.writeCompressedInt(eClassData.id);
                this.writeString(eClass.getName());
                int featureCount = eClass.getFeatureCount();
                eClassData.eStructuralFeatureData = new EStructuralFeatureData[featureCount];
                EStructuralFeatureData[] eStructuralFeaturesData = eClassData.eStructuralFeatureData;
                int i = 0;
                while (i < featureCount) {
                    EStructuralFeature.Internal eStructuralFeature = (EStructuralFeature.Internal)eClass.getEStructuralFeature(i);
                    eStructuralFeaturesData[i] = this.createEStructuralFeatureData(eStructuralFeature);
                    ++i;
                }
                ePackageData.eClassData[eClassData.id] = eClassData;
                this.eClassDataMap.put(eClass, eClassData);
            } else {
                this.writeCompressedInt(eClassData.ePackageID);
                this.writeCompressedInt(eClassData.id);
            }
            return eClassData;
        }

        protected EStructuralFeatureData createEStructuralFeatureData(EStructuralFeature.Internal eStructuralFeature) {
            EStructuralFeatureData eStructuralFeatureData = new EStructuralFeatureData();
            eStructuralFeatureData.name = eStructuralFeature.getName();
            eStructuralFeatureData.isTransient = eStructuralFeature.isTransient() || eStructuralFeature.isContainer() && !eStructuralFeature.isResolveProxies();
            eStructuralFeatureData.kind = BinaryIO.FeatureKind.get(eStructuralFeature);
            if (eStructuralFeature instanceof EAttribute) {
                DataConverter<Object> dataConverter;
                EDataType eDataType;
                EAttribute eAttribute = (EAttribute)((Object)eStructuralFeature);
                eStructuralFeatureData.eDataType = eDataType = eAttribute.getEAttributeType();
                eStructuralFeatureData.eFactory = eDataType.getEPackage().getEFactoryInstance();
                boolean bl = eStructuralFeatureData.isProxyTransient = eStructuralFeatureData.kind == BinaryIO.FeatureKind.FEATURE_MAP;
                if (this.segmentedStringToIDMap != null && (dataConverter = (DataConverter<Object>)this.dataConverterMap.get(eDataType)) != DataConverter.NULL) {
                    if (dataConverter == null) {
                        final DataConverter<Object> rawDataConverter = ((DataConverter.Factory)((Object)eStructuralFeatureData.eFactory)).create(eDataType);
                        if (rawDataConverter == null) {
                            this.dataConverterMap.put(eDataType, DataConverter.NULL);
                        } else {
                            DataConverter<Object> tabulatedDataConverter;
                            dataConverter = rawDataConverter.isTabulated() ? (tabulatedDataConverter = new DataConverter<Object>(){
                                Map<Object, Integer> objectToIDMap = new HashMap<Object, Integer>();

                                @Override
                                public Object read(EObjectInputStream eObjectInputStream) throws IOException {
                                    throw new UnsupportedOperationException();
                                }

                                @Override
                                public void write(EObjectOutputStream eObjectOutputStream, Object value) throws IOException {
                                    if (value == null) {
                                        eObjectOutputStream.writeCompressedInt(-1);
                                    } else {
                                        Integer id = this.objectToIDMap.get(value);
                                        if (id == null) {
                                            int idValue = this.objectToIDMap.size();
                                            this.objectToIDMap.put(value, idValue);
                                            eObjectOutputStream.writeCompressedInt(idValue);
                                            super.write(eObjectOutputStream, value);
                                        } else {
                                            eObjectOutputStream.writeCompressedInt(id);
                                        }
                                    }
                                }

                                @Override
                                protected void doWrite(EObjectOutputStream eObjectOutputStream, Object value) throws IOException {
                                    rawDataConverter.write(eObjectOutputStream, value);
                                }
                            }) : rawDataConverter;
                            this.dataConverterMap.put(eDataType, dataConverter);
                        }
                    }
                    eStructuralFeatureData.dataConverter = dataConverter;
                }
            } else {
                eStructuralFeatureData.isProxyTransient = true;
            }
            return eStructuralFeatureData;
        }

        protected EStructuralFeatureData writeEStructuralFeature(EStructuralFeature eStructuralFeature) throws IOException {
            EClass eClass = eStructuralFeature.getEContainingClass();
            EClassData eClassData = this.writeEClass(eClass);
            int featureID = eClass.getFeatureID(eStructuralFeature);
            EStructuralFeatureData eStructuralFeatureData = eClassData.eStructuralFeatureData[featureID];
            this.writeCompressedInt(featureID);
            if (eStructuralFeatureData.name != null) {
                this.writeString(eStructuralFeatureData.name);
                if (this.segmentedStringToIDMap != null && eStructuralFeatureData.eDataType != null) {
                    this.writeBoolean(eStructuralFeatureData.dataConverter != null);
                }
                eStructuralFeatureData.name = null;
            }
            return eStructuralFeatureData;
        }

        public void saveResource(Resource resource) throws IOException {
            this.resource = resource;
            URI uri = resource.getURI();
            if (uri != null && uri.isHierarchical() && !uri.isRelative()) {
                this.baseURI = uri;
            }
            InternalEList internalEList = (InternalEList)resource.getContents();
            this.saveEObjects(internalEList, Check.CONTAINER);
        }

        public void saveEObjects(InternalEList<? extends InternalEObject> internalEObjects, Check check) throws IOException {
            int size = internalEObjects.size();
            InternalEObject[] values = this.allocateInternalEObjectArray(size);
            internalEObjects.basicToArray(values);
            this.writeCompressedInt(size);
            int i = 0;
            while (i < size) {
                InternalEObject internalEObject = values[i];
                this.saveEObject(internalEObject, check);
                ++i;
            }
            this.recycle(values);
        }

        public void saveFeatureMap(FeatureMap.Internal featureMap) throws IOException {
            int size = featureMap.size();
            FeatureMap.Entry.Internal[] values = this.allocateFeatureMapEntryArray(size);
            featureMap.toArray(values);
            this.writeCompressedInt(size);
            int i = 0;
            while (i < size) {
                FeatureMap.Entry.Internal entry = values[i];
                this.saveFeatureMapEntry(entry);
                ++i;
            }
            this.recycle(values);
        }

        public void saveFeatureMapEntry(FeatureMap.Entry.Internal entry) throws IOException {
            EStructuralFeatureData eStructuralFeatureData = this.writeEStructuralFeature(entry.getEStructuralFeature());
            Object value = entry.getValue();
            switch (eStructuralFeatureData.kind) {
                case EOBJECT: 
                case EOBJECT_LIST: 
                case EOBJECT_CONTAINMENT: 
                case EOBJECT_CONTAINMENT_LIST: {
                    this.saveEObject((InternalEObject)value, Check.NOTHING);
                    break;
                }
                case EOBJECT_CONTAINMENT_PROXY_RESOLVING: 
                case EOBJECT_CONTAINMENT_LIST_PROXY_RESOLVING: {
                    this.saveEObject((InternalEObject)value, Check.DIRECT_RESOURCE);
                    break;
                }
                case EOBJECT_PROXY_RESOLVING: 
                case EOBJECT_LIST_PROXY_RESOLVING: {
                    this.saveEObject((InternalEObject)value, Check.RESOURCE);
                    break;
                }
                case BOOLEAN: {
                    this.writeBoolean((Boolean)value);
                    break;
                }
                case BYTE: {
                    this.writeByte(((Byte)value).byteValue());
                    break;
                }
                case CHAR: {
                    this.writeChar(((Character)value).charValue());
                    break;
                }
                case DOUBLE: {
                    this.writeDouble((Double)value);
                    break;
                }
                case FLOAT: {
                    this.writeFloat(((Float)value).floatValue());
                    break;
                }
                case INT: {
                    this.writeInt((Integer)value);
                    break;
                }
                case LONG: {
                    this.writeLong((Long)value);
                    break;
                }
                case SHORT: {
                    this.writeShort(((Short)value).shortValue());
                    break;
                }
                case STRING: {
                    this.writeSegmentedString((String)value);
                    break;
                }
                case DATE: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        eStructuralFeatureData.dataConverter.write(this, value);
                        break;
                    }
                    if ((this.style & 2) != 0) {
                        this.writeDate((Date)value);
                        break;
                    }
                    this.writeSegmentedString(eStructuralFeatureData.eFactory.convertToString(eStructuralFeatureData.eDataType, value));
                    break;
                }
                case ENUMERATOR: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        eStructuralFeatureData.dataConverter.write(this, value);
                        break;
                    }
                    if ((this.style & 8) != 0) {
                        this.writeInt(((Enumerator)value).getValue());
                        break;
                    }
                    this.writeString(eStructuralFeatureData.eFactory.convertToString(eStructuralFeatureData.eDataType, value));
                    break;
                }
                case DATA: 
                case DATA_LIST: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        eStructuralFeatureData.dataConverter.write(this, value);
                        break;
                    }
                    String literal = eStructuralFeatureData.eFactory.convertToString(eStructuralFeatureData.eDataType, value);
                    this.writeSegmentedString(literal);
                    break;
                }
                default: {
                    throw new IOException("Unhandled case " + (Object)((Object)eStructuralFeatureData.kind));
                }
            }
        }

        public void saveEObject(InternalEObject internalEObject, Check check) throws IOException {
            if (internalEObject == null) {
                this.writeCompressedInt(-1);
            } else {
                Integer id = this.eObjectIDMap.get(internalEObject);
                if (id == null) {
                    int idValue = this.eObjectIDMap.size();
                    this.writeCompressedInt(idValue);
                    this.eObjectIDMap.put(internalEObject, idValue);
                    EClass eClass = internalEObject.eClass();
                    EClassData eClassData = this.writeEClass(eClass);
                    boolean checkIsTransientProxy = false;
                    switch (check) {
                        case DIRECT_RESOURCE: {
                            Resource resource = internalEObject.eDirectResource();
                            if (resource != null) {
                                this.writeCompressedInt(-1);
                                this.writeURI(resource.getURI(), resource.getURIFragment(internalEObject));
                                if ((this.style & 4) == 0) {
                                    return;
                                }
                                checkIsTransientProxy = true;
                                break;
                            }
                            if (!internalEObject.eIsProxy()) break;
                            this.writeCompressedInt(-1);
                            this.writeURI(internalEObject.eProxyURI());
                            if ((this.style & 4) == 0) {
                                return;
                            }
                            checkIsTransientProxy = true;
                            break;
                        }
                        case RESOURCE: {
                            Resource resource = internalEObject.eResource();
                            if (resource != this.resource && resource != null) {
                                this.writeCompressedInt(-1);
                                this.writeURI(resource.getURI(), resource.getURIFragment(internalEObject));
                                if ((this.style & 4) == 0) {
                                    return;
                                }
                                checkIsTransientProxy = true;
                                break;
                            }
                            if (!internalEObject.eIsProxy()) break;
                            this.writeCompressedInt(-1);
                            this.writeURI(internalEObject.eProxyURI());
                            if ((this.style & 4) == 0) {
                                return;
                            }
                            checkIsTransientProxy = true;
                            break;
                        }
                    }
                    EStructuralFeatureData[] eStructuralFeatureData = eClassData.eStructuralFeatureData;
                    int i = 0;
                    int length = eStructuralFeatureData.length;
                    while (i < length) {
                        EStructuralFeatureData structuralFeatureData = eStructuralFeatureData[i];
                        if (!(structuralFeatureData.isTransient || structuralFeatureData.kind == BinaryIO.FeatureKind.EOBJECT_CONTAINER_PROXY_RESOLVING && check != Check.CONTAINER || checkIsTransientProxy && structuralFeatureData.isProxyTransient)) {
                            this.saveFeatureValue(internalEObject, i, structuralFeatureData);
                        }
                        ++i;
                    }
                    this.writeCompressedInt(0);
                } else {
                    this.writeCompressedInt(id);
                }
            }
        }

        protected void saveFeatureValue(InternalEObject internalEObject, int featureID, EStructuralFeatureData eStructuralFeatureData) throws IOException {
            if (internalEObject.eIsSet(featureID)) {
                this.writeCompressedInt(featureID + 1);
                if (eStructuralFeatureData.name != null) {
                    this.writeString(eStructuralFeatureData.name);
                    if (this.segmentedStringToIDMap != null && eStructuralFeatureData.eDataType != null) {
                        this.writeBoolean(eStructuralFeatureData.dataConverter != null);
                    }
                    eStructuralFeatureData.name = null;
                }
                Object value = internalEObject.eGet(featureID, false, true);
                this.saveFeatureValue(internalEObject, value, featureID, eStructuralFeatureData);
            }
        }

        protected void saveFeatureValue(InternalEObject internalEObject, Object value, int featureID, EStructuralFeatureData eStructuralFeatureData) throws IOException {
            switch (eStructuralFeatureData.kind) {
                case EOBJECT: 
                case EOBJECT_CONTAINMENT: {
                    this.saveEObject((InternalEObject)value, Check.NOTHING);
                    break;
                }
                case EOBJECT_CONTAINER_PROXY_RESOLVING: {
                    this.saveEObject((InternalEObject)value, Check.RESOURCE);
                    break;
                }
                case EOBJECT_CONTAINMENT_PROXY_RESOLVING: {
                    this.saveEObject((InternalEObject)value, Check.DIRECT_RESOURCE);
                    break;
                }
                case EOBJECT_PROXY_RESOLVING: {
                    this.saveEObject((InternalEObject)value, Check.RESOURCE);
                    break;
                }
                case EOBJECT_LIST: 
                case EOBJECT_CONTAINMENT_LIST: {
                    InternalEList internalEList = (InternalEList)value;
                    this.saveEObjects(internalEList, Check.NOTHING);
                    break;
                }
                case EOBJECT_CONTAINMENT_LIST_PROXY_RESOLVING: {
                    InternalEList internalEList = (InternalEList)value;
                    this.saveEObjects(internalEList, Check.DIRECT_RESOURCE);
                    break;
                }
                case EOBJECT_LIST_PROXY_RESOLVING: {
                    InternalEList internalEList = (InternalEList)value;
                    this.saveEObjects(internalEList, Check.RESOURCE);
                    break;
                }
                case BOOLEAN: {
                    this.writeBoolean((Boolean)value);
                    break;
                }
                case BYTE: {
                    this.writeByte(((Byte)value).byteValue());
                    break;
                }
                case CHAR: {
                    this.writeChar(((Character)value).charValue());
                    break;
                }
                case DOUBLE: {
                    this.writeDouble((Double)value);
                    break;
                }
                case FLOAT: {
                    this.writeFloat(((Float)value).floatValue());
                    break;
                }
                case INT: {
                    this.writeInt((Integer)value);
                    break;
                }
                case LONG: {
                    this.writeLong((Long)value);
                    break;
                }
                case SHORT: {
                    this.writeShort(((Short)value).shortValue());
                    break;
                }
                case STRING: {
                    this.writeSegmentedString((String)value);
                    break;
                }
                case FEATURE_MAP: {
                    FeatureMap.Internal featureMap = (FeatureMap.Internal)value;
                    this.saveFeatureMap(featureMap);
                    break;
                }
                case DATE: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        eStructuralFeatureData.dataConverter.write(this, value);
                        break;
                    }
                    if ((this.style & 2) != 0) {
                        this.writeDate((Date)value);
                        break;
                    }
                    this.writeSegmentedString(eStructuralFeatureData.eFactory.convertToString(eStructuralFeatureData.eDataType, value));
                    break;
                }
                case ENUMERATOR: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        eStructuralFeatureData.dataConverter.write(this, value);
                        break;
                    }
                    if ((this.style & 8) != 0) {
                        this.writeInt(((Enumerator)value).getValue());
                        break;
                    }
                    this.writeString(eStructuralFeatureData.eFactory.convertToString(eStructuralFeatureData.eDataType, value));
                    break;
                }
                case DATA: {
                    if (eStructuralFeatureData.dataConverter != null) {
                        eStructuralFeatureData.dataConverter.write(this, value);
                        break;
                    }
                    String literal = eStructuralFeatureData.eFactory.convertToString(eStructuralFeatureData.eDataType, value);
                    this.writeSegmentedString(literal);
                    break;
                }
                case DATA_LIST: {
                    List dataValues = (List)value;
                    int length = dataValues.size();
                    this.writeCompressedInt(length);
                    if (eStructuralFeatureData.dataConverter != null) {
                        int j = 0;
                        while (j < length) {
                            eStructuralFeatureData.dataConverter.write(this, dataValues.get(j));
                            ++j;
                        }
                    } else {
                        int j = 0;
                        while (j < length) {
                            String literal = eStructuralFeatureData.eFactory.convertToString(eStructuralFeatureData.eDataType, dataValues.get(j));
                            this.writeSegmentedString(literal);
                            ++j;
                        }
                    }
                    break;
                }
                default: {
                    throw new IOException("Unhandled case " + (Object)((Object)eStructuralFeatureData.kind));
                }
            }
        }

        public void writeByte(int value) throws IOException {
            if (this.bytes == null) {
                this.outputStream.write(value);
            } else {
                if (this.index == this.bytes.length) {
                    this.doFlush();
                }
                this.bytes[this.index++] = (byte)value;
            }
        }

        public void flush() throws IOException {
            if (this.bytes != null && this.index > 0) {
                this.doFlush();
            }
        }

        private void doFlush() throws IOException {
            this.outputStream.write(this.bytes, 0, this.index);
            this.index = 0;
        }

        public void writeBoolean(boolean value) throws IOException {
            this.writeByte(value ? 1 : 0);
        }

        public void writeChar(int value) throws IOException {
            this.writeByte((byte)(value >> 8 & 0xFF));
            this.writeByte((byte)(value & 0xFF));
        }

        public void writeShort(int value) throws IOException {
            this.writeByte((byte)(value >> 8 & 0xFF));
            this.writeByte((byte)(value & 0xFF));
        }

        public void writeInt(int value) throws IOException {
            this.writeByte((byte)(value >> 24 & 0xFF));
            this.writeByte((byte)(value >> 16 & 0xFF));
            this.writeByte((byte)(value >> 8 & 0xFF));
            this.writeByte((byte)(value & 0xFF));
        }

        public void writeLong(long value) throws IOException {
            this.writeInt((int)(value >> 32));
            this.writeInt((int)value);
        }

        public void writeFloat(float value) throws IOException {
            if ((this.style & 1) != 0) {
                this.writeInt(Float.floatToIntBits(value));
            } else {
                this.writeString(Float.toString(value));
            }
        }

        public void writeDouble(double value) throws IOException {
            if ((this.style & 1) != 0) {
                this.writeLong(Double.doubleToLongBits(value));
            } else {
                this.writeString(Double.toString(value));
            }
        }

        public void writeCompressedInt(int value) throws IOException {
            if (++value < 0) {
                this.handleInvalidValue(value);
            } else if (value <= 63) {
                this.writeByte(value);
            } else if (value <= 16383) {
                this.writeByte(value >> 8 | 0x40);
                this.writeByte(value & 0xFF);
            } else if (value <= 0x3FFFFF) {
                this.writeByte(value >> 16 | 0x80);
                this.writeByte(value >> 8 & 0xFF);
                this.writeByte(value & 0xFF);
            } else if (value <= 0x3FFFFFFF) {
                this.writeByte(value >> 24 | 0xC0);
                this.writeByte(value >> 16 & 0xFF);
                this.writeByte(value >> 8 & 0xFF);
                this.writeByte(value & 0xFF);
            } else {
                this.handleInvalidValue(value);
            }
        }

        private final void handleInvalidValue(int value) throws IOException {
            throw new IOException("Invalid value " + value);
        }

        private void ensureSegmentCapacity(int capacity) {
            if (this.segments == null) {
                this.segments = new String[Math.max(20, capacity)];
            } else if (this.segments.length < capacity) {
                String[] newSegments = new String[Math.max(2 * this.segments.length, capacity)];
                System.arraycopy(this.segments, 0, newSegments, 0, this.segments.length);
                this.segments = newSegments;
            }
        }

        public void writeSegmentedString(String value) throws IOException {
            if (this.segmentedStringToIDMap == null) {
                this.writeString(value);
            } else if (value == null) {
                this.writeCompressedInt(-1);
            } else {
                Integer id = this.segmentedStringToIDMap.get(value);
                if (id == null) {
                    int idValue = this.segmentedStringToIDMap.size();
                    this.segmentedStringToIDMap.put(value, idValue);
                    this.writeCompressedInt(idValue);
                    int segmentCount = 0;
                    int start = 0;
                    int end = value.length();
                    int i = 0;
                    while (i < end) {
                        String delimiter;
                        char c = value.charAt(i);
                        if (c < '\u00c0' && (delimiter = DELIMITERS[c]) != null) {
                            this.ensureSegmentCapacity(segmentCount + 2);
                            if (start < i) {
                                this.segments[segmentCount++] = value.substring(start, i);
                            }
                            this.segments[segmentCount++] = delimiter;
                            start = i + 1;
                        }
                        ++i;
                    }
                    if (start == 0 || segmentCount == 1 && start == end) {
                        this.writeCompressedInt(0);
                        this.writeString(value);
                    } else {
                        if (start < end) {
                            this.ensureSegmentCapacity(segmentCount + 1);
                            this.segments[segmentCount++] = value.substring(start, end);
                        }
                        this.writeCompressedInt(segmentCount);
                        i = 0;
                        while (i < segmentCount) {
                            this.writeString(this.segments[i]);
                            ++i;
                        }
                    }
                } else {
                    this.writeCompressedInt(id);
                }
            }
        }

        public void writeString(String value) throws IOException {
            if (value == null) {
                this.writeCompressedInt(-1);
            } else {
                if (this.segmentToIDMap != null) {
                    Integer id = this.segmentToIDMap.get(value);
                    if (id != null) {
                        this.writeCompressedInt(id);
                        return;
                    }
                    int idValue = this.segmentToIDMap.size();
                    this.segmentToIDMap.put(value, idValue);
                    this.writeCompressedInt(idValue);
                }
                int length = value.length();
                this.writeCompressedInt(length);
                if (this.characters == null || this.characters.length < length) {
                    this.characters = new char[length];
                }
                value.getChars(0, length, this.characters, 0);
                int i = 0;
                while (i < length) {
                    char character = this.characters[i];
                    if (character == '\u0000' || character > '\u00ff') {
                        this.writeByte(0);
                        this.writeChar(character);
                        while (++i < length) {
                            this.writeChar(this.characters[i]);
                        }
                        break;
                    }
                    this.writeByte((byte)character);
                    ++i;
                }
            }
        }

        public void writeDate(Date date) throws IOException {
            this.writeLong(date.getTime());
        }

        public void writeURI(URI uri) throws IOException {
            this.writeURI(uri.trimFragment(), uri.fragment());
        }

        public void writeURI(URI uri, String fragment) throws IOException {
            if (uri == null) {
                this.writeCompressedInt(-1);
            } else {
                assert (uri.fragment() == null);
                Integer id = this.uriToIDMap.get(uri);
                if (id == null) {
                    int idValue = this.uriToIDMap.size();
                    this.uriToIDMap.put(uri, idValue);
                    this.writeCompressedInt(idValue);
                    this.writeSegmentedString(this.deresolve(uri).toString());
                } else {
                    this.writeCompressedInt(id);
                }
                this.writeSegmentedString(fragment);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Check {
            NOTHING,
            DIRECT_RESOURCE,
            RESOURCE,
            CONTAINER;

        }

        protected static class EClassData {
            public int ePackageID;
            public int id;
            public EStructuralFeatureData[] eStructuralFeatureData;

            protected EClassData() {
            }
        }

        protected static class EPackageData {
            public int id;
            public EClassData[] eClassData;

            protected EPackageData() {
            }

            public final int allocateEClassID() {
                int i = 0;
                int length = this.eClassData.length;
                while (i < length) {
                    EClassData eClassData = this.eClassData[i];
                    if (eClassData == null) {
                        return i;
                    }
                    ++i;
                }
                return -1;
            }
        }

        protected static class EStructuralFeatureData {
            public String name;
            public boolean isTransient;
            public boolean isProxyTransient;
            public BinaryIO.FeatureKind kind;
            public EFactory eFactory;
            public EDataType eDataType;
            public DataConverter<?> dataConverter;

            protected EStructuralFeatureData() {
            }
        }
    }
}

