/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.impl;

import java.util.List;
import java.util.TreeMap;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolProvider;

public class BaseSymbolFunction
implements ISymbolFunction {
    private static final BaseSymbolFunction INSTANCE = new BaseSymbolFunction();

    protected void addCompositeSymbol(Object composite_p, StringBuilder builder_p) {
        Iterable<?> decomposed = this.decompose(composite_p);
        this.addDecomposedCompositeSymbol(decomposed, builder_p);
    }

    protected void addDecomposedCompositeSymbol(Iterable<?> composite_p, StringBuilder builder_p) {
        builder_p.append('(');
        boolean first = true;
        for (Object element : composite_p) {
            if (first) {
                first = false;
            } else {
                builder_p.append(',');
                builder_p.append(' ');
            }
            this.addSymbol(element, builder_p);
        }
        builder_p.append(')');
    }

    protected void addSymbol(Object object_p, StringBuilder builder_p) {
        if (object_p instanceof ISymbolProvider) {
            Object ownSymbol = ((ISymbolProvider)object_p).getSymbol(this);
            builder_p.append(ownSymbol);
        } else if (this.isComposite(object_p)) {
            this.addCompositeSymbol(object_p, builder_p);
        } else {
            Object atomSymbol = this.getAtomSymbol(object_p);
            builder_p.append(atomSymbol);
        }
    }

    protected Iterable<?> decompose(Object object_p) {
        Iterable<?> iterable = (Iterable<?>)object_p;
        Iterable<?> result = this.isOrderSignificant(iterable) ? iterable : this.order(iterable);
        return result;
    }

    protected Object getAtomSymbol(Object object_p) {
        return object_p == null ? null : object_p.toString();
    }

    public static BaseSymbolFunction getInstance() {
        return INSTANCE;
    }

    @Override
    public Object getSymbol(Object object_p) {
        StringBuilder builder = new StringBuilder();
        this.addSymbol(object_p, builder);
        return builder.toString();
    }

    protected boolean isComposite(Object object_p) {
        return object_p instanceof Iterable;
    }

    protected boolean isOrderSignificant(Iterable<?> iterable_p) {
        return iterable_p instanceof List;
    }

    protected Iterable<?> order(Iterable<?> iterable_p) {
        TreeMap result = new TreeMap();
        for (Object part : iterable_p) {
            Object partSymbol = this.getSymbol(part);
            result.put(partSymbol, part);
        }
        return result.values();
    }
}

