/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.util.structures;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.diffmerge.bridge.api.ISymbolFunction;
import org.eclipse.emf.diffmerge.bridge.util.structures.AbstractPureStructure;
import org.eclipse.emf.diffmerge.bridge.util.structures.ITuple;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuple2;
import org.eclipse.emf.diffmerge.bridge.util.structures.Tuples;

public class TupleN<E>
extends AbstractPureStructure<E>
implements ITuple<E> {
    protected final List<E> _elements;

    public TupleN(E ... elements_p) {
        this._elements = Arrays.asList(elements_p);
    }

    @Override
    public List<E> asCollection() {
        return this._elements;
    }

    public boolean equals(Object object_p) {
        boolean result = false;
        if (object_p instanceof ITuple) {
            ITuple peer = (ITuple)object_p;
            result = this.asCollection().equals(peer.asCollection());
        }
        return result;
    }

    @Override
    public E get(int index_p) {
        return this._elements.get(index_p - 1);
    }

    @Override
    public Collection<Tuple2<Integer, E>> getContents() {
        ArrayList<Tuple2<Integer, E>> result = new ArrayList<Tuple2<Integer, E>>(this._elements.size());
        int i = 1;
        for (E element : this._elements) {
            result.add(Tuples.tuple(i, element));
            ++i;
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Object getSymbol(ISymbolFunction function_p) {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        boolean first = true;
        for (E element : this._elements) {
            if (first) {
                first = false;
            } else {
                builder.append(',');
                builder.append(' ');
            }
            Object elementSymbol = function_p.getSymbol(element);
            builder.append(elementSymbol);
        }
        builder.append(')');
        return builder.toString();
    }

    public int hashCode() {
        return this._elements.hashCode();
    }

    @Override
    public int size() {
        return this._elements.size();
    }

    public String toString() {
        return String.valueOf(this.getClass().getSimpleName()) + this.asCollection().toString();
    }
}

