/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.patterns.templates.engine.resources;

import java.util.Map;
import java.util.Set;
import org.eclipse.emf.diffmerge.patterns.core.CorePatternsPlugin;
import org.eclipse.emf.diffmerge.patterns.core.api.IPattern;
import org.eclipse.emf.diffmerge.patterns.core.api.ext.IIdProvider;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.impl.ResourceImpl;
import org.eclipse.emf.edit.domain.EditingDomain;

public class PatternVirtualResource
extends ResourceImpl {
    private Map<EObject, EObject> _copiedToOriginalMap;
    private EditingDomain _originalEditingDomain;

    public PatternVirtualResource(Map<EObject, EObject> copiedToOriginalMap_p, EditingDomain originalEditingDomain_p) {
        this._copiedToOriginalMap = copiedToOriginalMap_p;
        this._originalEditingDomain = originalEditingDomain_p;
        for (EObject cur : copiedToOriginalMap_p.values()) {
            if (!(cur instanceof IPattern)) continue;
            this.getContents().add((Object)cur);
        }
    }

    public String getID(EObject eObject) {
        String result = null;
        IIdProvider idProvider = CorePatternsPlugin.getDefault().getIdProvider();
        if (this._copiedToOriginalMap != null && idProvider != null) {
            EObject original = this.getKeyForValue(this._copiedToOriginalMap, eObject);
            result = idProvider.getId(original, this._originalEditingDomain);
        }
        return result;
    }

    private EObject getKeyForValue(Map<EObject, EObject> map_p, EObject value_p) {
        EObject result = null;
        Set<EObject> kset = map_p.keySet();
        for (EObject current : kset) {
            if (map_p.get(current) != value_p) continue;
            return current;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean map(EObject keyObject, EObject valueObject, boolean replaceMapping) {
        boolean result = true;
        if (keyObject == null) return result;
        if (this._copiedToOriginalMap.get(keyObject) != null) {
            result = false;
            if (!replaceMapping) return result;
            this._copiedToOriginalMap.remove(keyObject);
            this._copiedToOriginalMap.put(keyObject, valueObject);
            return result;
        } else {
            this._copiedToOriginalMap.put(keyObject, valueObject);
        }
        return result;
    }

    public EditingDomain getEditingDomain() {
        return this._originalEditingDomain;
    }
}

