/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.bridge.mapping.operations;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.diffmerge.bridge.api.IBridge;
import org.eclipse.emf.diffmerge.bridge.api.IBridgeExecution;
import org.eclipse.emf.diffmerge.bridge.api.ICause;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IMappingBridge;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQuery;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IQueryIdentifier;
import org.eclipse.emf.diffmerge.bridge.mapping.api.IRule;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.MappingCause;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.MappingExecution;
import org.eclipse.emf.diffmerge.bridge.mapping.impl.QueryExecution;
import org.eclipse.emf.diffmerge.bridge.operations.AbstractBridgeOperation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingBridgeOperation
extends AbstractBridgeOperation {
    public MappingBridgeOperation(Object sourceDataSet_p, Object targetDataSet_p, IMappingBridge<?, ?> bridge_p, IBridgeExecution execution_p) {
        super(sourceDataSet_p, targetDataSet_p, bridge_p, execution_p);
    }

    protected QueryExecution createQueryExecution() {
        QueryExecution rootQueryEnv = new QueryExecution();
        return rootQueryEnv;
    }

    public IMappingBridge<?, ?> getBridge() {
        return (IMappingBridge)super.getBridge();
    }

    public MappingExecution getBridgeExecution() {
        return (MappingExecution)super.getBridgeExecution();
    }

    protected int getWorkAmount() {
        return this.getBridge().getWorkAmount(this.getSourceDataSet(), this.getTargetDataSet());
    }

    protected void handleBridge(IMappingBridge<?, ?> bridge_p, MappingExecution execution_p, Object sourceDataSet_p, Object targetDataSet_p) {
        QueryExecution rootQueryEnv = this.createQueryExecution();
        this.handleQueriesForTargetCreationRec(bridge_p.getQueries(), bridge_p, sourceDataSet_p, targetDataSet_p, rootQueryEnv, execution_p);
        bridge_p.targetsCreated(targetDataSet_p);
        this.handleTargetDefinitions(execution_p);
        bridge_p.targetsDefined(targetDataSet_p);
        execution_p.setStatus(Status.OK_STATUS);
    }

    protected void handleQueriesForTargetCreationRec(Collection<? extends IQuery<?, ?>> queries_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        for (IQuery<?, ?> query : queries_p) {
            this.handleQueryForTargetCreationRec(query, bridge_p, source_p, targetDataSet_p, queryExecution_p, execution_p);
        }
    }

    protected void handleQueryForTargetCreationRec(IQuery<?, ?> query_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        this.checkProgress();
        Iterator<?> queryResultIterator = query_p.evaluate(source_p, queryExecution_p);
        if (queryResultIterator.hasNext()) {
            IQueryIdentifier queryID = (IQueryIdentifier)query_p.getID();
            while (queryResultIterator.hasNext()) {
                Object queryResult = queryResultIterator.next();
                QueryExecution newQueryEnv = queryExecution_p.newWith(queryID, queryResult);
                this.handleQueryForTargetCreation(query_p, bridge_p, queryResult, targetDataSet_p, newQueryEnv, execution_p);
                this.handleQueriesForTargetCreationRec(query_p.getQueries(), bridge_p, queryResult, targetDataSet_p, newQueryEnv, execution_p);
            }
        }
    }

    protected void handleQueryForTargetCreation(IQuery<?, ?> query_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        for (IRule<?, ?> rule : query_p.getRules()) {
            this.handleRuleForTargetCreation(rule, bridge_p, source_p, targetDataSet_p, queryExecution_p, execution_p);
        }
        this.getMonitor().worked(1);
    }

    protected void handleRuleForTargetCreation(IRule<?, ?> rule_p, IBridge<?, ?> bridge_p, Object source_p, Object targetDataSet_p, QueryExecution queryExecution_p, MappingExecution execution_p) {
        this.checkProgress();
        MappingCause cause = new MappingCause(queryExecution_p, source_p, rule_p);
        if (!execution_p.isTolerantToDuplicates() || !execution_p.isRegistered((ICause<?, ?>)cause)) {
            Object target = rule_p.createTarget(source_p, queryExecution_p);
            ((IMappingBridge)bridge_p).addTarget(targetDataSet_p, target);
            execution_p.put(cause, target);
        }
    }

    protected void handleTargetDefinitions(MappingExecution execution_p) {
        Set<Object> pendingSources = execution_p.getPendingSources();
        for (Object source : pendingSources) {
            this.handleRuleForTargetDefinitions(source, execution_p);
        }
        int nbPendingSources = pendingSources.size();
        int remainingProgress = Math.max(0, this.getBridge().getNbRules() - nbPendingSources);
        this.getMonitor().worked(remainingProgress);
    }

    protected void handleRuleForTargetDefinitions(Object source_p, MappingExecution execution_p) {
        Map<IRule<?, ?>, MappingExecution.PendingDefinition> pendingDefinitions = execution_p.getPendingDefinitions(source_p);
        for (Map.Entry<IRule<?, ?>, MappingExecution.PendingDefinition> entry : pendingDefinitions.entrySet()) {
            this.handleRuleForTargetDefinition(entry.getKey(), source_p, entry.getValue(), execution_p);
        }
    }

    protected void handleRuleForTargetDefinition(IRule<?, ?> rule_p, Object source_p, MappingExecution.PendingDefinition pendingDef_p, MappingExecution execution_p) {
        this.checkProgress();
        rule_p.defineTarget(source_p, pendingDef_p.getTarget(), pendingDef_p.getQueryExecution(), execution_p);
        this.getMonitor().worked(1);
    }

    public IStatus run() {
        IStatus result;
        this.getMonitor().worked(1);
        try {
            this.handleBridge((IMappingBridge<?, ?>)this.getBridge(), this.getBridgeExecution(), this.getSourceDataSet(), this.getTargetDataSet());
            result = Status.OK_STATUS;
        }
        catch (OperationCanceledException e) {
            result = Status.CANCEL_STATUS;
        }
        return result;
    }
}

