/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.diffmerge.impl.scopes;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.diffmerge.api.scopes.IModelScope;
import org.eclipse.emf.ecore.EObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultiRootTreeIterator
implements TreeIterator<EObject> {
    private final IModelScope _scope;
    private final Iterator<EObject> _rootIterator;
    private TreeIterator<EObject> _rootContentIterator;
    private boolean _prunedOnRoot;
    private boolean _currentIsRoot;

    public MultiRootTreeIterator(IModelScope scope_p, Iterator<EObject> rootIterator_p) {
        assert (scope_p != null && rootIterator_p != null);
        this._scope = scope_p;
        this._rootIterator = rootIterator_p;
        this._prunedOnRoot = false;
        this._currentIsRoot = false;
    }

    public boolean hasNext() {
        return this._rootContentIterator != null && this._rootContentIterator.hasNext() || this._rootIterator.hasNext();
    }

    public EObject next() {
        EObject result = null;
        if (!this._prunedOnRoot && this._rootContentIterator != null && this._rootContentIterator.hasNext()) {
            result = (EObject)this._rootContentIterator.next();
            this._currentIsRoot = false;
        } else if (this._rootIterator.hasNext()) {
            result = this._rootIterator.next();
            this._rootContentIterator = this._scope.getAllContents(result);
            this._currentIsRoot = true;
        }
        this._prunedOnRoot = false;
        if (result != null) {
            return result;
        }
        throw new NoSuchElementException();
    }

    public void prune() {
        if (this._currentIsRoot) {
            this._prunedOnRoot = true;
        } else if (this._rootContentIterator != null) {
            this._rootContentIterator.prune();
        }
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }
}

